/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.capability;

import com.swdteam.common.capability.interfaces.IRegenerationCapability;
import com.swdteam.common.regeneration.skinchanging.SkinChangingHandler;
import com.swdteam.common.regeneration.skinchanging.SkinData;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_Regeneration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CapabilityRegeneration
implements IRegenerationCapability {
    @CapabilityInject(value=IRegenerationCapability.class)
    public static final Capability<IRegenerationCapability> REGEN_CAP = null;
    public EntityPlayer player;
    private int regenCount;
    private int regenTicks;
    private int preRegenTicks;
    private int postRegenTicks;
    private boolean canRegen;
    private boolean isPreRegen;
    private boolean isPostRegen;
    public int regen_color = -30444;
    public SkinData skinData = new SkinData();
    public boolean requireSkinUpdate = false;
    public boolean has_skin_changed = false;
    public boolean can_change_skin = false;
    public SkinChangingHandler.SkinChoice preffered_type = SkinChangingHandler.SkinChoice.RANDOM;

    public CapabilityRegeneration(EntityPlayer p) {
        this.player = p;
    }

    @Override
    public void syncToPlayer() {
        if (!this.player.field_70170_p.field_72995_K) {
            PacketHandler.INSTANCE.sendToAll((IMessage)new Packet_Regeneration(this.player, this.writeNBT()));
        }
    }

    @Override
    public void update() {
    }

    @Override
    public void setTicksExisted(int ticks) {
        this.regenTicks = ticks;
    }

    @Override
    public void setPreRegenTicks(int ticks) {
        this.preRegenTicks = ticks;
    }

    @Override
    public void setPostRegenTicks(int ticks) {
        this.postRegenTicks = ticks;
    }

    @Override
    public void setPreRegen(boolean preRegen) {
        this.isPreRegen = preRegen;
    }

    @Override
    public void setPostRegen(boolean postRegen) {
        this.isPostRegen = postRegen;
    }

    @Override
    public SkinData getSkinData() {
        return this.skinData;
    }

    @Override
    public boolean canSkinChange() {
        return this.can_change_skin;
    }

    @Override
    public void canSkinChange(boolean b) {
        this.can_change_skin = b;
    }

    @Override
    public void setSkinChanged(boolean changed) {
        this.has_skin_changed = changed;
    }

    @Override
    public boolean isSkinUpdate() {
        return this.requireSkinUpdate;
    }

    @Override
    public void setPreferredType(SkinChangingHandler.SkinChoice choice) {
        this.preffered_type = choice;
    }

    @Override
    public SkinChangingHandler.SkinChoice getPreferredType() {
        return this.preffered_type;
    }

    @Override
    public void skinUpdate() {
        this.requireSkinUpdate = true;
        this.syncToPlayer();
    }

    @Override
    public void resetSkinUpdate() {
        this.requireSkinUpdate = false;
    }

    @Override
    public boolean hasChangedSkin() {
        return this.has_skin_changed;
    }

    @Override
    public void setRegenCount(int count) {
        this.regenCount = count;
    }

    @Override
    public void setCanRegen(boolean timelord) {
        this.canRegen = timelord;
    }

    @Override
    public void setColor(int color) {
        this.regen_color = color;
    }

    @Override
    public int getColor() {
        return this.regen_color;
    }

    @Override
    public boolean canPlayerRegenerate() {
        return this.canRegen;
    }

    @Override
    public int getTicksExisted() {
        return this.regenTicks;
    }

    @Override
    public int getPreRegenTicks() {
        return this.preRegenTicks;
    }

    @Override
    public int getPostRegenTicks() {
        return this.postRegenTicks;
    }

    @Override
    public int getRegenAmount() {
        return this.regenCount;
    }

    @Override
    public boolean isPreRegen() {
        return this.isPreRegen;
    }

    @Override
    public boolean isPostRegen() {
        return this.isPostRegen;
    }

    @Override
    public NBTTagCompound writeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("regenCount", this.regenCount);
        compound.func_74768_a("regenTicks", this.regenTicks);
        compound.func_74768_a("preRegenTicks", this.preRegenTicks);
        compound.func_74768_a("postRegenTicks", this.postRegenTicks);
        compound.func_74757_a("canRegen", this.canRegen);
        compound.func_74768_a("regenColor", this.regen_color);
        compound.func_74757_a("changed_skin", this.has_skin_changed);
        compound.func_74757_a("updateSkin", this.requireSkinUpdate);
        compound.func_74778_a("prefer_type", this.preffered_type.getChoice());
        compound.func_74757_a("can_change", this.can_change_skin);
        this.skinData.writeNBT(compound);
        return compound;
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        this.regenCount = nbt.func_74762_e("regenCount");
        this.regenTicks = nbt.func_74762_e("regenTicks");
        this.preRegenTicks = nbt.func_74762_e("preRegenTicks");
        this.postRegenTicks = nbt.func_74762_e("postRegenTicks");
        this.canRegen = nbt.func_74767_n("canRegen");
        this.regen_color = nbt.func_74762_e("regenColor");
        this.has_skin_changed = nbt.func_74767_n("changed_skin");
        this.requireSkinUpdate = nbt.func_74767_n("updateSkin");
        this.preffered_type = SkinChangingHandler.SkinChoice.getSkinChoice(nbt.func_74779_i("prefer_type"));
        this.can_change_skin = nbt.func_74767_n("can_change");
        this.skinData.readNBT(nbt);
    }

    public static class Storage
    implements Capability.IStorage<IRegenerationCapability> {
        @Nullable
        public NBTBase writeNBT(Capability<IRegenerationCapability> capability, IRegenerationCapability instance, EnumFacing side) {
            return instance.writeNBT();
        }

        public void readNBT(Capability<IRegenerationCapability> capability, IRegenerationCapability instance, EnumFacing side, NBTBase nbt) {
            instance.readNBT(nbt instanceof NBTTagCompound ? (NBTTagCompound)nbt : new NBTTagCompound());
        }
    }

    public static class CapabilityTimelordProvider
    implements ICapabilitySerializable<NBTTagCompound> {
        private IRegenerationCapability capability;

        public CapabilityTimelordProvider(EntityPlayer player) {
            this.capability = new CapabilityRegeneration(player);
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return REGEN_CAP != null && capability == REGEN_CAP;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == REGEN_CAP ? REGEN_CAP.cast((Object)this.capability) : null);
        }

        public NBTTagCompound serializeNBT() {
            return (NBTTagCompound)REGEN_CAP.getStorage().writeNBT(REGEN_CAP, (Object)this.capability, null);
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            REGEN_CAP.getStorage().readNBT(REGEN_CAP, (Object)this.capability, null, (NBTBase)nbt);
        }
    }
}

