/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.capability;

import com.swdteam.common.capability.interfaces.ITardisCapability;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tardis.data.UserTardises;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_RequestTardisData;
import com.swdteam.network.packets.Packet_SyncFlightModeCap;
import com.swdteam.utils.FileUtils;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CapabilityTardis
implements ITardisCapability {
    @CapabilityInject(value=ITardisCapability.class)
    public static final Capability<ITardisCapability> FLIGHTMODE_CAP = null;
    public TardisData data = null;
    public EntityPlayer player;
    public boolean isInFlight = false;
    public boolean isOnGround = false;
    public boolean resetLogin = false;
    private int tardis_id = 0;
    private BlockPos tardis_pos = BlockPos.field_177992_a;
    private float tardis_yaw = 1.0f;
    private float tardis_pitch = 1.0f;
    private int ticksOnGround = 0;
    public float rotation = 0.0f;
    public int humID = -1;
    public boolean requestedSent = false;

    public CapabilityTardis(EntityPlayer player) {
        this.player = player;
    }

    @Override
    public void syncToPlayer() {
        if (!this.player.field_70170_p.field_72995_K) {
            PacketHandler.INSTANCE.sendToAll((IMessage)new Packet_SyncFlightModeCap(this.player, this.writeNBT()));
        }
    }

    @Override
    public boolean getInFlight() {
        return this.isInFlight;
    }

    @Override
    public int getTARDISID() {
        return this.tardis_id;
    }

    @Override
    public void setTARDISID(int flight_mode_tid) {
        this.tardis_id = flight_mode_tid;
        TardisData data = DMTardis.getTardis(flight_mode_tid);
        if (data.getCurrentOwner().equals(this.player.func_110124_au())) {
            UserTardises t = DMTardis.getUserTardises(UUID.fromString(this.player.func_110124_au().toString()));
            t.addTardis(flight_mode_tid);
            DMTardis.updateUserTardisData(t, this.player.func_110124_au());
        }
    }

    @Override
    public void setTARDISPos(BlockPos pos) {
        this.tardis_pos = pos;
    }

    @Override
    public void setInFlight(boolean inFlight) {
        this.isInFlight = inFlight;
    }

    @Override
    public boolean getOnGround() {
        return this.isOnGround;
    }

    @Override
    public void setOnGround(boolean OnGround) {
        this.isOnGround = OnGround;
    }

    @Override
    public NBTTagCompound writeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("isInFlight", this.isInFlight);
        compound.func_74776_a("rotation", this.rotation);
        compound.func_74757_a("isOnGround", this.isOnGround);
        compound.func_74768_a("tardis_id", this.tardis_id);
        compound.func_74780_a("tardis_yaw", (double)this.tardis_yaw);
        compound.func_74780_a("tardis_pitch", (double)this.tardis_pitch);
        compound.func_74757_a("resetLogin", this.resetLogin);
        compound.func_74768_a("ticksOnGround", this.ticksOnGround);
        compound.func_74772_a("tardis_pos", this.tardis_pos.func_177986_g());
        compound.func_74768_a("hum_id", this.humID);
        return compound;
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        this.isInFlight = nbt.func_74767_n("isInFlight");
        this.rotation = nbt.func_74760_g("rotation");
        this.isOnGround = nbt.func_74767_n("isOnGround");
        this.tardis_id = nbt.func_74762_e("tardis_id");
        this.resetLogin = nbt.func_74767_n("resetLogin");
        this.tardis_yaw = nbt.func_74760_g("tardis_yaw");
        this.tardis_pitch = nbt.func_74760_g("tardis_pitch");
        this.ticksOnGround = nbt.func_74762_e("ticksOnground");
        this.tardis_pos = BlockPos.func_177969_a((long)nbt.func_74763_f("tardis_pos"));
        this.humID = nbt.func_74762_e("hum_id");
    }

    @Override
    public void setPitch(float pitch) {
        this.tardis_pitch = pitch;
    }

    @Override
    public void setYaw(float yaw) {
        this.tardis_yaw = yaw;
    }

    @Override
    public void setHumID(int id) {
        this.humID = id;
    }

    @Override
    public int getHumID() {
        return this.humID;
    }

    @Override
    public BlockPos getTardisPos() {
        return this.tardis_pos;
    }

    @Override
    public float getYaw() {
        return this.tardis_yaw;
    }

    @Override
    public float getPitch() {
        return this.tardis_pitch;
    }

    @Override
    public boolean getResetLogin() {
        return this.resetLogin;
    }

    @Override
    public void setResetLogin(boolean b) {
        this.resetLogin = b;
    }

    @Override
    public int getTicksOnground() {
        return this.ticksOnGround;
    }

    @Override
    public void setTicksOnground(int ticks) {
        this.ticksOnGround = ticks;
    }

    @Override
    public void setTardisData(TardisData data) {
        this.data = data;
    }

    @Override
    public TardisData getTardisData(boolean serverSide) {
        if (this.data == null || this.data != null && this.data == DMTardis.DEFAULT_DATA) {
            this.data = DMTardis.getTardis(serverSide, this.getTARDISID());
        }
        if (!this.requestedSent && !serverSide && this.data == null) {
            this.requestedSent = true;
            PacketHandler.INSTANCE.sendToServer((IMessage)new Packet_RequestTardisData(this.getTARDISID()));
        }
        return this.data;
    }

    @Override
    public float getRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public static class Storage
    implements Capability.IStorage<ITardisCapability> {
        @Nullable
        public NBTBase writeNBT(Capability<ITardisCapability> capability, ITardisCapability instance, EnumFacing side) {
            return instance.writeNBT();
        }

        public void readNBT(Capability<ITardisCapability> capability, ITardisCapability instance, EnumFacing side, NBTBase nbt) {
            instance.readNBT(nbt instanceof NBTTagCompound ? (NBTTagCompound)nbt : new NBTTagCompound());
        }
    }

    @Mod.EventBusSubscriber
    public static class EventHandler {
        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (!(event.getObject() instanceof EntityPlayer) || ((Entity)event.getObject()).hasCapability(FLIGHTMODE_CAP, null)) {
                return;
            }
            event.addCapability(FileUtils.newResourceLocation("thedalekmod:TARDIS"), (ICapabilityProvider)new CapabilityFlightModeProvider((EntityPlayer)event.getObject()));
        }

        @SubscribeEvent
        public static void playerTracking(PlayerEvent.StartTracking event) {
            if (event.getEntityPlayer().field_70170_p.func_72820_D() % 20L == 0L) {
                EventHandler.get(event.getEntityPlayer()).syncToPlayer();
            }
        }

        @SubscribeEvent
        public static void update(LivingEvent.LivingUpdateEvent event) {
            ITardisCapability cap;
            if (event.getEntity() instanceof EntityPlayer && (cap = EventHandler.get((EntityPlayer)event.getEntityLiving())) != null && event.getEntity().field_70170_p.func_72820_D() % 40L == 0L) {
                cap.syncToPlayer();
            }
        }

        @SubscribeEvent
        public static void onDeathEvent(LivingDeathEvent e) {
            if (e.getEntityLiving() instanceof EntityPlayer) {
                EventHandler.get((EntityPlayer)e.getEntityLiving()).syncToPlayer();
            }
        }

        @SubscribeEvent
        public static void onPlayerClone(PlayerEvent.Clone event) {
            Capability.IStorage storage = FLIGHTMODE_CAP.getStorage();
            ITardisCapability oldCap = EventHandler.get(event.getOriginal());
            ITardisCapability newCap = EventHandler.get(event.getEntityPlayer());
            NBTTagCompound nbt = (NBTTagCompound)storage.writeNBT(FLIGHTMODE_CAP, (Object)oldCap, null);
            storage.readNBT(FLIGHTMODE_CAP, (Object)newCap, null, (NBTBase)nbt);
            EventHandler.get(event.getEntityPlayer()).syncToPlayer();
        }

        @SubscribeEvent
        public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            EventHandler.get(event.player).syncToPlayer();
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            EventHandler.get(event.player).syncToPlayer();
        }

        @Nonnull
        public static ITardisCapability get(EntityPlayer player) {
            if (player.hasCapability(FLIGHTMODE_CAP, null)) {
                return (ITardisCapability)player.getCapability(FLIGHTMODE_CAP, null);
            }
            throw new IllegalStateException("Tardis Capability Missing");
        }
    }

    public static class CapabilityFlightModeProvider
    implements ICapabilitySerializable<NBTTagCompound> {
        private ITardisCapability capability;

        public CapabilityFlightModeProvider(EntityPlayer player) {
            this.capability = new CapabilityTardis(player);
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return FLIGHTMODE_CAP != null && capability == FLIGHTMODE_CAP;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == FLIGHTMODE_CAP ? FLIGHTMODE_CAP.cast((Object)this.capability) : null);
        }

        public NBTTagCompound serializeNBT() {
            return (NBTTagCompound)FLIGHTMODE_CAP.getStorage().writeNBT(FLIGHTMODE_CAP, (Object)this.capability, null);
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            FLIGHTMODE_CAP.getStorage().readNBT(FLIGHTMODE_CAP, (Object)this.capability, null, (NBTBase)nbt);
        }
    }
}

