/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.commands;

import com.mojang.authlib.GameProfile;
import com.swdteam.common.init.DMBlocks;
import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tardis.data.UserTardises;
import com.swdteam.common.tileentity.tardis.TileEntityTardis;
import com.swdteam.common.tileentity.tardis.perms.TardisPermission;
import com.swdteam.main.TheDalekMod;
import com.swdteam.utils.DMUtils;
import com.swdteam.utils.PlayerUtils;
import com.swdteam.utils.Vector3;
import com.swdteam.utils.WorldUtils;
import com.swdteam.utils.math.Vector3d;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import net.minecraftforge.server.command.CommandTreeBase;

public class CommandTardisAdmin
extends CommandTreeBase {
    public CommandTardisAdmin() {
        this.addSubcommand((ICommand)new DataQuery());
        this.addSubcommand((ICommand)new DataChange());
    }

    public String func_71517_b() {
        return "tardis-admin";
    }

    public String func_71518_a(ICommandSender sender) {
        String[] subcmds = new String[this.getSubCommands().size()];
        int i = 0;
        for (ICommand c : this.getSubCommands()) {
            subcmds[i] = c.func_71517_b();
            ++i;
        }
        StringBuilder b = new StringBuilder();
        for (int i1 = 0; i1 < subcmds.length; ++i1) {
            b.append(subcmds[i1] + (i1 == subcmds.length - 1 ? "" : "|"));
        }
        return "/" + this.func_71517_b() + " [" + b.toString() + "] [parameters]";
    }

    private class DataQuery
    extends CommandBase {
        private DataQuery() {
        }

        public String func_71517_b() {
            return "data-query";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/tardis-admin " + this.func_71517_b() + " [tardis ID] [information]";
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
            switch (args.length) {
                case 1: {
                    return DataQuery.func_71530_a((String[])args, (String[])DMTardis.getTardisListAsArray());
                }
                case 2: {
                    return DataQuery.func_71530_a((String[])args, (String[])new String[]{"all", "owner", "chameleon-circuit", "location", "destination", "flight", "health", "hads", "cloak", "locked", "permissions", "interior", "count", "list"});
                }
                case 3: {
                    if (!args[2].equalsIgnoreCase("list")) break;
                    return DataQuery.func_71530_a((String[])args, (String[])server.func_71213_z());
                }
            }
            return super.func_184883_a(server, sender, args, targetPos);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length > 1) {
                EntityPlayerMP player = DataQuery.func_71521_c((ICommandSender)sender);
                int id = DataQuery.func_175755_a((String)args[0]);
                TardisData data = DMTardis.getTardis(id);
                String information = args[1];
                if (data.isRemoved()) {
                    PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.RED + "TARDIS was Removed");
                    return;
                }
                switch (information) {
                    case "all": {
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "-------------TARDIS-------------");
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "ID:" + data.getTardisID() + " | Owner: " + data.getOwner());
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Exterior: " + DMTardis.getTardisSkin(data.getExteriorID()).getExteriorName());
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Location: [" + data.getCurrentTardisPosition() + "]");
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Interior Pos: [" + data.getTardisInteriorDoorLocation() + "](" + data.getInteriorX() + ";" + data.getInteriorZ() + ")");
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Planet / Dimension: " + data.getTardisCurrentdimension());
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Destination: " + data.getCurrentLocationName());
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "In Flight: " + data.isInFlight());
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Health: " + data.getTardisHealth());
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "HADS: " + (data.getHads() ? "enabled" : "disabled"));
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Cloaked: " + (data.isCloak() ? "enabled" : "disabled"));
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Locked: " + data.isLocked());
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Permissions: " + (Object)((Object)data.getTardisPermissions()));
                        return;
                    }
                    case "owner": {
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "-------------TARDIS[" + TextFormatting.WHITE + data.getTardisID() + TextFormatting.GREEN + "]-------------");
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Owner: " + data.getOwner());
                        return;
                    }
                    case "chameleon-circuit": {
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "-------------TARDIS[" + TextFormatting.WHITE + data.getTardisID() + TextFormatting.GREEN + "]-------------");
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Exterior: " + DMTardis.getTardisSkin(data.getExteriorID()).getExteriorName());
                        return;
                    }
                    case "location": {
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "-------------TARDIS[" + TextFormatting.WHITE + data.getTardisID() + TextFormatting.GREEN + "]-------------");
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Location: [" + data.getCurrentTardisPosition() + "]");
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Planet / Dimension: " + data.getTardisCurrentdimension());
                        return;
                    }
                    case "destination": {
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "-------------TARDIS[" + TextFormatting.WHITE + data.getTardisID() + TextFormatting.GREEN + "]-------------");
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Destination: " + data.getCurrentLocationName());
                        return;
                    }
                    case "flight": {
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "-------------TARDIS[" + TextFormatting.WHITE + data.getTardisID() + TextFormatting.GREEN + "]-------------");
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "In Flight: " + data.isInFlight());
                        return;
                    }
                    case "health": {
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "-------------TARDIS[" + TextFormatting.WHITE + data.getTardisID() + TextFormatting.GREEN + "]-------------");
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Health: " + data.getTardisHealth());
                        return;
                    }
                    case "hads": {
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "-------------TARDIS[" + TextFormatting.WHITE + data.getTardisID() + TextFormatting.GREEN + "]-------------");
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "HADS: " + (data.getHads() ? "enabled" : "disabled"));
                        return;
                    }
                    case "cloak": {
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "-------------TARDIS[" + TextFormatting.WHITE + data.getTardisID() + TextFormatting.GREEN + "]-------------");
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Cloaked: " + (data.isCloak() ? "enabled" : "disabled"));
                        return;
                    }
                    case "locked": {
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "-------------TARDIS[" + TextFormatting.WHITE + data.getTardisID() + TextFormatting.GREEN + "]-------------");
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Locked: " + data.isLocked());
                        return;
                    }
                    case "permissions": {
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "-------------TARDIS[" + TextFormatting.WHITE + data.getTardisID() + TextFormatting.GREEN + "]-------------");
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Permissions: " + (Object)((Object)data.getTardisPermissions()));
                        return;
                    }
                    case "interior": {
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "-------------TARDIS[" + TextFormatting.WHITE + data.getTardisID() + TextFormatting.GREEN + "]-------------");
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Interior Pos: [" + data.getTardisInteriorDoorLocation() + "](" + data.getInteriorX() + ";" + data.getInteriorZ() + ")");
                        return;
                    }
                    case "count": {
                        String fileDir = ((File)FMLInjectionData.data()[6]).getAbsolutePath() + "/saves/" + TheDalekMod.FML.getMinecraftServerInstance().func_71270_I() + "/Tardis_Data/Tardises/";
                        File f = new File(fileDir);
                        int size = f.listFiles().length - 1 - DMTardis.removed_tardis.size();
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "There are currently " + size + " TARDIS IDs in use");
                        return;
                    }
                    case "list": {
                        if (args.length > 2) {
                            UUID uuid;
                            GameProfile profile = sender.func_184102_h().func_152358_ax().func_152655_a(args[2]);
                            if (profile != null && (uuid = profile.getId()) != null) {
                                DMTardis.reconstructPlayerLookup(uuid.toString());
                                UserTardises uTar = DMTardis.getUserTardises(uuid);
                                if (uTar != null && uTar.getTardises().size() > 0) {
                                    StringBuilder b = new StringBuilder();
                                    for (int i = 0; i < uTar.getTardises().size(); ++i) {
                                        b.append(uTar.getTardises().get(i) + (i == uTar.getTardises().size() - 1 ? "" : ","));
                                    }
                                    PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + args[2] + " owns the following Tardises: " + TextFormatting.RESET + b.toString());
                                    return;
                                }
                            }
                        } else {
                            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.BOLD + "Displaying TARDIS List for all online players");
                            for (EntityPlayerMP p : server.func_184103_al().func_181057_v()) {
                                UUID uuid = p.func_110124_au();
                                if (uuid == null) continue;
                                DMTardis.reconstructPlayerLookup(uuid.toString());
                                UserTardises uTar = DMTardis.getUserTardises(uuid);
                                if (uTar == null || uTar.getTardises().size() <= 0) continue;
                                StringBuilder b = new StringBuilder();
                                for (int i = 0; i < uTar.getTardises().size(); ++i) {
                                    b.append(uTar.getTardises().get(i) + (i == uTar.getTardises().size() - 1 ? "" : ","));
                                }
                                PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + p.func_70005_c_() + " owns the following Tardises: " + TextFormatting.RESET + b.toString());
                            }
                        }
                        return;
                    }
                }
                return;
            }
            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)DataQuery.func_71521_c((ICommandSender)sender), TextFormatting.RED + "Usage: " + this.func_71518_a(sender));
        }
    }

    private class DataChange
    extends CommandBase {
        private DataChange() {
        }

        public String func_71517_b() {
            return "data-change";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/tardis-admin " + this.func_71517_b() + " [x y x] [tardis ID] [data] [value]";
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
            switch (args.length) {
                case 1: {
                    if (targetPos != null) {
                        return DataChange.func_71530_a((String[])args, (String[])new String[]{"" + targetPos.func_177958_n()});
                    }
                    return DataChange.func_71530_a((String[])args, (String[])new String[]{"~"});
                }
                case 2: {
                    if (targetPos != null) {
                        return DataChange.func_71530_a((String[])args, (String[])new String[]{"" + targetPos.func_177956_o()});
                    }
                    return DataChange.func_71530_a((String[])args, (String[])new String[]{"~"});
                }
                case 3: {
                    if (targetPos != null) {
                        return DataChange.func_71530_a((String[])args, (String[])new String[]{"" + targetPos.func_177952_p()});
                    }
                    return DataChange.func_71530_a((String[])args, (String[])new String[]{"~"});
                }
                case 4: {
                    return DataChange.func_71530_a((String[])args, (String[])DMTardis.getTardisListAsArray());
                }
                case 5: {
                    return DataChange.func_71530_a((String[])args, (String[])new String[]{"owner", "chameleon-circuit", "scale", "summon", "destination", "demat", "health", "hads", "forcefield", "cloak", "locked", "open", "permissions", "interior", "add-companion", "remove"});
                }
                case 6: {
                    if (!args[4].equalsIgnoreCase("owner") && !args[4].equalsIgnoreCase("add-companion")) break;
                    return DataChange.func_71530_a((String[])args, (String[])server.func_71213_z());
                }
            }
            return super.func_184883_a(server, sender, args, targetPos);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length > 5) {
                EntityPlayerMP player = DataChange.func_71521_c((ICommandSender)sender);
                Vector3d coords = new Vector3d(DataChange.func_175770_a((double)player.field_70165_t, (String)args[0], (boolean)true).func_179628_a(), DataChange.func_175770_a((double)player.field_70163_u, (String)args[1], (boolean)true).func_179628_a(), DataChange.func_175770_a((double)player.field_70161_v, (String)args[2], (boolean)true).func_179628_a());
                BlockPos blockpos = new BlockPos(coords.x, coords.y, coords.z);
                int id = DataChange.func_175755_a((String)args[3]);
                String information = args[4];
                String value = args[5];
                TardisData data = DMTardis.getTardis(id);
                TileEntityTardis tardis = null;
                if (player.field_70170_p.func_180495_p(blockpos).func_177230_c() == DMBlocks.TARDIS && player.func_130014_f_().func_175625_s(blockpos) instanceof TileEntityTardis) {
                    tardis = (TileEntityTardis)player.func_130014_f_().func_175625_s(blockpos);
                    if (tardis.tempTardisData != null) {
                        data = tardis.tempTardisData;
                    }
                    id = data.getTardisID();
                }
                switch (information) {
                    case "owner": {
                        this.owner(data, value, sender);
                        break;
                    }
                    case "chameleon-circuit": {
                        int chamid = DataChange.func_175755_a((String)value);
                        if (chamid <= 0) {
                            chamid = 1;
                        }
                        data.setExteriorID(chamid);
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.YELLOW + "You set the TARDIS(" + data.getTardisID() + ") Chameleon Circuit to " + DMTardis.getTardisSkin(data.getExteriorID()).getExteriorName());
                        break;
                    }
                    case "scale": {
                        double scale = DataChange.func_175765_c((String)value);
                        if (!(scale > 0.0)) {
                            scale = 1.0;
                        }
                        data.setScale((float)scale);
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.YELLOW + "You have scaled the TARDIS(" + data.getTardisID() + ") to " + data.getScale());
                        break;
                    }
                    case "summon": {
                        this.summon(data, player, args, sender, server);
                        break;
                    }
                    case "destination": {
                        if (args.length <= 7) break;
                        if (args.length > 8) {
                            data.setTravelRotation((float)DataChange.func_175765_c((String)args[8]));
                        }
                        if (args.length > 9) {
                            data.setTardisCurrentDimensionLocation(DataChange.func_175755_a((String)args[9]));
                        }
                        data.setCurrentTardisPosition(new Vector3((int)DataChange.func_175770_a((double)player.field_70165_t, (String)args[5], (boolean)true).func_179628_a(), (int)DataChange.func_175770_a((double)player.field_70163_u, (String)args[6], (boolean)true).func_179628_a(), (int)DataChange.func_175770_a((double)player.field_70161_v, (String)args[7], (boolean)true).func_179628_a()));
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.YELLOW + "You set the TARDIS(" + data.getTardisID() + ") Destination to " + data.getCurrentTardisPosition() + " DIM " + data.getTardisCurrentdimension());
                        break;
                    }
                    case "demat": {
                        if (tardis == null) break;
                        tardis.setDemat(DataChange.func_180527_d((String)value));
                        break;
                    }
                    case "health": {
                        int health = DataChange.func_175755_a((String)value);
                        if (health <= 0) {
                            health = 1;
                        }
                        data.setTardisHealth(health);
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.YELLOW + "You set the TARDIS(" + data.getTardisID() + ") Health to " + data.getTardisHealth());
                        break;
                    }
                    case "hads": {
                        boolean hads = DataChange.func_180527_d((String)value);
                        data.setHads(hads);
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.YELLOW + "You set the TARDIS(" + data.getTardisID() + ") HADS to " + data.getHads());
                        break;
                    }
                    case "forcefield": {
                        boolean forcefield = DataChange.func_180527_d((String)value);
                        data.setForcefieldsEnabled(forcefield);
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.YELLOW + "You set the TARDIS(" + data.getTardisID() + ") Forcefield to " + data.areForcefieldsEnabled());
                        break;
                    }
                    case "cloak": {
                        boolean cloak = DataChange.func_180527_d((String)value);
                        data.setCloak(cloak);
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.YELLOW + "You set the TARDIS(" + data.getTardisID() + ") Cloack to " + data.isCloak());
                        break;
                    }
                    case "locked": {
                        boolean lock = DataChange.func_180527_d((String)value);
                        data.setLocked(lock);
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.YELLOW + "You set the TARDIS(" + data.getTardisID() + ") Lock to " + data.isLocked());
                        break;
                    }
                    case "permissions": {
                        data.setTardisPermissions(TardisPermission.getFromString(value.replaceAll("nobody", "owner")));
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.YELLOW + "You set the TARDIS(" + data.getTardisID() + ") Permission level to " + (Object)((Object)data.getTardisPermissions()));
                        break;
                    }
                    case "interior": {
                        if (args.length <= 7) break;
                        if (args.length > 8) {
                            data.setSpawnFacing((float)DataChange.func_175765_c((String)args[8]));
                        }
                        data.setTardisInteriorDoorLocation(new Vector3((int)DataChange.func_175770_a((double)player.field_70165_t, (String)args[5], (boolean)true).func_179628_a(), (int)DataChange.func_175770_a((double)player.field_70163_u, (String)args[6], (boolean)true).func_179628_a(), (int)DataChange.func_175770_a((double)player.field_70161_v, (String)args[7], (boolean)true).func_179628_a()));
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.YELLOW + "You set the TARDIS(" + data.getTardisID() + ") Interior position to " + (Object)((Object)data.getTardisPermissions()));
                        break;
                    }
                    case "add-companion": {
                        this.companion(data, value, sender, server);
                        break;
                    }
                    case "remove": {
                        System.out.println(data.getTardisID());
                        if (!DMTardis.removeTardis(data, (EntityPlayer)player, DataChange.func_180527_d((String)value))) break;
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.RED + "Removed TARDIS with ID: " + data.getTardisID());
                        break;
                    }
                }
                TardisSaveHandler.saveTardis(data);
                for (Object p : player.field_70170_p.field_73010_i) {
                    DMTardis.loadClientData(data.getTardisID(), (EntityPlayerMP)p);
                }
                return;
            }
            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)DataChange.func_71521_c((ICommandSender)sender), TextFormatting.RED + "Usage: " + this.func_71518_a(sender));
        }

        private void owner(TardisData data, String owner, ICommandSender sender) throws PlayerNotFoundException {
            GameProfile profile = sender.func_184102_h().func_152358_ax().func_152655_a(owner);
            if (profile != null) {
                UUID uuid = profile.getId();
                if (uuid == null || !(sender instanceof EntityPlayerMP)) {
                    uuid = UUID.fromString(DMUtils.getUUIDs(owner.replaceAll("@p", sender.func_70005_c_())));
                }
                if (uuid != null) {
                    UserTardises uTarOld = DMTardis.getUserTardises(data.getCurrentOwner());
                    UserTardises uTarNew = DMTardis.getUserTardises(uuid);
                    uTarOld.getTardises().removeAll(Arrays.asList(data.getTardisID()));
                    uTarNew.addTardis(data.getTardisID());
                    DMTardis.updateUserTardisData(uTarOld, data.getCurrentOwner());
                    DMTardis.updateUserTardisData(uTarNew, uuid);
                    data.setCurrentOwner(uuid);
                    data.setOwner(owner.replaceAll("@p", sender.func_70005_c_()));
                    if (sender instanceof EntityPlayerMP) {
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)DataChange.func_71521_c((ICommandSender)sender), TextFormatting.YELLOW + "You have transferred TARDIS(" + data.getTardisID() + ") ownership to " + data.getOwner());
                    }
                }
            }
        }

        private void companion(TardisData data, String value, ICommandSender sender, MinecraftServer server) throws PlayerNotFoundException {
            UUID uuid;
            GameProfile profile = sender.func_184102_h().func_152358_ax().func_152655_a(value.replaceAll("@p", sender.func_70005_c_()));
            if (profile != null && (uuid = profile.getId()) != null && server.func_175576_a(uuid) instanceof EntityPlayerMP) {
                EntityPlayerMP companion = (EntityPlayerMP)server.func_175576_a(uuid);
                data.addCompanion((EntityPlayer)companion);
                data.setTardisPermissions(TardisPermission.COMPANIONS);
                if (sender instanceof EntityPlayerMP) {
                    PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)DataChange.func_71521_c((ICommandSender)sender), TextFormatting.YELLOW + "Added " + companion.func_70005_c_() + " to the TARDIS(" + data.getTardisID() + ")");
                }
            }
        }

        private void summon(TardisData data, EntityPlayerMP player, String[] args, ICommandSender sender, MinecraftServer server) throws PlayerNotFoundException, NumberInvalidException {
            BlockPos landpos = player.func_180425_c();
            float rotation = player.func_70079_am();
            World world = player.field_70170_p;
            if (args.length > 8) {
                Vector3d landcoords = new Vector3d(DataChange.func_175770_a((double)player.field_70165_t, (String)args[5], (boolean)true).func_179628_a(), DataChange.func_175770_a((double)player.field_70163_u, (String)args[6], (boolean)true).func_179628_a(), DataChange.func_175770_a((double)player.field_70161_v, (String)args[7], (boolean)true).func_179628_a());
                landpos = new BlockPos(landcoords.x, landcoords.y, landcoords.z);
                if (args.length > 8) {
                    rotation = (float)DataChange.func_175765_c((String)args[8]);
                }
                if (args.length > 9 && DataChange.func_175755_a((String)args[9]) != DMDimensions.DIM_TARDIS_ID) {
                    world = server.func_71218_a(DataChange.func_175755_a((String)args[9]));
                }
            }
            if (WorldUtils.summonTardisToPos(world, data, landpos, rotation) == EnumActionResult.SUCCESS) {
                PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "Summoned Tardis with ID: " + data.getTardisID() + " to " + landpos.func_177958_n() + "|" + landpos.func_177956_o() + "|" + landpos.func_177952_p() + " DIM: " + world.field_73011_w.func_186058_p().func_186065_b());
            }
        }
    }
}

