/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.model;

import com.swdteam.client.model.DMVortex;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.opengl.GL11;

public class ModelDMVortex {
    public static final int SIZE = 12;
    public int texture = 0;
    public double[] color = new double[]{1.0, 1.0, 1.0};
    public double speed = 1.0;
    public double distortion_speed = 1.0;
    public double distortion_factor = 1.0;
    public double distortion_separation_factor = 0.6666666666666666;
    public double rotation_speed = 1.0;
    public double rotation_factor = 1.0;
    public double texture_rotation_offset_factor = 0.0;
    public boolean senoid_rotation = true;
    public boolean custom_color = false;
    public boolean rainbow = false;
    public double rainbow_speed = 1.0;
    public boolean depth_change = false;
    public double depth_scale = 1.0;
    public double depth_change_speed = 1.0;
    public double scale = 10.0;
    public boolean update_custom_color_settings = true;

    public ModelDMVortex(int texture, double r, double g, double b, double speed, double distortion_speed, double distortion_factor, double distortion_separation_factor, double rotation_speed, double rotation_factor, double texture_rotation_offset_factor, boolean senoid_rotation, boolean custom_color, boolean rainbow, boolean depth_change, double depth_scale, double depth_change_speed) {
        this.texture = texture;
        this.color = new double[]{r, g, b};
        this.speed = speed;
        this.distortion_speed = distortion_speed;
        this.distortion_factor = distortion_factor;
        this.distortion_separation_factor = distortion_separation_factor;
        this.rotation_speed = rotation_speed;
        this.rotation_factor = rotation_factor;
        this.texture_rotation_offset_factor = texture_rotation_offset_factor;
        this.senoid_rotation = senoid_rotation;
        this.custom_color = custom_color;
        this.rainbow = rainbow;
        this.depth_change = depth_change;
        this.depth_scale = depth_scale;
        this.depth_change_speed = depth_change_speed;
    }

    public ModelDMVortex(DMVortex.DMVortexType type) {
        this.updateSettings(type);
    }

    public void updateSettings(DMVortex.DMVortexType type) {
        if (type == DMVortex.DMVortexType.CUSTOM) {
            if (this.update_custom_color_settings) {
                this.rainbow = Math.random() > 0.5;
                this.rainbow_speed = 1.0 + Math.random() * 9.0;
                this.color = new double[]{Math.random() * 2.0, Math.random() * 2.0, Math.random() * 2.0};
            }
            this.texture = type.texture;
            this.speed = type.speed;
            this.distortion_speed = type.distortion_speed;
            this.distortion_factor = type.distortion_factor;
            this.distortion_separation_factor = type.distortion_separation_factor;
            this.rotation_speed = type.rotation_speed;
            this.rotation_factor = type.rotation_factor;
            this.texture_rotation_offset_factor = type.texture_rotation_offset_factor;
            this.senoid_rotation = type.senoid_rotation;
            this.custom_color = true;
            this.depth_change = type.depth_change;
            this.depth_scale = type.depth_scale;
            this.depth_change_speed = type.depth_change_speed;
        } else {
            this.texture = type.texture;
            this.speed = type.speed;
            this.distortion_speed = type.distortion_speed;
            this.distortion_factor = type.distortion_factor;
            this.distortion_separation_factor = type.distortion_separation_factor;
            this.rotation_speed = type.rotation_speed;
            this.rotation_factor = type.rotation_factor;
            this.texture_rotation_offset_factor = type.texture_rotation_offset_factor;
            this.senoid_rotation = type.senoid_rotation;
            this.custom_color = false;
            this.rainbow = false;
            this.depth_change = type.depth_change;
            this.depth_scale = type.depth_scale;
            this.depth_change_speed = type.depth_change_speed;
        }
    }

    public ModelDMVortex(Random rand) {
        this.updateSettings(rand);
    }

    public void updateSettings(Random rand) {
        this.texture = rand.nextInt(DMVortex.VORTEXTEXTURE.length);
        this.speed = 1.0 + Math.random() * 50.0;
        this.distortion_speed = Math.random() * 40.0;
        this.distortion_factor = Math.random() * 2.0;
        this.distortion_separation_factor = Math.random() * 4.0;
        this.rotation_speed = Math.random() * 18.0;
        this.rotation_factor = Math.random() * 20.0;
        this.texture_rotation_offset_factor = Math.random() * 5.0;
        this.senoid_rotation = rand.nextBoolean();
        this.custom_color = this.texture == 0 ? true : rand.nextBoolean();
        this.rainbow = rand.nextBoolean();
        this.rainbow_speed = 1.0 + Math.random() * 9.0;
        this.color = new double[]{Math.random() * 2.0, Math.random() * 2.0, Math.random() * 2.0};
        this.depth_change = rand.nextBoolean();
        this.depth_scale = Math.random() * 10.0;
        this.depth_change_speed = Math.random() * 40.0;
    }

    public void render() {
        this.render((double)System.currentTimeMillis() / 100000.0);
    }

    public void render(boolean fullvortex) {
        this.render((double)System.currentTimeMillis() / 100000.0, fullvortex);
    }

    public void render(double time) {
        this.render(time, true);
    }

    public void render(double time, boolean fullvortex) {
        this.rendervortex(time >= 0.0 ? time : 0.0, fullvortex);
    }

    public void rendervortex(double time, boolean fullvortex) {
        int i;
        GlStateManager.func_179094_E();
        GlStateManager.func_179089_o();
        GlStateManager.func_179098_w();
        GlStateManager.func_179140_f();
        GL11.glScaled((double)this.scale, (double)this.scale, (double)this.scale);
        if (this.depth_change) {
            GL11.glScaled((double)1.0, (double)1.0, (double)(1.0 + this.depth_scale * Math.sin(time * this.depth_change_speed) + (this.depth_scale - 0.9)));
        }
        GL11.glTranslated((double)0.0, (double)0.0, (double)6.0);
        double f0 = Math.toDegrees(this.senoid_rotation ? this.rotation_factor * Math.sin(time * this.rotation_speed) : this.rotation_factor * time * this.rotation_speed) + 360.0;
        double f1 = f0 / 360.0 - (double)((int)(f0 / 360.0));
        double f2 = this.texture_rotation_offset_factor * f1 - (double)((int)(this.texture_rotation_offset_factor * f1));
        GL11.glRotated((double)(f1 * 360.0), (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)0.0, (double)(-this.o(time, 6)), (double)0.0);
        if (this.custom_color) {
            if (this.rainbow) {
                GL11.glColor3d((double)(Math.sin(time * this.rainbow_speed) + 1.0), (double)(Math.sin(2.0 + time * this.rainbow_speed) + 1.0), (double)(Math.sin(4.0 + time * this.rainbow_speed) + 1.0));
            } else {
                GL11.glColor3d((double)this.color[0], (double)this.color[1], (double)this.color[2]);
            }
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(DMVortex.VORTEXTEXTURE[this.texture]);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        int n = i = fullvortex ? 0 : 6;
        while (i < 12) {
            this.vortexSection(buffer, time, i, time * this.speed - (double)((int)(time * this.speed)), f2, Math.sin((double)i * Math.PI / 12.0), Math.sin((double)(i + 1) * Math.PI / 12.0));
            ++i;
        }
        tessellator.func_78381_a();
        GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
        GlStateManager.func_179082_a((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    public void vortexSection(BufferBuilder builder, double time, int location_offset, double texture_distance_offset, double texture_rotation_offset, double start_scale, double end___scale) {
        int v_offset = (double)location_offset * 0.16666666666666666 + texture_distance_offset > 1.0 ? location_offset - 6 : location_offset;
        int u_offset = 0.0 + texture_rotation_offset > 1.0 ? -6 : 0;
        builder.func_181662_b(start_scale * -0.0, start_scale * -1.0 + this.o(time, location_offset + 0), (double)(0 - location_offset)).func_187315_a((double)u_offset * 0.16666666666666666 + 0.0 + texture_rotation_offset, (double)v_offset * 0.16666666666666666 + 0.0 + texture_distance_offset).func_181675_d();
        builder.func_181662_b(end___scale * -0.0, end___scale * -1.0 + this.o(time, location_offset + 1), (double)(-1 - location_offset)).func_187315_a((double)u_offset * 0.16666666666666666 + 0.0 + texture_rotation_offset, (double)v_offset * 0.16666666666666666 + 0.16666666666666666 + texture_distance_offset).func_181675_d();
        builder.func_181662_b(end___scale * -0.866025, end___scale * -0.5 + this.o(time, location_offset + 1), (double)(-1 - location_offset)).func_187315_a((double)u_offset * 0.16666666666666666 + 0.16666666666666666 + texture_rotation_offset, (double)v_offset * 0.16666666666666666 + 0.16666666666666666 + texture_distance_offset).func_181675_d();
        builder.func_181662_b(start_scale * -0.866025, start_scale * -0.5 + this.o(time, location_offset + 0), (double)(0 - location_offset)).func_187315_a((double)u_offset * 0.16666666666666666 + 0.16666666666666666 + texture_rotation_offset, (double)v_offset * 0.16666666666666666 + 0.0 + texture_distance_offset).func_181675_d();
        u_offset = 0.16666666666666666 + texture_rotation_offset > 1.0 ? -5 : 1;
        builder.func_181662_b(start_scale * -0.866025, start_scale * -0.5 + this.o(time, location_offset + 0), (double)(0 - location_offset)).func_187315_a((double)u_offset * 0.16666666666666666 + 0.0 + texture_rotation_offset, (double)v_offset * 0.16666666666666666 + 0.0 + texture_distance_offset).func_181675_d();
        builder.func_181662_b(end___scale * -0.866025, end___scale * -0.5 + this.o(time, location_offset + 1), (double)(-1 - location_offset)).func_187315_a((double)u_offset * 0.16666666666666666 + 0.0 + texture_rotation_offset, (double)v_offset * 0.16666666666666666 + 0.16666666666666666 + texture_distance_offset).func_181675_d();
        builder.func_181662_b(end___scale * -0.866025, end___scale * 0.5 + this.o(time, location_offset + 1), (double)(-1 - location_offset)).func_187315_a((double)u_offset * 0.16666666666666666 + 0.16666666666666666 + texture_rotation_offset, (double)v_offset * 0.16666666666666666 + 0.16666666666666666 + texture_distance_offset).func_181675_d();
        builder.func_181662_b(start_scale * -0.866025, start_scale * 0.5 + this.o(time, location_offset + 0), (double)(0 - location_offset)).func_187315_a((double)u_offset * 0.16666666666666666 + 0.16666666666666666 + texture_rotation_offset, (double)v_offset * 0.16666666666666666 + 0.0 + texture_distance_offset).func_181675_d();
        u_offset = 0.3333333333333333 + texture_rotation_offset > 1.0 ? -4 : 2;
        builder.func_181662_b(start_scale * -0.866025, start_scale * 0.5 + this.o(time, location_offset + 0), (double)(0 - location_offset)).func_187315_a((double)u_offset * 0.16666666666666666 + 0.0 + texture_rotation_offset, (double)v_offset * 0.16666666666666666 + 0.0 + texture_distance_offset).func_181675_d();
        builder.func_181662_b(end___scale * -0.866025, end___scale * 0.5 + this.o(time, location_offset + 1), (double)(-1 - location_offset)).func_187315_a((double)u_offset * 0.16666666666666666 + 0.0 + texture_rotation_offset, (double)v_offset * 0.16666666666666666 + 0.16666666666666666 + texture_distance_offset).func_181675_d();
        builder.func_181662_b(end___scale * -0.0, end___scale * 1.0 + this.o(time, location_offset + 1), (double)(-1 - location_offset)).func_187315_a((double)u_offset * 0.16666666666666666 + 0.16666666666666666 + texture_rotation_offset, (double)v_offset * 0.16666666666666666 + 0.16666666666666666 + texture_distance_offset).func_181675_d();
        builder.func_181662_b(start_scale * -0.0, start_scale * 1.0 + this.o(time, location_offset + 0), (double)(0 - location_offset)).func_187315_a((double)u_offset * 0.16666666666666666 + 0.16666666666666666 + texture_rotation_offset, (double)v_offset * 0.16666666666666666 + 0.0 + texture_distance_offset).func_181675_d();
        u_offset = 0.5 + texture_rotation_offset > 1.0 ? -3 : 3;
        builder.func_181662_b(start_scale * -0.0, start_scale * 1.0 + this.o(time, location_offset + 0), (double)(0 - location_offset)).func_187315_a((double)u_offset * 0.16666666666666666 + 0.0 + texture_rotation_offset, (double)v_offset * 0.16666666666666666 + 0.0 + texture_distance_offset).func_181675_d();
        builder.func_181662_b(end___scale * -0.0, end___scale * 1.0 + this.o(time, location_offset + 1), (double)(-1 - location_offset)).func_187315_a((double)u_offset * 0.16666666666666666 + 0.0 + texture_rotation_offset, (double)v_offset * 0.16666666666666666 + 0.16666666666666666 + texture_distance_offset).func_181675_d();
        builder.func_181662_b(end___scale * 0.866025, end___scale * 0.5 + this.o(time, location_offset + 1), (double)(-1 - location_offset)).func_187315_a((double)u_offset * 0.16666666666666666 + 0.16666666666666666 + texture_rotation_offset, (double)v_offset * 0.16666666666666666 + 0.16666666666666666 + texture_distance_offset).func_181675_d();
        builder.func_181662_b(start_scale * 0.866025, start_scale * 0.5 + this.o(time, location_offset + 0), (double)(0 - location_offset)).func_187315_a((double)u_offset * 0.16666666666666666 + 0.16666666666666666 + texture_rotation_offset, (double)v_offset * 0.16666666666666666 + 0.0 + texture_distance_offset).func_181675_d();
        u_offset = 0.6666666666666666 + texture_rotation_offset > 1.0 ? -2 : 4;
        builder.func_181662_b(start_scale * 0.866025, start_scale * 0.5 + this.o(time, location_offset + 0), (double)(0 - location_offset)).func_187315_a((double)u_offset * 0.16666666666666666 + 0.0 + texture_rotation_offset, (double)v_offset * 0.16666666666666666 + 0.0 + texture_distance_offset).func_181675_d();
        builder.func_181662_b(end___scale * 0.866025, end___scale * 0.5 + this.o(time, location_offset + 1), (double)(-1 - location_offset)).func_187315_a((double)u_offset * 0.16666666666666666 + 0.0 + texture_rotation_offset, (double)v_offset * 0.16666666666666666 + 0.16666666666666666 + texture_distance_offset).func_181675_d();
        builder.func_181662_b(end___scale * 0.866025, end___scale * -0.5 + this.o(time, location_offset + 1), (double)(-1 - location_offset)).func_187315_a((double)u_offset * 0.16666666666666666 + 0.16666666666666666 + texture_rotation_offset, (double)v_offset * 0.16666666666666666 + 0.16666666666666666 + texture_distance_offset).func_181675_d();
        builder.func_181662_b(start_scale * 0.866025, start_scale * -0.5 + this.o(time, location_offset + 0), (double)(0 - location_offset)).func_187315_a((double)u_offset * 0.16666666666666666 + 0.16666666666666666 + texture_rotation_offset, (double)v_offset * 0.16666666666666666 + 0.0 + texture_distance_offset).func_181675_d();
        u_offset = 0.8333333333333333 + texture_rotation_offset > 1.0 ? -1 : 5;
        builder.func_181662_b(start_scale * 0.866025, start_scale * -0.5 + this.o(time, location_offset + 0), (double)(0 - location_offset)).func_187315_a((double)u_offset * 0.16666666666666666 + 0.0 + texture_rotation_offset, (double)v_offset * 0.16666666666666666 + 0.0 + texture_distance_offset).func_181675_d();
        builder.func_181662_b(end___scale * 0.866025, end___scale * -0.5 + this.o(time, location_offset + 1), (double)(-1 - location_offset)).func_187315_a((double)u_offset * 0.16666666666666666 + 0.0 + texture_rotation_offset, (double)v_offset * 0.16666666666666666 + 0.16666666666666666 + texture_distance_offset).func_181675_d();
        builder.func_181662_b(end___scale * -0.0, end___scale * -1.0 + this.o(time, location_offset + 1), (double)(-1 - location_offset)).func_187315_a((double)u_offset * 0.16666666666666666 + 0.16666666666666666 + texture_rotation_offset, (double)v_offset * 0.16666666666666666 + 0.16666666666666666 + texture_distance_offset).func_181675_d();
        builder.func_181662_b(start_scale * -0.0, start_scale * -1.0 + this.o(time, location_offset + 0), (double)(0 - location_offset)).func_187315_a((double)u_offset * 0.16666666666666666 + 0.16666666666666666 + texture_rotation_offset, (double)v_offset * 0.16666666666666666 + 0.0 + texture_distance_offset).func_181675_d();
    }

    private double o(double time, int t) {
        return Math.sin(time * this.distortion_speed * 2.0 * Math.PI + (double)(13 - t) * this.distortion_separation_factor) * this.distortion_factor;
    }
}

