/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.worldportal;

import com.swdteam.client.worldportal.BlockData;
import com.swdteam.client.worldportal.CustomWorld;
import com.swdteam.client.worldportal.CustomWorldClient;
import com.swdteam.client.worldportal.IWorldPortal;
import com.swdteam.client.worldportal.WorldRender;
import com.swdteam.client.worldportal.packet.PacketWorldPortal;
import com.swdteam.common.tileentity.TileEntityGallifreyFallsPainting;
import com.swdteam.main.TheDalekMod;
import com.swdteam.main.config.DMConfig;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.utils.Graphics;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BlockFluidRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class WorldPortal {
    public static HashMap<Integer, CustomWorldClient> clients = new HashMap();
    public static HashMap<Long, BufferBuilder.State> worldrenders = new HashMap();
    public static CustomWorld customWorld = new CustomWorld();
    public static List<String> tileEntities_ignore = new ArrayList<String>();
    public static BlockFluidRenderer blockFluidRenderer = new BlockFluidRenderer(Minecraft.func_71410_x().func_184125_al());
    public static int RELOAD = 500;
    private static long f382 = System.currentTimeMillis();

    @SideOnly(value=Side.CLIENT)
    public static void render(IWorldPortal world, Vec3d renderPos, float rot) {
        if (DMConfig.clientSide.renderBoti) {
            if (world != null) {
                GlStateManager.func_179094_E();
                GL11.glShadeModel((int)7425);
                if (clients.containsKey(world.getWorldRender().getDimension())) {
                    WorldClient worldClient = clients.get(world.getWorldRender().getDimension());
                    if (worldClient != null && worldClient.field_73011_w != null && worldClient.field_73011_w.getSkyRenderer() != null) {
                        worldClient.field_73011_w.getSkyRenderer().render(Minecraft.func_71410_x().func_184121_ak(), worldClient, Minecraft.func_71410_x());
                    } else {
                        int dim = Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension();
                        Minecraft.func_71410_x().field_71441_e.field_73011_w.setDimension(world.getDimension());
                        Minecraft.func_71410_x().field_71441_e.field_73011_w.setSkyRenderer(null);
                        GlStateManager.func_179109_b((float)0.0f, (float)5.0f, (float)0.0f);
                        Minecraft.func_71410_x().field_71438_f.func_174976_a(Minecraft.func_71410_x().func_184121_ak(), 0);
                        Minecraft.func_71410_x().field_71438_f.func_180447_b(Minecraft.func_71410_x().func_184121_ak(), 0, 10.0, 10.0, 10.0);
                        GlStateManager.func_179109_b((float)0.0f, (float)-5.0f, (float)0.0f);
                        Minecraft.func_71410_x().field_71441_e.field_73011_w.setDimension(dim);
                    }
                } else {
                    world.getWorldRender().renderPos = BlockPos.field_177992_a;
                }
                if (world.getWorldRender().blocks != null) {
                    Framebuffer old = Minecraft.func_71410_x().func_147110_a();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.5);
                    GlStateManager.func_179114_b((float)((int)rot), (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)-0.5);
                    GlStateManager.func_179137_b((double)0.0, (double)-1.5, (double)0.0);
                    BlockPos offset = world.getWorldRender().renderPos;
                    GlStateManager.func_179137_b((double)(renderPos.field_72450_a - (double)offset.func_177958_n()), (double)(renderPos.field_72448_b - (double)offset.func_177956_o()), (double)(renderPos.field_72449_c - (double)offset.func_177952_p()));
                    GlStateManager.func_179137_b((double)(-renderPos.field_72450_a), (double)(-renderPos.field_72448_b), (double)(-renderPos.field_72449_c));
                    WorldPortal.renderBlocks(world);
                    old.func_147610_a(true);
                    GlStateManager.func_179121_F();
                } else {
                    world.requestRender();
                }
            }
            GlStateManager.func_179121_F();
        }
    }

    public static void drawOutline(Vec3d s) {
        GlStateManager.func_179094_E();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)((float)Color.BLACK.getRed() / 255.0f), (float)((float)Color.BLACK.getGreen() / 255.0f), (float)((float)Color.BLACK.getBlue() / 255.0f), (float)((float)Color.BLACK.getAlpha() / 255.0f));
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buf = tes.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        buf.func_181662_b(0.0, s.field_72448_b, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buf.func_181662_b(s.field_72450_a, s.field_72448_b, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buf.func_181662_b(s.field_72450_a, 0.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        tes.func_78381_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderBlocks(IWorldPortal portal) {
        WorldRender world = portal.getWorldRender();
        if (RELOAD < 500) {
            ++RELOAD;
        } else {
            RELOAD = 0;
            worldrenders.clear();
        }
        if (!worldrenders.containsKey(world.identifier) || worldrenders.get(world.identifier) == null) {
            BlockPos blockPos;
            IBlockState block;
            GlStateManager.func_179094_E();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexBuffer = tessellator.func_178180_c();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            HashMap<BlockPos, BlockData> see_Trough_blocks = new HashMap<BlockPos, BlockData>();
            Graphics.bindTexture(TextureMap.field_110575_b);
            for (Map.Entry<BlockPos, BlockData> entry : world.blocks.entrySet()) {
                block = entry.getValue().getState();
                blockPos = entry.getKey();
                if (blockPos == null || block == null || block == null || blockPos.func_177986_g() == portal.getWorldRender().getRenderPos().func_177986_g()) continue;
                if (block.func_177230_c().func_180664_k() == BlockRenderLayer.TRANSLUCENT) {
                    see_Trough_blocks.put(blockPos, entry.getValue());
                }
                if (see_Trough_blocks.containsKey(blockPos)) continue;
                Minecraft.func_71410_x().func_175602_ab().func_175018_a(block, blockPos, (IBlockAccess)customWorld, vertexBuffer);
            }
            for (Map.Entry<Object, BlockData> entry : see_Trough_blocks.entrySet()) {
                block = entry.getValue().getState();
                blockPos = (BlockPos)entry.getKey();
                if (blockPos == null || block == null || block == null || blockPos.func_177986_g() == portal.getWorldRender().getRenderPos().func_177986_g()) continue;
                if (block.func_185901_i() == EnumBlockRenderType.LIQUID) {
                    blockPos = blockPos.func_177984_a();
                }
                Minecraft.func_71410_x().func_175602_ab().func_175018_a(block, blockPos, (IBlockAccess)customWorld, vertexBuffer);
            }
            see_Trough_blocks.clear();
            worldrenders.put(world.identifier, vertexBuffer.func_181672_a());
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
        } else {
            GlStateManager.func_179094_E();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexBuffer = tessellator.func_178180_c();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            Graphics.bindTexture(TextureMap.field_110575_b);
            vertexBuffer.func_178993_a(worldrenders.get(world.identifier));
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
        }
        if (clients.containsKey(portal.getDimension())) {
            WorldPortal.renderTiles(portal, clients.get(portal.getDimension()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderTiles(IWorldPortal portal, CustomWorldClient client) {
        GlStateManager.func_179094_E();
        Graphics.bindTexture(TextureMap.field_110575_b);
        for (int i = 0; i < portal.getWorldRender().tileEntities.size(); ++i) {
            block5: {
                int pass;
                TileEntity tileEntity = portal.getWorldRender().tileEntities.get(i);
                if (tileEntity == null || tileEntity instanceof TileEntityGallifreyFallsPainting || tileEntity.func_174877_v().func_177986_g() == portal.getPosToRender().func_177986_g() || tileEntities_ignore.contains(tileEntity.getClass().getSimpleName()) || !tileEntity.shouldRenderInPass(pass = MinecraftForgeClient.getRenderPass())) continue;
                try {
                    if (tileEntity.func_145831_w() == null) {
                        tileEntity.func_145834_a((World)client);
                    }
                    if (tileEntity instanceof ITickable && System.currentTimeMillis() - f382 >= 50L) {
                        f382 = System.currentTimeMillis();
                        ((ITickable)tileEntity).func_73660_a();
                    }
                    TileEntityRendererDispatcher.field_147556_a.func_147547_b(tileEntity).func_192841_a(tileEntity, (double)tileEntity.func_174877_v().func_177958_n(), (double)tileEntity.func_174877_v().func_177956_o(), (double)tileEntity.func_174877_v().func_177952_p(), Minecraft.func_71410_x().func_184121_ak(), -100, 1.0f);
                }
                catch (Exception e) {
                    if (tileEntities_ignore.contains(tileEntity.getClass().getSimpleName())) break block5;
                    tileEntities_ignore.add(tileEntity.getClass().getSimpleName());
                    portal.getWorldRender().tileEntities.remove(tileEntity);
                    TheDalekMod.LOG.warn(tileEntity.getClass().getSimpleName() + " couldn't be rendered!");
                }
            }
            GlStateManager.func_179145_e();
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    public static void renderEntities(WorldRender world, BlockPos p) {
        List<Entity> entities = world.entities;
        for (Entity e : entities) {
            if (e == null) continue;
            double x1 = e.field_70165_t;
            double y1 = e.field_70163_u;
            double z1 = e.field_70161_v;
            e.func_189654_d(true);
            e.func_70071_h_();
            e.field_70124_G = true;
            Minecraft.func_71410_x().func_175598_ae().func_188391_a(e, x1, y1, z1, e.field_70177_z, Minecraft.func_71410_x().func_184121_ak(), false);
        }
    }

    public static class WorldPortalServer {
        public static void getWorldRender(final World world, final BlockPos posToRender, final int dimensiontorender, final BlockPos pos, final float rot, final boolean boti) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    world.func_73046_m().func_152344_a(new Runnable(){

                        @Override
                        public void run() {
                            WorldServer renderworld;
                            if (world.func_82737_E() % 5L == 0L && !world.field_72995_K && DimensionManager.isDimensionRegistered((int)dimensiontorender) && (renderworld = world.func_73046_m().func_71218_a(dimensiontorender)) != null) {
                                WorldRender worlds = new WorldRender(posToRender);
                                int r = boti ? DMConfig.tardis.blockMapSizeBoti : DMConfig.tardis.blockMapSizeSoto;
                                worlds.setDimension(dimensiontorender);
                                worlds.setIdentifier(System.currentTimeMillis());
                                BlockPos renderpos = worlds.renderPos;
                                for (BlockPos p : BlockPos.func_177980_a((BlockPos)renderpos.func_177973_b(new Vec3i(r, 10, r)), (BlockPos)renderpos.func_177971_a(new Vec3i(r, 15, r)))) {
                                    IBlockState state = renderworld.func_180495_p(p);
                                    if (state.func_177230_c() == Blocks.field_150350_a || state.func_177230_c() == Blocks.field_180401_cv) continue;
                                    BlockData bl = new BlockData(state, renderworld.func_175625_s(p), renderworld.func_175671_l(p));
                                    double ba = Math.cos(-((double)(rot + 90.0f) * 0.0174533) + Math.atan2(p.func_177952_p() - posToRender.func_177952_p(), p.func_177958_n() - posToRender.func_177958_n())) + (double)0.1f;
                                    if (!(ba > 0.0) && (p.func_177952_p() != posToRender.func_177952_p() || p.func_177958_n() != posToRender.func_177958_n())) continue;
                                    worlds.blocks.put(p, bl);
                                }
                                for (BlockPos p : BlockPos.func_177980_a((BlockPos)renderpos.func_177973_b(new Vec3i(1, 0, 1)), (BlockPos)renderpos.func_177971_a(new Vec3i(1, 1, 1)))) {
                                    worlds.blocks.remove(p);
                                }
                                PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketWorldPortal(worlds, pos, dimensiontorender), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 16.0));
                            }
                        }
                    });
                }
            }, "Boti").start();
        }

        public static List<Entity> getEntities(WorldRender worlds, World renderworld) {
            AxisAlignedBB bb = new AxisAlignedBB(worlds.renderPos.func_177982_a(-10, -10, -10), worlds.renderPos.func_177982_a(10, 10, 10));
            List entities = renderworld.func_72872_a(Entity.class, bb);
            worlds.entities.clear();
            worlds.setEntities(entities);
            return entities;
        }
    }
}

