/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.commands.handles;

import com.swdteam.common.capability.CapabilityTardis;
import com.swdteam.common.capability.interfaces.ITardisCapability;
import com.swdteam.common.commands.handles.CommandHandlesBase;
import com.swdteam.common.init.DMSounds;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tileentity.tardis.TileEntityTardis;
import com.swdteam.utils.WorldUtils;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class CommandLockTardis
extends CommandHandlesBase {
    public CommandLockTardis() {
        this.alias = new ArrayList();
        this.alias.add("lock the doors!");
        this.alias.add("lock the door");
        this.alias.add("lock the door!");
    }

    @Override
    public void processCommand(EntityPlayerMP player, String[] arg1) {
        World w = player.func_130014_f_();
        ITardisCapability capa = (ITardisCapability)player.getCapability(CapabilityTardis.FLIGHTMODE_CAP, null);
        int tardisID = capa.getTARDISID();
        TardisData data = DMTardis.getTardis(tardisID);
        if (data == null) {
            player.func_146105_b((ITextComponent)new TextComponentString("Tardis is invalid..."), true);
            return;
        }
        if (DMTardis.hasPermission(data, (EntityPlayer)player)) {
            if (data.isLocked()) {
                data.setLocked(false);
                w.func_184133_a(null, player.func_180425_c(), DMSounds.circuit_added, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.sendMessage(player, TextFormatting.YELLOW + "The Tardis doors are now unlocked!");
            } else {
                if (data.isDoorOpen()) {
                    data.setDoorOpen(false);
                }
                data.setLocked(true);
                w.func_184133_a(null, player.func_180425_c(), DMSounds.tardisKeyLock, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.sendMessage(player, TextFormatting.YELLOW + "The Tardis doors are now locked!");
            }
            TardisSaveHandler.saveTardis(data);
            if (w.func_73046_m().func_71218_a(data.getTardisCurrentdimension()).func_175625_s(WorldUtils.vec3ToBlockPos(data.getCurrentTardisPosition())) != null) {
                TileEntityTardis tileEntityTardis = (TileEntityTardis)w.func_73046_m().func_71218_a(data.getTardisCurrentdimension()).func_175625_s(WorldUtils.vec3ToBlockPos(data.getCurrentTardisPosition()));
                tileEntityTardis.tempTardisData = data;
            }
        } else {
            this.sendMessage(player, "You don't have permission to summon this tardis!");
        }
    }

    @Override
    public String getCommandName() {
        return "lock the doors";
    }
}

