/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.init;

import com.swdteam.common.entity.EntityIceWarrior;
import com.swdteam.common.entity.dalek.EntityDalek;
import com.swdteam.common.entity.dalek.EntityDalekEmperor;
import com.swdteam.common.init.DMBlocks;
import com.swdteam.common.init.DMTardis;
import com.swdteam.main.TheDalekMod;
import com.swdteam.main.config.DMConfig;
import com.swdteam.utils.world.Schematic;
import com.swdteam.utils.world.SchematicUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DMSchematics {
    public static Schematic TARDIS_DEFAULT;
    public static Schematic TARDIS_DM_A;
    public static Schematic TARDIS_DM_B;
    public static Schematic TARDIS_DM_C;
    public static Schematic TARDIS_DM_D;
    public static Schematic TARDIS_ALPHA;
    public static Schematic TARDIS_TT;
    public static Schematic TARDIS_HARTNELL;
    public static Schematic TARDIS_SECOND;
    public static Schematic TARDIS_VANILLA;
    public static Schematic TARDIS_COPPER;
    public static Schematic TARDIS_FLORAL;
    public static Schematic TARDIS_WAR;
    public static Schematic TARDIS_HEXON;
    public static Schematic TARDIS_SECONDARY;
    public static Schematic TARDIS_FRIDGE;
    public static Schematic TARDIS_CORAL;
    public static Schematic TARDIS_SPACEBLOCK;
    public static Schematic TARDIS_TOYOTA;
    public static Schematic TARDIS_TUD;
    public static Schematic TARDIS_GINGERBREAD;
    public static Schematic TARDIS_POKEBALL;
    public static Schematic TARDIS_K2;
    public static Schematic TARDIS_GIZMO;
    public static Schematic TARDIS_GERONIMO;
    public static Schematic TARDIS_EPSIMO;
    public static Schematic TARDIS_RANI;
    public static Schematic TARDIS_BETA;
    public static Schematic TARDIS_VENDING;
    public static Schematic TARDIS_80S;
    public static Schematic TARDIS_BILL_TED;
    public static Schematic TARDIS_EIGHT;
    public static Schematic TARDIS_AMBIENT;
    public static Schematic TARDIS_THIRTEEN;
    public static Schematic TARDIS_CHRONOTIS;
    public static Schematic TARDIS_WARDROBE;
    public static Schematic TARDIS_GALLIFREY_WARDROBE;
    public static Schematic TARDIS_SHED;
    public static Schematic TARDIS_BLOCKTOR;
    public static Schematic TARDIS_GRANDFATHER_CLOCK;
    public static Schematic TARDIS_ED;
    public static Schematic TARDIS_RUTH;
    public static Schematic TARDIS_TEMPUS;
    public static Schematic[] ASYLUMS;
    public static Schematic SKARO_BUILD_1;
    public static Schematic MOON_CYBER_SHIP;
    public static Schematic MARS_ICE_WARRIOR_SHIP;
    public static Schematic DALEK_EMPEROR_SHIP;
    public static Schematic DALEK_SHIP_A;
    public static Schematic DALEK_SHIP_B;
    public static Schematic DALEK_SHIP_C;
    public static Schematic GALLIFREY_CITADEL;
    public static SchematicUtils.IReplaceBlockSpawn MARS_ICE_WARRIOR_SPAWN;
    public static SchematicUtils.IReplaceBlockSpawn DALEK_EMPEROR_SHIP_SPAWN;
    public static SchematicUtils.IReplaceBlockSpawn DALEK_EMPEROR_SHIP_SPAWN_BOSS;
    public static SchematicUtils.IReplaceBlockSpawn DALEK_SHIP_SPAWNER_A;
    public static SchematicUtils.IReplaceBlockSpawn DALEK_SHIP_SPAWNER_B;
    public static SchematicUtils.IReplaceBlockSpawn DALEK_SHIP_SPAWNER_C;
    public static List<BlockPos> TARDIS_BOUNDARIES;

    public static void init() {
        DMSchematics.structuresInit();
        TARDISBoundary.init();
    }

    public static void TARDISInts() {
        try {
            TARDIS_DEFAULT = DMSchematics.loadSchematic("tardis/dm_default", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_DM_A = DMSchematics.loadSchematic("tardis/dm_a_int", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_DM_B = DMSchematics.loadSchematic("tardis/dm_b_int", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_DM_C = DMSchematics.loadSchematic("tardis/dm_c_int", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_DM_D = DMSchematics.loadSchematic("tardis/dm_d_int", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_TT = DMSchematics.loadSchematic("tardis/hellbent_int", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_SECOND = DMSchematics.loadSchematic("tardis/second_int", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_ALPHA = DMSchematics.loadSchematic("tardis/alpha_int", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_HARTNELL = DMSchematics.loadSchematic("tardis/hartnell_int", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_VANILLA = DMSchematics.loadSchematic("tardis/vanilla_int", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_COPPER = DMSchematics.loadSchematic("tardis/2010_int", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_FLORAL = DMSchematics.loadSchematic("tardis/floral", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_WAR = DMSchematics.loadSchematic("tardis/war_int", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_HEXON = DMSchematics.loadSchematic("tardis/hex_int", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_SECONDARY = DMSchematics.loadSchematic("tardis/fourth_secondary", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_FRIDGE = DMSchematics.loadSchematic("tardis/fridge_int", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_CORAL = DMSchematics.loadSchematic("tardis/coral_int", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_SPACEBLOCK = DMSchematics.loadSchematic("tardis/spaceblock", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_TUD = DMSchematics.loadSchematic("tardis/tud_tardis", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_TOYOTA = DMSchematics.loadSchematic("tardis/toyota_int", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_GINGERBREAD = DMSchematics.loadSchematic("tardis/gingerbread_interior", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_POKEBALL = DMSchematics.loadSchematic("tardis/pokeball_int", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_K2 = DMSchematics.loadSchematic("tardis/yblocks_k2", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_GIZMO = DMSchematics.loadSchematic("tardis/gizmo_int", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_GERONIMO = DMSchematics.loadSchematic("tardis/ger_tar", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_EPSIMO = DMSchematics.loadSchematic("tardis/epsimo_int", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_RANI = DMSchematics.loadSchematic("tardis/rani_int", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_VENDING = DMSchematics.loadSchematic("tardis/vending_int", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_80S = DMSchematics.loadSchematic("tardis/classic_int", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_BILL_TED = DMSchematics.loadSchematic("tardis/bill_ted_int", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_EIGHT = DMSchematics.loadSchematic("tardis/eight_int", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_AMBIENT = DMSchematics.loadSchematic("tardis/ambient_int", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_THIRTEEN = DMSchematics.loadSchematic("tardis/crystaline_int", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_CHRONOTIS = DMSchematics.loadSchematic("tardis/chronotis_int", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_BETA = DMSchematics.loadSchematic("tardis/beta_int", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_WARDROBE = DMSchematics.loadSchematic("tardis/wardrobe_int", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_GALLIFREY_WARDROBE = DMSchematics.loadSchematic("tardis/gallifrey_wardrobe", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_SHED = DMSchematics.loadSchematic("tardis/shed_int", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_BLOCKTOR = DMSchematics.loadSchematic("tardis/blocktor_int", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_GRANDFATHER_CLOCK = DMSchematics.loadSchematic("tardis/grandfather_interior", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_ED = DMSchematics.loadSchematic("tardis/ed_interior", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_RUTH = DMSchematics.loadSchematic("tardis/ruth_interior", SchematicUtils.FileLocation.EXTERNAL);
            TARDIS_TEMPUS = DMSchematics.loadSchematic("tardis/tempus_ints", SchematicUtils.FileLocation.EXTERNAL);
        }
        catch (Exception e) {
            TheDalekMod.LOG.warn((Object)e);
        }
    }

    public static void structuresInit() {
        GALLIFREY_CITADEL = DMSchematics.loadSchematic("gallifrey/gallifrey_citadel", SchematicUtils.FileLocation.EXTERNAL);
        DMSchematics.ASYLUMS[0] = DMSchematics.loadSchematic("skaro/asylum_1", SchematicUtils.FileLocation.EXTERNAL);
        DMSchematics.ASYLUMS[1] = DMSchematics.loadSchematic("skaro/asylum_2", SchematicUtils.FileLocation.EXTERNAL);
        DMSchematics.ASYLUMS[2] = DMSchematics.loadSchematic("skaro/asylum_3", SchematicUtils.FileLocation.EXTERNAL);
        MOON_CYBER_SHIP = DMSchematics.loadSchematic("moon/cyber_ship", SchematicUtils.FileLocation.EXTERNAL);
        MARS_ICE_WARRIOR_SHIP = DMSchematics.loadSchematic("mars/ice_warrior_ship", SchematicUtils.FileLocation.EXTERNAL);
        DALEK_EMPEROR_SHIP = DMSchematics.loadSchematic("skaro/emperor_ship", SchematicUtils.FileLocation.EXTERNAL);
        DALEK_SHIP_A = DMSchematics.loadSchematic("skaro/dalek_ship_new_a", SchematicUtils.FileLocation.EXTERNAL);
        DALEK_SHIP_B = DMSchematics.loadSchematic("skaro/dalek_ship_new_b", SchematicUtils.FileLocation.EXTERNAL);
        DALEK_SHIP_C = DMSchematics.loadSchematic("skaro/dalek_ship_new_c", SchematicUtils.FileLocation.EXTERNAL);
        MARS_ICE_WARRIOR_SPAWN = new SchematicUtils.IReplaceBlockSpawn(){

            @Override
            public void replaceBlock(World w, BlockPos p) {
                EntityIceWarrior iw = new EntityIceWarrior(w);
                iw.func_70012_b(p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), w.field_73012_v.nextInt(360), 0.0f);
                w.func_72838_d((Entity)iw);
            }

            @Override
            public IBlockState getBlockState() {
                return Blocks.field_150357_h.func_176223_P();
            }
        };
        DALEK_EMPEROR_SHIP_SPAWN = new SchematicUtils.IReplaceBlockSpawn(){

            @Override
            public void replaceBlock(World w, BlockPos p) {
                EntityDalek d = new EntityDalek(w);
                d.func_70012_b(p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), w.field_73012_v.nextInt(360), 0.0f);
                w.func_72838_d((Entity)d);
                d.setDalekID(w.field_73012_v.nextBoolean() ? 27 : 65);
            }

            @Override
            public IBlockState getBlockState() {
                return Blocks.field_150360_v.func_176223_P();
            }
        };
        DALEK_EMPEROR_SHIP_SPAWN_BOSS = new SchematicUtils.IReplaceBlockSpawn(){

            @Override
            public void replaceBlock(World w, BlockPos p) {
                w.func_175656_a(p, DMBlocks.dalek_emperor.func_176223_P());
                EntityDalekEmperor d = new EntityDalekEmperor(w);
                d.func_70012_b((float)p.func_177958_n() + 0.5f, (float)p.func_177956_o() + 3.5f, (float)p.func_177952_p() + 0.5f, 0.0f, 0.0f);
                d.func_184212_Q().func_187227_b(EntityDalekEmperor.ROTATION, (Object)Float.valueOf(180.0f));
                w.func_72838_d((Entity)d);
            }

            @Override
            public IBlockState getBlockState() {
                return DMBlocks.dalek_emperor.func_176223_P();
            }
        };
        DALEK_SHIP_SPAWNER_A = new SchematicUtils.IReplaceBlockSpawn(){

            @Override
            public void replaceBlock(World w, BlockPos p) {
                int[] ids = new int[]{1, 2, 3, 4, 5};
                EntityDalek d = new EntityDalek(w);
                d.func_70012_b(p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), w.field_73012_v.nextInt(360), 0.0f);
                w.func_72838_d((Entity)d);
                d.setDalekID(ids[w.field_73012_v.nextInt(ids.length)]);
            }

            @Override
            public IBlockState getBlockState() {
                return Blocks.field_150360_v.func_176223_P();
            }
        };
        DALEK_SHIP_SPAWNER_B = new SchematicUtils.IReplaceBlockSpawn(){

            @Override
            public void replaceBlock(World w, BlockPos p) {
                int[] ids = new int[]{27, 28, 29, 30};
                EntityDalek d = new EntityDalek(w);
                d.func_70012_b(p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), w.field_73012_v.nextInt(360), 0.0f);
                w.func_72838_d((Entity)d);
                d.setDalekID(ids[w.field_73012_v.nextInt(ids.length)]);
            }

            @Override
            public IBlockState getBlockState() {
                return Blocks.field_150360_v.func_176223_P();
            }
        };
        DALEK_SHIP_SPAWNER_C = new SchematicUtils.IReplaceBlockSpawn(){

            @Override
            public void replaceBlock(World w, BlockPos p) {
                int[] ids = new int[]{32, 33, 34, 35, 36, 37, 38};
                EntityDalek d = new EntityDalek(w);
                d.func_70012_b(p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), w.field_73012_v.nextInt(360), 0.0f);
                w.func_72838_d((Entity)d);
                d.setDalekID(ids[w.field_73012_v.nextInt(ids.length)]);
            }

            @Override
            public IBlockState getBlockState() {
                return Blocks.field_150360_v.func_176223_P();
            }
        };
    }

    public static Schematic loadSchematic(String s, SchematicUtils.FileLocation f) {
        if (f == SchematicUtils.FileLocation.EXTERNAL) {
            Schematic ss = SchematicUtils.loadSchematic("mods/Dalek Mod/cdn/schematics/" + s + ".schm", f);
            return ss;
        }
        return SchematicUtils.loadSchematic(s, f);
    }

    static {
        ASYLUMS = new Schematic[3];
        TARDIS_BOUNDARIES = new ArrayList<BlockPos>();
    }

    public static class TARDISBoundary {
        public static List<Block> blocks = new ArrayList<Block>();

        public static void init() {
            DMTardis.INTERIOR_BOUNDS = DMConfig.tardis.TARDIS_Boundary_Size;
            BlockPos pos2 = new BlockPos(0, 0, 0);
            for (int y = 0; y < 256; ++y) {
                for (int z = 0; z <= DMTardis.INTERIOR_BOUNDS; ++z) {
                    for (int x = 0; x <= DMTardis.INTERIOR_BOUNDS; ++x) {
                        IBlockState s = Blocks.field_180401_cv.func_176223_P();
                        BlockPos pos = pos2.func_177982_a(x, y, z);
                        if (y < 255) {
                            if (y == 0) {
                                s = Blocks.field_150357_h.func_176223_P();
                            }
                            if (x != 0 && x != DMTardis.INTERIOR_BOUNDS && z != 0 && z != DMTardis.INTERIOR_BOUNDS) continue;
                            blocks.add(new Block(pos, s));
                            continue;
                        }
                        blocks.add(new Block(pos, s));
                    }
                }
            }
        }

        public static class Block {
            private BlockPos p;
            private IBlockState s;

            public Block(BlockPos p, IBlockState s) {
                this.p = p;
                this.s = s;
            }

            public BlockPos getPos() {
                return this.p;
            }

            public IBlockState getState() {
                return this.s;
            }
        }
    }
}

