/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.network.packets;

import com.swdteam.common.capability.CapabilityTardis;
import com.swdteam.common.capability.interfaces.ITardisCapability;
import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.init.DMItems;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.TardisFunctions;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.main.config.DMConfig;
import com.swdteam.network.packets.AbstractServerMessageHandler;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_OpenGui;
import com.swdteam.utils.PlayerUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class Packet_TardisLocatePlayer
implements IMessage {
    public String username;

    public Packet_TardisLocatePlayer() {
    }

    public Packet_TardisLocatePlayer(String username) {
        this.username = username;
    }

    public void fromBytes(ByteBuf buf) {
        this.username = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.username);
    }

    public static class Handler
    extends AbstractServerMessageHandler<Packet_TardisLocatePlayer> {
        @Override
        public IMessage handleServerMessage(EntityPlayer player, Packet_TardisLocatePlayer message, MessageContext ctx) {
            player.func_184102_h().func_152344_a(() -> {
                World w = player.func_130014_f_();
                ITardisCapability capa = (ITardisCapability)player.getCapability(CapabilityTardis.FLIGHTMODE_CAP, null);
                int TardisID = capa.getTARDISID();
                TardisData data = DMTardis.getTardis(TardisID);
                if (data != null) {
                    if (!DMTardis.hasPermission(data, player)) {
                        player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "" + TextFormatting.BOLD + "This is not your TARDIS"), true);
                        PacketHandler.INSTANCE.sendTo((IMessage)new Packet_OpenGui(-1, player.func_180425_c(), ""), (EntityPlayerMP)player);
                        return;
                    }
                    if (!DMConfig.tardis.locatePlayers) {
                        player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "" + TextFormatting.BOLD + "Tracking players is disabled in the config!"), false);
                        return;
                    }
                    EntityPlayerMP playerToAdd = player.func_184102_h().func_184103_al().func_152612_a(message.username);
                    if (playerToAdd != null) {
                        boolean isDampened = PlayerUtils.Hands.hasItemInInventory((EntityPlayer)playerToAdd, DMItems.BIODAMPER);
                        if (playerToAdd.field_70170_p.field_73011_w.getDimension() != DMDimensions.DIM_TARDIS_ID && !playerToAdd.func_175149_v() && !isDampened) {
                            TardisFunctions.setToLocation(w, playerToAdd.func_180425_c(), playerToAdd.field_70170_p.field_73011_w.getDimension(), data);
                            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "" + TextFormatting.BOLD + "TARDIS coordinates set"), true);
                        } else if (isDampened) {
                            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "" + TextFormatting.BOLD + "Player is bio-dampened"), true);
                        } else {
                            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "" + TextFormatting.BOLD + "Player is unreachable"), true);
                        }
                    } else {
                        player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "" + TextFormatting.BOLD + "Player does not exist"), true);
                    }
                }
                PacketHandler.INSTANCE.sendTo((IMessage)new Packet_OpenGui(-1, player.func_180425_c(), ""), (EntityPlayerMP)player);
            });
            return null;
        }
    }
}

