/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.utils.model.obj;

import com.swdteam.main.TheDalekMod;
import com.swdteam.main.config.DMConfig;
import com.swdteam.utils.model.obj.Obj;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Scanner;
import java.util.zip.ZipInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public class OBJLoader {
    public static OBJLoader INSTANCE = new OBJLoader();

    public int createDisplayList(Obj model) {
        int displayList = GL11.glGenLists((int)1);
        GL11.glNewList((int)displayList, (int)4864);
        this.render(model);
        GL11.glEndList();
        return displayList;
    }

    public void render(Obj model) {
        GlStateManager.func_179094_E();
        for (Obj.Face face : model.getFaces()) {
            List<Vector3f> n = model.getNormals();
            List<Vector2f> t = model.getTextureCoordinates();
            List<Vector3f> v = model.getVertices();
            if (face.getNormals().length > 3) {
                GL11.glBegin((int)7);
            } else {
                GL11.glBegin((int)4);
            }
            for (int i = 0; i < face.getNormals().length; ++i) {
                GL11.glNormal3f((float)n.get(face.getNormals()[i] - 1).getX(), (float)n.get(face.getNormals()[i] - 1).getY(), (float)n.get(face.getNormals()[i] - 1).getZ());
                GL11.glTexCoord2f((float)t.get(face.getTextureCoords()[i] - 1).getX(), (float)(1.0f - t.get(face.getTextureCoords()[i] - 1).getY()));
                GL11.glVertex3f((float)v.get(face.getVertices()[i] - 1).getX(), (float)v.get(face.getVertices()[i] - 1).getY(), (float)v.get(face.getVertices()[i] - 1).getZ());
            }
            GL11.glEnd();
        }
        GlStateManager.func_179121_F();
    }

    public Obj loadModel(File file) throws FileNotFoundException {
        Scanner s = new Scanner(file);
        Obj obj = this.loadModel(s);
        return obj;
    }

    public Obj loadModel(InputStream stream) {
        Scanner s = new Scanner(stream);
        Obj obj = this.loadModel(s);
        return obj;
    }

    public Obj loadModel(ResourceLocation resource) {
        try {
            InputStream stream = Minecraft.func_71410_x().func_110442_L().func_110536_a(resource).func_110527_b();
            Obj obj = this.loadModel(stream);
            return obj;
        }
        catch (IOException e) {
            return null;
        }
    }

    public Obj loadModel(Scanner sc) {
        Obj model = new Obj();
        block14: while (sc.hasNextLine()) {
            String ln = sc.nextLine();
            if (ln == null || ln.equals("") || ln.startsWith("#")) continue;
            String[] split = ln.split(" ");
            switch (split[0]) {
                case "v": {
                    model.getVertices().add(new Vector3f(Float.parseFloat(split[1]), Float.parseFloat(split[2]), Float.parseFloat(split[3])));
                    continue block14;
                }
                case "vn": {
                    model.getNormals().add(new Vector3f(Float.parseFloat(split[1]), Float.parseFloat(split[2]), Float.parseFloat(split[3])));
                    continue block14;
                }
                case "vt": {
                    model.getTextureCoordinates().add(new Vector2f(Float.parseFloat(split[1]), Float.parseFloat(split[2])));
                    continue block14;
                }
                case "f": {
                    if (split.length == 4) {
                        model.getFaces().add(new Obj.Face(new int[]{Integer.parseInt(split[1].split("/")[0]), Integer.parseInt(split[2].split("/")[0]), Integer.parseInt(split[3].split("/")[0])}, new int[]{Integer.parseInt(split[1].split("/")[1]), Integer.parseInt(split[2].split("/")[1]), Integer.parseInt(split[3].split("/")[1])}, new int[]{Integer.parseInt(split[1].split("/")[2]), Integer.parseInt(split[2].split("/")[2]), Integer.parseInt(split[3].split("/")[2])}));
                    }
                    if (split.length != 5) continue block14;
                    model.getFaces().add(new Obj.Face(new int[]{Integer.parseInt(split[1].split("/")[0]), Integer.parseInt(split[2].split("/")[0]), Integer.parseInt(split[3].split("/")[0]), Integer.parseInt(split[4].split("/")[0])}, new int[]{Integer.parseInt(split[1].split("/")[1]), Integer.parseInt(split[2].split("/")[1]), Integer.parseInt(split[3].split("/")[1]), Integer.parseInt(split[4].split("/")[1])}, new int[]{Integer.parseInt(split[1].split("/")[2]), Integer.parseInt(split[2].split("/")[2]), Integer.parseInt(split[3].split("/")[2]), Integer.parseInt(split[4].split("/")[2])}));
                    continue block14;
                }
                case "s": {
                    model.setSmoothShadingEnabled(!ln.contains("off"));
                    continue block14;
                }
            }
            if (!DMConfig.debug.debug_game_output) continue;
            TheDalekMod.LOG.error("[OBJ] Unknown Line: " + ln);
        }
        return model;
    }

    public Obj loadModel(ZipInputStream stream) {
        Scanner s = new Scanner(stream);
        Obj obj = this.loadModel(s);
        return obj;
    }
}

