/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.init.skinpacks;

import com.swdteam.client.init.DMMDLLoader;
import com.swdteam.client.init.skinpacks.DalekModel;
import com.swdteam.client.init.skinpacks.SkinpackData;
import com.swdteam.client.init.skinpacks.skinpack.Skin;
import com.swdteam.client.init.skinpacks.skinpack.SkinSession;
import com.swdteam.client.init.skinpacks.skinpack.Skinpack;
import com.swdteam.client.model.entities.ModelClockworkDroid;
import com.swdteam.client.model.entities.ModelGelGuard;
import com.swdteam.client.model.entities.ModelIceWarrior;
import com.swdteam.client.model.entities.ModelOod;
import com.swdteam.client.model.entities.ModelSilence;
import com.swdteam.client.model.entities.ModelSontaran;
import com.swdteam.client.model.entities.ModelZygon;
import com.swdteam.client.model.entities.auton.ModelAuton;
import com.swdteam.client.model.entities.cybermen.ModelCyberVillager;
import com.swdteam.client.model.entities.cybermen.ModelCybermanEarthShock;
import com.swdteam.client.model.entities.cybermen.ModelCybermanModern;
import com.swdteam.client.model.entities.cybermen.ModelCybermenInvasion;
import com.swdteam.client.model.entities.cybermen.ModelTenthPlanetCyberman;
import com.swdteam.client.model.entities.cybermen.patients.Cyberman_Patient_V1;
import com.swdteam.client.model.entities.cybermen.patients.Cyberman_Patient_V2;
import com.swdteam.client.model.entities.cybermen.patients.Cyberman_Patient_V3;
import com.swdteam.client.model.entities.gasmask_zombies.ModelEmptyNPC;
import com.swdteam.client.model.entities.gasmask_zombies.ModelVilGm;
import com.swdteam.client.model.entities.k9.ModelK9;
import com.swdteam.client.model.entities.k9.ModelK9Australia;
import com.swdteam.client.model.entities.players.ModelAlex18;
import com.swdteam.client.model.entities.snowmen.ModelSnowman;
import com.swdteam.client.model.entities.timelords.ModelChancelleryGuard;
import com.swdteam.client.model.entities.timelords.ModelTimeLord;
import com.swdteam.common.entity.dalek.IDalek;
import com.swdteam.common.init.DMDalekRegistry;
import com.swdteam.main.TheDalekMod;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;

public class DMSkinpack {
    public static HashMap<String, ModelBase> models = new HashMap();
    public static HashMap<String, BufferedImage> textures = new HashMap();
    public static HashMap<Integer, Skinpack> skinPacks = new HashMap();
    public static HashMap<String, SkinSession> skinSessions = new HashMap();
    public static int packID = 0;

    public static int clearCache() {
        int i = 0;
        i += models.size();
        i += textures.size();
        i += skinPacks.size();
        i += skinSessions.size();
        packID = 0;
        models.clear();
        textures.clear();
        skinSessions.clear();
        DMSkinpack.init();
        return i;
    }

    public static void addSession(String username, int pack, int skin) {
        SkinSession skinSession = new SkinSession(username, pack, skin);
        skinSessions.put(username, skinSession);
    }

    public static void deleteSession(String username) {
        skinSessions.remove(username);
    }

    public static SkinSession getSession(String username) {
        return skinSessions.get(username);
    }

    public static boolean sessionExists(String user) {
        return skinSessions.containsKey(user);
    }

    public static void init() {
        models.put("CyberEarthShock", (ModelBase)new ModelCybermanEarthShock());
        models.put("CyberModern", new ModelCybermanModern());
        models.put("CyberInvasion", (ModelBase)new ModelCybermenInvasion());
        models.put("CyberTenthPlanet", (ModelBase)new ModelTenthPlanetCyberman());
        models.put("CyberVillager", new ModelCyberVillager());
        models.put("Patient1", (ModelBase)new Cyberman_Patient_V1());
        models.put("Patient2", (ModelBase)new Cyberman_Patient_V2());
        models.put("Patient3", (ModelBase)new Cyberman_Patient_V3());
        models.put("Silence", (ModelBase)new ModelSilence());
        models.put("TimelordGuard", (ModelBase)new ModelChancelleryGuard());
        models.put("Timelord", (ModelBase)new ModelTimeLord());
        models.put("Ood", (ModelBase)new ModelOod());
        models.put("IceWarrior", (ModelBase)new ModelIceWarrior());
        models.put("Cyberman", new ModelCybermanModern());
        models.put("EmptyNPC", new ModelEmptyNPC());
        models.put("Auton", new ModelAuton());
        models.put("WeepingAngel", DMMDLLoader.loadModel("entity/angels/weeping_angel", true));
        models.put("GMVillager", new ModelVilGm());
        models.put("ClockworkDroid", new ModelClockworkDroid());
        models.put("GelGuard", new ModelGelGuard());
        models.put("K9", new ModelK9());
        models.put("K9Regen", new ModelK9Australia());
        models.put("Snowman", new ModelSnowman());
        models.put("Sontaran", new ModelSontaran());
        models.put("Zygon", (ModelBase)new ModelZygon());
        DMSkinpack.setupDalekModels();
        ModelBiped biped = new ModelBiped();
        biped.field_78091_s = false;
        models.put("ModelSteve", (ModelBase)biped);
        ModelAlex18 alex = new ModelAlex18(0.0f, true);
        alex.field_78091_s = false;
        models.put("ModelAlex", (ModelBase)alex);
        DMSkinpack.loadSkinPacks();
    }

    private static void setupDalekModels() {
        for (int x = 0; x < DMDalekRegistry.getDaleks().size(); ++x) {
            IDalek dalek = DMDalekRegistry.getDaleks().get(x);
            DalekModel dalek_model = new DalekModel(dalek.getModel(null));
            models.put("dalek_" + dalek.getID(), dalek_model);
        }
    }

    public static void setupDalekSkinPacks() {
        ArrayList<Skin> skins = new ArrayList<Skin>();
        Skinpack pack = new Skinpack(packID++);
        pack.setSkinpackName("Daleks");
        for (int x = 0; x < DMDalekRegistry.getDaleks().size(); ++x) {
            IDalek dalek = DMDalekRegistry.getDaleks().get(x);
            Skin skin = new Skin();
            skin.setSkinName(dalek.getName());
            skin.setModelName("dalek_" + dalek.getID());
            skin.setup();
            skins.add(skin);
        }
        DMSkinpack.finalizeSkinpack(skins, pack);
    }

    public static void loadSkinPacks() {
        File[] files;
        File f = new File("mods/Dalek Mod/cdn/skinpacks");
        if (!f.exists()) {
            f.mkdirs();
        }
        if ((files = f.listFiles()).length > 0) {
            for (int x = 0; x < files.length; ++x) {
                File file = files[x];
                if (!file.getName().startsWith("skinpack_") || !file.getName().endsWith(".skinpack")) continue;
                try {
                    ZipEntry entryZip;
                    Enumeration<? extends ZipEntry> e;
                    ZipFile fis1 = new ZipFile(file.getAbsoluteFile());
                    if (fis1.size() > 0) {
                        e = fis1.entries();
                        while (e.hasMoreElements()) {
                            entryZip = e.nextElement();
                            if (!entryZip.getName().endsWith(".png")) continue;
                            InputStream input = fis1.getInputStream(entryZip);
                            textures.put(entryZip.getName().substring(0, entryZip.getName().length() - 4), ImageIO.read(input));
                            input.close();
                        }
                    }
                    if ((fis1 = new ZipFile(file.getAbsoluteFile())).size() <= 0) continue;
                    e = fis1.entries();
                    while (e.hasMoreElements()) {
                        entryZip = e.nextElement();
                        if (!entryZip.getName().equalsIgnoreCase("pack.json")) continue;
                        InputStream in = fis1.getInputStream(entryZip);
                        BufferedReader r = new BufferedReader(new InputStreamReader(in));
                        StringBuilder sb = new StringBuilder();
                        String line = "";
                        while ((line = r.readLine()) != null) {
                            sb.append(line);
                        }
                        r.close();
                        SkinpackData skinpackData = (SkinpackData)TheDalekMod.GSON.fromJson(sb.toString(), SkinpackData.class);
                        Skinpack pack = new Skinpack(packID++);
                        pack.setSkinpackName(skinpackData.pack_name);
                        pack.setSkinpackCreator(skinpackData.pack_creator);
                        ArrayList<Skin> skins = new ArrayList<Skin>();
                        for (int i = 0; i < skinpackData.pack_content.size(); ++i) {
                            SkinpackData.SkinData skinData = skinpackData.pack_content.get(i);
                            Skin skin = new Skin();
                            skin.setSkinName(skinData.name);
                            skin.setModelName(skinData.model_name);
                            skin.setTexture(skinData.texture_location);
                            skin.setTextureLocation(skinData.fileLocation);
                            skin.setup();
                            skins.add(skin);
                        }
                        DMSkinpack.finalizeSkinpack(skins, pack);
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        DMSkinpack.setupDalekSkinPacks();
    }

    public static void finalizeSkinpack(List<Skin> skins, Skinpack pack) {
        Skin[] skinArray = new Skin[skins.size()];
        skinArray = skins.toArray(skinArray);
        pack.setSkins(skinArray);
        skinPacks.put(pack.getSkinPackID(), pack);
    }
}

