/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.commands;

import com.mojang.authlib.GameProfile;
import com.swdteam.common.capability.CapabilityTardis;
import com.swdteam.common.capability.interfaces.ITardisCapability;
import com.swdteam.common.commands.TardisAdminSubCommands;
import com.swdteam.common.data.PlayerData;
import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tileentity.tardis.TileEntityTardis;
import com.swdteam.common.tileentity.tardis.perms.TardisPermission;
import com.swdteam.utils.DMUtils;
import com.swdteam.utils.PlayerUtils;
import com.swdteam.utils.Vector3;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.server.command.CommandTreeBase;

public class CommandTardisAdmin
extends CommandTreeBase {
    public CommandTardisAdmin() {
        this.addSubcommand((ICommand)new TardisAdminSubCommands.SetOwner(new String[]{"set-owner", "tardis_id", "player"}));
        this.addSubcommand((ICommand)new TardisAdminSubCommands.ToggleOpen(new String[]{"toggle-open", "x", "y", "z"}));
        this.addSubcommand((ICommand)new TardisAdminSubCommands.ToggleLock(new String[]{"toggle-lock", "x", "y", "z"}));
        this.addSubcommand((ICommand)new TardisAdminSubCommands.Summon(new String[]{"summon", "tardis_id", "x", "y", "z", "rotation", "dimension", "boolean"}));
        this.addSubcommand((ICommand)new TardisAdminSubCommands.Remove(new String[]{"remove", "automatic,manual", "tardis_id"}));
        this.addSubcommand((ICommand)new TardisAdminSubCommands.Companion(new String[]{"companion", "add,remove", "player", "tardis_id"}));
        this.addSubcommand((ICommand)new TardisAdminSubCommands.WTAILA(new String[]{"WTAILA", "x", "y", "z", "edit"}));
        this.addSubcommand((ICommand)new TardisAdminSubCommands.TardisList());
        this.addSubcommand((ICommand)new TardisInfo());
        this.addSubcommand((ICommand)new DataChange());
    }

    public String func_71517_b() {
        return "tardis-admin";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b() + " [" + this.func_930289454() + "] [parameters]";
    }

    private String func_930289454() {
        String[] subcmds = new String[this.getSubCommands().size()];
        int i = 0;
        for (ICommand c : this.getSubCommands()) {
            subcmds[i] = c.func_71517_b();
            ++i;
        }
        StringBuilder b = new StringBuilder();
        for (int i1 = 0; i1 < subcmds.length; ++i1) {
            b.append(subcmds[i1] + (i1 == subcmds.length - 1 ? "" : "|"));
        }
        return b.toString();
    }

    private class TardisInfo
    extends CommandBase {
        private TardisInfo() {
        }

        public String func_71517_b() {
            return "tardis-info";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/tardis-admin " + this.func_71517_b() + " [tardis ID] [information]";
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
            switch (args.length) {
                case 1: {
                    return TardisInfo.func_71530_a((String[])args, (String[])DMTardis.getTardisListAsArray());
                }
                case 2: {
                    return TardisInfo.func_71530_a((String[])args, (String[])new String[]{"all", "owner", "chameleon-circuit", "location", "destination", "flight", "health", "hads", "cloak", "locked", "permissions", "interior"});
                }
                case 3: {
                    if (!args[2].equalsIgnoreCase("list")) break;
                    return TardisInfo.func_71530_a((String[])args, (String[])server.func_71213_z());
                }
            }
            return super.func_184883_a(server, sender, args, targetPos);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            TardisData data;
            EntityPlayerMP player = TardisInfo.func_71521_c((ICommandSender)sender);
            int id = 0;
            BlockPos tardis_pos = null;
            boolean found = false;
            Vec3d start = player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
            TileEntityTardis tardis = null;
            for (int i = 0; i < 64; ++i) {
                tardis_pos = new BlockPos(start = start.func_178787_e(player.func_70040_Z()));
                if (!player.field_70170_p.func_180495_p(tardis_pos).func_177230_c().func_176223_P().func_185913_b()) continue;
                found = true;
                break;
            }
            if (found) {
                if (player.func_130014_f_().func_175625_s(tardis_pos) instanceof TileEntityTardis) {
                    found = true;
                    tardis = (TileEntityTardis)player.func_130014_f_().func_175625_s(tardis_pos);
                    if (tardis.tempTardisData != null) {
                        id = tardis.tempTardisData.getTardisID();
                    }
                } else {
                    found = false;
                }
            }
            if (!found) {
                ITardisCapability capa = (ITardisCapability)player.getCapability(CapabilityTardis.FLIGHTMODE_CAP, null);
                id = capa.getTARDISID();
            }
            if (player.field_70170_p.field_73011_w.getDimension() == DMDimensions.DIM_TARDIS_ID) {
                id = DMTardis.getIDForXZ((int)player.field_70165_t, (int)player.field_70161_v);
            }
            if (args.length > 0) {
                id = TardisInfo.func_175755_a((String)args[0]);
            }
            if ((data = DMTardis.getTardis(id)).isRemoved()) {
                PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.RED + "TARDIS was Removed");
                return;
            }
            if (args.length > 1) {
                String information;
                switch (information = args[1]) {
                    case "all": {
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "-------------TARDIS-------------");
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "ID: " + data.getTardisID() + " | Owner: " + data.getOwner());
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Exterior: " + DMTardis.getTardisSkin(data.getExteriorID()).getExteriorName());
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Location: [" + data.getCurrentTardisPosition() + "]");
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Interior Pos: [" + data.getTardisInteriorDoorLocation() + "](" + data.getInteriorX() + ";" + data.getInteriorZ() + ")");
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Planet / Dimension: " + data.getTardisCurrentdimension());
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Destination: " + data.getCurrentLocationName());
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "In Flight: " + data.isInFlight());
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Health: " + data.getTardisHealth());
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "HADS: " + (data.getHads() ? "enabled" : "disabled"));
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Cloaked: " + (data.isCloak() ? "enabled" : "disabled"));
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Locked: " + data.isLocked());
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Permissions: " + (Object)((Object)data.getTardisPermissions()));
                        return;
                    }
                    case "owner": {
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "-------------TARDIS[" + TextFormatting.WHITE + data.getTardisID() + TextFormatting.GREEN + "]-------------");
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Owner: " + data.getOwner());
                        return;
                    }
                    case "chameleon-circuit": {
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "-------------TARDIS[" + TextFormatting.WHITE + data.getTardisID() + TextFormatting.GREEN + "]-------------");
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Exterior: " + DMTardis.getTardisSkin(data.getExteriorID()).getExteriorName());
                        return;
                    }
                    case "location": {
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "-------------TARDIS[" + TextFormatting.WHITE + data.getTardisID() + TextFormatting.GREEN + "]-------------");
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Location: [" + data.getCurrentTardisPosition() + "]");
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Planet / Dimension: " + data.getTardisCurrentdimension());
                        return;
                    }
                    case "destination": {
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "-------------TARDIS[" + TextFormatting.WHITE + data.getTardisID() + TextFormatting.GREEN + "]-------------");
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Destination: " + data.getCurrentLocationName());
                        return;
                    }
                    case "flight": {
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "-------------TARDIS[" + TextFormatting.WHITE + data.getTardisID() + TextFormatting.GREEN + "]-------------");
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "In Flight: " + data.isInFlight());
                        return;
                    }
                    case "health": {
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "-------------TARDIS[" + TextFormatting.WHITE + data.getTardisID() + TextFormatting.GREEN + "]-------------");
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Health: " + data.getTardisHealth());
                        return;
                    }
                    case "hads": {
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "-------------TARDIS[" + TextFormatting.WHITE + data.getTardisID() + TextFormatting.GREEN + "]-------------");
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "HADS: " + (data.getHads() ? "enabled" : "disabled"));
                        return;
                    }
                    case "cloak": {
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "-------------TARDIS[" + TextFormatting.WHITE + data.getTardisID() + TextFormatting.GREEN + "]-------------");
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Cloaked: " + (data.isCloak() ? "enabled" : "disabled"));
                        return;
                    }
                    case "locked": {
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "-------------TARDIS[" + TextFormatting.WHITE + data.getTardisID() + TextFormatting.GREEN + "]-------------");
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Locked: " + data.isLocked());
                        return;
                    }
                    case "permissions": {
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "-------------TARDIS[" + TextFormatting.WHITE + data.getTardisID() + TextFormatting.GREEN + "]-------------");
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Permissions: " + (Object)((Object)data.getTardisPermissions()));
                        return;
                    }
                    case "interior": {
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "-------------TARDIS[" + TextFormatting.WHITE + data.getTardisID() + TextFormatting.GREEN + "]-------------");
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Interior Pos: [" + data.getTardisInteriorDoorLocation() + "](" + data.getInteriorX() + ";" + data.getInteriorZ() + ")");
                        return;
                    }
                }
                return;
            }
            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "-------------TARDIS-------------");
            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "ID: " + data.getTardisID() + " | Owner: " + data.getOwner());
            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Exterior: " + DMTardis.getTardisSkin(data.getExteriorID()).getExteriorName());
            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Location: [" + data.getCurrentTardisPosition() + "]");
            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Interior Pos: [" + data.getTardisInteriorDoorLocation() + "](" + data.getInteriorX() + ";" + data.getInteriorZ() + ")");
            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Planet / Dimension: " + data.getTardisCurrentdimension());
            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Destination: " + data.getCurrentLocationName());
            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "In Flight: " + data.isInFlight());
            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Health: " + data.getTardisHealth());
            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "HADS: " + (data.getHads() ? "enabled" : "disabled"));
            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Cloaked: " + (data.isCloak() ? "enabled" : "disabled"));
            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Locked: " + data.isLocked());
            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Permissions: " + (Object)((Object)data.getTardisPermissions()));
        }
    }

    private class DataChange
    extends CommandBase {
        private DataChange() {
        }

        public String func_71517_b() {
            return "data-change";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/tardis-admin " + this.func_71517_b() + " [x y x] [tardis ID] [data] [value]";
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
            switch (args.length) {
                case 1: {
                    return DataChange.func_71530_a((String[])args, (String[])DMTardis.getTardisListAsArray());
                }
                case 2: {
                    return DataChange.func_71530_a((String[])args, (String[])new String[]{"chameleon-circuit", "scale", "health", "hads", "forcefield", "cloak", "locked", "permissions", "add-companion", "interior"});
                }
                case 3: {
                    if (args[1].equalsIgnoreCase("owner") || args[1].equalsIgnoreCase("add-companion")) {
                        return DataChange.func_71530_a((String[])args, (String[])server.func_71213_z());
                    }
                    if (args[1].equalsIgnoreCase("permissions")) {
                        return DataChange.func_71530_a((String[])args, (String[])new String[]{"nobody", "everyone", "companions"});
                    }
                    if (args[1].equalsIgnoreCase("chameleon-circuit")) {
                        return DataChange.func_71530_a((String[])args, (String[])new String[]{"next"});
                    }
                    if (args[1].equalsIgnoreCase("scale")) {
                        return DataChange.func_71530_a((String[])args, (String[])new String[]{"" + (0.5 + Math.random())});
                    }
                    if (args[1].equalsIgnoreCase("interior")) {
                        return DataChange.func_71530_a((String[])args, (String[])new String[]{sender.func_180425_c().func_177958_n() + ""});
                    }
                    return DataChange.func_71530_a((String[])args, (String[])new String[]{"true", "false"});
                }
                case 4: {
                    if (args[1].equalsIgnoreCase("interior")) {
                        return DataChange.func_71530_a((String[])args, (String[])new String[]{sender.func_180425_c().func_177956_o() + ""});
                    }
                }
                case 5: {
                    if (args[1].equalsIgnoreCase("interior")) {
                        return DataChange.func_71530_a((String[])args, (String[])new String[]{sender.func_180425_c().func_177952_p() + ""});
                    }
                }
                case 6: {
                    if (!args[1].equalsIgnoreCase("interior")) break;
                    return DataChange.func_71530_a((String[])args, (String[])new String[]{Math.random() * 360.0 + ""});
                }
            }
            return super.func_184883_a(server, sender, args, targetPos);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length > 0) {
                EntityPlayerMP player = DataChange.func_71521_c((ICommandSender)sender);
                int id = DataChange.func_175755_a((String)args[0]);
                String information = args[1];
                String value = "true";
                if (args.length > 2) {
                    value = args[2];
                }
                TardisData data = DMTardis.getTardis(id);
                boolean bool = false;
                switch (information) {
                    case "chameleon-circuit": {
                        int chamid = 0;
                        chamid = value.equalsIgnoreCase("next") ? data.getExteriorID() + 1 : DataChange.func_175755_a((String)value);
                        if (chamid <= 0) {
                            chamid = 1;
                        }
                        if (chamid >= DMTardis.ccTardisesAL.size()) {
                            chamid = 1;
                        }
                        data.setExteriorID(chamid);
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.YELLOW + "You set the TARDIS(" + data.getTardisID() + ") Chameleon Circuit to " + DMTardis.getTardisSkin(data.getExteriorID()).getExteriorName());
                        break;
                    }
                    case "scale": {
                        double scale = DataChange.func_175765_c((String)value);
                        if (!(scale > 0.0)) {
                            scale = 1.0;
                        }
                        data.setScale((float)scale);
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.YELLOW + "You have scaled the TARDIS(" + data.getTardisID() + ") to " + data.getScale());
                        break;
                    }
                    case "health": {
                        int health = DataChange.func_175755_a((String)value);
                        if (health <= 0) {
                            health = 1;
                        }
                        data.setTardisHealth(health);
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.YELLOW + "You set the TARDIS(" + data.getTardisID() + ") Health to " + data.getTardisHealth());
                        break;
                    }
                    case "hads": {
                        bool = args.length > 2 ? (value.equalsIgnoreCase("toggle") ? !data.getHads() : DataChange.func_180527_d((String)value)) : !data.getHads();
                        data.setHads(bool);
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.YELLOW + "You set the TARDIS(" + data.getTardisID() + ") HADS to " + data.getHads());
                        break;
                    }
                    case "forcefield": {
                        bool = args.length > 2 ? (value.equalsIgnoreCase("toggle") ? !data.areForcefieldsEnabled() : DataChange.func_180527_d((String)value)) : !data.areForcefieldsEnabled();
                        data.setForcefieldsEnabled(bool);
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.YELLOW + "You set the TARDIS(" + data.getTardisID() + ") Forcefield to " + data.areForcefieldsEnabled());
                        break;
                    }
                    case "cloak": {
                        bool = args.length > 2 ? (value.equalsIgnoreCase("toggle") ? !data.isCloak() : DataChange.func_180527_d((String)value)) : !data.isCloak();
                        data.setCloak(bool);
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.YELLOW + "You set the TARDIS(" + data.getTardisID() + ") Cloak to " + data.isCloak());
                        break;
                    }
                    case "fligth": {
                        bool = args.length > 2 ? (value.equalsIgnoreCase("toggle") ? !data.isInFlight() : DataChange.func_180527_d((String)value)) : !data.isInFlight();
                        data.setInFlight(bool);
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "You have force " + (data.isInFlight() ? "inflight " : "landed ") + data.getOwner() + "'s Tardis(" + data.getTardisID() + ")"));
                        break;
                    }
                    case "locked": {
                        bool = args.length > 2 ? (value.equalsIgnoreCase("toggle") ? !data.isLocked() : DataChange.func_180527_d((String)value)) : !data.isLocked();
                        data.setLocked(bool);
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "You have force " + (data.isLocked() ? "locked " : "unlocked ") + data.getOwner() + "'s Tardis(" + data.getTardisID() + ")"));
                        break;
                    }
                    case "permissions": {
                        if (args.length <= 2) break;
                        data.setTardisPermissions(TardisPermission.getFromString(value.replaceAll("nobody", "owner")));
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.YELLOW + "You set the TARDIS(" + data.getTardisID() + ") Permission level to " + (Object)((Object)data.getTardisPermissions()));
                        break;
                    }
                    case "interior": {
                        if (args.length <= 4) break;
                        if (args.length > 5) {
                            data.setSpawnFacing((float)DataChange.func_175765_c((String)args[5]));
                        }
                        data.setTardisInteriorDoorLocation(new Vector3((int)DataChange.func_175770_a((double)player.field_70165_t, (String)args[2], (boolean)true).func_179628_a(), (int)DataChange.func_175770_a((double)player.field_70163_u, (String)args[3], (boolean)true).func_179628_a(), (int)DataChange.func_175770_a((double)player.field_70161_v, (String)args[4], (boolean)true).func_179628_a()));
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.YELLOW + "You set the TARDIS(" + data.getTardisID() + ") Interior position to " + data.getTardisInteriorDoorLocation());
                        break;
                    }
                    case "add-companion": {
                        if (args.length <= 2) break;
                        this.companion(data, value, sender, server);
                        break;
                    }
                    case "remove-companion": {
                        if (args.length <= 2) break;
                        data.removeCompanion(value);
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)DataChange.func_71521_c((ICommandSender)sender), TextFormatting.YELLOW + "Removed " + value + " from the TARDIS(" + data.getTardisID() + ")");
                        break;
                    }
                }
                TardisSaveHandler.saveTardis(data);
                for (Object p : player.field_70170_p.field_73010_i) {
                    DMTardis.loadClientData(data.getTardisID(), (EntityPlayerMP)p);
                }
                return;
            }
            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)DataChange.func_71521_c((ICommandSender)sender), TextFormatting.RED + "Usage: " + this.func_71518_a(sender));
        }

        private void companion(TardisData data, String value, ICommandSender sender, MinecraftServer server) throws PlayerNotFoundException {
            GameProfile profile = sender.func_184102_h().func_152358_ax().func_152655_a(value.replaceAll("@p", sender.func_70005_c_()));
            if (profile != null) {
                UUID uuid = profile.getId();
                if (uuid == null || !(sender instanceof EntityPlayerMP)) {
                    uuid = UUID.fromString(DMUtils.getUUIDs(value.replaceAll("@p", sender.func_70005_c_())));
                }
                if (uuid == null) {
                    PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)DataChange.func_71521_c((ICommandSender)sender), TextFormatting.RED + "Player " + value + " does not exist.");
                    return;
                }
                if (uuid != null) {
                    for (PlayerData pd : data.getCompanions()) {
                        UUID tempUUID = pd.getPlayerUUID();
                        if (!tempUUID.equals(uuid)) continue;
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)DataChange.func_71521_c((ICommandSender)sender), TextFormatting.RED + "Player " + value + " already a companion.");
                        return;
                    }
                    data.getCompanions().add(new PlayerData(uuid, value));
                    data.setTardisPermissions(TardisPermission.COMPANIONS);
                    if (sender instanceof EntityPlayerMP) {
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)DataChange.func_71521_c((ICommandSender)sender), TextFormatting.YELLOW + "Added " + value + " to the TARDIS(" + data.getTardisID() + ")");
                    }
                    if (server.func_175576_a(uuid) instanceof EntityPlayerMP) {
                        // empty if block
                    }
                }
            }
        }
    }
}

