/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.commands;

import com.swdteam.common.capability.CapabilityTardis;
import com.swdteam.common.capability.interfaces.ITardisCapability;
import com.swdteam.common.init.DMBlocks;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tardis.data.UserTardises;
import com.swdteam.common.tileentity.tardis.TileEntityTardis;
import com.swdteam.common.tileentity.tardis.perms.TardisPermission;
import com.swdteam.main.TheDalekMod;
import com.swdteam.main.config.DMConfig;
import com.swdteam.utils.EnumDefaultResponse;
import com.swdteam.utils.PlayerUtils;
import com.swdteam.utils.WorldUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraftforge.server.command.CommandTreeBase;

public class CommandTardisOwnership
extends CommandTreeBase {
    public static Map<EntityPlayer, TardisOwnerRequest> requests = new HashMap<EntityPlayer, TardisOwnerRequest>();

    public String func_71517_b() {
        return "tardis-ownership";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b() + " [new owner] / cancel / accept / deny";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        block24: {
            TardisData data;
            EntityPlayer player;
            block25: {
                if (!(sender instanceof EntityPlayer)) break block24;
                player = (EntityPlayer)sender;
                ITardisCapability capa = (ITardisCapability)player.getCapability(CapabilityTardis.FLIGHTMODE_CAP, null);
                int tardisID = capa.getTARDISID();
                data = DMTardis.getTardis(tardisID);
                if (args.length < 1) break block25;
                switch (args[0]) {
                    case "cancel": {
                        boolean cancel = false;
                        for (Map.Entry<EntityPlayer, TardisOwnerRequest> requestEntry : requests.entrySet()) {
                            if (!player.func_110124_au().toString().equalsIgnoreCase(requestEntry.getValue().oldOwnerUUID.toString())) continue;
                            requests.remove(requestEntry.getKey());
                            cancel = true;
                            break;
                        }
                        if (cancel) {
                            PlayerUtils.Messaging.sendMessageToPlayer(player, (ITextComponent)new TextComponentString(TextFormatting.GREEN + "Removed your request"));
                            break;
                        }
                        PlayerUtils.Messaging.sendMessageToPlayer(player, (ITextComponent)new TextComponentString(TextFormatting.RED + "You didn't have any requests"));
                        break;
                    }
                    case "accept": {
                        if (requests.containsKey(player) && args.length >= 2) {
                            TardisOwnerRequest ownerRequest = requests.get(player);
                            if (args[1].equalsIgnoreCase(String.valueOf(ownerRequest.tardisID))) {
                                System.out.println(player.func_70005_c_());
                                this.transfer(ownerRequest.newOwnerName, ownerRequest.tardisID, ownerRequest.oldOwnerUUID, ownerRequest.oldOwnerName);
                                break;
                            }
                        }
                        break block24;
                    }
                    case "deny": {
                        if (requests.containsKey(player)) {
                            EntityPlayerMP old = TheDalekMod.FML.getMinecraftServerInstance().func_184103_al().func_152612_a(CommandTardisOwnership.requests.get((Object)player).oldOwnerName);
                            if (old != null) {
                                PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)old, (ITextComponent)new TextComponentString(TextFormatting.RED + player.func_70005_c_() + " denied your request"));
                            }
                            requests.remove(player);
                            PlayerUtils.Messaging.sendMessageToPlayer(player, (ITextComponent)new TextComponentString(TextFormatting.RED + "Removed Tardis Transfer request."));
                            break;
                        }
                        PlayerUtils.Messaging.sendMessageToPlayer(player, (ITextComponent)new TextComponentString(TextFormatting.RED + "You don't have any requests"));
                        break;
                    }
                    default: {
                        if (data != null) {
                            if (args[0].equalsIgnoreCase(player.func_70005_c_())) {
                                player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "You can't send a request to yourself!"), false);
                                return;
                            }
                            if (!data.getCurrentOwner().equals(player.func_110124_au())) {
                                PlayerUtils.Messaging.sendMessageToPlayer(player, EnumDefaultResponse.NOT_YOUR_TARDIS);
                                return;
                            }
                            TardisOwnerRequest request = new TardisOwnerRequest();
                            request.tardisID = tardisID;
                            request.oldOwnerName = player.func_70005_c_();
                            request.oldOwnerUUID = player.func_110124_au();
                            request.unix = System.currentTimeMillis();
                            EntityPlayerMP newOwner = TheDalekMod.FML.getMinecraftServerInstance().func_184103_al().func_152612_a(args[0]);
                            if (newOwner != null) {
                                request.newOwnerName = newOwner.func_70005_c_();
                                request.newOwnerUUID = newOwner.func_110124_au();
                                UserTardises uTar = DMTardis.getUserTardises(newOwner.func_110124_au());
                                if (DMConfig.tardis.Tardis_Per_Player_Limit && uTar.getTardises().size() >= DMConfig.tardis.Tardis_Per_Player_Limit_count) {
                                    PlayerUtils.Messaging.sendMessageToPlayer(player, TextFormatting.RED + "This player already has the maximum amount of tardis's!");
                                    return;
                                }
                            } else {
                                PlayerUtils.Messaging.sendMessageToPlayer(player, (ITextComponent)new TextComponentString(TextFormatting.RED + "This user is not online!"));
                                return;
                            }
                            if (!requests.containsKey(newOwner)) {
                                requests.put((EntityPlayer)newOwner, request);
                                PlayerUtils.Messaging.sendMessageToPlayer(player, (ITextComponent)new TextComponentString(TextFormatting.GREEN + "Succesfully created transfer request\n" + TextFormatting.GREEN + "Execute: '/tardis-ownership cancel' to cancel."));
                                PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)newOwner, (ITextComponent)new TextComponentString(TextFormatting.GREEN + "[TARDIS Ownership] " + request.oldOwnerName + " has sent you a transfer request.\n" + TextFormatting.GREEN + "Execute: '/tardis-ownership accept " + request.tardisID + "' to accept.\n" + TextFormatting.GREEN + "Execute: '/tardis-ownership deny' to deny."));
                                break;
                            }
                            PlayerUtils.Messaging.sendMessageToPlayer(player, (ITextComponent)new TextComponentString(TextFormatting.RED + "This user already has a tardis to accept."));
                            break;
                        }
                        PlayerUtils.Messaging.sendMessageToPlayer(player, EnumDefaultResponse.TARDIS_DOES_NOT_EXIST);
                    }
                }
                break block24;
            }
            if (args.length == 0) {
                PlayerUtils.Messaging.sendMessageToPlayer(player, TextFormatting.GREEN + "This Tardis is owned by: " + data.getOwner());
            }
        }
    }

    public void transfer(String newOwnerName, int tardisID, UUID oldOwner, String oldOwnerName) {
        TileEntity tileEntity;
        TardisData data = DMTardis.getTardis(tardisID);
        EntityPlayerMP newOwner = TheDalekMod.FML.getMinecraftServerInstance().func_184103_al().func_152612_a(newOwnerName);
        UserTardises uTar = DMTardis.getUserTardises(newOwner.func_110124_au());
        if (DMConfig.tardis.Tardis_Per_Player_Limit && uTar.getTardises().size() >= DMConfig.tardis.Tardis_Per_Player_Limit_count) {
            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)newOwner, TextFormatting.RED + "You already have the maximum amount of tardis's allowed!");
            requests.remove(newOwner);
            return;
        }
        data.setCurrentOwner(newOwner.func_110124_au());
        data.setOwner(newOwner.func_70005_c_());
        TardisSaveHandler.saveTardis(data);
        UserTardises uTarOld = DMTardis.getUserTardises(oldOwner);
        UserTardises uTarNew = DMTardis.getUserTardises(newOwner.func_110124_au());
        uTarOld.getTardises().removeAll(Arrays.asList(data.getTardisID()));
        uTarNew.addTardis(data.getTardisID());
        DMTardis.updateUserTardisData(uTarOld, oldOwner);
        DMTardis.updateUserTardisData(uTarNew, newOwner.func_110124_au());
        data.getCompanions().clear();
        data.setTardisPermissions(TardisPermission.NOBODY);
        TardisSaveHandler.saveTardis(data);
        for (Object player2 : newOwner.field_70170_p.field_73010_i) {
            DMTardis.loadClientData(data.getTardisID(), (EntityPlayerMP)player2);
        }
        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)newOwner, TextFormatting.GREEN + "Tardis ownership transferred!, You now own ID: " + tardisID);
        EntityPlayerMP old = TheDalekMod.FML.getMinecraftServerInstance().func_184103_al().func_152612_a(oldOwnerName);
        if (old != null) {
            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)old, TextFormatting.GREEN + newOwnerName + " has accepted the tardis!");
        }
        WorldServer tardis = newOwner.field_70170_p.func_73046_m().func_71218_a(data.getTardisCurrentdimension());
        BlockPos tardisPos = WorldUtils.vec3ToBlockPos(data.getCurrentTardisPosition());
        if (tardis != null && tardisPos != null && tardisPos.func_177956_o() >= 0 && tardis.func_180495_p(tardisPos).func_177230_c() == DMBlocks.TARDIS && (tileEntity = tardis.func_175625_s(tardisPos)) != null && tileEntity instanceof TileEntityTardis) {
            ((TileEntityTardis)tileEntity).tempTardisData = data;
        }
        requests.remove(newOwner);
    }

    public static class TardisOwnerRequest {
        public String newOwnerName;
        public UUID newOwnerUUID;
        public UUID oldOwnerUUID;
        public String oldOwnerName;
        public int tardisID;
        public long unix;
    }
}

