/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.commands.handles;

import com.swdteam.common.capability.CapabilityTardis;
import com.swdteam.common.capability.interfaces.ITardisCapability;
import com.swdteam.common.commands.handles.CommandHandlesBase;
import com.swdteam.common.init.DMBlocks;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.utils.WorldUtils;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class CommandSummonTARDIS
extends CommandHandlesBase {
    public CommandSummonTARDIS() {
        this.alias = new ArrayList();
        this.alias.add("where's my tardis?");
        this.alias.add("where's my tardis");
        this.alias.add("wheres my tardis?");
        this.alias.add("wheres my tardis");
        this.alias.add("where is my tardis?");
        this.alias.add("where is my tardis");
        this.alias.add("tardis");
        this.alias.add("where my ride at");
    }

    @Override
    public void processCommand(EntityPlayerMP player, String[] arg1) {
        int offsetX = player.func_184172_bi().func_82601_c();
        int offsetZ = player.func_184172_bi().func_82599_e();
        if (offsetX < 0) {
            offsetX = -2;
        }
        if (offsetX > 0) {
            offsetX = 2;
        }
        if (offsetZ < 0) {
            offsetZ = -2;
        }
        if (offsetZ > 0) {
            offsetZ = 2;
        }
        BlockPos pos = player.func_180425_c().func_177982_a(offsetX, 0, offsetZ);
        World w = player.func_130014_f_();
        ITardisCapability capa = (ITardisCapability)player.getCapability(CapabilityTardis.FLIGHTMODE_CAP, null);
        if (w.func_190527_a(DMBlocks.TARDIS, pos, true, EnumFacing.DOWN, (Entity)player)) {
            int tardisID = capa.getTARDISID();
            TardisData data = DMTardis.getTardis(tardisID);
            if (data == null) {
                player.func_146105_b((ITextComponent)new TextComponentString("Can't summon your tardis :: NULL"), true);
                return;
            }
            if (DMTardis.hasPermission(data, (EntityPlayer)player)) {
                int i = MathHelper.func_76128_c((double)player.field_70126_B);
                if (i < 0) {
                    i = 360 + i;
                }
                if (data != null && WorldUtils.summonTardisToPos(w, data, pos, i) == EnumActionResult.SUCCESS) {
                    this.sendMessage(player, "Here is your Tardis");
                } else {
                    this.sendMessage(player, "I seem to be having problems summoning your Tardis");
                }
            } else {
                this.sendMessage(player, "You don't have permission to summon this tardis!");
            }
        } else {
            this.sendMessage(player, "There is no room infront of you to summon your Tardis");
        }
    }

    @Override
    public String getCommandName() {
        return "bring me my tardis";
    }
}

