/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.entity;

import com.swdteam.common.init.DMDamageSources;
import com.swdteam.common.init.DMItems;
import com.swdteam.common.init.DMSounds;
import com.swdteam.utils.WorldUtils;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

@Mod.EventBusSubscriber(modid="thedalekmod")
public class EntityWeepingAngel
extends EntityMob
implements IEntityAdditionalSpawnData {
    public ItemStack stolenKey;
    private static final DataParameter<ItemStack> CARRIED_ITEM = EntityDataManager.func_187226_a(EntityWeepingAngel.class, (DataSerializer)DataSerializers.field_187196_f);
    public float rotationOnSeen = 0.0f;
    public boolean canBeSeen = false;
    public boolean isAngry = false;

    public EntityWeepingAngel(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.95f);
        this.field_70178_ae = true;
        float moveSpeed = 0.2f;
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, (double)moveSpeed, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAITempt((EntityCreature)this, 9.5, DMItems.TARDIS_KEY, false));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(150.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1000.0);
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        this.func_145779_a(Item.func_150898_a((Block)Blocks.field_150348_b), this.func_70681_au().nextInt(3));
        if (this.getStolenKey() != null) {
            this.func_70099_a(this.getStolenKey(), 0.0f);
        }
        super.func_70628_a(wasRecentlyHit, lootingModifier);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source != null && source.func_76346_g() != null && source.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)source.func_76346_g();
            if (player.func_184607_cu() != null) {
                if (player.func_184607_cu().func_77973_b() instanceof ItemPickaxe) {
                    amount = 2.0f;
                }
            } else {
                amount = 2.0f;
                player.func_70097_a((DamageSource)DMDamageSources.WEEPINGANGEL_STONE, 2.0f);
            }
        }
        return super.func_70097_a(source, amount);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEFINED;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getPlayers() != null) {
            for (EntityPlayer ep : this.getPlayers()) {
                if (this.isInFieldOfVision((EntityLiving)this, ep)) {
                    if (this.rotationOnSeen == -1.0f) {
                        this.rotationOnSeen = this.field_70126_B + (this.field_70177_z - this.field_70126_B);
                        if (this.func_70638_az() == ep) {
                            this.func_184185_a(DMSounds.angelBlink, 1.0f, 1.0f);
                        }
                    }
                    this.isAngry = true;
                    this.canBeSeen = true;
                    continue;
                }
                this.canBeSeen = false;
                this.rotationOnSeen = -1.0f;
            }
        }
        if (this.canBeSeen) {
            if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73012_v.nextInt(400) == 200) {
                List<WorldUtils.BlockWithPos> blocks = WorldUtils.getBlocksWithinBounds(this.field_70170_p, this.func_174813_aQ().func_72321_a(8.0, 8.0, 8.0));
                for (int i = 0; i < blocks.size(); ++i) {
                    boolean LightBreakGamerule;
                    WorldUtils.BlockWithPos block = blocks.get(i);
                    if (this.field_70170_p.func_175625_s(block.getBlockPos()) != null || !(LightBreakGamerule = this.field_70170_p.func_82736_K().func_82766_b("DMAngelLightBreak"))) continue;
                    if (block.getBlock() == Blocks.field_150374_bv) {
                        WorldUtils.setBlock(this.field_70170_p, block.getBlockPos().func_177958_n(), block.getBlockPos().func_177956_o(), block.getBlockPos().func_177952_p(), Blocks.field_150379_bu);
                    }
                    if (block.getBlock() == Blocks.field_150478_aa) {
                        WorldUtils.setBlock(this.field_70170_p, block.getBlockPos().func_177958_n(), block.getBlockPos().func_177956_o(), block.getBlockPos().func_177952_p(), Blocks.field_150437_az);
                    }
                    if (block.getBlock() == Blocks.field_150429_aA) {
                        WorldUtils.setBlock(this.field_70170_p, block.getBlockPos().func_177958_n(), block.getBlockPos().func_177956_o(), block.getBlockPos().func_177952_p(), Blocks.field_150437_az);
                        continue;
                    }
                    if (block.getBlock().func_149750_m(null) < 7) continue;
                    this.func_184185_a(DMSounds.angelBreakLight, 1.0f, 1.0f);
                    this.field_70170_p.func_175698_g(block.getBlockPos());
                    this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, (double)block.getBlockPos().func_177958_n(), (double)block.getBlockPos().func_177956_o(), (double)block.getBlockPos().func_177952_p(), new ItemStack(block.getBlock(), 1, 0)));
                    break;
                }
            }
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)2.2f);
        }
        if (this.rotationOnSeen != -1.0f) {
            // empty if block
        }
    }

    protected boolean func_70610_aX() {
        if (this.canBeSeen) {
            return true;
        }
        return super.func_70610_aX();
    }

    public List<EntityPlayer> getPlayers() {
        return this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72321_a(30.0, 30.0, 30.0));
    }

    protected boolean isInFieldOfVision(EntityLiving e1, EntityPlayer e2) {
        if (e2 == null) {
            return false;
        }
        Vec3d vec3 = e2.func_70040_Z();
        Vec3d vec31 = new Vec3d(this.field_70165_t - e2.field_70165_t, this.func_174813_aQ().field_72338_b + (double)this.field_70131_O - (e2.field_70163_u + (double)e2.func_70047_e()), this.field_70161_v - e2.field_70161_v);
        double d0 = vec31.func_72433_c();
        double d1 = vec3.func_72430_b(vec31 = vec31.func_72432_b());
        boolean b = d1 > 0.975 / d0;
        if ((b = b ? this.canEntityBeSeen((Entity)e2, (Entity)this) : false) && d0 > (double)0.1f) {
            return true;
        }
        return b;
    }

    public boolean canEntityBeSeen(Entity e1, Entity e2) {
        RayTraceResult mop = e1.field_70170_p.func_72933_a(new Vec3d(e1.field_70165_t, e1.field_70163_u + (double)e1.func_70047_e(), e1.field_70161_v), new Vec3d(e2.field_70165_t, e2.field_70163_u + (double)e2.func_70047_e(), e2.field_70161_v));
        if (mop == null) {
            return true;
        }
        Block b = this.field_70170_p.func_180495_p(mop.func_178782_a()).func_177230_c();
        return !b.func_149730_j(null) || !b.func_149686_d(null);
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    protected void func_82167_n(Entity arg0) {
        boolean PlayerGameRule;
        if (!this.field_70170_p.field_72995_K && arg0 instanceof EntityPlayer && (PlayerGameRule = this.field_70170_p.func_82736_K().func_82766_b("DMAngelPlayerTeleporting"))) {
            int amount = 120;
            int AmountB = amount / 2;
            if (AmountB <= 5) {
                AmountB += 8;
            }
            EntityPlayer e = (EntityPlayer)arg0;
            if (this.field_70170_p.field_73012_v.nextInt(25) == 5) {
                double d2;
                double d1;
                double d0 = this.field_70165_t + (double)this.field_70146_Z.nextInt(amount);
                BlockPos p = new BlockPos(d0, d1 = this.field_70163_u + (double)this.field_70146_Z.nextInt(AmountB * 4), d2 = this.field_70161_v + (double)this.field_70146_Z.nextInt(amount));
                if (this.field_70170_p.func_175623_d(p)) {
                    if (this.field_70170_p.func_180495_p(p.func_177982_a(0, -1, 0)).func_185904_a().func_76220_a()) {
                        e.func_70634_a((double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p());
                    } else {
                        for (int i = 1; i < 255; ++i) {
                            if (!this.field_70170_p.func_180495_p(p.func_177982_a(0, -p.func_177956_o() + i - 1, 0)).func_185904_a().func_76220_a()) continue;
                            e.func_70634_a((double)p.func_177958_n(), (double)i, (double)p.func_177952_p());
                        }
                    }
                } else {
                    for (int i = 1; i < 255; ++i) {
                        if (!this.field_70170_p.func_175623_d(p.func_177982_a(0, -p.func_177956_o() + i, 0)) || !this.field_70170_p.func_180495_p(p.func_177982_a(0, -p.func_177956_o() + i - 1, 0)).func_185904_a().func_76220_a()) continue;
                        e.func_70634_a((double)p.func_177958_n(), (double)i, (double)p.func_177952_p());
                    }
                }
                return;
            }
        }
        super.func_82167_n(arg0);
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        super.func_70665_d((DamageSource)DMDamageSources.WEEPINGANGEL, damageAmount);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public boolean func_70652_k(Entity entity) {
        EntityPlayer ep;
        if (this.canBeSeen) {
            return false;
        }
        if (entity instanceof EntityPlayer) {
            ep = (EntityPlayer)entity;
            ep.func_70097_a((DamageSource)DMDamageSources.WEEPINGANGEL, 4.0f);
            if (this.getStolenKey() != null && this.getStolenKey().func_77973_b() != DMItems.TARDIS_KEY && this.field_70146_Z.nextBoolean()) {
                for (int i = 0; i < ep.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack stack = ep.field_71071_by.func_70301_a(i);
                    if (stack.func_77973_b() == Items.field_190931_a || stack.func_77973_b() != DMItems.TARDIS_KEY) continue;
                    this.stolenKey = ep.field_71071_by.func_70301_a(i).func_77946_l();
                    ep.field_71071_by.func_70301_a(i).func_190920_e(0);
                    ep.field_71069_bz.func_75142_b();
                    if (this.field_70170_p.field_72995_K) continue;
                    ep.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + "message.angel.key_taken", new Object[0]));
                    this.func_184212_Q().func_187227_b(CARRIED_ITEM, (Object)this.stolenKey);
                }
            }
            if (!this.canBeSeen) {
                this.isAngry = true;
            }
        }
        if (entity instanceof EntityPlayer && this.field_70146_Z.nextInt(3) == 2) {
            if (!this.canBeSeen) {
                this.teleportRandomly();
                this.isAngry = false;
            }
            ep = (EntityPlayer)entity;
            ep.func_70097_a((DamageSource)DMDamageSources.WEEPINGANGEL, 1.0f);
            if (ep.func_70660_b(MobEffects.field_76440_q) == null) {
                ep.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 50, 5));
            }
            if (ep.func_70660_b(MobEffects.field_76421_d) == null) {
                ep.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 18, 5));
            }
            if (ep.func_70660_b(MobEffects.field_76437_t) == null) {
                ep.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 18, 5));
            }
            if (ep.func_70660_b(MobEffects.field_76431_k) == null) {
                ep.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 18, 5));
            }
        }
        return super.func_70652_k(entity);
    }

    protected boolean teleportRandomly() {
        int amount = 64;
        double d0 = this.field_70165_t + (double)this.field_70146_Z.nextInt(amount);
        double d1 = this.field_70163_u + (double)this.field_70146_Z.nextInt(amount / 2);
        double d2 = this.field_70161_v + (double)this.field_70146_Z.nextInt(amount);
        this.teleportTo(d0, d1, d2);
        return true;
    }

    protected boolean teleportTo(double p_70825_1_, double p_70825_3_, double p_70825_5_) {
        BlockPos p = new BlockPos(p_70825_1_, p_70825_3_, p_70825_5_);
        if (this.field_70170_p.func_175623_d(p)) {
            if (this.field_70170_p.func_180495_p(p.func_177982_a(0, -1, 0)).func_185904_a().func_76220_a()) {
                this.func_70634_a(p.func_177958_n(), p.func_177956_o(), p.func_177952_p());
            } else {
                for (int i = 1; i < 255; ++i) {
                    if (!this.field_70170_p.func_180495_p(p.func_177982_a(0, -p.func_177956_o() + i - 1, 0)).func_185904_a().func_76220_a()) continue;
                    this.func_70634_a(p.func_177958_n(), i, p.func_177952_p());
                }
            }
        } else {
            for (int i = 1; i < 255; ++i) {
                if (!this.field_70170_p.func_175623_d(p.func_177982_a(0, -p.func_177956_o() + i, 0)) || !this.field_70170_p.func_180495_p(p.func_177982_a(0, -p.func_177956_o() + i - 1, 0)).func_185904_a().func_76220_a()) continue;
                this.func_70634_a(p.func_177958_n(), i, p.func_177952_p());
            }
        }
        return true;
    }

    public void writeSpawnData(ByteBuf buffer) {
    }

    public void readSpawnData(ByteBuf additionalData) {
    }

    public ItemStack getStolenKey() {
        return this.stolenKey;
    }

    public boolean isAngry() {
        return this.isAngry;
    }

    public void func_70014_b(NBTTagCompound nbt_tag) {
        super.func_70014_b(nbt_tag);
        if (this.getStolenKey() != null && this.getStolenKey().func_77973_b() == DMItems.TARDIS_KEY) {
            NBTTagCompound tag = new NBTTagCompound();
            this.getStolenKey().func_77955_b(tag);
            nbt_tag.func_74782_a("items", (NBTBase)tag);
        }
    }

    public void func_70037_a(NBTTagCompound nbt_tag) {
        super.func_70037_a(nbt_tag);
        if (nbt_tag.func_74764_b("items")) {
            NBTTagCompound tag = nbt_tag.func_74775_l("items");
            this.stolenKey = new ItemStack(tag);
            this.func_184212_Q().func_187227_b(CARRIED_ITEM, (Object)this.stolenKey);
        }
    }
}

