/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.init;

import com.google.common.reflect.TypeToken;
import com.swdteam.common.capability.CapabilityTardis;
import com.swdteam.common.capability.interfaces.ITardisCapability;
import com.swdteam.common.data.PlayerData;
import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.init.DMSchematics;
import com.swdteam.common.init.DMTardisInteriors;
import com.swdteam.common.init.DMTardisSkinReg;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tardis.data.TardisInterior;
import com.swdteam.common.tardis.data.UserTardises;
import com.swdteam.common.tardis.data.chameleon.ChameleonCircuitBase;
import com.swdteam.common.tileentity.tardis.TileEntityTardis;
import com.swdteam.common.tileentity.tardis.perms.TardisPermission;
import com.swdteam.main.TheDalekMod;
import com.swdteam.main.config.DMConfig;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_SendTardisData;
import com.swdteam.utils.FileUtils;
import com.swdteam.utils.PlayerUtils;
import com.swdteam.utils.TeleportUtils;
import com.swdteam.utils.Vector3;
import com.swdteam.utils.WorldUtils;
import com.swdteam.utils.world.SchematicUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import net.minecraftforge.fml.relauncher.Side;

public class DMTardis {
    public static int INTERIOR_BOUNDS = 128;
    public static TardisData DEFAULT_DATA = new TardisData(0);
    public static HashMap<Integer, TardisData> tardises = new HashMap();
    public static List<ChameleonCircuitBase> ccTardisesAL = new ArrayList<ChameleonCircuitBase>();
    public static List<Integer> removed_tardis = new ArrayList<Integer>();
    public static Type removed = new TypeToken<ArrayList<Integer>>(){}.getType();

    public static void updateIDFromPosition(EntityPlayer player) {
        int tardis_id;
        TardisData data;
        ITardisCapability capa;
        if (player.hasCapability(CapabilityTardis.FLIGHTMODE_CAP, null) && (capa = (ITardisCapability)player.getCapability(CapabilityTardis.FLIGHTMODE_CAP, null)) != null && (data = DMTardis.getTardis(capa.getTARDISID())) != null && !capa.getInFlight() && (tardis_id = DMTardis.getIDForXZ((int)player.field_70165_t, (int)player.field_70161_v)) > 0) {
            capa.setTARDISID(tardis_id);
            capa.syncToPlayer();
        }
    }

    public static int getRemovedTardis() {
        int i;
        block0: {
            i = 0;
            Iterator<Integer> iterator = removed_tardis.iterator();
            if (!iterator.hasNext()) break block0;
            Integer integer = iterator.next();
            i = integer;
            removed_tardis.remove(integer);
            DMTardis.saveRemovedTardis();
        }
        return i;
    }

    public static List<Integer> getRemoved_tardis() {
        return removed_tardis;
    }

    public static String[] getTardisSkinArray() {
        String[] s = new String[ccTardisesAL.size()];
        for (int i = 0; i < ccTardisesAL.size(); ++i) {
            ChameleonCircuitBase ccb = ccTardisesAL.get(i);
            s[i] = ccb.getExteriorName();
        }
        return s;
    }

    public static String[] getTardisListAsArray() {
        String fileDir = ((File)FMLInjectionData.data()[6]).getAbsolutePath() + "/saves/" + TheDalekMod.FML.getMinecraftServerInstance().func_71270_I() + "/Tardis_Data/Tardises/";
        File f = new File(fileDir);
        int size = f.listFiles().length - 1;
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i < size + 1; ++i) {
            if (DMTardis.isRemovedTardis(i)) continue;
            list.add("" + i);
        }
        String[] array = new String[list.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (String)list.get(i);
        }
        return array;
    }

    public static void generateInterior(TardisData data, int interiorID) {
        TardisInterior interior = DMTardisInteriors.getInteriors().get(interiorID);
        DMTardis.generateInterior(data, interior);
    }

    public static void generateInterior(TardisData data, TardisInterior interior) {
        WorldServer w = TheDalekMod.FML.getMinecraftServerInstance().func_71218_a(DMConfig.dimensionIDs.Tardis_Dimension_ID);
        BlockPos p = DMTardis.getXZForMap(data.getTardisID());
        int[] pos = new int[]{p.func_177958_n(), p.func_177952_p()};
        BlockPos pos2 = new BlockPos(p.func_177958_n() * INTERIOR_BOUNDS, 0, p.func_177952_p() * INTERIOR_BOUNDS);
        BlockPos pos1 = pos2.func_177982_a(INTERIOR_BOUNDS / 2 - interior.getSchematic().getSchemDimX() / 2, 127 - interior.getSchematic().getSchemDimY() / 2, INTERIOR_BOUNDS / 2 - interior.getSchematic().getSchemDimZ() / 2);
        data.setTardisInteriorDoorLocation(new Vector3(pos1.func_177958_n() + interior.getPlayerSpawnOffset().x, pos1.func_177956_o() + interior.getPlayerSpawnOffset().y - 58, pos1.func_177952_p() + interior.getPlayerSpawnOffset().z));
        data.setInteriorState(TardisData.InteriorState.GENERATED);
        data.setSpawnFacing(interior.getSpawnRotation());
        TardisSaveHandler.saveTardis(data);
        SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.TARDIS, (World)w, pos1, interior.getSchematic());
        if (interior.getGenerator() != null) {
            interior.getGenerator().generate((World)w, pos1, data);
        }
    }

    public static int addTardis(int exterior) {
        ChameleonCircuitBase exteriorCC = DMTardis.getTardisSkin(exterior);
        int tardisID = removed_tardis.size() > 0 ? DMTardis.getRemovedTardis() : DMTardis.getFreeTardisID();
        BlockPos p = DMTardis.getXZForMap(tardisID);
        int[] pos = new int[]{p.func_177958_n(), p.func_177952_p()};
        BlockPos pos2 = new BlockPos(p.func_177958_n() * INTERIOR_BOUNDS, 0, p.func_177952_p() * INTERIOR_BOUNDS);
        BlockPos pos1 = pos2.func_177982_a(INTERIOR_BOUNDS / 2 - exteriorCC.getInterior().getSchematic().getSchemDimX() / 2, 127 - exteriorCC.getInterior().getSchematic().getSchemDimY() / 2, INTERIOR_BOUNDS / 2 - exteriorCC.getInterior().getSchematic().getSchemDimZ() / 2);
        TardisData data = new TardisData(tardisID);
        data.setTardisInteriorDoorLocation(new Vector3(pos1.func_177958_n() + exteriorCC.getInterior().getPlayerSpawnOffset().x, pos1.func_177956_o() + exteriorCC.getInterior().getPlayerSpawnOffset().y - 58, pos1.func_177952_p() + exteriorCC.getInterior().getPlayerSpawnOffset().z));
        data.setSpawnFacing(exteriorCC.getInterior().getSpawnRotation());
        data.setTardisInteriorPosition(pos);
        data.setExteriorID(exterior);
        TardisSaveHandler.saveTardis(data);
        tardises.put(tardisID, data);
        WorldServer w = TheDalekMod.FML.getMinecraftServerInstance().func_71218_a(DMConfig.dimensionIDs.Tardis_Dimension_ID);
        if (DMConfig.serverSide.TARDIS_BOUNDS) {
            DMSchematics.TARDIS_BOUNDARIES.add(pos2);
        }
        TheDalekMod.LOG.info("Added TARDIS: " + pos2.func_177958_n() + " | " + pos2.func_177952_p() + ", with ID of " + tardisID);
        return tardisID;
    }

    public static UserTardises getUserTardises(UUID user) {
        Object o;
        String fileDir = ((File)FMLInjectionData.data()[6]).getAbsolutePath() + "/saves/" + TheDalekMod.FML.getMinecraftServerInstance().func_71270_I() + "/Tardis_Data/Player Lookup/" + user + ".json";
        File file = new File(fileDir);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if ((o = FileUtils.loadObjectFromFile(file, UserTardises.class)) != null && o instanceof UserTardises) {
            UserTardises uTar = (UserTardises)o;
            return uTar;
        }
        return new UserTardises();
    }

    public static void updateUserTardisData(UserTardises uTar, UUID user) {
        DMTardis.updateUserTardisData(uTar, user.toString());
    }

    public static boolean isPlayerOwnerOrCompanion(EntityPlayer player, TardisData data) {
        boolean owner = false;
        boolean compa = false;
        if (data.getCurrentOwner().toString().equalsIgnoreCase(player.func_110124_au().toString())) {
            owner = true;
        }
        for (PlayerData p : data.getCompanions()) {
            if (!p.getPlayerUUID().toString().equalsIgnoreCase(player.func_110124_au().toString())) continue;
            compa = true;
            break;
        }
        return owner || compa;
    }

    public static void updateUserTardisData(UserTardises uTar, String user) {
        String fileDir = ((File)FMLInjectionData.data()[6]).getAbsolutePath() + "/saves/" + TheDalekMod.FML.getMinecraftServerInstance().func_71270_I() + "/Tardis_Data/Player Lookup/" + user + ".json";
        File file = new File(fileDir);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        FileUtils.writeObjectToFile((Object)uTar, file);
    }

    public static void reconstructPlayerLookup(String uuid) {
        UserTardises tardises = DMTardis.getUserTardises(UUID.fromString(uuid));
        UserTardises uTarNew = new UserTardises();
        if (tardises.getTardises().size() > 0) {
            tardises.getTardises().forEach(i -> {
                TardisData d = TardisSaveHandler.loadTardis(i);
                if (d != null && d.getCurrentOwner() != null && d.getCurrentOwner().toString().equalsIgnoreCase(uuid) && !d.isRemoved()) {
                    uTarNew.addTardis((int)i);
                }
            });
            DMTardis.updateUserTardisData(uTarNew, uuid);
        }
    }

    public static BlockPos getXZForMap(int np) {
        int dx = 0;
        int dy = 1;
        int segment_length = 1;
        int x = 0;
        int y = 0;
        int segment_passed = 0;
        if (np == 0) {
            return new BlockPos(x, 0, y);
        }
        for (int n = 0; n < np; ++n) {
            x += dx;
            y += dy;
            if (++segment_passed != segment_length) continue;
            segment_passed = 0;
            int buffer = dy;
            dy = -dx;
            dx = buffer;
            if (dx != 0) continue;
            ++segment_length;
        }
        return new BlockPos(x, 0, y);
    }

    public static int getIDForXZ(int X, int Z) {
        int index = 0;
        int x = 0;
        int y = 0;
        int dx = 0;
        int dy = 1;
        int segment_length = 1;
        int segment_passed = 0;
        int fX = X;
        int fZ = Z;
        boolean found = false;
        long timecheck = System.currentTimeMillis();
        while (true) {
            if (System.currentTimeMillis() - timecheck > 10000L) {
                System.out.println("Finding ID from XZ Coordinates is taking too long!");
                break;
            }
            if (fX >= x * INTERIOR_BOUNDS && fX <= INTERIOR_BOUNDS + x * INTERIOR_BOUNDS && fZ >= y * INTERIOR_BOUNDS && fZ <= INTERIOR_BOUNDS + y * INTERIOR_BOUNDS) {
                found = true;
                break;
            }
            x += dx;
            y += dy;
            if (++segment_passed == segment_length) {
                segment_passed = 0;
                int buffer = dy;
                dy = -dx;
                dx = buffer;
                if (dx == 0) {
                    ++segment_length;
                }
            }
            ++index;
        }
        if (!found) {
            index = 0;
        }
        return index;
    }

    public static boolean isCoordinateInTARDIS(int X, int Z, TardisData tardis) {
        if (tardis != null) {
            int x1 = tardis.getInteriorX() * INTERIOR_BOUNDS;
            int x2 = tardis.getInteriorX() * INTERIOR_BOUNDS + INTERIOR_BOUNDS;
            int z1 = tardis.getInteriorZ() * INTERIOR_BOUNDS;
            int z2 = tardis.getInteriorZ() * INTERIOR_BOUNDS + INTERIOR_BOUNDS;
            return X > x1 && X < x2 && Z > z1 && Z < z2;
        }
        return false;
    }

    public TardisData getDatafromXZ(int X, int Z) {
        TardisData data = DMTardis.getTardis(DMTardis.getIDForXZ(X, Z));
        return data;
    }

    public static int getFreeTardisID() {
        String fileDir = ((File)FMLInjectionData.data()[6]).getAbsolutePath() + "/saves/" + TheDalekMod.FML.getMinecraftServerInstance().func_71270_I() + "/Tardis_Data/Tardises/";
        File f = new File(fileDir);
        if (!f.exists()) {
            f.mkdirs();
        }
        int id = f.listFiles().length - 1;
        while (DMTardis.doesTardisExist(id)) {
            ++id;
        }
        if (id == 0) {
            ++id;
        }
        return id;
    }

    public static boolean doesTardisExist(int id) {
        if (tardises.containsKey(id)) {
            return true;
        }
        String fileDir = ((File)FMLInjectionData.data()[6]).getAbsolutePath() + "/saves/" + TheDalekMod.FML.getMinecraftServerInstance().func_71270_I() + "/Tardis_Data/Tardises/TardisData_" + id + ".json";
        return new File(fileDir).exists();
    }

    public static TardisData getTardis(int id) {
        return DMTardis.getTardis(true, id);
    }

    public static TardisData getTardis(boolean side, int id) {
        if (side) {
            // empty if block
        }
        if (tardises.containsKey(id)) {
            return tardises.get(id);
        }
        if (side) {
            TardisData d = TardisSaveHandler.loadTardis(id);
            if (d != null) {
                tardises.put(id, d);
                return d;
            }
            return tardises.get(0);
        }
        return null;
    }

    public static HashMap<Integer, TardisData> getTardises() {
        return tardises;
    }

    public static void setTardises(HashMap<Integer, TardisData> tardises) {
        DMTardis.tardises = tardises;
    }

    public static void loadClientData(int tardisID, EntityPlayerMP player) {
        TardisData data = DMTardis.getTardis(tardisID);
        if (data == null) {
            data = new TardisData(0);
        }
        if (data != null) {
            if (player == null) {
                PacketHandler.INSTANCE.sendToAll((IMessage)new Packet_SendTardisData(data));
            } else {
                PacketHandler.INSTANCE.sendTo((IMessage)new Packet_SendTardisData(data), player);
            }
        }
    }

    public static void loadClientDataDim(int tardisID, int dim) {
        TardisData data = DMTardis.getTardis(tardisID);
        if (data == null) {
            data = new TardisData(0);
        }
        if (data != null) {
            PacketHandler.INSTANCE.sendToDimension((IMessage)new Packet_SendTardisData(data), dim);
        }
    }

    public static void addTardisFromData(TardisData d) {
        if (d != null) {
            if (tardises.containsKey(d.getTardisID())) {
                tardises.replace(d.getTardisID(), tardises.get(d.getTardisID()), d);
            } else {
                tardises.put(d.getTardisID(), d);
            }
        }
    }

    public static ChameleonCircuitBase addTardisSkin(ChameleonCircuitBase b) {
        if (ccTardisesAL.contains(b)) {
            TheDalekMod.LOG.info("[Dalek Mod] Tardis Already registered");
            return null;
        }
        ccTardisesAL.add(b);
        return b;
    }

    @Deprecated
    public static ChameleonCircuitBase getTardisSkin(String s) {
        for (ChameleonCircuitBase ccb : ccTardisesAL) {
            if (!ccb.getExteriorName().equalsIgnoreCase(s)) continue;
            return ccb;
        }
        return DMTardisSkinReg.SKIN_DEFAULT;
    }

    public static ChameleonCircuitBase getTardisSkin(int i) {
        if (i >= 0 && i < ccTardisesAL.size()) {
            return ccTardisesAL.get(i);
        }
        return DMTardisSkinReg.SKIN_DEFAULT;
    }

    public static boolean doesTardisSkinExist(String s) {
        for (ChameleonCircuitBase ccb : ccTardisesAL) {
            if (!ccb.getExteriorName().equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean doesTardisSkinExist(int i) {
        return i >= 0 && i < ccTardisesAL.size();
    }

    public static void removeTardis(int id) {
        tardises.remove(id);
    }

    public static boolean hasPermission(TardisData data, EntityPlayer p) {
        if (data.getTardisPermissions() == null) {
            data.setTardisPermissions(TardisPermission.NOBODY);
        }
        if (data.getCurrentOwner() == null && data.getOwner().equals(p.func_70005_c_())) {
            data.setCurrentOwner(p.func_110124_au());
        }
        switch (data.getTardisPermissions()) {
            case NOBODY: {
                if (data.getCurrentOwner() == null || !data.getCurrentOwner().equals(p.func_110124_au())) break;
                return true;
            }
            case COMPANIONS: {
                if ((data.getCurrentOwner() == null || !data.getCurrentOwner().equals(p.func_110124_au())) && !data.isCompanion(p)) break;
                return true;
            }
            case EVERYONE: {
                return true;
            }
        }
        return false;
    }

    public static int getNextFreeTardisChameleonID() {
        return ccTardisesAL.size();
    }

    public static boolean removeTardis(TardisData data, EntityPlayer player, boolean b) {
        if (data != null) {
            int id = data.getTardisID();
            World world = player.field_70170_p;
            if (!DMTardis.isRemovedTardis(id)) {
                if (world != null) {
                    BlockPos p = DMTardis.getXZForMap(id);
                    BlockPos pos2 = new BlockPos(p.func_177958_n() * INTERIOR_BOUNDS, 0, p.func_177952_p() * INTERIOR_BOUNDS);
                    WorldServer tardisDim = world.func_73046_m().func_71218_a(DMDimensions.DIM_TARDIS_ID);
                    WorldServer exteriorDIm = world.func_73046_m().func_71218_a(data.getTardisCurrentdimension());
                    if (b) {
                        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)pos2.func_177982_a(1, 1, 1), (BlockPos)pos2.func_177982_a(INTERIOR_BOUNDS - 1, 254, INTERIOR_BOUNDS - 1))) {
                            if (tardisDim.func_180495_p(pos) == Blocks.field_150350_a) continue;
                            WorldUtils.setBlockFast((World)tardisDim, pos, Blocks.field_150350_a.func_176223_P(), 2);
                        }
                    } else {
                        BlockPos pos = WorldUtils.vec3ToBlockPos(data.getTardisInteriorDoorLocation());
                        TeleportUtils.teleportToDimension((Entity)player, tardisDim.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), data.getSpawnFacing(), 0.0f);
                        PlayerUtils.Messaging.sendMessageToPlayer(player, TextFormatting.RED + "Don't forget to remove the interior!");
                    }
                    if (data.getCurrentOwner() != null) {
                        UserTardises uTarOld = DMTardis.getUserTardises(data.getCurrentOwner());
                        uTarOld.getTardises().removeAll(Arrays.asList(id));
                        DMTardis.updateUserTardisData(uTarOld, data.getCurrentOwner());
                    }
                    DMTardis.removeTardis(id);
                    DMTardis.addRemovedID(id);
                    DMTardis.saveRemovedTardis();
                    data.setRemoved(true);
                    TardisSaveHandler.saveTardis(data);
                    TileEntityTardis tileEntityTardis = (TileEntityTardis)exteriorDIm.func_175625_s(WorldUtils.vec3ToBlockPos(data.getCurrentTardisPosition()));
                    if (tileEntityTardis != null) {
                        exteriorDIm.func_175656_a(WorldUtils.vec3ToBlockPos(data.getCurrentTardisPosition()), Blocks.field_150350_a.func_176223_P());
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static void addRemovedID(int id) {
        if (!removed_tardis.contains(id)) {
            removed_tardis.add(id);
        }
    }

    public static ArrayList<Integer> removedToMap(String json) {
        ArrayList ret = new ArrayList();
        return json != null && !json.isEmpty() ? (ArrayList)TheDalekMod.GSON.fromJson(json, removed) : ret;
    }

    public static String removedToJson(List<Integer> map) {
        if (map == null) {
            map = new ArrayList<Integer>();
        }
        return TheDalekMod.GSON.toJson(map);
    }

    public static boolean isRemovedTardis(int id) {
        return removed_tardis.contains(id);
    }

    private static void saveRemovedTardis() {
        if (TheDalekMod.FML.getEffectiveSide() == Side.CLIENT) {
            return;
        }
        String fileDir = ((File)FMLInjectionData.data()[6]).getAbsolutePath() + "/saves/" + TheDalekMod.FML.getMinecraftServerInstance().func_71270_I() + "/Tardis_Data//Tardises/";
        String fileName = "removed_Tardises.json";
        File dir = new File(fileDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String json = DMTardis.removedToJson(removed_tardis);
        try {
            FileWriter fw = new FileWriter(dir + "/" + fileName);
            fw.write(json);
            fw.close();
        }
        catch (IOException var5) {
            var5.printStackTrace();
        }
    }

    public static void loadRemovedTardises() {
        File dir;
        if (TheDalekMod.FML.getEffectiveSide() == Side.CLIENT) {
            return;
        }
        removed_tardis.clear();
        String fileDir = ((File)FMLInjectionData.data()[6]).getAbsolutePath() + "/saves/" + TheDalekMod.FML.getMinecraftServerInstance().func_71270_I() + "/Tardis_Data//Tardises/";
        String fileName = "removed_Tardises.json";
        File f = new File(fileDir + fileName);
        if (!f.exists()) {
            DMTardis.saveRemovedTardis();
        }
        if ((dir = new File(fileDir)).exists()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(fileDir + fileName));
                StringBuilder b = new StringBuilder();
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        b.append(line);
                    }
                }
                catch (IOException var7) {
                    var7.printStackTrace();
                }
                if (b.toString().length() > 0) {
                    removed_tardis = DMTardis.removedToMap(b.toString());
                }
            }
            catch (FileNotFoundException var8) {
                var8.printStackTrace();
            }
        }
    }
}

