/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.tileentity.tardis;

import com.swdteam.client.worldportal.IWorldPortal;
import com.swdteam.client.worldportal.WorldPortal;
import com.swdteam.client.worldportal.WorldRender;
import com.swdteam.client.worldportal.packet.PacketRequestBoti;
import com.swdteam.common.block.actions.ActionList;
import com.swdteam.common.capability.CapabilityTardis;
import com.swdteam.common.capability.interfaces.ITardisCapability;
import com.swdteam.common.dimensions.world.WorldProviderTardis;
import com.swdteam.common.event.TardisHandler;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tardis.data.chameleon.ChameleonCircuitBase;
import com.swdteam.common.tileentity.DMTileEntityBase;
import com.swdteam.main.TheDalekMod;
import com.swdteam.main.config.DMConfig;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_RequestTardisData;
import com.swdteam.network.packets.Packet_SotoDoors;
import com.swdteam.utils.WorldUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityDoor
extends DMTileEntityBase
implements IWorldPortal,
ITickable {
    public TardisData tempTardisData;
    public int tardisID = 0;
    public float rot = 0.0f;
    public boolean open = false;
    public int open_tick = 0;
    public boolean sotoUpdate = false;
    public float maxRotation = 0.0f;
    public float rotationSpeedOpen = 0.0f;
    public float rotationSpeedClosed = 0.0f;
    public long lastUpdateTime = 0L;
    public boolean init;
    public int chameleonid;
    public boolean inflight;
    public WorldRender worldRender = new WorldRender(this.func_174877_v());

    public void func_73660_a() {
        List entities;
        if (!this.init) {
            this.init();
            this.init = true;
        }
        if (this.tempTardisData == null) {
            this.tardisID = DMTardis.getIDForXZ(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177952_p());
            this.tempTardisData = DMTardis.getTardis(this.tardisID);
        }
        this.keepUpdated();
        if (this.tempTardisData != null && !this.field_145850_b.field_72995_K) {
            this.checkFlight(this.tardisID);
            if (this.inflight || this.tempTardisData.isInFlightMode() || this.tempTardisData.isLocked()) {
                this.setOpen(false);
            }
        }
        this.handleDoorRotations();
        if (this.open && !this.field_145850_b.field_72995_K) {
            ++this.open_tick;
            if (this.open_tick > 1800 && (entities = this.field_145850_b.func_72872_a(EntityPlayer.class, Block.field_185505_j.func_186670_a(this.func_174877_v()).func_186662_g(10.0))).isEmpty()) {
                this.setOpen(false);
                this.open_tick = 0;
            }
        } else if (this.open_tick > 0) {
            this.open_tick = 0;
        }
        if (!this.field_145850_b.field_72995_K && DMConfig.tardis.isBotiEnabled && this.field_145850_b.field_73011_w instanceof WorldProviderTardis && this.sotoUpdate && this.open) {
            this.tempTardisData = DMTardis.getTardis(this.tardisID);
            if (this.tempTardisData != null && this.field_145850_b.func_72820_D() % 20L == 0L) {
                WorldPortal.WorldPortalServer.getWorldRender(this.field_145850_b, this.getPosToRender(), this.getDimension(), this.func_174877_v(), this.tempTardisData.getActualLandRotation() + 180.0f, false);
            }
        }
        this.setSotoUpdate(false);
        if (!(this.field_145850_b.field_72995_K || !this.open || this.tempTardisData == null || this.tempTardisData.isInFlightMode() || this.tempTardisData.isInFlight() || (entities = this.field_145850_b.func_72872_a(Entity.class, Block.field_185505_j.func_186670_a(this.func_174877_v()).func_186662_g(0.1))).isEmpty())) {
            if (entities.get(0) instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entities.get(0);
                if (player.func_184218_aH()) {
                    player.func_184210_p();
                }
                ActionList.tardisDoorExit(this.field_145850_b, (EntityPlayer)entities.get(0));
                this.setOpen(false);
            } else {
                Entity e = (Entity)entities.get(0);
                if (e.func_184207_aI() && e.func_184188_bt().size() > 0) {
                    e.func_184226_ay();
                }
                ActionList.tardisDoorExit(this.field_145850_b, e, this.tardisID);
            }
        }
    }

    public void init() {
        this.setRot(0.0f);
        this.updateDoorRotations();
    }

    public void checkFlight(int id) {
        boolean b;
        if (TardisHandler.rotor_animation.containsKey(id) && (b = TardisHandler.rotor_animation.get(id).booleanValue()) != this.inflight) {
            this.inflight = b;
            this.sendUpdates();
        }
    }

    public double func_145833_n() {
        return super.func_145833_n();
    }

    public void handleInteract(EntityPlayer player) {
        ITardisCapability capability = (ITardisCapability)player.getCapability(CapabilityTardis.FLIGHTMODE_CAP, null);
        int tID = 0;
        if (capability != null) {
            tID = capability.getTARDISID();
            if (capability.getTARDISID() != this.tardisID) {
                this.requestRender();
            }
            this.keepUpdated();
        }
        if (!this.field_145850_b.field_72995_K) {
            TardisData data = DMTardis.getTardis(tID);
            if (data != null) {
                this.tempTardisData = data;
                if (data.isInFlight()) {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You can't open the doors in flight!"));
                    return;
                }
                if (data.isLocked()) {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You can't open the doors while locked!"));
                    return;
                }
                this.setOpen(!this.isOpen());
                this.soundHandle();
                this.syncExterior(player);
            }
            if (this.isOpen()) {
                this.requestRender();
                this.requestSoto();
            }
        }
    }

    public void soundHandle() {
        try {
            if (this.field_145850_b.func_175697_a(this.field_174879_c, 20)) {
                for (EntityPlayer player1 : this.field_145850_b.func_72872_a(EntityPlayer.class, Block.field_185505_j.func_72317_d((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p()).func_186662_g(20.0))) {
                    this.playDoorSound(player1);
                }
            }
        }
        catch (Exception e) {
            TheDalekMod.LOG.warn("Something went wrong in TileEntityDoor");
        }
    }

    public void requestSoto() {
        PacketHandler.INSTANCE.sendToDimension((IMessage)new PacketRequestBoti(this.field_174879_c), this.func_145831_w().field_73011_w.getDimension());
    }

    public void keepUpdated() {
        if (this.field_145850_b != null && System.currentTimeMillis() - this.lastUpdateTime > 10000L) {
            if (this.tardisID != 0) {
                if (this.field_145850_b.field_72995_K) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new Packet_RequestTardisData(this.tardisID));
                    this.tempTardisData = DMTardis.tardises.get(this.tardisID);
                }
                if (!this.field_145850_b.field_72995_K) {
                    this.tempTardisData = DMTardis.getTardis(this.tardisID);
                }
            }
            this.lastUpdateTime = System.currentTimeMillis();
        }
    }

    public void syncExterior(EntityPlayer player) {
        if (this.tardisID != 0) {
            // empty if block
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public ChameleonCircuitBase getSkin(TardisData data) {
        return DMTardis.getTardisSkin(data.getExteriorID());
    }

    public void setDoorRotation(float rot) {
        this.rot = rot;
    }

    public boolean isSotoUpdate() {
        return this.sotoUpdate;
    }

    public float getRotation() {
        return this.rot;
    }

    public void setTardisID(int tardisID) {
        this.tardisID = tardisID;
    }

    public int getTardisID() {
        return this.tardisID;
    }

    public void setMaxRotation(float maxRotation) {
        this.maxRotation = maxRotation;
    }

    public void setOpen(boolean open) {
        this.open = open;
        if (!this.field_145850_b.field_72995_K) {
            PacketHandler.INSTANCE.sendToDimension((IMessage)new Packet_SotoDoors(this.field_174879_c, open), this.func_145831_w().field_73011_w.getDimension());
        }
    }

    public void setOpen_tick(int open_tick) {
        this.open_tick = open_tick;
    }

    public void setRot(float rot) {
        this.rot = rot;
    }

    public void setChameleonid(int chameleonid) {
        this.chameleonid = chameleonid;
    }

    public int getChameleonid() {
        return this.chameleonid;
    }

    public void setRotationSpeedClosed(float rotationSpeedClosed) {
        this.rotationSpeedClosed = rotationSpeedClosed;
    }

    public void setRotationSpeedOpen(float rotationSpeedOpen) {
        this.rotationSpeedOpen = rotationSpeedOpen;
    }

    public float getMaxRotation() {
        return this.maxRotation;
    }

    public void setSotoUpdate(boolean sotoUpdate) {
        this.sotoUpdate = sotoUpdate;
    }

    public void setTempTardisData(TardisData tempTardisData) {
        this.tempTardisData = tempTardisData;
    }

    public void func_174878_a(BlockPos posIn) {
        super.func_174878_a(posIn);
    }

    public void onLoad() {
        super.onLoad();
        this.keepUpdated();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("tardis_id", this.tardisID);
        compound.func_74776_a("rotation_door", this.rot);
        compound.func_74757_a("init", this.init);
        compound.func_74757_a("open", this.open);
        compound.func_74776_a("maxRot", this.maxRotation);
        compound.func_74776_a("openSpeed", this.rotationSpeedOpen);
        compound.func_74776_a("closedSpeed", this.rotationSpeedClosed);
        compound.func_74757_a("flight", this.inflight);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.tardisID = compound.func_74764_b("tardis_id") ? compound.func_74762_e("tardis_id") : 0;
        this.rot = compound.func_74764_b("rotation_door") ? compound.func_74760_g("rotation_door") : 0.0f;
        this.open = compound.func_74764_b("open") ? compound.func_74767_n("open") : false;
        this.init = compound.func_74764_b("init") ? compound.func_74767_n("init") : false;
        this.inflight = compound.func_74764_b("flight") ? compound.func_74767_n("flight") : false;
        this.maxRotation = compound.func_74760_g("maxRot");
        this.rotationSpeedOpen = compound.func_74760_g("openSpeed");
        this.rotationSpeedClosed = compound.func_74760_g("closedSpeed");
    }

    public void onChunkUnload() {
        super.onChunkUnload();
    }

    @Override
    public int getDimension() {
        return this.tempTardisData != null ? this.tempTardisData.getTardisCurrentdimension() : 0;
    }

    @Override
    public BlockPos getPosToRender() {
        return this.tempTardisData != null ? WorldUtils.vec3ToBlockPos(this.tempTardisData.getCurrentTardisPosition()) : BlockPos.field_177992_a;
    }

    @Override
    public WorldRender getWorldRender() {
        return this.worldRender;
    }

    @Override
    public void setWorldRender(WorldRender worldRender) {
        this.worldRender = worldRender;
    }

    @Override
    public void requestRender() {
        if (this.field_145850_b.field_72995_K && this.open && !this.sotoUpdate) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketRequestBoti(this.func_174877_v()));
            this.setSotoUpdate(true);
        }
        if (!this.field_145850_b.field_72995_K && !this.sotoUpdate) {
            this.setSotoUpdate(true);
        }
    }

    public void handleDoorRotations() {
        if (this.maxRotation == 0.0f) {
            this.updateDoorRotations();
        }
        if (this.open && this.getRotation() < this.maxRotation) {
            this.setDoorRotation(this.getRotation() + this.rotationSpeedOpen);
        } else if (!this.open && this.getRotation() > 0.0f) {
            this.setDoorRotation(this.getRotation() - this.rotationSpeedClosed);
        }
        if (this.getRotation() < 0.0f) {
            this.setDoorRotation(0.0f);
        }
        if (this.getRotation() > this.maxRotation) {
            this.setDoorRotation(this.maxRotation);
        }
    }

    public void playDoorSound(EntityPlayer player) {
        ChameleonCircuitBase base = DMTardis.getTardisSkin(this.chameleonid);
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            if (this.open) {
                playerMP.field_71135_a.func_147359_a((Packet)new SPacketSoundEffect(base.doorSound(ChameleonCircuitBase.DoorState.OPEN), SoundCategory.MASTER, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 1.0f, 1.0f));
            } else {
                playerMP.field_71135_a.func_147359_a((Packet)new SPacketSoundEffect(base.doorSound(ChameleonCircuitBase.DoorState.CLOSED), SoundCategory.MASTER, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 1.0f, 1.0f));
            }
        }
    }

    public void updateDoorRotations() {
        if (this.tempTardisData != null) {
            ChameleonCircuitBase base = this.getSkin(this.tempTardisData);
            this.maxRotation = base.maxDoorRotation() - 0.2f;
            this.rotationSpeedOpen = base.doorOpenSpeed();
            this.rotationSpeedClosed = base.doorCloseSpeed();
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

