/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.main;

import com.swdteam.common.init.DMSchematics;
import com.swdteam.common.init.DMTardisInteriors;
import com.swdteam.main.TheDalekMod;
import com.swdteam.utils.IOUtils;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import org.apache.logging.log4j.Level;

public class DMCDN {
    public static boolean redoSetup = false;

    public static boolean init(CDNSide side) {
        boolean available = false;
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL("http://cdn.dalekmod.com/files.php").openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            if (connection.getResponseCode() == 200) {
                available = true;
            }
        }
        catch (ProtocolException protocolException) {
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (available) {
            String json = IOUtils.getRawJsonFromURL("http://cdn.dalekmod.com/files.php");
            if (json != null) {
                System.out.println("Setting up CDN: " + (Object)((Object)side));
                CDN cdn = new CDN();
                cdn.files = (CDNFile[])TheDalekMod.GSON.fromJson(json, CDNFile[].class);
                if (cdn != null && cdn.files != null) {
                    for (int i = 0; i < cdn.files.length; ++i) {
                        File f;
                        CDNFile file = cdn.files[i];
                        if (side == CDNSide.BOTH && file.side_required == CDNSide.BOTH) {
                            f = new File("mods/Dalek Mod/cdn/" + file.file_name);
                            if (!f.exists()) {
                                f.getParentFile().mkdirs();
                            }
                            if (f.exists() && (!f.exists() || f.length() == file.file_size)) continue;
                            IOUtils.tryDownloadFile("http://cdn.dalekmod.com/files/" + file.file_name, f.getAbsolutePath());
                            TheDalekMod.LOG.log(Level.INFO, "Server: Downloading: " + file.file_name);
                            continue;
                        }
                        if (side != CDNSide.CLIENT || file.side_required != CDNSide.CLIENT) continue;
                        f = new File("mods/Dalek Mod/cdn/" + file.file_name);
                        if (!f.exists()) {
                            f.getParentFile().mkdirs();
                        }
                        if (f.exists() && (!f.exists() || f.length() == file.file_size)) continue;
                        IOUtils.tryDownloadFile("http://cdn.dalekmod.com/files/" + file.file_name, f.getAbsolutePath());
                        TheDalekMod.LOG.log(Level.INFO, "Client: Downloading: " + file.file_name);
                    }
                }
            }
            if (redoSetup) {
                DMSchematics.init();
                DMTardisInteriors.init();
            }
            return true;
        }
        DMCDN.tryDownloadThread(side);
        System.out.println("CDN not available, trying again later");
        return false;
    }

    public static void tryDownloadThread(CDNSide side) {
        new Thread(() -> {
            boolean b = true;
            CDNSide cdnSide = side;
            while (b) {
                try {
                    Thread.sleep(20000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                DMCDN.init(cdnSide);
                b = false;
                redoSetup = true;
            }
        }, "CDN Download").start();
    }

    public static enum CDNSide {
        CLIENT,
        BOTH;

    }

    public static class CDNFile {
        public int id;
        public String file_name;
        public CDNSide side_required;
        public long file_size;
    }

    public static class CDN {
        public CDNFile[] files;
    }
}

