/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.network.packets;

import com.swdteam.common.tileentity.tardis.decoration.TileEntityChalkboard;
import com.swdteam.network.packets.AbstractServerMessageHandler;
import com.swdteam.utils.DMUtils;
import com.swdteam.utils.WorldUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class Packet_UpdateChalkboard
implements IMessage {
    public int x;
    public int y;
    public int z;
    public int length;
    public int[] dataArray;

    public Packet_UpdateChalkboard() {
    }

    public Packet_UpdateChalkboard(int x, int y, int z, int[] pixels) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.length = pixels.length;
        this.dataArray = pixels;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.length = buf.readInt();
        this.dataArray = new int[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.dataArray[i] = buf.readInt();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.length);
        for (int i = 0; i < this.length; ++i) {
            buf.writeInt(this.dataArray[i]);
        }
    }

    public static class Handler
    extends AbstractServerMessageHandler<Packet_UpdateChalkboard> {
        @Override
        public IMessage handleServerMessage(EntityPlayer player, final Packet_UpdateChalkboard message, final MessageContext ctx) {
            player.func_184102_h().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    BlockPos pos = new BlockPos(message.x, message.y, message.z);
                    TileEntity t = ctx.getServerHandler().field_147369_b.func_130014_f_().func_175625_s(pos);
                    if (t instanceof TileEntityChalkboard) {
                        TileEntityChalkboard tep = (TileEntityChalkboard)t;
                        tep.setPixels(DMUtils.to2dArray(message.dataArray, 32, 18));
                        WorldUtils.markBlockForUpdate(tep.func_145831_w(), tep.func_174877_v());
                    }
                }
            });
            return null;
        }
    }
}

