/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.worldportal;

import com.swdteam.client.worldportal.BlockData;
import com.swdteam.client.worldportal.CustomWorld;
import com.swdteam.client.worldportal.CustomWorldClient;
import com.swdteam.client.worldportal.IWorldPortal;
import com.swdteam.client.worldportal.WorldRender;
import com.swdteam.client.worldportal.packet.PacketWorldPortal;
import com.swdteam.client.worldportal.sky.SkyEnd;
import com.swdteam.common.tileentity.TileEntityBrachiInteriorDoor;
import com.swdteam.common.tileentity.TileEntityGallifreyFallsPainting;
import com.swdteam.common.tileentity.TileEntityTardisFlightPanel;
import com.swdteam.common.tileentity.TileEntityUntemperedSchism;
import com.swdteam.main.TheDalekMod;
import com.swdteam.main.config.DMConfig;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.utils.Graphics;
import com.swdteam.utils.misc.ReflectionHelper;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BlockFluidRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class WorldPortal {
    public static HashMap<Integer, CustomWorldClient> clients = new HashMap();
    public static HashMap<Long, BufferBuilder.State> worldrenders = new HashMap();
    public static List<String> tileEntities_ignore = new ArrayList<String>();
    public static BlockFluidRenderer blockFluidRenderer;
    private static long f382;
    private static long f383;

    public static void init() {
        try {
            blockFluidRenderer = (BlockFluidRenderer)ObfuscationReflectionHelper.getPrivateValue(BlockRendererDispatcher.class, (Object)Minecraft.func_71410_x().func_175602_ab(), (String[])new String[]{ReflectionHelper.doesFieldExist(BlockRendererDispatcher.class, "field_175025_e") ? "field_175025_e" : "fluidRenderer"});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void tilesToIgnore() {
        WorldPortal.init();
        tileEntities_ignore.add(TileEntityBeacon.class.getSimpleName());
        tileEntities_ignore.add(TileEntityGallifreyFallsPainting.class.getSimpleName());
        tileEntities_ignore.add(TileEntityUntemperedSchism.class.getSimpleName());
        tileEntities_ignore.add(TileEntityTardisFlightPanel.class.getSimpleName());
        tileEntities_ignore.add(TileEntityBrachiInteriorDoor.class.getSimpleName());
    }

    @SideOnly(value=Side.CLIENT)
    public static void render(IWorldPortal world, Vec3d renderPos, float rot) {
        if (DMConfig.clientSide.renderBoti) {
            if (world != null) {
                GlStateManager.func_179094_E();
                GL11.glShadeModel((int)7425);
                if (clients.containsKey(world.getWorldRender().getDimension())) {
                    WorldClient worldClient = clients.get(world.getWorldRender().getDimension());
                    if (worldClient != null && worldClient.field_73011_w != null && worldClient.field_73011_w.getSkyRenderer() != null) {
                        worldClient.field_73011_w.getSkyRenderer().render(Minecraft.func_71410_x().func_184121_ak(), worldClient, Minecraft.func_71410_x());
                    } else {
                        GlStateManager.func_179140_f();
                        GlStateManager.func_179109_b((float)0.0f, (float)5.0f, (float)0.0f);
                        if (world.getDimension() != 1) {
                            Minecraft.func_71410_x().field_71438_f.func_174976_a(Minecraft.func_71410_x().func_184121_ak(), 0);
                        } else {
                            SkyEnd.render();
                        }
                        GlStateManager.func_179145_e();
                        Minecraft.func_71410_x().field_71438_f.func_180447_b(Minecraft.func_71410_x().func_184121_ak(), 0, 10.0, 10.0, 10.0);
                        GlStateManager.func_179109_b((float)0.0f, (float)-5.0f, (float)0.0f);
                    }
                } else {
                    clients.put(world.getWorldRender().getDimension(), new CustomWorldClient(Minecraft.func_71410_x().field_71441_e, world.getWorldRender().getDimension(), Minecraft.func_71410_x().field_71441_e.func_72820_D()));
                    WorldPortal.markTileBotiUpdate(renderPos);
                }
                if (world.getWorldRender().blocks != null) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.5);
                    GlStateManager.func_179114_b((float)((int)rot), (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)-0.5);
                    GlStateManager.func_179137_b((double)0.0, (double)-1.5, (double)0.0);
                    BlockPos offset = world.getWorldRender().getRenderPos();
                    GlStateManager.func_179137_b((double)(renderPos.field_72450_a - (double)offset.func_177958_n()), (double)(renderPos.field_72448_b - (double)offset.func_177956_o()), (double)(renderPos.field_72449_c - (double)offset.func_177952_p()));
                    GlStateManager.func_179137_b((double)(-renderPos.field_72450_a), (double)(-renderPos.field_72448_b), (double)(-renderPos.field_72449_c));
                    WorldPortal.renderBlocks(world);
                    GlStateManager.func_179121_F();
                } else {
                    world.requestRender();
                }
            }
            GlStateManager.func_179121_F();
        }
    }

    public static void drawOutline(Vec3d s) {
        GlStateManager.func_179094_E();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)((float)Color.BLACK.getRed() / 255.0f), (float)((float)Color.BLACK.getGreen() / 255.0f), (float)((float)Color.BLACK.getBlue() / 255.0f), (float)((float)Color.BLACK.getAlpha() / 255.0f));
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buf = tes.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        buf.func_181662_b(0.0, s.field_72448_b, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buf.func_181662_b(s.field_72450_a, s.field_72448_b, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buf.func_181662_b(s.field_72450_a, 0.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        tes.func_78381_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GlStateManager.func_179121_F();
    }

    public static void initTiles(WorldRender render) {
        render.tileEntities = new ArrayList<TileEntity>();
        for (Map.Entry<Long, BlockData> dataEntry : render.blocks.entrySet()) {
            if (dataEntry.getValue().getCompound() == null) continue;
            TileEntity tileEntity = TileEntity.func_190200_a((World)((World)clients.get(render.dimension)), (NBTTagCompound)dataEntry.getValue().getCompound());
            tileEntity.func_145834_a((World)clients.get(render.dimension));
            dataEntry.getValue().setTileEntity(tileEntity);
            try {
                Class c = ReflectionHelper.getClassFromSuperClasses(tileEntity, TileEntity.class);
                if (c != null) {
                    Field f = c.getDeclaredField(ReflectionHelper.doesFieldExist(TileEntity.class, "field_145847_g") ? "field_145847_g" : "blockMetadata");
                    f.setAccessible(true);
                    f.set(tileEntity, dataEntry.getValue().blockMetaData);
                    f.setAccessible(false);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            render.tileEntities.add(tileEntity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderBlocks(IWorldPortal portal) {
        WorldRender world = portal.getWorldRender();
        if (System.currentTimeMillis() - f383 >= 10000L) {
            f383 = System.currentTimeMillis();
            worldrenders.clear();
        }
        if (!worldrenders.containsKey(world.identifier) || worldrenders.get(world.identifier) == null) {
            GlStateManager.func_179094_E();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexBuffer = tessellator.func_178180_c();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            HashMap<BlockPos, BlockData> see_Trough_blocks = null;
            Graphics.bindTexture(TextureMap.field_110575_b);
            CustomWorld customWorld = world.customWorld;
            if (customWorld != null && customWorld.blocks != null) {
                BlockPos blockPos;
                IBlockState block;
                for (Map.Entry<BlockPos, BlockData> entry : customWorld.blocks.entrySet()) {
                    block = entry.getValue().getState();
                    blockPos = entry.getKey();
                    if (blockPos == null || block == null || block == null || blockPos.func_177986_g() == portal.getWorldRender().getRenderPos().func_177986_g()) continue;
                    if (block.func_177230_c().func_180664_k() == BlockRenderLayer.TRANSLUCENT || block.func_185901_i() == EnumBlockRenderType.LIQUID || !block.func_185913_b() || !block.func_185914_p()) {
                        if (see_Trough_blocks == null) {
                            see_Trough_blocks = new HashMap<BlockPos, BlockData>();
                        }
                        see_Trough_blocks.put(blockPos, entry.getValue());
                        continue;
                    }
                    Minecraft.func_71410_x().func_175602_ab().func_175018_a(block, blockPos, (IBlockAccess)customWorld, vertexBuffer);
                }
                if (see_Trough_blocks != null && see_Trough_blocks.size() > 0) {
                    for (Map.Entry<Object, BlockData> entry : see_Trough_blocks.entrySet()) {
                        block = entry.getValue().getState();
                        blockPos = (BlockPos)entry.getKey();
                        if (blockPos == null || block == null || block == null || blockPos.func_177986_g() == portal.getWorldRender().getRenderPos().func_177986_g()) continue;
                        if (block.func_185901_i() == EnumBlockRenderType.LIQUID) {
                            blockPos = blockPos.func_177984_a();
                            blockFluidRenderer.func_178270_a((IBlockAccess)customWorld, block, blockPos, vertexBuffer);
                            continue;
                        }
                        Minecraft.func_71410_x().func_175602_ab().func_175018_a(block, blockPos, (IBlockAccess)customWorld, vertexBuffer);
                    }
                    see_Trough_blocks.clear();
                }
                worldrenders.put(world.identifier, vertexBuffer.func_181672_a());
                tessellator.func_78381_a();
                GlStateManager.func_179121_F();
            }
        } else {
            GlStateManager.func_179094_E();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexBuffer = tessellator.func_178180_c();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            Graphics.bindTexture(TextureMap.field_110575_b);
            vertexBuffer.func_178993_a(worldrenders.get(world.identifier));
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
        }
        if (clients.containsKey(portal.getDimension())) {
            WorldPortal.renderTiles(portal, clients.get(portal.getDimension()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderTiles(IWorldPortal portal, CustomWorldClient client) {
        GlStateManager.func_179094_E();
        Graphics.bindTexture(TextureMap.field_110575_b);
        ArrayList<TileEntity> tileRemoval = null;
        int pass = MinecraftForgeClient.getRenderPass();
        if (portal != null && portal.getWorldRender() != null && portal.getWorldRender().tileEntities != null) {
            for (int i = 0; i < portal.getWorldRender().tileEntities.size(); ++i) {
                TileEntity tileEntity = portal.getWorldRender().tileEntities.get(i);
                if (tileEntity == null || tileEntity.func_174877_v().func_177986_g() == portal.getPosToRender().func_177986_g() || tileEntities_ignore.contains(tileEntity.getClass().getSimpleName()) || !tileEntity.shouldRenderInPass(pass)) continue;
                if (tileEntity.func_145831_w() == null) {
                    tileEntity.func_145834_a((World)client);
                }
                try {
                    if (tileEntity instanceof ITickable && System.currentTimeMillis() - f382 >= 50L) {
                        f382 = System.currentTimeMillis();
                        ((ITickable)tileEntity).func_73660_a();
                    }
                    TileEntityRendererDispatcher.field_147556_a.func_147547_b(tileEntity).func_192841_a(tileEntity, (double)tileEntity.func_174877_v().func_177958_n(), (double)tileEntity.func_174877_v().func_177956_o(), (double)tileEntity.func_174877_v().func_177952_p(), 0.0f, -1, 1.0f);
                    if (GL11.glGetError() == 0) continue;
                    throw new Exception("Couldn't render: " + tileEntity.getClass().getSimpleName());
                }
                catch (Exception e) {
                    if (tileEntities_ignore.contains(tileEntity.getClass().getSimpleName())) continue;
                    if (tileRemoval == null) {
                        tileRemoval = new ArrayList<TileEntity>();
                    }
                    tileRemoval.add(tileEntity);
                    tileEntities_ignore.add(tileEntity.getClass().getSimpleName());
                    portal.getWorldRender().tileEntities.remove(tileEntity);
                    TheDalekMod.LOG.warn(tileEntity.getClass().getSimpleName() + " couldn't be rendered!");
                }
            }
            if (tileRemoval != null) {
                portal.getWorldRender().tileEntities.removeAll(tileRemoval);
            }
            GlStateManager.func_179121_F();
        }
    }

    public static void markTileBotiUpdate(Vec3d renderPos) {
        TileEntity tileEntity = Minecraft.func_71410_x().field_71441_e.func_175625_s(new BlockPos(renderPos.field_72450_a, renderPos.field_72448_b, renderPos.field_72449_c));
        if (tileEntity != null && tileEntity instanceof IWorldPortal) {
            ((IWorldPortal)tileEntity).requestRender();
        }
    }

    static {
        f382 = System.currentTimeMillis();
        f383 = System.currentTimeMillis();
    }

    public static class WorldPortalServer {
        public static void getWorldRender(final World world, final BlockPos posToRender, final int dimensiontorender, final BlockPos pos, final float rot, final boolean boti) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    world.func_73046_m().func_152344_a(new Runnable(){

                        @Override
                        public void run() {
                            WorldServer renderworld;
                            if (!world.field_72995_K && DimensionManager.isDimensionRegistered((int)dimensiontorender) && (renderworld = world.func_73046_m().func_71218_a(dimensiontorender)) != null) {
                                WorldRender worlds = new WorldRender(posToRender);
                                int r = boti ? DMConfig.tardis.blockMapSizeBoti : DMConfig.tardis.blockMapSizeSoto;
                                worlds.setDimension(dimensiontorender);
                                worlds.setIdentifier(System.currentTimeMillis() + posToRender.func_177986_g());
                                BlockPos renderpos = worlds.getRenderPos();
                                for (BlockPos p : BlockPos.func_177980_a((BlockPos)renderpos.func_177973_b(new Vec3i(r, 10, r)), (BlockPos)renderpos.func_177971_a(new Vec3i(r, 15, r)))) {
                                    IBlockState state = renderworld.func_180495_p(p);
                                    if (state.func_177230_c() == Blocks.field_150350_a || state.func_177230_c() == Blocks.field_180401_cv) continue;
                                    BlockData bl = new BlockData(state, renderworld.func_175625_s(p), renderworld.func_175699_k(p));
                                    double ba = Math.cos(-((double)(rot + 90.0f) * 0.0174533) + Math.atan2(p.func_177952_p() - posToRender.func_177952_p(), p.func_177958_n() - posToRender.func_177958_n())) + (double)0.1f;
                                    if (!(ba > 0.0) && (p.func_177952_p() != posToRender.func_177952_p() || p.func_177958_n() != posToRender.func_177958_n())) continue;
                                    worlds.blocks.put(p.func_177986_g(), bl);
                                }
                                for (BlockPos p : BlockPos.func_177980_a((BlockPos)renderpos.func_177973_b(new Vec3i(1, 0, 1)), (BlockPos)renderpos.func_177971_a(new Vec3i(1, 1, 1)))) {
                                    worlds.blocks.remove(p);
                                }
                                if (worlds.blocks.size() > 0) {
                                    worlds.blocks.remove(renderpos);
                                    PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketWorldPortal(worlds, pos), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 16.0));
                                }
                            }
                        }
                    });
                }
            }, "Boti").start();
        }
    }
}

