/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.commands;

import com.mojang.authlib.GameProfile;
import com.swdteam.common.block.tardis.BlockTardis;
import com.swdteam.common.init.DMBlocks;
import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.init.DMTardisInteriors;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tardis.data.UserTardises;
import com.swdteam.common.tileentity.tardis.TileEntityTardis;
import com.swdteam.common.tileentity.tardis.perms.TardisPermission;
import com.swdteam.main.DMCDN;
import com.swdteam.main.TheDalekMod;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_ClearCache;
import com.swdteam.utils.DMUtils;
import com.swdteam.utils.EnumDefaultResponse;
import com.swdteam.utils.PlayerUtils;
import com.swdteam.utils.WorldUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import net.minecraftforge.server.command.CommandTreeBase;

public class CommandDM
extends CommandTreeBase {
    public String func_71517_b() {
        return "dalek-mod";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b() + " [cache|tardis|version] [action] [id] [value]";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        switch (args.length) {
            case 1: {
                return CommandDM.func_71530_a((String[])args, (String[])new String[]{"cache", "tardis", "version"});
            }
            case 2: {
                switch (args[0]) {
                    case "cache": {
                        return CommandDM.func_71530_a((String[])args, (String[])new String[]{"reload"});
                    }
                    case "tardis": {
                        return CommandDM.func_71530_a((String[])args, (String[])new String[]{"find-owner", "set-owner", "add-self", "toggle-lock", "toggle-open", "set-health", "set-scale", "info", "summon", "remove", "id-xz", "list", "count"});
                    }
                }
            }
            case 3: {
                if (args[0].equalsIgnoreCase("tardis")) {
                    return CommandDM.func_71530_a((String[])args, (String[])server.func_71213_z());
                }
            }
            case 4: {
                if (!args[0].equalsIgnoreCase("tardis")) break;
                return CommandDM.func_71530_a((String[])args, (String[])server.func_71213_z());
            }
        }
        return super.func_184883_a(server, sender, args, targetPos);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        DMTardisInteriors.init();
        if (args.length <= 0) {
            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)CommandDM.func_71521_c((ICommandSender)sender), this.func_71518_a(sender));
            return;
        }
        if (!(sender instanceof EntityPlayerMP)) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + "message.fail.playeronly", new Object[0]));
        }
        EntityPlayerMP player = CommandDM.func_71521_c((ICommandSender)sender);
        World w = player.func_130014_f_();
        TileEntity te = null;
        boolean isTileTardis = false;
        List<WorldUtils.BlockWithPos> l = WorldUtils.getBlocksWithinBounds(sender.func_130014_f_(), player.func_174813_aQ().func_72314_b(2.0, 1.0, 2.0));
        WorldUtils.BlockWithPos blockWithPos = null;
        boolean isTile = false;
        for (WorldUtils.BlockWithPos bwp : l) {
            Block b = bwp.getBlock();
            if (b != DMBlocks.TARDIS) continue;
            blockWithPos = bwp;
            isTile = true;
            break;
        }
        if (isTile) {
            te = w.func_175625_s(blockWithPos.getBlockPos());
        }
        TardisData data = null;
        TileEntityTardis tardis = null;
        if (te instanceof TileEntityTardis && (data = (tardis = (TileEntityTardis)te).getTardisData()) != null) {
            isTileTardis = true;
        }
        String pattern = "(.*)\\{\"name\":\"(.*)\"(.*)\\}\\]";
        if (args[0].equalsIgnoreCase("cache")) {
            if (args[1].equalsIgnoreCase("reload")) {
                player.func_145747_a((ITextComponent)new TextComponentString("Reload started..."));
                PacketHandler.INSTANCE.sendToAll((IMessage)new Packet_ClearCache());
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        DMCDN.init(DMCDN.CDNSide.BOTH);
                    }
                }).start();
                return;
            }
            player.func_145747_a((ITextComponent)new TextComponentString("Available actions: reload"));
            return;
        }
        if (args[0].equalsIgnoreCase("tardis")) {
            if (args[1].equalsIgnoreCase("add-self")) {
                if (args.length == 3) {
                    int id = Integer.parseInt(args[2]);
                    if (id > 0) {
                        data = DMTardis.getTardis(id);
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid TARDIS ID."));
                        return;
                    }
                }
                data.addCompanion((EntityPlayer)player);
                data.setTardisPermissions(TardisPermission.COMPANIONS);
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.LIGHT_PURPLE + "You have force added yourself to " + data.getOwner() + "'s Tardis (" + data.getTardisID() + ")"));
                TardisSaveHandler.saveTardis(data);
            } else if (args[1].equalsIgnoreCase("find-owner")) {
                if (args.length == 3) {
                    int id = Integer.parseInt(args[2].replace(".", ""));
                    if (id > 0) {
                        data = DMTardis.getTardis(id);
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid TARDIS ID."));
                        return;
                    }
                }
                if (data.getCurrentOwner() != null) {
                    String OwnerName = DMUtils.getName(data.getCurrentOwner().toString()).replaceAll(pattern, "$2").replace("\",\"changedToAt", "");
                    data.setOwner(OwnerName);
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.LIGHT_PURPLE + "TARDIS ID " + data.getTardisID() + " Belongs to " + data.getOwner() + " AKA " + data.getCurrentOwner().toString()));
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid TARDIS!"));
                }
                TardisSaveHandler.saveTardis(data);
            } else {
                if (args[1].equalsIgnoreCase("set-owner")) {
                    int id;
                    UUID ownerUUID = player.func_110124_au();
                    if (args.length == 4) {
                        ownerUUID = UUID.fromString(DMUtils.getUUIDs(args[3]));
                        id = Integer.parseInt(args[2].replace(".", ""));
                        if (id > 0) {
                            data = DMTardis.getTardis(id);
                        } else {
                            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid TARDIS ID."));
                            return;
                        }
                    }
                    if (args.length == 3) {
                        if (isTileTardis) {
                            ownerUUID = UUID.fromString(DMUtils.getUUIDs(args[3]));
                        } else {
                            id = Integer.parseInt(args[2].replace(".", ""));
                            if (id > 0) {
                                data = DMTardis.getTardis(id);
                            } else {
                                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid TARDIS ID."));
                                return;
                            }
                        }
                    }
                    UserTardises uTarOld = DMTardis.getUserTardises(data.getCurrentOwner());
                    UserTardises uTarNew = DMTardis.getUserTardises(ownerUUID);
                    uTarOld.getTardises().removeAll(Arrays.asList(data.getTardisID()));
                    uTarNew.addTardis(data.getTardisID());
                    DMTardis.updateUserTardisData(uTarOld, data.getCurrentOwner());
                    DMTardis.updateUserTardisData(uTarNew, ownerUUID);
                    data.setCurrentOwner(ownerUUID);
                    data.setOwner(args[3]);
                    TardisSaveHandler.saveTardis(data);
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.LIGHT_PURPLE + "You have transferred TARDIS(" + data.getTardisID() + ") ownership to " + data.getOwner()));
                    return;
                }
                if (args[1].equalsIgnoreCase("set-scale")) {
                    float scale = 1.0f;
                    if (args.length == 4) {
                        scale = Float.parseFloat(args[3]);
                        int id = Integer.parseInt(args[2].replace(".", ""));
                        if (id > 0) {
                            data = DMTardis.getTardis(id);
                        } else {
                            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid TARDIS ID."));
                            return;
                        }
                    }
                    if (args.length == 3) {
                        scale = Float.parseFloat(args[2]);
                    }
                    data.setScale(scale);
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.LIGHT_PURPLE + "You have scaled the TARDIS(" + data.getTardisID() + ") to " + data.getScale()));
                    TardisSaveHandler.saveTardis(data);
                } else if (args[1].equalsIgnoreCase("set-health")) {
                    int health = 1;
                    if (args.length == 4) {
                        health = Integer.parseInt(args[3]);
                        int id = Integer.parseInt(args[2].replace(".", ""));
                        if (id > 0) {
                            data = DMTardis.getTardis(id);
                        } else {
                            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid TARDIS ID."));
                            return;
                        }
                    }
                    if (args.length == 3) {
                        health = Integer.parseInt(args[2]);
                    }
                    data.setTardisHealth(health);
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.LIGHT_PURPLE + "You have set the TARDIS(" + data.getTardisID() + ") Health to " + data.getTardisHealth()));
                    TardisSaveHandler.saveTardis(data);
                } else if (args[1].equalsIgnoreCase("toggle-lock")) {
                    if (args.length == 3) {
                        int id = Integer.parseInt(args[2].replace(".", ""));
                        if (id > 0) {
                            data = DMTardis.getTardis(id);
                        } else {
                            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid TARDIS ID."));
                            return;
                        }
                    }
                    data.setLocked(!data.isLocked());
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.LIGHT_PURPLE + "You have force " + (data.isLocked() ? "locked " : "unlocked ") + data.getOwner() + "'s Tardis(" + data.getTardisID() + ")"));
                    TardisSaveHandler.saveTardis(data);
                } else if (args[1].equalsIgnoreCase("toggle-open")) {
                    if (args.length == 3) {
                        int id = Integer.parseInt(args[2].replace(".", ""));
                        if (id > 0) {
                            data = DMTardis.getTardis(id);
                        } else {
                            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid TARDIS ID."));
                            return;
                        }
                    }
                    if (data.isInFlight()) {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You cannot enter the Tardis during materialization"));
                    }
                    if (data.isLocked()) {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + data.getOwner() + "'s Tardis is now unlocked."));
                    }
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.LIGHT_PURPLE + "You have force " + (data.isDoorOpen() ? "closed " : "opened ") + data.getOwner() + "'s Tardis(" + data.getTardisID() + ")"));
                    BlockTardis.getSkin(w, blockWithPos.getBlockPos()).onRightClick(w, (EntityPlayer)player, blockWithPos.getBlockPos(), tardis, true, false);
                    TardisSaveHandler.saveTardis(data);
                } else {
                    if (args[1].equalsIgnoreCase("id-xz")) {
                        if (player.field_70170_p.field_73011_w.getDimension() != DMDimensions.DIM_TARDIS_ID) {
                            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, EnumDefaultResponse.CANNOT_EXECUTE_IN_DIMENSION);
                            return;
                        }
                        boolean givxz = false;
                        int x = (int)player.field_70165_t;
                        int z = (int)player.field_70161_v;
                        int id = 0;
                        if (args.length == 3) {
                            givxz = true;
                            id = Integer.parseInt(args[2]);
                        } else if (args.length > 3) {
                            givxz = false;
                            x = Integer.parseInt(args[2]);
                            z = Integer.parseInt(args[3]);
                        }
                        if (!givxz) {
                            id = DMTardis.getIDForXZ(x, z);
                        }
                        BlockPos pos = DMTardis.getXZForMap(id);
                        if (givxz) {
                            x = DMTardis.INTERIOR_BOUNDS / 2 + pos.func_177958_n() * DMTardis.INTERIOR_BOUNDS;
                        }
                        if (givxz) {
                            z = DMTardis.INTERIOR_BOUNDS / 2 + pos.func_177952_p() * DMTardis.INTERIOR_BOUNDS;
                        }
                        int ix = pos.func_177958_n();
                        int iz = pos.func_177952_p();
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.RED + "ID: " + id + " (" + x + ";" + z + ")[" + ix + ";" + iz + "]");
                        return;
                    }
                    if (args[1].equalsIgnoreCase("info")) {
                        if (args.length > 2) {
                            int id = Integer.parseInt(args[2]);
                            data = DMTardis.getTardis(id);
                            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "-------------TARDIS-------------");
                            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "ID:" + data.getTardisID() + " | Owner: " + data.getOwner());
                            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Exterior: " + DMTardis.getTardisSkin(data.getExteriorID()).getExteriorName());
                            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Location: [" + data.getCurrentTardisPosition() + "]");
                            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Planet / Dimension: " + data.getTardisCurrentdimension());
                            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Destination: " + data.getCurrentLocationName());
                            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "In Flight: " + data.isInFlight());
                            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Health: " + data.getTardisHealth());
                            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "HADS: " + (data.getHads() ? "enabled" : "disabled"));
                            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Cloaked: " + (data.isCloak() ? "enabled" : "disabled"));
                            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Locked: " + data.isLocked());
                            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.WHITE + "Permissions: " + (Object)((Object)data.getTardisPermissions()));
                        } else {
                            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.RED + "Please specify a TARDIS ID");
                        }
                        return;
                    }
                    if (args[1].equalsIgnoreCase("list")) {
                        if (args.length >= 3) {
                            if (args[2].equalsIgnoreCase("*")) {
                                PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.BOLD + "Displaying TARDIS List for all online players");
                                for (EntityPlayerMP p : server.func_184103_al().func_181057_v()) {
                                    UUID uuid = p.func_110124_au();
                                    if (uuid == null) {
                                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.RED + "Player " + p.func_70005_c_() + " does not exist.");
                                        continue;
                                    }
                                    DMTardis.reconstructPlayerLookup(uuid.toString());
                                    UserTardises uTar = DMTardis.getUserTardises(uuid);
                                    if (uTar == null) {
                                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.RED + p.func_70005_c_() + " has no Tardises");
                                        continue;
                                    }
                                    if (uTar.getTardises() != null && uTar.getTardises().size() > 0) {
                                        StringBuilder b = new StringBuilder();
                                        for (int i = 0; i < uTar.getTardises().size(); ++i) {
                                            b.append(uTar.getTardises().get(i) + (i == uTar.getTardises().size() - 1 ? "" : ","));
                                        }
                                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + p.func_70005_c_() + " [" + TextFormatting.RESET + b.toString() + TextFormatting.GREEN + "]");
                                        continue;
                                    }
                                    PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.RED + p.func_70005_c_() + " has no Tardises");
                                }
                                return;
                            }
                            GameProfile profile = sender.func_184102_h().func_152358_ax().func_152655_a(args[2]);
                            if (profile == null) {
                                PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.RED + "Unable to get data for " + args[2]);
                                return;
                            }
                            UUID uuid = profile.getId();
                            if (uuid == null) {
                                PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.RED + "Player " + args[2] + " does not exist.");
                                return;
                            }
                            DMTardis.reconstructPlayerLookup(uuid.toString());
                            UserTardises uTar = DMTardis.getUserTardises(uuid);
                            if (uTar == null) {
                                PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.RED + args[2] + " has no Tardises");
                                return;
                            }
                            if (uTar.getTardises() != null && uTar.getTardises().size() > 0) {
                                StringBuilder b = new StringBuilder();
                                for (int i = 0; i < uTar.getTardises().size(); ++i) {
                                    b.append(uTar.getTardises().get(i) + (i == uTar.getTardises().size() - 1 ? "" : ","));
                                }
                                PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + args[2] + " owns the following Tardises: " + TextFormatting.RESET + b.toString());
                                return;
                            }
                            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.RED + args[2] + " has no Tardises");
                            return;
                        }
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "No user specified"));
                        return;
                    }
                    if (args[1].equalsIgnoreCase("summon")) {
                        if (args.length > 2) {
                            BlockPos position = player.func_180425_c();
                            data = DMTardis.getTardis(Integer.parseInt(args[2]));
                            float rotation = player.func_70079_am();
                            if (args.length >= 6) {
                                position = new BlockPos(Double.parseDouble(args[3]), Double.parseDouble(args[4]), Double.parseDouble(args[5]));
                            }
                            if (args.length > 6) {
                                rotation = Float.parseFloat(args[6]);
                            }
                            if (player.field_70170_p.func_180495_p(player.func_180425_c()).func_177230_c() == Blocks.field_150350_a) {
                                if (!data.isRemoved()) {
                                    if (WorldUtils.summonTardisToPos(player.field_70170_p, data, position, rotation) == EnumActionResult.SUCCESS) {
                                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "Summoned Tardis with ID: " + args[2]);
                                    } else if (WorldUtils.summonTardisAlternate(Integer.parseInt(args[2]), player.field_70170_p, position)) {
                                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "Force Summoned Tardis with ID: " + args[2]);
                                    } else {
                                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.RED + "Failed to summon Tardis with ID: " + args[2]);
                                    }
                                    return;
                                }
                                PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.RED + "This TARDIS is marked as removed!");
                                return;
                            }
                            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.RED + "You can't summon a tardis here!");
                            return;
                        }
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.RED + "Please define a tardis id!");
                        return;
                    }
                    if (args[1].equalsIgnoreCase("count")) {
                        String fileDir = ((File)FMLInjectionData.data()[6]).getAbsolutePath() + "/saves/" + TheDalekMod.FML.getMinecraftServerInstance().func_71270_I() + "/Tardis_Data/Tardises/";
                        File f = new File(fileDir);
                        int size = f.listFiles().length - 1;
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "IDs in use: " + (DMTardis.removed_tardis.size() > 0 ? size - DMTardis.removed_tardis.size() : size));
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "Next ID : " + (DMTardis.removed_tardis.size() > 0 ? DMTardis.removed_tardis.get(0) : size + 1));
                        return;
                    }
                    if (args[1].equalsIgnoreCase("remove")) {
                        if (args.length >= 4) {
                            boolean m;
                            int id = Integer.parseInt(args[2]);
                            data = DMTardis.getTardis(id);
                            if (args[3].equalsIgnoreCase("automatic")) {
                                m = true;
                            } else if (args[3].equalsIgnoreCase("manual")) {
                                m = false;
                            } else {
                                PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.RED + "Define Automatic or Manual");
                                return;
                            }
                            if (DMTardis.removeTardis(data, (EntityPlayer)player, m)) {
                                PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "Removed TARDIS with ID: " + args[2]);
                                return;
                            }
                            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.RED + "Failed to remove TARDIS with ID: " + args[2]);
                            return;
                        }
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.RED + "/dalek-mod tardis remove 'ID' <manual/automatic>");
                        return;
                    }
                    player.func_145747_a((ITextComponent)new TextComponentString("Available actions: add-self, find-owner, set-owner, set-scale, toggle-lock, toggle-open, list, summon, remove"));
                    return;
                }
            }
        }
        if (!args[0].equalsIgnoreCase("version")) {
            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)CommandDM.func_71521_c((ICommandSender)sender), this.func_71518_a(sender));
            return;
        }
        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "You are playing: " + TextFormatting.RED + "Dalek Mod" + " " + TextFormatting.BLUE + "(Update 57.1.0)"));
    }
}

