/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.init;

import com.swdteam.common.entity.EntityIceWarrior;
import com.swdteam.common.entity.dalek.EntityDalek;
import com.swdteam.common.entity.dalek.EntityDalekEmperor;
import com.swdteam.common.init.DMBlocks;
import com.swdteam.common.init.DMTardis;
import com.swdteam.main.config.DMConfig;
import com.swdteam.utils.world.Schematic;
import com.swdteam.utils.world.SchematicUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DMSchematics {
    public static Schematic[] ASYLUMS = new Schematic[3];
    public static Schematic SKARO_BUILD_1;
    public static Schematic MOON_CYBER_SHIP;
    public static Schematic MARS_ICE_WARRIOR_SHIP;
    public static Schematic DALEK_EMPEROR_SHIP;
    public static Schematic DALEK_SHIP_A;
    public static Schematic DALEK_SHIP_B;
    public static Schematic DALEK_SHIP_C;
    public static Schematic GALLIFREY_CITADEL;
    public static Schematic GALLIFREY_SHACK;
    public static SchematicUtils.IReplaceBlockSpawn MARS_ICE_WARRIOR_SPAWN;
    public static SchematicUtils.IReplaceBlockSpawn DALEK_EMPEROR_SHIP_SPAWN;
    public static SchematicUtils.IReplaceBlockSpawn DALEK_EMPEROR_SHIP_SPAWN_BOSS;
    public static SchematicUtils.IReplaceBlockSpawn DALEK_SHIP_SPAWNER_A;
    public static SchematicUtils.IReplaceBlockSpawn DALEK_SHIP_SPAWNER_B;
    public static SchematicUtils.IReplaceBlockSpawn DALEK_SHIP_SPAWNER_C;
    public static SchematicUtils.IReplaceBlockSpawn GALLIFREY_SHACK_MOMENT;
    public static List<BlockPos> TARDIS_BOUNDARIES;

    public static void init() {
        DMSchematics.structuresInit();
        TARDISBoundary.init();
    }

    public static void structuresInit() {
        GALLIFREY_CITADEL = DMSchematics.loadSchematic("gallifrey/gallifrey_citadel", SchematicUtils.FileLocation.EXTERNAL);
        DMSchematics.ASYLUMS[0] = DMSchematics.loadSchematic("skaro/asylum_1", SchematicUtils.FileLocation.EXTERNAL);
        DMSchematics.ASYLUMS[1] = DMSchematics.loadSchematic("skaro/asylum_2", SchematicUtils.FileLocation.EXTERNAL);
        DMSchematics.ASYLUMS[2] = DMSchematics.loadSchematic("skaro/asylum_3", SchematicUtils.FileLocation.EXTERNAL);
        MOON_CYBER_SHIP = DMSchematics.loadSchematic("moon/cyber_ship", SchematicUtils.FileLocation.EXTERNAL);
        MARS_ICE_WARRIOR_SHIP = DMSchematics.loadSchematic("mars/ice_warrior_ship", SchematicUtils.FileLocation.EXTERNAL);
        DALEK_EMPEROR_SHIP = DMSchematics.loadSchematic("skaro/emperor_ship", SchematicUtils.FileLocation.EXTERNAL);
        GALLIFREY_SHACK = DMSchematics.loadSchematic("gallifrey/shack", SchematicUtils.FileLocation.INTERNAL);
        DALEK_SHIP_A = DMSchematics.loadSchematic("skaro/dalek_ship_new_a", SchematicUtils.FileLocation.EXTERNAL);
        DALEK_SHIP_B = DMSchematics.loadSchematic("skaro/dalek_ship_new_b", SchematicUtils.FileLocation.EXTERNAL);
        DALEK_SHIP_C = DMSchematics.loadSchematic("skaro/dalek_ship_new_c", SchematicUtils.FileLocation.EXTERNAL);
        GALLIFREY_SHACK_MOMENT = new SchematicUtils.IReplaceBlockSpawn(){

            @Override
            public void replaceBlock(World w, BlockPos p) {
                w.func_175656_a(p, DMBlocks.moment_box.func_176223_P());
            }

            @Override
            public IBlockState getBlockState() {
                return Blocks.field_150325_L.func_176203_a(10);
            }
        };
        MARS_ICE_WARRIOR_SPAWN = new SchematicUtils.IReplaceBlockSpawn(){

            @Override
            public void replaceBlock(World w, BlockPos p) {
                EntityIceWarrior iw = new EntityIceWarrior(w);
                iw.func_70012_b(p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), w.field_73012_v.nextInt(360), 0.0f);
                w.func_72838_d((Entity)iw);
            }

            @Override
            public IBlockState getBlockState() {
                return Blocks.field_150357_h.func_176223_P();
            }
        };
        DALEK_EMPEROR_SHIP_SPAWN = new SchematicUtils.IReplaceBlockSpawn(){

            @Override
            public void replaceBlock(World w, BlockPos p) {
                EntityDalek d = new EntityDalek(w);
                d.func_70012_b(p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), w.field_73012_v.nextInt(360), 0.0f);
                w.func_72838_d((Entity)d);
                d.setDalekID(w.field_73012_v.nextBoolean() ? 27 : 65);
            }

            @Override
            public IBlockState getBlockState() {
                return Blocks.field_150360_v.func_176223_P();
            }
        };
        DALEK_EMPEROR_SHIP_SPAWN_BOSS = new SchematicUtils.IReplaceBlockSpawn(){

            @Override
            public void replaceBlock(World w, BlockPos p) {
                w.func_175656_a(p, DMBlocks.dalek_emperor.func_176223_P());
                EntityDalekEmperor d = new EntityDalekEmperor(w);
                d.func_70012_b((float)p.func_177958_n() + 0.5f, (float)p.func_177956_o() + 3.5f, (float)p.func_177952_p() + 0.5f, 0.0f, 0.0f);
                d.func_184212_Q().func_187227_b(EntityDalekEmperor.ROTATION, (Object)Float.valueOf(180.0f));
                w.func_72838_d((Entity)d);
            }

            @Override
            public IBlockState getBlockState() {
                return DMBlocks.dalek_emperor.func_176223_P();
            }
        };
        DALEK_SHIP_SPAWNER_A = new SchematicUtils.IReplaceBlockSpawn(){

            @Override
            public void replaceBlock(World w, BlockPos p) {
                int[] ids = new int[]{1, 2, 3, 4, 5};
                EntityDalek d = new EntityDalek(w);
                d.func_70012_b(p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), w.field_73012_v.nextInt(360), 0.0f);
                w.func_72838_d((Entity)d);
                d.setDalekID(ids[w.field_73012_v.nextInt(ids.length)]);
            }

            @Override
            public IBlockState getBlockState() {
                return Blocks.field_150360_v.func_176223_P();
            }
        };
        DALEK_SHIP_SPAWNER_B = new SchematicUtils.IReplaceBlockSpawn(){

            @Override
            public void replaceBlock(World w, BlockPos p) {
                int[] ids = new int[]{27, 28, 29, 30};
                EntityDalek d = new EntityDalek(w);
                d.func_70012_b(p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), w.field_73012_v.nextInt(360), 0.0f);
                w.func_72838_d((Entity)d);
                d.setDalekID(ids[w.field_73012_v.nextInt(ids.length)]);
            }

            @Override
            public IBlockState getBlockState() {
                return Blocks.field_150360_v.func_176223_P();
            }
        };
        DALEK_SHIP_SPAWNER_C = new SchematicUtils.IReplaceBlockSpawn(){

            @Override
            public void replaceBlock(World w, BlockPos p) {
                int[] ids = new int[]{32, 33, 34, 35, 36, 37, 38};
                EntityDalek d = new EntityDalek(w);
                d.func_70012_b(p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), w.field_73012_v.nextInt(360), 0.0f);
                w.func_72838_d((Entity)d);
                d.setDalekID(ids[w.field_73012_v.nextInt(ids.length)]);
            }

            @Override
            public IBlockState getBlockState() {
                return Blocks.field_150360_v.func_176223_P();
            }
        };
    }

    public static Schematic loadSchematic(String s, SchematicUtils.FileLocation f) {
        if (f == SchematicUtils.FileLocation.EXTERNAL) {
            Schematic ss = SchematicUtils.loadSchematic("mods/Dalek Mod/cdn/schematics/" + s + ".schm", f);
            return ss;
        }
        return SchematicUtils.loadSchematic(s, f);
    }

    static {
        TARDIS_BOUNDARIES = new ArrayList<BlockPos>();
    }

    public static class TARDISBoundary {
        public static List<Block> blocks = new ArrayList<Block>();

        public static void init() {
            DMTardis.INTERIOR_BOUNDS = DMConfig.tardis.TARDIS_Boundary_Size;
            BlockPos pos2 = new BlockPos(0, 0, 0);
            for (int y = 0; y < 256; ++y) {
                for (int z = 0; z <= DMTardis.INTERIOR_BOUNDS; ++z) {
                    for (int x = 0; x <= DMTardis.INTERIOR_BOUNDS; ++x) {
                        IBlockState s = Blocks.field_180401_cv.func_176223_P();
                        BlockPos pos = pos2.func_177982_a(x, y, z);
                        if (y < 255) {
                            if (y == 0) {
                                s = Blocks.field_150357_h.func_176223_P();
                            }
                            if (x != 0 && x != DMTardis.INTERIOR_BOUNDS && z != 0 && z != DMTardis.INTERIOR_BOUNDS) continue;
                            blocks.add(new Block(pos, s));
                            continue;
                        }
                        blocks.add(new Block(pos, s));
                    }
                }
            }
        }

        public static class Block {
            private BlockPos p;
            private IBlockState s;

            public Block(BlockPos p, IBlockState s) {
                this.p = p;
                this.s = s;
            }

            public BlockPos getPos() {
                return this.p;
            }

            public IBlockState getState() {
                return this.s;
            }
        }
    }
}

