/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.item;

import com.swdteam.common.block.actions.ActionList;
import com.swdteam.common.entity.EntityLaser;
import com.swdteam.common.init.DMDamageSources;
import com.swdteam.common.init.DMItems;
import com.swdteam.common.init.DMSounds;
import com.swdteam.common.item.ItemAmmo;
import com.swdteam.common.item.ItemSonicScrewdriver;
import com.swdteam.utils.PlayerUtils;
import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemLaserScrewDriver
extends ItemSonicScrewdriver {
    public ItemLaserScrewDriver(SoundEvent useSound, String ... desc) {
        super(useSound, desc);
    }

    @Override
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77978_p() != null) {
            if (!player.func_70093_af()) {
                if (!stack.func_77978_p().func_74764_b("mode")) {
                    stack.func_77978_p().func_74757_a("mode", false);
                }
                if (!stack.func_77978_p().func_74767_n("mode")) {
                    if (this.usageSound == null) {
                        this.usageSound = DMSounds.sonicScrewdriver;
                    }
                    worldIn.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, this.usageSound, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    if (stack.func_77978_p() == null) {
                        stack.func_77982_d(new NBTTagCompound());
                        stack.func_77978_p().func_74778_a("owner", player.func_174793_f().func_70005_c_());
                        stack.func_77978_p().func_74778_a("uuid", player.func_174793_f().func_110124_au().toString());
                        stack.func_77978_p().func_74757_a("working", true);
                        stack.func_77978_p().func_74768_a("charge", 100);
                        stack.func_77978_p().func_74757_a("ext", false);
                    } else {
                        boolean isWorking;
                        String uuid;
                        if (stack.func_77978_p().func_74764_b("uuid") && !(uuid = stack.func_77978_p().func_74779_i("uuid")).equalsIgnoreCase(player.func_110124_au().toString())) {
                            PlayerUtils.Messaging.sendMessageToPlayer(player, TextFormatting.RED + "This screwdriver belongs to " + TextFormatting.YELLOW + stack.func_77978_p().func_74779_i("owner"));
                            return EnumActionResult.PASS;
                        }
                        boolean bl = isWorking = stack.func_77978_p().func_74764_b("working") && stack.func_77978_p().func_74767_n("working");
                        if (player.func_70093_af()) {
                            stack.func_77978_p().func_74757_a("ext", !stack.func_77978_p().func_74767_n("ext"));
                        }
                        ItemLaserScrewDriver.initFirstSonic(stack, player);
                        if (isWorking) {
                            this.utils.onSonicUsed(stack, player);
                            return ActionList.sonicInteraction(worldIn, player, pos, hitZ, this.usageSound);
                        }
                        PlayerUtils.Messaging.sendMessageToPlayer(player, "Please charge/repair your sonic before usage.");
                    }
                }
            } else {
                this.toggleMode(stack, player);
            }
        }
        return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    public static ItemStack getCharges(NonNullList<ItemStack> stacks, Item item) {
        for (ItemStack stack : stacks) {
            if (stack.func_77973_b() != item) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (stack.func_77978_p() != null) {
            boolean isWorking;
            if (!stack.func_77978_p().func_74764_b("mode")) {
                stack.func_77978_p().func_74757_a("mode", false);
            }
            if (!playerIn.func_70093_af() && !worldIn.field_72995_K && stack.func_77978_p().func_74767_n("mode")) {
                Vec3d v = playerIn.func_70040_Z();
                if (playerIn.field_71071_by.func_70431_c(new ItemStack(DMItems.iAMMO)) || playerIn.func_184812_l_()) {
                    if (!playerIn.func_184812_l_()) {
                        ItemLaserScrewDriver.getCharges((NonNullList<ItemStack>)playerIn.field_71071_by.field_70462_a, DMItems.iAMMO).func_190918_g(1);
                    }
                    EntityLaser laser = ItemAmmo.createLaser(worldIn, playerIn.func_184586_b(handIn), (EntityLivingBase)playerIn, EnumParticleTypes.CRIT);
                    laser.setLazerRGB(Color.ORANGE.getRed(), Color.YELLOW.getGreen(), Color.ORANGE.getBlue(), 0.9f);
                    laser.setDamage(3.0f);
                    laser.setDamageSource(DMDamageSources.LASERSD.setSource((Entity)playerIn));
                    laser.func_70186_c(v.field_72450_a, v.field_72448_b, v.field_72449_c, 1.5f, 0.0f);
                    worldIn.func_72838_d((Entity)laser);
                    stack.func_77978_p().func_74768_a("charge", stack.func_77978_p().func_74762_e("charge") - 5);
                    worldIn.func_184133_a(null, playerIn.func_180425_c(), this.usageSound, SoundCategory.MASTER, 1.0f, 1.0f);
                }
            }
            boolean bl = isWorking = stack.func_77978_p().func_74764_b("working") && stack.func_77978_p().func_74767_n("working");
            if (!isWorking && !playerIn.field_70170_p.field_72995_K) {
                PlayerUtils.Messaging.sendMessageToPlayer(playerIn, "Please charge/repair your sonic before usage.");
            }
            this.toggleMode(stack, playerIn);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void toggleMode(ItemStack stack, EntityPlayer player) {
        if (player.func_70093_af()) {
            stack.func_77978_p().func_74757_a("mode", !stack.func_77978_p().func_74767_n("mode"));
            if (stack.func_77978_p().func_74767_n("mode")) {
                player.func_146105_b((ITextComponent)new TextComponentString("Enabled Laser Mode"), true);
            } else {
                player.func_146105_b((ITextComponent)new TextComponentString("Enabled Sonic Mode"), true);
            }
        }
    }
}

