/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.tileentity;

import com.swdteam.common.init.DMSounds;
import com.swdteam.common.tileentity.DMTileEntityBase;
import com.swdteam.main.config.DMConfig;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_MomentSync;
import com.swdteam.utils.math.Vector3d;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityMoment
extends DMTileEntityBase
implements ITickable {
    public static List<MomentWaveData> waveDataList = new ArrayList<MomentWaveData>();
    public boolean open = false;
    public int passed = 0;

    public void toggle() {
        this.open = !this.open;
    }

    public void wave() {
        if (DMConfig.serverSide.MOMENT_FUNCTION) {
            MomentWaveData data = new MomentWaveData(this.field_174879_c, this.field_145850_b.field_73011_w.getDimension());
            data.setSend(System.currentTimeMillis());
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new Packet_MomentSync(data), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 200.0));
            DMSounds.playSound(this.field_145850_b, this.field_174879_c, DMSounds.MOMENT, SoundCategory.MASTER, 200, 1.0f, 1.0f);
            waveDataList.add(data);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("open_moment", this.open);
        compound.func_74768_a("passed", this.passed);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.open = compound.func_74767_n("open_moment");
        this.passed = compound.func_74762_e("passed");
    }

    public void func_73660_a() {
        if (this.passed > 0 && !this.field_145850_b.field_72995_K) {
            --this.passed;
            if (this.passed == 60) {
                DMSounds.playSound(this.field_145850_b, this.field_174879_c, DMSounds.MOMENT_ACTIVE, SoundCategory.MASTER, 200, 1.0f, 1.0f);
            }
            if (this.passed == 0) {
                this.wave();
            }
        }
    }

    public static class MomentWaveData {
        public Vector3d origin;
        public AxisAlignedBB bb;
        public int dimension;
        public double rangePassed = 0.0;
        public long send;
        public long arrived;

        public MomentWaveData() {
        }

        public MomentWaveData(BlockPos origin, int dim) {
            this.origin = new Vector3d(origin.func_177958_n(), origin.func_177956_o(), origin.func_177952_p());
            this.bb = new AxisAlignedBB(origin);
            this.dimension = dim;
        }

        public void setArrived(long arrived) {
            this.arrived = arrived;
        }

        public void setSend(long send) {
            this.send = send;
        }

        public AxisAlignedBB getBb() {
            return this.bb;
        }

        public void grow(World world) {
            this.bb = this.bb.func_186662_g(0.5);
            if (!world.field_72995_K) {
                WorldServer world1 = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.dimension);
                List livings = world1.func_72872_a(EntityLivingBase.class, this.bb);
                for (int x = 0; x < livings.size(); ++x) {
                    EntityLivingBase s = (EntityLivingBase)livings.get(x);
                    if (!(s instanceof EntityLiving) && !(s instanceof EntityPlayer) || s instanceof EntityPlayer && ((EntityPlayer)s).func_184812_l_() || s.field_70128_L || (int)this.rangePassed != (int)s.func_180425_c().func_185332_f((int)this.origin.x, (int)this.origin.y, (int)this.origin.z)) continue;
                    s.func_174812_G();
                }
            }
            this.rangePassed = this.bb.field_72336_d - this.origin.x;
            if (this.rangePassed > 200.0) {
                waveDataList.remove(this);
            }
        }

        public double rangePassed() {
            return this.rangePassed;
        }

        public BlockPos getOrigin() {
            return new BlockPos(this.origin.x, this.origin.y, this.origin.z);
        }
    }
}

