/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.main;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.swdteam.client.command.shades.ShadesCommandRegistry;
import com.swdteam.client.data.ClientTardisCache;
import com.swdteam.client.events.ChunkEvents;
import com.swdteam.client.init.DMGuiHandler;
import com.swdteam.common.capability.CapabilityRegeneration;
import com.swdteam.common.capability.CapabilityTardis;
import com.swdteam.common.capability.interfaces.IRegenerationCapability;
import com.swdteam.common.capability.interfaces.ITardisCapability;
import com.swdteam.common.event.EventHandler;
import com.swdteam.common.init.DMCommands;
import com.swdteam.common.init.DMDalekRegistry;
import com.swdteam.common.init.DMDispenserBehaviour;
import com.swdteam.common.init.DMLasers;
import com.swdteam.common.init.DMPlugins;
import com.swdteam.common.init.DMPotions;
import com.swdteam.common.init.DMSchematics;
import com.swdteam.common.init.DMSurvival;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.init.DMTardisInteriors;
import com.swdteam.common.init.DMTardisSkinReg;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tardis.data.UserTardises;
import com.swdteam.common.world.gen.structures.global.OreGeneration;
import com.swdteam.dmapi.DMApiHandler;
import com.swdteam.info.DMDates;
import com.swdteam.info.DMPlayers;
import com.swdteam.main.CommonProxy;
import com.swdteam.main.DM18BlockMap;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.utils.DataFixerTiles;
import com.swdteam.utils.FileUtils;
import com.swdteam.utils.world.SchematicUtils;
import java.io.File;
import java.util.Calendar;
import java.util.HashMap;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="thedalekmod", version="(Update 57.1.0)", name="thedalekmod", dependencies="required-after:forge@[14.23.2.2638,)", acceptedMinecraftVersions="[1.12.2]")
public class TheDalekMod {
    @SidedProxy(clientSide="com.swdteam.main.ClientProxy", serverSide="com.swdteam.main.CommonProxy")
    public static CommonProxy proxy;
    public static final Gson GSON;
    @Mod.Instance(value="thedalekmod")
    public static TheDalekMod instance;
    public static FMLCommonHandler FML;
    public static final String MODID = "thedalekmod";
    public static final String UPDATE_NUMBER = "57";
    public static final int MAJOR_PATCH = 1;
    public static final int MINOR_PATCH = 0;
    public static final String devString = "";
    public static final String VERSION = "(Update 57.1.0)";
    public static final String NAME = "Dalek Mod";
    public static final String DEPEND_CHECK = "required-after:forge@[14.23.2.2638,)";
    public static final boolean IS_CHRISTMAS;
    public static final boolean IS_BUGGY = false;
    public static Logger LOG;

    public static boolean isDevEnv() {
        return (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.cdnSetup();
        proxy.preInit();
        DMTardisInteriors.init();
        DMTardisSkinReg.init();
        DMPlayers.addAllowedAdmin();
        DMLasers.init();
        DMDalekRegistry.init();
        PacketHandler.init();
        DM18BlockMap.init();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
        MinecraftForge.EVENT_BUS.register((Object)new ChunkEvents());
        MinecraftForge.EVENT_BUS.register((Object)new ChunkEvents.ServerSide());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new DMGuiHandler());
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OreGeneration(), (int)0);
        DMSurvival.init();
        DMPotions.init();
        DMApiHandler.init();
        CapabilityManager.INSTANCE.register(IRegenerationCapability.class, (Capability.IStorage)new CapabilityRegeneration.Storage(), CapabilityRegeneration.class);
        CapabilityManager.INSTANCE.register(ITardisCapability.class, (Capability.IStorage)new CapabilityTardis.Storage(), CapabilityTardis.class);
        FMLCommonHandler.instance().getDataFixer().init(MODID, 1).registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new DataFixerTiles());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        DMDispenserBehaviour.init();
        DMSchematics.init();
        try {
            DMPlugins.init();
        }
        catch (Exception e) {
            LOG.catching((Throwable)e);
        }
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartedEvent e) {
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent e) {
        if (e.getSide() == Side.CLIENT) {
            ClientTardisCache.clearTardisData();
            System.out.println("Clearing Tardis Data Cache");
        }
        for (SchematicUtils.GenerationQueue queue : SchematicUtils.GenerationQueue.values()) {
            queue.getList().clear();
        }
        EventHandler.tardisTransferthread();
        DMTardis.getTardises().clear();
        DMTardis.getRemoved_tardis().clear();
        DMCommands.init(e);
        ShadesCommandRegistry.init();
        DMTardis.loadRemovedTardises();
        File fileConv = new File(((File)FMLInjectionData.data()[6]).getAbsolutePath() + "/saves/" + FML.getMinecraftServerInstance().func_71270_I() + "/Tardis_Data/cova.dat");
        if (!fileConv.exists()) {
            String fileDir = ((File)FMLInjectionData.data()[6]).getAbsolutePath() + "/saves/" + FML.getMinecraftServerInstance().func_71270_I() + "/Tardis_Data//Tardises/";
            File f = new File(fileDir);
            if (!f.exists()) {
                f.mkdirs();
            }
            HashMap<String, UserTardises> uTars = new HashMap<String, UserTardises>();
            for (int i = 0; i < f.listFiles().length; ++i) {
                TardisData data;
                File file = f.listFiles()[i];
                Object o = FileUtils.loadObjectFromFile(file, TardisData.class);
                if (o == null || !(o instanceof TardisData) || (data = (TardisData)o) == null || data.getCurrentOwner() == null) continue;
                if (uTars.containsKey(data.getCurrentOwner().toString())) {
                    ((UserTardises)uTars.get(data.getCurrentOwner().toString())).addTardis(data.getTardisID());
                    continue;
                }
                UserTardises t = new UserTardises();
                t.addTardis(data.getTardisID());
                uTars.put(data.getCurrentOwner().toString(), t);
            }
            for (String uuid : uTars.keySet()) {
                DMTardis.updateUserTardisData((UserTardises)uTars.get(uuid), uuid);
            }
            FileUtils.writeObjectToFile((Object)System.currentTimeMillis(), fileConv);
        }
    }

    public static boolean isServer() {
        return FMLCommonHandler.instance().getSide().isServer();
    }

    public static boolean canAdventBeUnlocked(int day) {
        if (TheDalekMod.is2020()) {
            if (TheDalekMod.isDecember()) {
                return day <= TheDalekMod.getDate();
            }
        } else {
            return true;
        }
        return false;
    }

    public static int getDate() {
        Calendar cal = Calendar.getInstance();
        int dayOfMonth = cal.get(5);
        return dayOfMonth;
    }

    public static boolean isDecember() {
        Calendar cal = Calendar.getInstance();
        int month = cal.get(2);
        return month == 11;
    }

    public static boolean is2020() {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        return year == 2020;
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
        FML = FMLCommonHandler.instance();
        IS_CHRISTMAS = DMDates.isDecember();
        LOG = LogManager.getLogger((String)NAME);
    }
}

