/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.mdl.obj;

import com.swdteam.mdl.IRenderHook;
import com.swdteam.mdl.MDL;
import com.swdteam.mdl.graphics.Graphics;
import com.swdteam.mdl.obj.OBJLoader;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public class Model {
    public IRenderHook renderHook;
    public String objName;
    public int renderListID = -1;
    public boolean isChild = false;
    public List<Model> children;
    public double xOrigin;
    public double yOrigin;
    public double zOrigin;
    public double xOffset;
    public double yOffset;
    public double zOffset;
    public double xRotation;
    public double yRotation;
    public double zRotation;
    public double xScale;
    public double yScale;
    public double zScale;
    public double xTransform;
    public double yTransform;
    public double zTransform;
    public float opacity = 1.0f;
    public float r = 1.0f;
    public float g = 1.0f;
    public float b = 1.0f;
    public boolean hidden = false;
    public boolean glow = false;
    public boolean blending;
    public boolean disable_shading;
    public boolean portal;
    private final List<Vector3f> vertices;
    private final List<Vector2f> textureCoords;
    private final List<Vector3f> normals;
    private final List<Face> faces;
    private boolean enableSmoothShading;
    public int textureIndex = 0;
    FloatBuffer previousColor;
    float[] oldlight = new float[]{OpenGlHelper.lastBrightnessX, OpenGlHelper.lastBrightnessY};

    public Model(List<Vector3f> vertices, List<Vector2f> textureCoords, List<Vector3f> normals, List<Face> faces, boolean enableSmoothShading) {
        this.vertices = vertices;
        this.textureCoords = textureCoords;
        this.normals = normals;
        this.faces = faces;
        this.enableSmoothShading = enableSmoothShading;
    }

    public Model() {
        this(new ArrayList<Vector3f>(), new ArrayList<Vector2f>(), new ArrayList<Vector3f>(), new ArrayList<Face>(), true);
        this.children = new ArrayList<Model>();
    }

    public void smoothShading() {
        if (this.isSmoothShadingEnabled()) {
            GL11.glShadeModel((int)7425);
        } else {
            GL11.glShadeModel((int)7424);
        }
    }

    public boolean hasTextureCoordinates() {
        return this.getTextureCoordinates().size() > 0;
    }

    public boolean hasNormals() {
        return this.getNormals().size() > 0;
    }

    public List<Vector3f> getVertices() {
        return this.vertices;
    }

    public List<Vector2f> getTextureCoordinates() {
        return this.textureCoords;
    }

    public List<Vector3f> getNormals() {
        return this.normals;
    }

    public List<Face> getFaces() {
        return this.faces;
    }

    public boolean isSmoothShadingEnabled() {
        return this.enableSmoothShading;
    }

    public void setSmoothShadingEnabled(boolean isSmoothShadingEnabled) {
        this.enableSmoothShading = isSmoothShadingEnabled;
    }

    public void loadTextures(MDL mdl) {
        if (mdl.textures[this.textureIndex] == -1 && !mdl.loadingTextures[this.textureIndex]) {
            mdl.textures[this.textureIndex] = Graphics.loadTexture(mdl.textureFiles[this.textureIndex]);
            mdl.loadingTextures[this.textureIndex] = true;
        }
    }

    public void renderAll(MDL mdl) {
        this.loadTextures(mdl);
        if (this.previousColor == null) {
            this.previousColor = BufferUtils.createFloatBuffer((int)16);
        }
        GL11.glGetFloat((int)2816, (FloatBuffer)this.previousColor);
        float[] rgbaOld = new float[]{this.previousColor.get(0), this.previousColor.get(1), this.previousColor.get(2), this.previousColor.get(3)};
        float[] oldlight = new float[]{OpenGlHelper.lastBrightnessX, OpenGlHelper.lastBrightnessY};
        GL11.glPushMatrix();
        GL11.glTranslated((double)this.xTransform, (double)this.yTransform, (double)(-this.zTransform));
        GL11.glScaled((double)this.xScale, (double)this.yScale, (double)this.zScale);
        GL11.glRotated((double)(-this.zRotation), (double)0.0, (double)0.0, (double)1.0);
        GL11.glRotated((double)this.yRotation, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)this.xRotation, (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)this.xOffset, (double)this.yOffset, (double)(-this.zOffset));
        if (this.renderHook != null) {
            this.renderHook.render();
        }
        this.smoothShading();
        if (this.glow) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)0.0f);
        }
        if (this.disable_shading) {
            GlStateManager.func_179140_f();
        }
        GL11.glColor4f((float)(this.r * rgbaOld[0]), (float)(this.g * rgbaOld[1]), (float)(this.b * rgbaOld[2]), (float)(this.opacity * rgbaOld[3]));
        Graphics.bindTexture(mdl.textures[this.textureIndex]);
        if (this.renderListID == -1) {
            this.renderListID = mdl.createDisplayList(this);
        } else {
            GL11.glCallList((int)this.renderListID);
        }
        GL11.glColor4f((float)rgbaOld[0], (float)rgbaOld[1], (float)rgbaOld[2], (float)rgbaOld[3]);
        if (this.glow) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)oldlight[0], (float)oldlight[1]);
        }
        if (this.disable_shading) {
            GlStateManager.func_179145_e();
        }
        int i = 0;
        while (i < this.children.size()) {
            if (!this.children.get((int)i).hidden) {
                this.children.get(i).renderAll(mdl);
            }
            ++i;
        }
        GL11.glPopMatrix();
    }

    public void render(MDL mdl) {
        OBJLoader.INSTANCE.render(this);
    }

    public void addRenderHook(IRenderHook renderHook) {
        this.renderHook = renderHook;
    }

    public static class Face {
        private final int[] vertexIndices;
        private final int[] normalIndices;
        private final int[] textureCoordinateIndices;

        public boolean hasNormals() {
            return this.normalIndices != null;
        }

        public boolean hasTextureCoords() {
            return this.textureCoordinateIndices != null;
        }

        public int[] getVertices() {
            return this.vertexIndices;
        }

        public int[] getTextureCoords() {
            return this.textureCoordinateIndices;
        }

        public int[] getNormals() {
            return this.normalIndices;
        }

        public Face(int[] vertexIndices, int[] textureCoordinateIndices, int[] normalIndices) {
            this.vertexIndices = vertexIndices;
            this.normalIndices = normalIndices;
            this.textureCoordinateIndices = textureCoordinateIndices;
        }

        public String toString() {
            return String.format("Face[vertexIndices%s normalIndices%s textureCoordinateIndices%s]", Arrays.toString(this.vertexIndices), Arrays.toString(this.normalIndices), Arrays.toString(this.textureCoordinateIndices));
        }
    }
}

