/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.network.packets;

import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tileentity.tardis.TileEntityTardis;
import com.swdteam.network.packets.AbstractServerMessageHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class Packet_GenerateInteriorSurvival
implements IMessage {
    public int dimension;
    public BlockPos pos;

    public Packet_GenerateInteriorSurvival() {
    }

    public Packet_GenerateInteriorSurvival(int dim, BlockPos pos) {
        this.dimension = dim;
        this.pos = pos;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readInt();
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimension);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
    }

    public static class Handler
    extends AbstractServerMessageHandler<Packet_GenerateInteriorSurvival> {
        @Override
        public IMessage handleServerMessage(EntityPlayer player, Packet_GenerateInteriorSurvival message, MessageContext ctx) {
            player.func_184102_h().func_152344_a(() -> {
                WorldServer w = player.func_184102_h().func_71218_a(message.dimension);
                TileEntity te = w.func_175625_s(message.pos);
                if (te != null && te instanceof TileEntityTardis) {
                    int TardisID = ((TileEntityTardis)te).tardisID;
                    TardisData data = DMTardis.getTardis(TardisID);
                    if (data != null) {
                        if (!DMTardis.hasPermission(data, player)) {
                            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "" + TextFormatting.BOLD + "This is not your TARDIS"), true);
                            return;
                        }
                        if (data.getInteriorState() == TardisData.InteriorState.PENDING) {
                            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.GREEN + "" + TextFormatting.BOLD + "Generating interior..."), true);
                            DMTardis.generateInterior(data, DMTardis.getTardisSkin(data.getExteriorID()).getInterior());
                        } else {
                            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "" + TextFormatting.BOLD + "Interior already generated"), true);
                        }
                    }
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "" + TextFormatting.BOLD + "Invalid Tardis"), true);
                }
            });
            return null;
        }
    }
}

