/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.network.packets;

import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.network.packets.AbstractServerMessageHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumActionResult;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class Packet_UpdateTardisSettings
implements IMessage {
    public String field;
    public String data;
    public int tardis;

    public Packet_UpdateTardisSettings() {
    }

    public Packet_UpdateTardisSettings(int tardis, String fieldName, String data) {
        this.field = fieldName;
        this.data = data;
        this.tardis = tardis;
    }

    public void fromBytes(ByteBuf buf) {
        this.field = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.data = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.tardis = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.field);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.data);
        buf.writeInt(this.tardis);
    }

    public static class Handler
    extends AbstractServerMessageHandler<Packet_UpdateTardisSettings> {
        @Override
        public IMessage handleServerMessage(final EntityPlayer player, final Packet_UpdateTardisSettings message, MessageContext ctx) {
            player.func_184102_h().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EnumActionResult RESULT = EnumActionResult.SUCCESS;
                    int tardisID = message.tardis;
                    TardisData tData = DMTardis.getTardis(tardisID);
                    if (DMTardis.hasPermission(tData, player)) {
                        if (message.field.equals("hads")) {
                            tData.setHads(!tData.getHads());
                        }
                        if (message.field.equals("cloak")) {
                            tData.setCloak(!tData.isCloak());
                        }
                        if (message.field.equals("tardislanding")) {
                            tData.setTravelRotation(Integer.parseInt(message.data) * 45);
                        }
                        if (message.field.equals("hum")) {
                            tData.setHumID(Integer.valueOf(message.data));
                        }
                        if (message.field.equals("hum_toggle")) {
                            tData.setHum(!tData.isHum());
                        }
                        if (RESULT == EnumActionResult.SUCCESS) {
                            TardisSaveHandler.saveTardis(tData);
                        }
                    }
                }
            });
            return null;
        }
    }
}

