/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.init;

import com.swdteam.client.init.DMMDLLoader;
import com.swdteam.client.model.ModelCube;
import com.swdteam.common.tileentity.TileEntityTCNLoader;
import com.swdteam.mdl.MDL;
import com.swdteam.mdl.MDLLoader;
import com.swdteam.mdl.ModelMDL;
import com.swdteam.utils.Graphics;
import com.swdteam.utils.model.techne.TechneModel;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.util.ResourceLocation;

public class DMTCNModelLoader {
    public static ModelLoaderModel defaultModel;
    public static int defaultTexture;
    private static boolean defTex;
    private static final HashMap<String, ModelLoaderModel> models;
    private static final HashMap<String, ModelLoaderModel> cdnModels;

    public static void initModels(TileEntityTCNLoader.ModelPath path) {
        File[] listOfFiles;
        File folder;
        HashMap<String, ModelLoaderModel> modelList;
        HashMap<String, ModelLoaderModel> hashMap = modelList = path == TileEntityTCNLoader.ModelPath.CDN ? models : cdnModels;
        if (!defTex) {
            BufferedImage im = new BufferedImage(64, 64, 10);
            for (int i = 0; i < 64; ++i) {
                for (int j = 0; j < 64; ++j) {
                    im.setRGB(i, j, 0);
                }
            }
            im.getGraphics().drawString("Missing", 11, 28);
            im.getGraphics().drawString("Model", 13, 41);
            defaultTexture = Graphics.loadTexture(im);
            defaultTexture = Graphics.loadTexture(im);
            defTex = true;
        }
        if (defaultModel == null) {
            ModelLoaderModel m;
            defaultModel = m = new ModelLoaderModel("Missingno", new ModelCube(), ModelType.UNKNOWN, null);
        }
        String folderPath = Minecraft.func_71410_x().field_71412_D + "/mods/Dalek Mod/Models";
        if (path == TileEntityTCNLoader.ModelPath.CDN) {
            folderPath = Minecraft.func_71410_x().field_71412_D + "/mods/Dalek Mod/CDN/model_loader";
        }
        if (!(folder = new File(folderPath)).exists()) {
            folder.mkdirs();
        }
        for (File listOfFile : listOfFiles = folder.listFiles()) {
            FileInputStream is;
            if (!listOfFile.isFile()) continue;
            if (listOfFile.getName().endsWith(".tcn")) {
                is = null;
                try {
                    is = new FileInputStream(listOfFile.getAbsolutePath());
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                if (is != null) {
                    if (!modelList.containsKey(listOfFile.getName())) {
                        DMTCNModelLoader.addModel(listOfFile.getName(), new TechneModel(is), path, ModelType.TCN, null);
                    }
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            if (!listOfFile.getName().endsWith(".mdl")) continue;
            is = null;
            try {
                is = new FileInputStream(listOfFile.getAbsolutePath());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            if (is == null) continue;
            if (!modelList.containsKey(listOfFile.getName())) {
                System.out.println(listOfFile.getName());
                MDL m = null;
                ModelBase mdl = DMMDLLoader.loadModel(is, true);
                ModelType mt = ModelType.MDL;
                if (mdl == null) {
                    try {
                        ((InputStream)is).close();
                        is = new FileInputStream(listOfFile.getAbsolutePath());
                        m = MDLLoader.loadMDL(is);
                        mdl = new ModelMDL(m);
                        mt = ModelType.MDL3;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (mdl != null) {
                    DMTCNModelLoader.addModel(listOfFile.getName(), mdl, path, mt, m == null ? null : m.MDLIcon);
                }
            }
            try {
                ((InputStream)is).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static HashMap<String, ModelLoaderModel> getModels(TileEntityTCNLoader.ModelPath path) {
        if (path == TileEntityTCNLoader.ModelPath.MODELS) {
            return models;
        }
        return cdnModels;
    }

    public static void addModel(String name, ModelBase b, TileEntityTCNLoader.ModelPath path, ModelType t, BufferedImage bi) {
        if (path == TileEntityTCNLoader.ModelPath.MODELS) {
            if (!models.containsKey(name)) {
                models.put(name, new ModelLoaderModel(name, b, t, bi));
            }
        } else if (!cdnModels.containsKey(name)) {
            cdnModels.put(name, new ModelLoaderModel(name, b, t, bi));
        }
    }

    public static ModelLoaderModel getModel(String name, TileEntityTCNLoader.ModelPath path) {
        if (path == TileEntityTCNLoader.ModelPath.MODELS) {
            if (models.containsKey(name)) {
                return models.get(name);
            }
        } else if (cdnModels.containsKey(name)) {
            return cdnModels.get(name);
        }
        return defaultModel;
    }

    @Deprecated
    public static int loadTexture(BufferedImage image) {
        return Graphics.loadTexture(image);
    }

    static {
        models = new HashMap();
        cdnModels = new HashMap();
    }

    public static enum ModelType {
        MDL("Legacy MDL", new ResourceLocation("thedalekmod", "gui/model_loader/mdl_legacy.png")),
        MDL3("MDL 3.0", new ResourceLocation("thedalekmod", "gui/model_loader/mdl_found.png")),
        TCN("Techne Model", new ResourceLocation("thedalekmod", "gui/model_loader/techne.png")),
        UNKNOWN("Unknown", null);

        private final String modelName;
        private final ResourceLocation texture;

        private ModelType(String name, ResourceLocation texture) {
            this.modelName = name;
            this.texture = texture;
        }

        public String getModelName() {
            return this.modelName;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }
    }

    public static class ModelLoaderModel {
        private final ModelBase model;
        private final String name;
        private final ModelType modelType;
        private final BufferedImage icon;
        private int textureID = -1;

        public ModelLoaderModel(String n, ModelBase b, ModelType t, BufferedImage bi) {
            this.name = n;
            this.model = b;
            this.modelType = t;
            this.icon = bi;
        }

        public ModelBase getModel() {
            return this.model;
        }

        public ModelType getModelType() {
            return this.modelType;
        }

        public String getName() {
            return this.name;
        }

        public int getTextureID() {
            if (this.textureID == -1) {
                this.textureID = this.icon != null ? Graphics.loadTexture(this.icon) : -2;
            }
            return this.textureID;
        }
    }
}

