/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.block.tardis.console_controls;

import com.swdteam.client.model.mdl.MDLState;
import com.swdteam.common.block.BlockDMTileEntityBase;
import com.swdteam.common.block.tardis.console_controls.IPanelControl;
import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.init.DMSounds;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tardis.data.chameleon.ChameleonCircuitBase;
import com.swdteam.common.tileentity.DMTileEntityBase;
import com.swdteam.utils.WorldUtils;
import java.util.function.Supplier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class BlockTardisDoorControl
extends BlockDMTileEntityBase
implements IPanelControl {
    public BlockTardisDoorControl(Supplier<TileEntity> tClass) {
        super(tClass);
    }

    @Override
    public String getDesc() {
        return "Door control";
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TardisData data;
        if (hand == EnumHand.MAIN_HAND && !worldIn.field_72995_K && (worldIn.field_73011_w.getDimension() == DMDimensions.DIM_TARDIS_ID || playerIn.func_70005_c_().equals("EdusgprNetwork") || playerIn.func_70005_c_().equals("LqSTDVd8qHs")) && (data = DMTardis.getTardis(pos)) != null) {
            ChameleonCircuitBase skin;
            if (data.isInFlight()) {
                playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You cannot open the doors during flight"));
                return true;
            }
            if (data.isLocked()) {
                worldIn.func_184133_a(playerIn, pos, DMSounds.DoorLocked, SoundCategory.BLOCKS, 1.0f, 1.0f);
                playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "The Tardis doors are locked"));
                return true;
            }
            WorldServer server = playerIn.func_184102_h().func_71218_a(data.getTardisCurrentdimension());
            if (server != null && (skin = DMTardis.getTardisSkin(data.getExteriorID())) != null && skin.hasDoorRotation()) {
                DMTileEntityBase tile = (DMTileEntityBase)worldIn.func_175625_s(pos);
                tile.model_state = tile.model_state == MDLState.ACTIVE ? MDLState.DEFAULT : MDLState.ACTIVE;
                if (tile != null) {
                    tile.func_70296_d();
                    tile.func_145831_w().func_184138_a(pos, state, state, this.field_149786_r);
                    WorldUtils.markBlockForUpdate(worldIn, pos);
                }
                if (data.isDoorOpen()) {
                    data.setDoorOpen(false);
                    DMSounds.playSound(playerIn, skin.doorSound(ChameleonCircuitBase.DoorState.CLOSED), SoundCategory.BLOCKS, pos, 1.0f, 1.0f);
                    playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Doors have been closed"));
                } else {
                    data.setDoorOpen(true);
                    playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Doors have been opened"));
                    DMSounds.playSound(playerIn, skin.doorSound(ChameleonCircuitBase.DoorState.OPEN), SoundCategory.BLOCKS, pos, 1.0f, 1.0f);
                }
                TardisSaveHandler.saveTardis(data);
            }
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, side, hitZ, hitZ, hitZ);
    }
}

