/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.regeneration;

import com.swdteam.common.block.actions.ActionList;
import com.swdteam.common.capability.CapabilityRegeneration;
import com.swdteam.common.capability.interfaces.IRegenerationCapability;
import com.swdteam.common.dimensions.world.WorldProviderTardis;
import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.init.DMSounds;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.regeneration.skinchanging.SkinChangingHandler;
import com.swdteam.common.regeneration.skinchanging.packet.Packet_RegenSkinChange;
import com.swdteam.common.regeneration.skinchanging.packet.Packet_RemovePlayerRegen;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.main.config.DMConfig;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.utils.CapabilityUtils;
import com.swdteam.utils.DMUtils;
import com.swdteam.utils.FileUtils;
import com.swdteam.utils.PlayerUtils;
import com.swdteam.utils.Vector3;
import java.awt.image.BufferedImage;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockFire;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
public class RegenerationHandler {
    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof EntityPlayer) || ((Entity)event.getObject()).hasCapability(CapabilityRegeneration.REGEN_CAP, null)) {
            return;
        }
        event.addCapability(FileUtils.newResourceLocation("thedalekmod:regeneration"), (ICapabilityProvider)new CapabilityRegeneration.CapabilityTimelordProvider((EntityPlayer)event.getObject()));
    }

    @SubscribeEvent
    public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        RegenerationHandler.get(event.getEntityPlayer()).syncToPlayer();
    }

    @SubscribeEvent
    public static void onPlayerJoinWorld(PlayerEvent.PlayerLoggedInEvent e) {
        if (!e.player.field_70170_p.field_72995_K) {
            RegenerationHandler.get(e.player).syncToPlayer();
        }
    }

    @SubscribeEvent
    public static void onPlayerLeaveWorld(PlayerEvent.PlayerLoggedOutEvent e) {
        if (!e.player.field_70170_p.field_72995_K) {
            RegenerationHandler.get(e.player).syncToPlayer();
        }
    }

    @Nonnull
    public static IRegenerationCapability get(EntityPlayer player) {
        if (player.hasCapability(CapabilityRegeneration.REGEN_CAP, null)) {
            return (IRegenerationCapability)player.getCapability(CapabilityRegeneration.REGEN_CAP, null);
        }
        throw new IllegalStateException("Regeneration Capability Missing");
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Capability.IStorage iStorage = CapabilityRegeneration.REGEN_CAP.getStorage();
        IRegenerationCapability old = RegenerationHandler.get(event.getOriginal());
        IRegenerationCapability newCap = RegenerationHandler.get(event.getEntityPlayer());
        NBTTagCompound nbt = (NBTTagCompound)iStorage.writeNBT(CapabilityRegeneration.REGEN_CAP, (Object)old, null);
        iStorage.readNBT(CapabilityRegeneration.REGEN_CAP, (Object)newCap, null, (NBTBase)nbt);
        RegenerationHandler.get(event.getEntityPlayer()).syncToPlayer();
        PacketHandler.INSTANCE.sendToAll((IMessage)new Packet_RemovePlayerRegen(event.getEntityPlayer().func_110124_au().toString()));
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        RegenerationHandler.get(event.player).syncToPlayer();
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        RegenerationHandler.get(event.player).syncToPlayer();
    }

    @SubscribeEvent
    public static void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        BufferedImage image;
        SkinChangingHandler.SkinChoice choice;
        IRegenerationCapability capability;
        EntityPlayer player;
        IRegenerationCapability capability2;
        if (event.getEntity() instanceof EntityPlayer) {
            capability2 = (IRegenerationCapability)event.getEntity().getCapability(CapabilityRegeneration.REGEN_CAP, null);
            capability2.update();
        }
        if (event.getEntity() instanceof EntityPlayerMP && CapabilityUtils.canRegenerate((EntityPlayer)event.getEntity())) {
            capability2 = (IRegenerationCapability)event.getEntity().getCapability(CapabilityRegeneration.REGEN_CAP, null);
            EntityPlayerMP player2 = (EntityPlayerMP)event.getEntity();
            int arrowCount = player2.func_85035_bI();
            if (capability2.getPreRegenTicks() > 0) {
                capability2.setPreRegen(true);
                if (capability2.isPreRegen()) {
                    RegenerationHandler.preRegen((EntityPlayer)player2, capability2);
                    capability2.setPreRegenTicks(capability2.getPreRegenTicks() - 1);
                }
                capability2.syncToPlayer();
            }
            if (capability2.getPreRegenTicks() == 0 && capability2.isPreRegen()) {
                capability2.setPreRegen(false);
                capability2.setTicksExisted(1);
                player2.func_70690_d(new PotionEffect(Potion.func_188412_a((int)10), 600, 1, false, false));
                capability2.syncToPlayer();
            }
            if (capability2.getTicksExisted() > 0) {
                if (player2.field_70163_u >= 0.0) {
                    if (capability2.getTicksExisted() == 1) {
                        player2.field_70170_p.func_184148_a(null, player2.field_70165_t, player2.field_70163_u, player2.field_70161_v, DMSounds.Regeneration, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        player2.func_184224_h(true);
                        player2.func_146105_b((ITextComponent)new TextComponentString("You've now regenerated " + (12 - capability2.getRegenAmount() + 1) + " times, you have " + (capability2.getRegenAmount() - 1) + " regenerations left."), true);
                        RegenerationHandler.tardisCrash((EntityPlayer)player2);
                    }
                    capability2.setTicksExisted(capability2.getTicksExisted() + 1);
                    arrowCount = player2.func_85035_bI();
                    capability2.syncToPlayer();
                    if (!player2.field_70170_p.field_72995_K && capability2.getTicksExisted() > 100 && DMConfig.regeneration.Explosions && DMUtils.RANDOM.nextInt(5) <= 2) {
                        player2.func_70066_B();
                        if (player2.field_70170_p.func_180495_p(player2.func_180425_c()).func_177230_c() instanceof BlockFire) {
                            player2.field_70170_p.func_175698_g(player2.func_180425_c());
                        }
                        double x = player2.field_70165_t + player2.func_70681_au().nextGaussian() * 2.0;
                        double y = player2.field_70163_u + 0.5 + player2.func_70681_au().nextGaussian() * 2.0;
                        double z = player2.field_70161_v + player2.func_70681_au().nextGaussian() * 2.0;
                        player2.field_70170_p.func_72885_a((Entity)player2, x, y, z, 0.0f, player2.func_70011_f(x, y, z) >= 4.0, false);
                    }
                }
                if (capability2.getTicksExisted() >= 200) {
                    capability2.setTicksExisted(0);
                    player2.func_70606_j(player2.func_110138_aP());
                    player2.func_85034_r(0);
                    player2.field_70170_p.func_72838_d((Entity)new EntityItem(player2.field_70170_p, (double)(player2.func_180425_c().func_177958_n() + DMUtils.RANDOM.nextInt(3)), (double)player2.func_180425_c().func_177956_o(), (double)(player2.func_180425_c().func_177952_p() + DMUtils.RANDOM.nextInt(3)), new ItemStack(Items.field_185166_h, arrowCount, 0)));
                    capability2.setRegenCount(capability2.getRegenAmount() - 1);
                    capability2.syncToPlayer();
                    player2.func_184224_h(false);
                }
            }
            if (capability2.getPostRegenTicks() > 0) {
                capability2.setPostRegen(true);
                RegenerationHandler.postRegen((EntityPlayer)player2, capability2);
                capability2.setPostRegenTicks(capability2.getPostRegenTicks() + 1);
                capability2.syncToPlayer();
                if (capability2.getPostRegenTicks() >= 600) {
                    capability2.setPostRegen(false);
                    capability2.setPostRegenTicks(0);
                    capability2.syncToPlayer();
                }
            }
        }
        if (event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityPlayer && (player = (EntityPlayer)event.getEntity()).func_110124_au().toString().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au().toString()) && CapabilityUtils.isRegenerating(player) && (capability = (IRegenerationCapability)player.getCapability(CapabilityRegeneration.REGEN_CAP, null)).getTicksExisted() == 150 && capability.canSkinChange() && capability.getPreferredType() != SkinChangingHandler.SkinChoice.NONE && SkinChangingHandler.checkAndNotify(choice = SkinChangingHandler.genSkinChoice(capability.getPreferredType()), player) && (image = SkinChangingHandler.getRandomNextSkin(choice, capability.getSkinData().getBufferedImage())) != null) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new Packet_RegenSkinChange(player.func_110124_au().toString(), image, choice));
            capability.skinUpdate();
        }
    }

    private static void tardisCrash(EntityPlayer player) {
        if (player.field_70170_p.field_73011_w instanceof WorldProviderTardis) {
            TardisData data = DMTardis.getTardis(player.func_180425_c());
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, DMSounds.CloisterBell, SoundCategory.PLAYERS, 1.0f, 1.0f);
            if (data != null && data.isInFlight()) {
                data.setTardisCurrentDimensionLocation(DimensionManager.getStaticDimensionIDs()[DMUtils.RANDOM.nextInt(DimensionManager.getStaticDimensionIDs().length)]);
                data.setTardisHealth(data.getTardisHealth() - 150);
                if (data.getTardisCurrentdimension() == DMDimensions.DIM_TARDIS_ID || !DimensionManager.isDimensionRegistered((int)data.getTardisCurrentdimension())) {
                    data.setTardisCurrentDimensionLocation(0);
                }
                Vector3 vec = new Vector3(DMUtils.RANDOM.nextInt(player.func_130014_f_().func_175723_af().func_177722_l() / 2), DMUtils.RANDOM.nextInt(100), DMUtils.RANDOM.nextInt(player.func_130014_f_().func_175723_af().func_177722_l() / 2));
                data.setTravelToLocation(vec);
                ActionList.tardisDematRemat(player.field_70170_p, player.func_180425_c(), player, true);
                PlayerUtils.Messaging.sendMessageToPlayer(player, TextFormatting.RED + "Your Tardis is crash landing!");
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), DMSounds.tardis_out_of_bounds, SoundCategory.MASTER, 1.0f, 1.0f);
            }
        }
    }

    private static void preRegen(EntityPlayer p, IRegenerationCapability cap) {
        if (p.field_70170_p.func_72820_D() % 150L == 0L) {
            p.func_70097_a(DamageSource.field_76376_m, 0.001f);
        }
    }

    private static void postRegen(EntityPlayer p, IRegenerationCapability cap) {
    }

    @SubscribeEvent
    public static void onAttacked(LivingAttackEvent event) {
        if (event.getEntity() instanceof EntityPlayer && CapabilityUtils.canRegenerate((EntityPlayer)event.getEntity())) {
            IRegenerationCapability capability = (IRegenerationCapability)event.getEntity().getCapability(CapabilityRegeneration.REGEN_CAP, null);
            if ((event.getSource().func_94541_c() || event.getSource().func_76347_k()) && capability.getTicksExisted() >= 100) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof EntityPlayer && CapabilityUtils.canRegenerate((EntityPlayer)event.getEntity())) {
            IRegenerationCapability capability = (IRegenerationCapability)event.getEntity().getCapability(CapabilityRegeneration.REGEN_CAP, null);
            capability.setPreRegen(false);
            capability.setPreRegenTicks(0);
            capability.setTicksExisted(0);
            capability.skinUpdate();
            capability.syncToPlayer();
        }
    }

    @SubscribeEvent
    public static void playerPoseFix(PlayerInteractEvent.RightClickBlock e) {
        if (CapabilityUtils.isRegenerating(e.getEntityPlayer()) || CapabilityUtils.isInFlight(e.getEntityPlayer())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        EntityPlayer player;
        if (event.getEntity() instanceof EntityPlayer && CapabilityUtils.canRegenerate(player = (EntityPlayer)event.getEntity())) {
            IRegenerationCapability capability = (IRegenerationCapability)event.getEntity().getCapability(CapabilityRegeneration.REGEN_CAP, null);
            if (player.func_110143_aJ() - event.getAmount() <= 0.0f) {
                if (capability.getRegenAmount() > 0 && capability.getTicksExisted() == 0 && capability.getPreRegenTicks() == 0) {
                    event.setCanceled(true);
                    player.func_70606_j(1.5f);
                    if (capability.getPreRegenTicks() == 0 && capability.getTicksExisted() == 0) {
                        capability.setPreRegen(true);
                        capability.setPostponed(false);
                        capability.setPreRegenTicks(280);
                        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, DMSounds.regentense, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    }
                } else if (capability.getRegenAmount() == 0 && capability.canPlayerRegenerate()) {
                    capability.setCanRegen(false);
                }
                capability.syncToPlayer();
            }
        }
    }
}

