/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.tardis;

import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.dmapi.interfaces.ITardisSaveManager;
import com.swdteam.main.TheDalekMod;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_RequestTardisDataSync;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import net.minecraftforge.fml.relauncher.Side;

public class TardisSaveHandler
implements ITardisSaveManager {
    public static void saveTardis(TardisData data) {
        if (data == null || data != null && data.isDefault || TheDalekMod.FML.getEffectiveSide() == Side.CLIENT) {
            return;
        }
        String fileDir = ((File)FMLInjectionData.data()[6]).getAbsolutePath() + "/saves/" + TheDalekMod.FML.getMinecraftServerInstance().func_71270_I() + "/Tardis_Data//Tardises/";
        String fileName = "TardisData_" + data.getTardisID() + ".json";
        File dir = new File(fileDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String json = TheDalekMod.GSON.toJson((Object)data);
        try {
            FileWriter fw = new FileWriter(dir + "/" + fileName);
            fw.write(json);
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PacketHandler.INSTANCE.sendToAll((IMessage)new Packet_RequestTardisDataSync(data));
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        StackTraceElement e = stacktrace[2];
        String methodName = e.getMethodName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TardisData loadTardis(int tardisID) {
        TardisData tardisData;
        if (TheDalekMod.FML.getEffectiveSide() == Side.CLIENT) {
            return null;
        }
        String fileDir = ((File)FMLInjectionData.data()[6]).getAbsolutePath() + "/saves/" + TheDalekMod.FML.getMinecraftServerInstance().func_71270_I() + "/Tardis_Data/Tardises/TardisData_" + tardisID + ".json";
        if (!new File(fileDir).exists()) {
            return null;
        }
        BufferedReader br = new BufferedReader(new FileReader(fileDir));
        try {
            tardisData = (TardisData)TheDalekMod.GSON.fromJson((Reader)br, TardisData.class);
        }
        catch (Throwable throwable) {
            try {
                br.close();
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        br.close();
        return tardisData;
    }

    @Override
    public void saveTardis(int arg0) {
        TardisData data = DMTardis.getTardis(arg0);
        if (data != null) {
            TardisSaveHandler.saveTardis(data);
        }
    }
}

