/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.tileentity.tardis;

import com.swdteam.client.data.ClientTardisCache;
import com.swdteam.client.worldportal.IWorldPortal;
import com.swdteam.client.worldportal.WorldPortal;
import com.swdteam.client.worldportal.WorldRender;
import com.swdteam.client.worldportal.packet.PacketRequestBoti;
import com.swdteam.common.block.actions.ActionList;
import com.swdteam.common.dimensions.world.WorldProviderTardis;
import com.swdteam.common.init.DMSounds;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tardis.data.chameleon.ChameleonCircuitBase;
import com.swdteam.common.tileentity.DMTileEntityBase;
import com.swdteam.main.config.DMConfig;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.utils.Vector3;
import com.swdteam.utils.WorldUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityHandbrakeBlack
extends DMTileEntityBase
implements IWorldPortal,
ITickable {
    public float doorRotation = 0.0f;
    public WorldRender worldRender = new WorldRender(this.func_174877_v());
    public TardisData tardisData;
    public boolean updateSoto = true;

    public void func_73660_a() {
        if (this.field_145850_b.field_73011_w instanceof WorldProviderTardis) {
            if (!this.field_145850_b.field_72995_K) {
                this.tardisData = DMTardis.getTardis(this.func_174877_v());
                if (this.tardisData != null) {
                    List entities = this.field_145850_b.func_72872_a(Entity.class, Block.field_185505_j.func_186670_a(this.func_174877_v()).func_186662_g(0.1));
                    if (!entities.isEmpty()) {
                        if (entities.get(0) instanceof EntityPlayer) {
                            EntityPlayer player = (EntityPlayer)entities.get(0);
                            if (player.func_184218_aH()) {
                                player.func_184210_p();
                            }
                            ActionList.tardisDoorExit(this.field_145850_b, (EntityPlayer)entities.get(0));
                            this.tardisData.setDoorOpen(false);
                            TardisSaveHandler.saveTardis(this.tardisData);
                        } else {
                            Entity e = (Entity)entities.get(0);
                            if (e.func_184207_aI() && e.func_184188_bt().size() > 0) {
                                e.func_184226_ay();
                            }
                            ActionList.tardisDoorExit(this.field_145850_b, e, this.tardisData.getTardisID());
                        }
                    }
                    if (DMConfig.tardis.isBotiEnabled && this.field_145850_b.func_72820_D() % 20L == 0L && this.updateSoto && this.getTardisData().isDoorOpen()) {
                        WorldPortal.WorldPortalServer.getWorldRender(this.field_145850_b, this.getPosToRender(), this.getDimension(), this.field_174879_c, this.getTardisData().getActualLandRotation() + 180.0f, true);
                        if (this.updateSoto) {
                            this.updateSoto = false;
                        }
                    }
                }
            } else {
                this.tardisData = ClientTardisCache.getTardisData(this.field_174879_c);
                this.handleDoorRotations();
            }
            if (this.updateSoto && this.field_145850_b.func_72820_D() % 40L == 0L) {
                this.updateSoto = false;
            }
        }
    }

    public void handleSound(EntityPlayer playerIn, ChameleonCircuitBase skin, boolean doorOpen) {
        DMSounds.playSound(playerIn, skin.doorSound(!doorOpen ? ChameleonCircuitBase.DoorState.OPEN : ChameleonCircuitBase.DoorState.CLOSED), SoundCategory.BLOCKS, this.field_174879_c, 1.0f, 1.0f);
    }

    public void handleDoorRotations() {
        if (this.tardisData.isDoorOpen()) {
            this.doorRotation += 5.0f;
            if (this.doorRotation > 90.0f) {
                this.doorRotation = 90.0f;
            }
        } else {
            this.doorRotation -= 25.0f;
            if (this.doorRotation < 0.0f) {
                this.doorRotation = 0.0f;
            }
        }
        this.tardisData.setDoorRotation(this.doorRotation);
    }

    public float getDoorRotation() {
        return this.doorRotation;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public int getDimension() {
        return this.getTardisData().getTardisCurrentdimension();
    }

    @Override
    public BlockPos getPosToRender() {
        Vector3 vector = this.getTardisData().getCurrentTardisPosition();
        return vector != null ? WorldUtils.vec3ToBlockPos(this.getTardisData().getCurrentTardisPosition()) : BlockPos.field_177992_a;
    }

    @Override
    public WorldRender getWorldRender() {
        return this.worldRender;
    }

    @Override
    public void setWorldRender(WorldRender worldRender) {
        this.worldRender = worldRender;
    }

    @Override
    public void requestRender() {
        if (this.field_145850_b.field_72995_K && this.doorRotation > 0.0f && !this.updateSoto) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketRequestBoti(this.func_174877_v()));
            this.updateSoto = true;
        }
        if (!this.field_145850_b.field_72995_K && !this.updateSoto) {
            this.updateSoto = true;
        }
    }

    public TardisData getTardisData() {
        if (this.tardisData == null) {
            return ClientTardisCache.DEFAULT_DATA;
        }
        return this.tardisData;
    }
}

