/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.tileentity.tardis;

import com.swdteam.client.data.ClientTardisCache;
import com.swdteam.client.worldportal.IWorldPortal;
import com.swdteam.client.worldportal.WorldPortal;
import com.swdteam.client.worldportal.WorldRender;
import com.swdteam.client.worldportal.packet.PacketRequestBoti;
import com.swdteam.common.dimensions.world.WorldProviderTardis;
import com.swdteam.common.init.DMBlocks;
import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.init.DMSounds;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.init.DMTardisSkinReg;
import com.swdteam.common.tardis.InteriorSounds;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tardis.data.chameleon.ChameleonCircuitBase;
import com.swdteam.common.tileentity.DMTileEntityBase;
import com.swdteam.main.TheDalekMod;
import com.swdteam.main.config.DMConfig;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_TardisDoors;
import com.swdteam.utils.WorldUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTardis
extends DMTileEntityBase
implements ITickable,
IWorldPortal {
    public boolean isExtendForceField = false;
    public float forcefieldalpha = 0.0f;
    public int tardisID;
    public int pulses = -1;
    public boolean isDemat = false;
    public boolean isRemat = false;
    public boolean b1;
    public int health = 1000;
    public float dematAmount = 1.0f;
    public WorldRender customWorld = new WorldRender(this.field_174879_c);
    private int botiticks = 0;
    public boolean botiUpdate = true;
    private int door_open_ticks = 0;
    public boolean sendPacket = false;
    private TardisData tardisDataCopy;
    public float scale = 1.0f;
    public float doorRotation;
    public static AxisAlignedBB defaultAABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static int timer = 1800;
    public AxisAlignedBB forceFieldBounds;

    public TardisData getTardisData() {
        if (this.tardisDataCopy == null) {
            return ClientTardisCache.DEFAULT_DATA;
        }
        return this.tardisDataCopy;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("tardis_id", this.tardisID);
        compound.func_74757_a("isDemat", this.isDemat);
        compound.func_74757_a("isRemat", this.isRemat);
        compound.func_74776_a("dematAmount", this.dematAmount);
        compound.func_74776_a("scale", this.scale);
        compound.func_74768_a("pulses", this.pulses);
        compound.func_74757_a("b1", this.b1);
        compound.func_74776_a("f_a", this.forcefieldalpha);
        compound.func_74768_a("health", this.health);
        compound.func_74768_a("door_ticks", this.door_open_ticks);
        compound.func_74757_a("forcefieldExtend", this.isExtendForceField);
        if (this.getTardisData() != null && !this.field_145850_b.field_72995_K) {
            TardisSaveHandler.saveTardis(this.getTardisData());
        }
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.tardisID = compound.func_74764_b("tardis_id") ? compound.func_74762_e("tardis_id") : 0;
        this.isDemat = compound.func_74764_b("isDemat") ? compound.func_74767_n("isDemat") : false;
        this.isRemat = compound.func_74764_b("isRemat") ? compound.func_74767_n("isRemat") : false;
        this.dematAmount = compound.func_74764_b("dematAmount") ? compound.func_74760_g("dematAmount") : 0.0f;
        this.scale = compound.func_74764_b("scale") ? compound.func_74760_g("scale") : 1.0f;
        this.pulses = compound.func_74764_b("pulses") ? compound.func_74762_e("pulses") : 0;
        this.b1 = compound.func_74764_b("b1") ? compound.func_74767_n("b1") : false;
        this.forcefieldalpha = compound.func_74764_b("f_a") ? compound.func_74760_g("f_a") : 0.0f;
        this.health = compound.func_74764_b("health") ? compound.func_74762_e("health") : 1000;
        this.door_open_ticks = compound.func_74764_b("door_ticks") ? compound.func_74762_e("door_ticks") : 0;
        this.isExtendForceField = compound.func_74764_b("forcefieldExtend") ? compound.func_74767_n("forcefieldExtend") : false;
    }

    public void onLoad() {
        super.onLoad();
        this.sendUpdates();
    }

    @Override
    public void sendUpdates() {
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
        this.func_70296_d();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.tardisDataCopy = DMTardis.getTardis(this.tardisID);
            ChameleonCircuitBase skin = this.getSkin(this.getTardisData());
            if (this.getTardisData() != null) {
                AxisAlignedBB bounds;
                List entities;
                int i;
                boolean recharge;
                if (this.forceFieldBounds == null) {
                    this.forceFieldBounds = new AxisAlignedBB(this.field_174879_c).func_186662_g(this.isExtendForceField ? 3.0 : 1.0);
                } else if (this.isExtendForceField != this.getTardisData().areForcefieldsEnabled()) {
                    this.isExtendForceField = this.getTardisData().areForcefieldsEnabled();
                    this.forceFieldBounds = this.getTardisData().areForcefieldsEnabled() ? new AxisAlignedBB(this.field_174879_c).func_186662_g(3.0) : new AxisAlignedBB(this.field_174879_c).func_186662_g(1.0);
                }
                if (this.field_145850_b.func_72820_D() % 60L == 0L && this.sendPacket) {
                    this.sendPacket = false;
                }
                if (DMConfig.tardis.isBotiEnabled && skin != null && skin.hasBoti() && (this.botiticks >= 500 || this.botiUpdate && this.getTardisData().isDoorOpen() && this.field_145850_b.func_72820_D() % 20L == 0L)) {
                    WorldPortal.WorldPortalServer.getWorldRender(this.field_145850_b, this.getPosToRender(), this.getDimension(), this.field_174879_c.func_185334_h(), this.getTardisData().getSpawnFacing(), true);
                    if (this.botiUpdate) {
                        this.botiUpdate = false;
                    }
                    this.botiticks = 0;
                    this.sendPacket = true;
                }
                if (this.getTardisData().isDoorOpen()) {
                    ++this.door_open_ticks;
                    if (this.botiticks < 500) {
                        ++this.botiticks;
                    }
                } else if (this.door_open_ticks != 0) {
                    this.door_open_ticks = 0;
                }
                if (this.door_open_ticks > 1800) {
                    this.getTardisData().setDoorOpen(false);
                    TardisSaveHandler.saveTardis(this.getTardisData());
                }
                if (this.tardisID == 0 || this.getTardisData().isRemoved()) {
                    this.field_145850_b.func_175656_a(this.func_174877_v(), Blocks.field_150350_a.func_176223_P());
                }
                if (this.getTardisData().getCurrentTardisPosition() != null && this.field_174879_c.func_177958_n() != this.getTardisData().getCurrentTardisPosition().x && this.field_174879_c.func_177956_o() != this.getTardisData().getCurrentTardisPosition().y && this.field_174879_c.func_177952_p() != this.getTardisData().getCurrentTardisPosition().z && !this.isRemat && !this.isDemat) {
                    if (DMConfig.debug.debug_game_output) {
                        TheDalekMod.LOG.info("Removed dupe with id: " + this.tardisID);
                    }
                    this.field_145850_b.func_175656_a(this.func_174877_v(), Blocks.field_150350_a.func_176223_P());
                }
                this.health = this.getTardisData().getTardisHealth();
                boolean bl = recharge = ++timer >= 1800;
                if (this.func_145831_w().func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c() == DMBlocks.ZeitonBlock) {
                    boolean bl2 = recharge = timer >= 800;
                }
                if (recharge && this.health < 1000) {
                    ++this.health;
                    if (this.health > 1000) {
                        this.health = 1000;
                    }
                    timer = 0;
                    this.getTardisData().setTardisHealth(this.health);
                    TardisSaveHandler.saveTardis(this.getTardisData());
                }
                boolean hads = this.getTardisData().getHads();
                List throwableList = this.field_145850_b.func_72872_a(Entity.class, this.forceFieldBounds);
                List mobList = this.field_145850_b.func_72872_a(EntityMob.class, this.forceFieldBounds);
                if (mobList.size() > 0 && this.getTardisData().areForcefieldsEnabled()) {
                    for (i = 0; i < mobList.size(); ++i) {
                        EntityMob mob = (EntityMob)mobList.get(i);
                        if (mob.field_70165_t > (double)this.field_174879_c.func_177958_n()) {
                            mob.func_70634_a(mob.field_70169_q + (double)0.05f, mob.field_70167_r, mob.field_70166_s);
                        }
                        if (mob.field_70165_t < (double)this.field_174879_c.func_177958_n()) {
                            mob.func_70634_a(mob.field_70169_q - (double)0.05f, mob.field_70167_r, mob.field_70166_s);
                        }
                        if (mob.field_70161_v > (double)this.field_174879_c.func_177952_p()) {
                            mob.func_70634_a(mob.field_70169_q, mob.field_70167_r, mob.field_70166_s + (double)0.05f);
                        }
                        if (!(mob.field_70161_v < (double)this.field_174879_c.func_177952_p())) continue;
                        mob.func_70634_a(mob.field_70169_q, mob.field_70167_r, mob.field_70166_s - (double)0.05f);
                    }
                }
                if (throwableList.size() > 0) {
                    for (i = 0; i < throwableList.size(); ++i) {
                        Entity entity = (Entity)throwableList.get(i);
                        if (entity instanceof EntityThrowable) {
                            this.field_145850_b.func_175688_a(EnumParticleTypes.REDSTONE, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 1.0, 1.0, 1.0, new int[0]);
                            this.forcefieldalpha = 0.16f;
                            entity.func_70106_y();
                            throwableList.remove(entity);
                            this.health = this.getTardisData().areForcefieldsEnabled() ? (this.health -= 3) : (this.health -= 30);
                            if (hads) {
                                this.handleHads();
                            }
                            TardisSaveHandler.saveTardis(this.getTardisData());
                        }
                        if (entity instanceof EntityArrow) {
                            this.field_145850_b.func_175688_a(EnumParticleTypes.REDSTONE, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 1.0, 1.0, 1.0, new int[0]);
                            this.forcefieldalpha = 0.16f;
                            entity.func_70106_y();
                            throwableList.remove(entity);
                            this.health = this.getTardisData().areForcefieldsEnabled() ? --this.health : (this.health -= 10);
                            if (hads) {
                                this.handleHads();
                            }
                            TardisSaveHandler.saveTardis(this.getTardisData());
                        }
                        if (entity instanceof IProjectile) {
                            this.field_145850_b.func_175688_a(EnumParticleTypes.REDSTONE, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 1.0, 1.0, 1.0, new int[0]);
                            this.forcefieldalpha = 0.16f;
                            entity.func_70106_y();
                            throwableList.remove(entity);
                            this.health = this.getTardisData().areForcefieldsEnabled() ? --this.health : (this.health -= 10);
                            if (hads) {
                                this.handleHads();
                            }
                            TardisSaveHandler.saveTardis(this.getTardisData());
                        }
                        if (!(entity instanceof EntityTNTPrimed) || !this.getTardisData().areForcefieldsEnabled()) continue;
                        for (int j = 0; j < 40; ++j) {
                            this.field_145850_b.func_175688_a(EnumParticleTypes.REDSTONE, entity.field_70165_t + (double)this.field_145850_b.field_73012_v.nextFloat(), entity.field_70163_u + (double)this.field_145850_b.field_73012_v.nextFloat(), entity.field_70161_v + (double)this.field_145850_b.field_73012_v.nextFloat(), 1.0, 1.0, 1.0, new int[0]);
                            this.field_145850_b.func_175688_a(EnumParticleTypes.REDSTONE, entity.field_70165_t - (double)this.field_145850_b.field_73012_v.nextFloat(), entity.field_70163_u - (double)this.field_145850_b.field_73012_v.nextFloat(), entity.field_70161_v - (double)this.field_145850_b.field_73012_v.nextFloat(), 1.0, 1.0, 1.0, new int[0]);
                            this.field_145850_b.func_175688_a(EnumParticleTypes.REDSTONE, entity.field_70165_t + (double)this.field_145850_b.field_73012_v.nextFloat(), entity.field_70163_u - (double)this.field_145850_b.field_73012_v.nextFloat(), entity.field_70161_v - (double)this.field_145850_b.field_73012_v.nextFloat(), 1.0, 1.0, 1.0, new int[0]);
                            this.field_145850_b.func_175688_a(EnumParticleTypes.REDSTONE, entity.field_70165_t - (double)this.field_145850_b.field_73012_v.nextFloat(), entity.field_70163_u - (double)this.field_145850_b.field_73012_v.nextFloat(), entity.field_70161_v + (double)this.field_145850_b.field_73012_v.nextFloat(), 1.0, 1.0, 1.0, new int[0]);
                        }
                        this.forcefieldalpha = 0.16f;
                        entity.func_70106_y();
                        throwableList.remove(entity);
                        this.health -= 10;
                        TardisSaveHandler.saveTardis(this.getTardisData());
                    }
                }
                if (this.health <= 0 && !this.isDemat) {
                    this.health = 1;
                    this.getTardisData().setTardisHealth(1);
                    this.getTardisData().setForcefieldsEnabled(false);
                    if (!this.isDemat) {
                        this.setDemat(true);
                        this.func_145831_w().func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), DMSounds.tardis_out_of_bounds, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                        TardisSaveHandler.saveTardis(this.getTardisData());
                    }
                }
                if (!(entities = this.field_145850_b.func_72872_a(Entity.class, bounds = defaultAABB.func_186670_a(this.func_174877_v()))).isEmpty() && this.pulses == -1 && this.getTardisData().isDoorOpen()) {
                    skin.handleEnter(this.field_145850_b, this.field_174879_c, this, (Entity)entities.get(0));
                }
                if (!this.getTardisData().isDoorOpen() && !entities.isEmpty() && this.pulses != -1 && !this.isDemat && entities.get(0) instanceof EntityPlayer && !(this.field_145850_b.field_73011_w instanceof WorldProviderTardis) && DMTardis.hasPermission(this.getTardisData(), (EntityPlayer)entities.get(0))) {
                    skin.handleEnter(this.field_145850_b, this.field_174879_c, this, (Entity)entities.get(0));
                }
                this.dematAnimation(this.getTardisData());
            }
        } else {
            this.tardisDataCopy = ClientTardisCache.getTardisData(this.tardisID);
            ChameleonCircuitBase skin = DMTardis.getTardisSkin(this.getTardisData().getExteriorID());
            if (skin == null) {
                skin = DMTardisSkinReg.SKIN_DEFAULT;
            }
            if (this.getTardisData() != null) {
                if (this.getTardisData().isDoorOpen()) {
                    this.doorRotation += skin.doorOpenSpeed();
                    if (this.doorRotation > skin.maxDoorRotation()) {
                        this.doorRotation = skin.maxDoorRotation();
                    }
                } else {
                    this.doorRotation -= skin.doorCloseSpeed();
                    if (this.doorRotation < 0.0f) {
                        this.doorRotation = 0.0f;
                    }
                }
                this.getTardisData().setDoorRotation(this.doorRotation);
                if (this.getTardisData().areForcefieldsEnabled()) {
                    if (this.forcefieldalpha > 0.0f) {
                        this.forcefieldalpha /= 1.1f;
                    }
                    if (this.getTardisData().isCloak()) {
                        this.forcefieldalpha = 0.0f;
                    }
                } else {
                    this.forcefieldalpha = 0.0f;
                }
                if (this.getTardisData().getHumID() >= 0) {
                    SoundEvent sound = InteriorSounds.InteriorSoundHelper.getEnumById(this.getTardisData().getHumID()).getSoundEvent();
                    if (this.getTardisData().isHum() && ++timer % 256 == 0 && !this.isDemat && !this.isRemat) {
                        DMSounds.playSound(this.field_145850_b, this.field_174879_c, sound, SoundCategory.BLOCKS, 10, this.getTardisData().isDoorOpen() ? 0.1f : 0.02f, 1.0f);
                        timer = 0;
                    }
                }
                if (this.getTardisData().getTardisHealth() < 20) {
                    this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 1.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), (double)0.01f, (double)0.05f, (double)0.01f, new int[]{1, 1, 1});
                }
                this.dematAnimation(this.getTardisData());
            }
        }
    }

    public void dematAnimation(TardisData data) {
        if (this.isDemat || this.isRemat) {
            if (this.pulses == -1) {
                this.pulses = 0;
                if (data != null) {
                    ChameleonCircuitBase base = this.getSkin(data);
                    if (!this.field_145850_b.field_72995_K) {
                        DMSounds.playSound(this.field_145850_b, this.field_174879_c, base.travelSound(!this.isRemat), SoundCategory.BLOCKS, 10, 0.2f, this.health <= 1 ? 0.1f : 1.0f);
                    }
                    if (data.isDoorOpen()) {
                        data.setDoorOpen(false);
                    }
                    if (this.health <= 1 && !this.field_145850_b.field_72995_K) {
                        this.func_145831_w().func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), DMSounds.CloisterBell, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                    }
                }
                if (this.isRemat) {
                    this.b1 = true;
                }
            }
            if (!this.b1) {
                this.dematAmount -= 0.05f;
                if (this.dematAmount <= 0.2f) {
                    this.b1 = !this.b1;
                    ++this.pulses;
                }
            } else {
                this.dematAmount += 0.05f;
                if (this.dematAmount >= 1.0f) {
                    this.b1 = !this.b1;
                    ++this.pulses;
                }
            }
            this.forcefieldalpha = 0.0f;
        }
        if (this.pulses >= 13) {
            if (this.isDemat) {
                this.field_145850_b.func_175698_g(this.func_174877_v());
                this.isDemat = false;
                this.isRemat = false;
                this.pulses = -1;
                this.dematAmount = 0.0f;
            }
            if (this.isRemat) {
                this.finishRemat(data);
            }
        }
    }

    public float getDoorRotation() {
        return this.doorRotation;
    }

    public void handleHads() {
        if (!(this.getTardisData().areForcefieldsEnabled() || this.isRemat || this.isDemat || this.field_145850_b.field_72995_K)) {
            Random r = this.field_145850_b.field_73012_v;
            int X = this.func_174877_v().func_177958_n() + r.nextInt(30);
            int Z = this.func_174877_v().func_177952_p() + r.nextInt(30);
            DMSounds.playSound(this.field_145850_b, this.field_174879_c, DMSounds.CloisterBell, SoundCategory.BLOCKS, 20, 1.0f, 1.0f);
            BlockPos bpto = new BlockPos(X, this.field_145850_b.func_175672_r(new BlockPos(X, this.func_174877_v().func_177956_o(), Z)).func_177956_o(), Z);
            WorldUtils.summonTardisToPos(this.field_145850_b, DMTardis.getTardis(this.tardisID), bpto, this.getTardisData().getTravelRotation());
        }
    }

    public void finishRemat(TardisData data) {
        if (this.getTardisData() != null) {
            this.getTardisData().setInFlight(false);
            this.getTardisData().setTardisCurrentDimensionLocation(this.field_145850_b.field_73011_w.getDimension());
            this.getTardisData().setCurrentLocationName(this.field_145850_b.field_73011_w.func_186058_p().func_186065_b());
            if (!this.field_145850_b.field_72995_K) {
                TardisSaveHandler.saveTardis(this.getTardisData());
            }
            this.isRemat = false;
            this.isDemat = false;
            this.pulses = -1;
            this.dematAmount = 1.0f;
            this.sendUpdates();
        }
    }

    public ChameleonCircuitBase getSkin(TardisData data) {
        return DMTardis.getTardisSkin(data.getExteriorID());
    }

    public void setDemat(boolean isDemat) {
        this.isDemat = isDemat;
        if (this.getTardisData() != null && this.getTardisData().isDoorOpen()) {
            PacketHandler.INSTANCE.sendToDimension((IMessage)new Packet_TardisDoors(this.field_174879_c, false), this.func_145831_w().field_73011_w.getDimension());
            this.getTardisData().setDoorOpen(false);
            this.sendUpdates();
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 2), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 2), (double)(this.field_174879_c.func_177958_n() + 2), (double)(this.field_174879_c.func_177956_o() + 5), (double)(this.field_174879_c.func_177952_p() + 2));
    }

    public void setRemat(boolean isRemat) {
        this.isRemat = isRemat;
        this.sendUpdates();
    }

    public void setBotiUpdate(boolean botiUpdate) {
        this.botiUpdate = botiUpdate;
    }

    public void onChunkUnload() {
        DMTardis.removeTardis(this.tardisID);
        if (this.isDemat) {
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
        super.onChunkUnload();
    }

    @Override
    public int getDimension() {
        return DMDimensions.DIM_TARDIS_ID;
    }

    @Override
    public BlockPos getPosToRender() {
        return this.getTardisData() != null ? WorldUtils.vec3ToBlockPos(this.getTardisData().getTardisInteriorDoorLocation()) : BlockPos.field_177992_a;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public WorldRender getWorldRender() {
        return this.customWorld;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setWorldRender(WorldRender worldRender) {
        this.customWorld = worldRender;
    }

    @Override
    public void requestRender() {
        if (this.field_145850_b.field_72995_K && this.getTardisData() != null && this.getTardisData().isDoorOpen() && !this.sendPacket) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketRequestBoti(this.func_174877_v()));
            this.sendPacket = true;
        }
        if (!this.field_145850_b.field_72995_K && !this.botiUpdate) {
            this.botiUpdate = true;
        }
    }
}

