/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.network.packets;

import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tileentity.tardis.perms.TardisPermission;
import com.swdteam.network.packets.AbstractServerMessageHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class Packet_UpdateTardisSettings
implements IMessage {
    public String field;
    public String data;
    public int tardis;

    public Packet_UpdateTardisSettings() {
    }

    public Packet_UpdateTardisSettings(int tardis, String fieldName, String data) {
        this.field = fieldName;
        this.data = data;
        this.tardis = tardis;
    }

    public void fromBytes(ByteBuf buf) {
        this.field = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.data = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.tardis = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.field);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.data);
        buf.writeInt(this.tardis);
    }

    public static class Handler
    extends AbstractServerMessageHandler<Packet_UpdateTardisSettings> {
        @Override
        public IMessage handleServerMessage(final EntityPlayer player, final Packet_UpdateTardisSettings message, MessageContext ctx) {
            player.func_184102_h().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EnumActionResult RESULT = EnumActionResult.SUCCESS;
                    String data = message.data;
                    int tardisID = message.tardis;
                    TardisData tData = DMTardis.getTardis(tardisID);
                    if (DMTardis.hasPermission(tData, player)) {
                        switch (message.field) {
                            case "hads": {
                                tData.setHads(!tData.getHads());
                                break;
                            }
                            case "cloak": {
                                tData.setCloak(!tData.isCloak());
                                break;
                            }
                            case "tardislanding": {
                                tData.setTravelRotation(Integer.parseInt(data) * 45);
                                break;
                            }
                            case "hum": {
                                tData.setHumID(Integer.valueOf(message.data));
                                break;
                            }
                            case "hum_toggle": {
                                tData.setHum(!tData.isHum());
                                break;
                            }
                            case "remove_companion": {
                                tData.removeCompanion(data);
                                break;
                            }
                            case "add_companion": {
                                EntityPlayerMP pl = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(data);
                                if (pl != null) {
                                    tData.addCompanion((EntityPlayer)pl);
                                    break;
                                }
                                player.func_146105_b((ITextComponent)new TextComponentString("Player isn't online!"), false);
                                break;
                            }
                            case "permission_level": {
                                tData.setTardisPermissions(TardisPermission.getFromString(data));
                            }
                        }
                        if (RESULT == EnumActionResult.SUCCESS) {
                            TardisSaveHandler.saveTardis(tData);
                        }
                    }
                }
            });
            return null;
        }
    }
}

