/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.gui.tardis.screens;

import com.swdteam.client.gui.elements.GuiButtonImage;
import com.swdteam.client.gui.tardis.GuiTardisMonitorNew;
import com.swdteam.client.gui.tardis.screens.AbstractTardisScreen;
import com.swdteam.common.tardis.InteriorSounds;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_UpdateTardisSettings;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TardisScreenSettings
extends AbstractTardisScreen {
    @Override
    public void init(GuiScreen screen) {
        GuiTardisMonitorNew tardis = (GuiTardisMonitorNew)screen;
        TardisData data = tardis.data;
        tardis.getButtonList().add(new GuiButtonImage(15, screen.field_146294_l / 2 - 110, screen.field_146295_m / 2 - 42, data.getHads() ? 20 : 52, 220, 32, 14).setTooltip("Toggle HADS"));
        tardis.getButtonList().add(new GuiButtonImage(16, screen.field_146294_l / 2 - 60, screen.field_146295_m / 2 - 42, data.isCloak() ? 20 : 52, 220, 32, 14).setTooltip("Toggle Cloak"));
        tardis.getButtonList().add(new GuiButtonImage(17, screen.field_146294_l / 2 - 10, screen.field_146295_m / 2 - 42, data.isHum() ? 20 : 52, 220, 32, 14).setTooltip("Toggle Hum"));
        tardis.getButtonList().add(new GuiButtonImage(18, screen.field_146294_l / 2 - 110, screen.field_146295_m / 2 - 8, 134, 136, 42, 14).setTooltip("Switch Hum"));
        tardis.getButtonList().add(new GuiButtonImage(19, screen.field_146294_l / 2 - 110, screen.field_146295_m / 2 + 24, 62, 164, 68, 14).setTooltip("Companions and Perms"));
    }

    @Override
    public void render(GuiScreen screen, float mouseX, float mouseY, float partialTicks) {
        float width = screen.field_146294_l;
        float height = screen.field_146295_m;
        TardisData data = ((GuiTardisMonitorNew)screen).data;
        this.fontRenderer.func_175065_a("Settings", width / 2.0f - (float)(this.fontRenderer.func_78256_a("Settings") / 2), height / 2.0f - 72.0f, -6710785, false);
        if (data != null) {
            this.fontRenderer.func_175065_a("HADS", width / 2.0f - 110.0f, height / 2.0f - 54.0f, -6710785, false);
            this.fontRenderer.func_175065_a("CLOAK", width / 2.0f - 60.0f, height / 2.0f - 54.0f, -6710785, false);
            this.fontRenderer.func_175065_a("HUM", width / 2.0f - 10.0f, height / 2.0f - 54.0f, -6710785, false);
            this.fontRenderer.func_175065_a("Toggle Hum Type", width / 2.0f - 110.0f, height / 2.0f - 20.0f, -6710785, false);
            this.fontRenderer.func_175065_a("Other", width / 2.0f - 110.0f, height / 2.0f + 12.0f, -6710785, false);
            String hum = "Null";
            if (data.getHumID() < InteriorSounds.values().length) {
                hum = InteriorSounds.values()[data.getHumID()].getName();
            }
            this.fontRenderer.func_175065_a("(" + hum + ")", width / 2.0f - 64.0f, height / 2.0f - 5.0f, -6710785, false);
        }
    }

    @Override
    public void update(GuiScreen screen) {
    }

    @Override
    public void actionPerformed(GuiScreen screen, GuiButton button) {
        TardisData data = ((GuiTardisMonitorNew)screen).data;
        if (button.field_146127_k == 15) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new Packet_UpdateTardisSettings(data.getTardisID(), "hads", ""));
            data.setHads(!data.getHads());
            ((GuiButtonImage)button).setOffsetX(data.getHads() ? 20 : 52);
        }
        if (button.field_146127_k == 16) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new Packet_UpdateTardisSettings(data.getTardisID(), "cloak", ""));
            data.setCloak(!data.isCloak());
            ((GuiButtonImage)button).setOffsetX(data.isCloak() ? 20 : 52);
        }
        if (button.field_146127_k == 17) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new Packet_UpdateTardisSettings(data.getTardisID(), "hum_toggle", ""));
            data.setHum(!data.isHum());
            ((GuiButtonImage)button).setOffsetX(data.isHum() ? 20 : 52);
        }
        if (button.field_146127_k == 18) {
            int hum = InteriorSounds.InteriorSoundHelper.nextHum(data.getHumID());
            data.setHumID(hum);
            PacketHandler.INSTANCE.sendToServer((IMessage)new Packet_UpdateTardisSettings(data.getTardisID(), "hum", "" + hum));
        }
        if (button.field_146127_k == 19) {
            ((GuiTardisMonitorNew)screen).changeScreen(GuiTardisMonitorNew.TardisMonitorScreen.COMPANIONS);
        }
    }
}

