/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.gui.tardis.screens;

import com.swdteam.client.gui.elements.GuiButtonImage;
import com.swdteam.client.gui.tardis.GuiTardisMonitorNew;
import com.swdteam.client.gui.tardis.screens.AbstractTardisScreen;
import com.swdteam.client.gui.tardis.screens.TardisScreenEditWaypoint;
import com.swdteam.common.data.WaypointData;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_RequestWaypoints;
import com.swdteam.network.packets.Packet_UpdateTardisDataField;
import com.swdteam.utils.Graphics;
import com.swdteam.utils.Vector3;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TardisScreenWaypointSelection
extends AbstractTardisScreen {
    public List<WaypointData> waypoints = new ArrayList<WaypointData>();
    public int totalWaypoints = 0;
    public int hoveredWaypoint = 0;
    public int selectedWaypoint = 0;
    private boolean isLoading = false;
    public int pageNum = 0;

    @Override
    public void show(GuiScreen screen) {
        super.show(screen);
        GuiTardisMonitorNew tardis = (GuiTardisMonitorNew)screen;
        this.totalWaypoints = 0;
        this.hoveredWaypoint = -1;
        this.selectedWaypoint = 0;
        this.pageNum = 0;
        this.setLoading(true);
        PacketHandler.INSTANCE.sendToServer((IMessage)new Packet_RequestWaypoints(tardis.data.getTardisID(), this.pageNum));
    }

    @Override
    public void init(GuiScreen screen) {
        GuiTardisMonitorNew tardis = (GuiTardisMonitorNew)screen;
        tardis.getButtonList().add(new GuiButtonImage(10, tardis.field_146294_l / 2 + 42, tardis.field_146295_m / 2 + 36, 0, 136, 10, 20).setTooltip("Previous Page"));
        tardis.getButtonList().add(new GuiButtonImage(11, tardis.field_146294_l / 2 + 101, tardis.field_146295_m / 2 + 36, 10, 136, 10, 20).setTooltip("Next Page"));
        tardis.getButtonList().add(new GuiButtonImage(12, tardis.field_146294_l / 2 + 57, tardis.field_146295_m / 2 + 36, 88, 192, 40, 20).setTooltip("Select Waypoint"));
        tardis.getButtonList().add(new GuiButtonImage(13, tardis.field_146294_l / 2 + 42, tardis.field_146295_m / 2 + 60, 20, 192, 32, 14).setTooltip("Edit Selected Waypoint"));
        tardis.getButtonList().add(new GuiButtonImage(14, tardis.field_146294_l / 2 + 78, tardis.field_146295_m / 2 + 60, 52, 192, 32, 14).setTooltip("Add New Waypoint"));
    }

    @Override
    public void render(GuiScreen screen, float mouseX, float mouseY, float partialTicks) {
        float width = screen.field_146294_l;
        float height = screen.field_146295_m;
        this.fontRenderer.func_175065_a("Waypoints", width / 2.0f - (float)(this.fontRenderer.func_78256_a("Waypoints") / 2), height / 2.0f - 72.0f, -6710785, false);
        this.hoveredWaypoint = -1;
        for (int i = 0; i < 10; ++i) {
            if (i < this.waypoints.size()) {
                int col = 0x554444AA;
                float wpBX = width / 2.0f - 110.0f + (float)(76 * (i / 5));
                float wpBY = height / 2.0f - 54.0f + (float)(i % 5 * 18);
                if (mouseX > wpBX && mouseX < wpBX + 72.0f && mouseY > wpBY && mouseY < wpBY + 14.0f) {
                    col = 0x776666CC;
                    this.hoveredWaypoint = i;
                }
                if (this.selectedWaypoint == i) {
                    col = -1432774162;
                    if (this.hoveredWaypoint == i) {
                        col = -1146443009;
                    }
                }
                Graphics.FillRect((double)wpBX, (double)wpBY, 72.0, 14.0, 0.0, col);
                WaypointData wpData = this.waypoints.get(i);
                String wpName = this.fontRenderer.func_78269_a(wpData.getWaypointName(), 68);
                this.fontRenderer.func_175065_a(wpName, width / 2.0f - 106.0f + (float)(76 * (i / 5)), height / 2.0f - 51.0f + (float)(i % 5 * 18), -1, false);
                continue;
            }
            Graphics.FillRect((double)(width / 2.0f - 110.0f + (float)(76 * (i / 5))), (double)(height / 2.0f - 54.0f + (float)(i % 5 * 18)), 72.0, 14.0, 0.0, 0x55666666);
        }
        Graphics.FillRect((double)(width / 2.0f + 42.0f), (double)(height / 2.0f - 54.0f), 68.0, 86.0, 0.0, 0x554444AA);
        this.fontRenderer.func_175065_a("Info", width / 2.0f + 64.0f, height / 2.0f - 48.0f, -1, false);
        if (this.selectedWaypoint >= 0 && this.selectedWaypoint < this.waypoints.size()) {
            WaypointData wp = this.waypoints.get(this.selectedWaypoint);
            this.fontRenderer.func_175065_a("X: " + wp.getPos().x, width / 2.0f + 48.0f, height / 2.0f - 34.0f, -1, false);
            this.fontRenderer.func_175065_a("Y: " + wp.getPos().y, width / 2.0f + 48.0f, height / 2.0f - 22.0f, -1, false);
            this.fontRenderer.func_175065_a("Z: " + wp.getPos().z, width / 2.0f + 48.0f, height / 2.0f - 10.0f, -1, false);
            this.fontRenderer.func_175065_a("Dim: " + wp.getDimension(), width / 2.0f + 48.0f, height / 2.0f + 2.0f, -1, false);
            this.fontRenderer.func_175065_a("Rot: " + (int)wp.getRotation(), width / 2.0f + 48.0f, height / 2.0f + 14.0f, -1, false);
        }
    }

    @Override
    public void update(GuiScreen screen) {
    }

    @Override
    public void actionPerformed(GuiScreen screen, GuiButton button) {
        GuiTardisMonitorNew tardis = (GuiTardisMonitorNew)screen;
        if (button.field_146127_k == 13 && this.waypoints.size() > 0) {
            if (this.selectedWaypoint < 0 || this.selectedWaypoint >= this.waypoints.size()) {
                this.selectedWaypoint = 0;
            }
            ((TardisScreenEditWaypoint)GuiTardisMonitorNew.TardisMonitorScreen.WAYPOINT_EDIT.screen).currentWaypoint = this.waypoints.get(this.selectedWaypoint);
            tardis.changeScreen(GuiTardisMonitorNew.TardisMonitorScreen.WAYPOINT_EDIT);
        }
        if (button.field_146127_k == 14) {
            tardis.changeScreen(GuiTardisMonitorNew.TardisMonitorScreen.WAYPOINT_ADD);
        }
        if (button.field_146127_k == 12 && this.waypoints.size() > 0) {
            WaypointData currentWP = this.waypoints.get(this.selectedWaypoint);
            PacketHandler.INSTANCE.sendToServer((IMessage)new Packet_UpdateTardisDataField(tardis.data.getTardisID(), "tardisDIM", Integer.toString(currentWP.getDimension())));
            PacketHandler.INSTANCE.sendToServer((IMessage)new Packet_UpdateTardisDataField(tardis.data.getTardisID(), "position", currentWP.getPos().x + ":" + currentWP.getPos().y + ":" + currentWP.getPos().z + ":" + currentWP.getRotation()));
            Minecraft.func_71410_x().func_147108_a(null);
        }
        if (button.field_146127_k == 10) {
            if (this.pageNum - 1 < 0) {
                this.pageNum = 0;
            } else {
                --this.pageNum;
                this.setLoading(true);
                PacketHandler.INSTANCE.sendToServer((IMessage)new Packet_RequestWaypoints(tardis.data.getTardisID(), this.pageNum));
            }
        }
        if (button.field_146127_k == 11) {
            if ((double)(this.pageNum + 1) >= Math.ceil((float)this.totalWaypoints / 10.0f)) {
                this.pageNum = (int)Math.ceil((float)this.totalWaypoints / 10.0f) - 1;
            } else {
                ++this.pageNum;
                this.setLoading(true);
                PacketHandler.INSTANCE.sendToServer((IMessage)new Packet_RequestWaypoints(tardis.data.getTardisID(), this.pageNum));
            }
        }
    }

    public void setLoading(boolean isLoading) {
        this.isLoading = isLoading;
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public void setWaypoints(NBTTagCompound tag) {
        this.waypoints.clear();
        this.selectedWaypoint = 0;
        for (int i = 0; i < tag.func_186856_d(); ++i) {
            if (!tag.func_74764_b("wp_" + i)) continue;
            NBTTagCompound t = tag.func_74775_l("wp_" + i);
            Vector3 v = new Vector3(t.func_74762_e("x"), t.func_74762_e("y"), t.func_74762_e("z"));
            WaypointData d = new WaypointData(t.func_74779_i("n"), v, t.func_74762_e("d"), t.func_74760_g("r"));
            d.setWaypointFileName(t.func_74779_i("fn"));
            this.waypoints.add(d);
        }
    }

    @Override
    public void mouseClicked(GuiScreen screen, int button, int mX, int mY) {
        if (button == 0 && this.hoveredWaypoint != -1 && this.hoveredWaypoint < this.waypoints.size()) {
            screen.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            this.selectedWaypoint = this.hoveredWaypoint;
        }
    }
}

