/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.block;

import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.init.FluidInit;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.utils.PlayerUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFuelTank
extends Block {
    public static final PropertyEnum<TankStage> STAGE = PropertyEnum.func_177709_a((String)"stage", TankStage.class);
    private static Map<Object, Double> fuelMap = new HashMap<Object, Double>();

    public BlockFuelTank(Material materialIn) {
        super(materialIn);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(STAGE, (Comparable)((Object)TankStage.EMPTY)));
        this.func_149675_a(true);
    }

    public static void addFuel(Block b, double amount) {
        fuelMap.put(b, amount);
    }

    public static void addFuel(Item b, double amount) {
        fuelMap.put(b, amount);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            TardisData data;
            if (worldIn.field_73011_w.getDimension() == DMDimensions.DIM_TARDIS_ID && (data = DMTardis.getTardis(pos)) != null && hand == playerIn.func_184600_cs()) {
                ItemStack stack = playerIn.func_184586_b(hand);
                Item o = stack.func_77973_b();
                Block b = Block.func_149634_a((Item)stack.func_77973_b());
                if (b != null && b != Blocks.field_150350_a) {
                    o = b;
                }
                if (stack.func_77973_b().getRegistryName().equals((Object)new ResourceLocation("forge:bucketfilled")) && FluidUtil.getFluidContained((ItemStack)stack).getFluid() == FluidInit.TOXIC_WASTE) {
                    if (data.getFuel() < 100.0f) {
                        data.setFuel(100.0f);
                        TardisSaveHandler.saveTardis(data);
                        this.func_180645_a(worldIn, pos, state, worldIn.field_73012_v);
                        playerIn.func_184611_a(hand, new ItemStack(Items.field_151133_ar));
                    }
                    return true;
                }
                if (fuelMap.containsKey(o)) {
                    double f = fuelMap.get(o);
                    if (data.getFuel() < 100.0f) {
                        data.setFuel((float)((double)data.getFuel() + f));
                        TardisSaveHandler.saveTardis(data);
                        this.func_180645_a(worldIn, pos, state, worldIn.field_73012_v);
                        stack.func_190918_g(1);
                        PlayerUtils.Messaging.sendMessageToPlayer(playerIn, TextFormatting.GREEN + "Fuel filled: " + f + "%");
                    } else {
                        PlayerUtils.Messaging.sendMessageToPlayer(playerIn, TextFormatting.RED + "Fuel bank is full");
                    }
                } else {
                    PlayerUtils.Messaging.sendMessageToPlayer(playerIn, TextFormatting.RED + "This cannot be used as fuel");
                }
                return true;
            }
        } else {
            ItemStack stack = playerIn.func_184586_b(hand);
            if (stack.func_77973_b().getRegistryName().equals((Object)new ResourceLocation("forge:bucketfilled")) && FluidUtil.getFluidContained((ItemStack)stack).getFluid() == FluidInit.TOXIC_WASTE) {
                return true;
            }
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public int func_149738_a(World worldIn) {
        return 20;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
        TankStage s1;
        TankStage s;
        TardisData data;
        if (!worldIn.field_72995_K && worldIn.field_73011_w.getDimension() == DMDimensions.DIM_TARDIS_ID && (data = DMTardis.getTardis(pos)) != null && (s = (TankStage)((Object)state.func_177229_b(STAGE))) != (s1 = TankStage.getEnumForFuelLevel(data.getFuel()))) {
            worldIn.func_175656_a(pos, this.func_176223_P().func_177226_a(STAGE, (Comparable)((Object)s1)));
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.func_180645_a(worldIn, pos, state, worldIn.field_73012_v);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STAGE});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        return ((TankStage)((Object)state.func_177229_b(STAGE))).meta;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(STAGE, (Comparable)((Object)TankStage.getEnumForMeta(meta)));
    }

    public static enum TankStage implements IStringSerializable
    {
        FULL("full", 0),
        PARTIAL("partial", 1),
        HALF("half", 2),
        LOW("low", 3),
        EMPTY("empty", 4);

        private final String name;
        private int meta;

        private TankStage(String name, int meta) {
            this.name = name;
            this.meta = meta;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static TankStage getEnumForMeta(int m) {
            TankStage s = EMPTY;
            switch (m) {
                case 0: {
                    s = FULL;
                    break;
                }
                case 1: {
                    s = PARTIAL;
                    break;
                }
                case 2: {
                    s = HALF;
                    break;
                }
                case 3: {
                    s = LOW;
                    break;
                }
                case 4: {
                    s = EMPTY;
                    break;
                }
            }
            return s;
        }

        public static TankStage getEnumForFuelLevel(double fuel) {
            TankStage stage = EMPTY;
            stage = fuel <= 5.0 ? EMPTY : (fuel <= 35.0 ? LOW : (fuel <= 60.0 ? HALF : (fuel <= 85.0 ? PARTIAL : FULL)));
            return stage;
        }
    }
}

