/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.init;

import com.google.gson.reflect.TypeToken;
import com.swdteam.common.data.WaypointData;
import com.swdteam.main.TheDalekMod;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.FMLInjectionData;

public class DMWaypoints {
    public static Type TYPE_TOKEN = new TypeToken<List<WaypointData>>(){}.getType();

    public static String getWaypointsAsJSON(int tardisID, int offset) {
        ArrayList<WaypointData> wpData = new ArrayList<WaypointData>();
        String fileDir = ((File)FMLInjectionData.data()[6]).getAbsolutePath() + "/saves/" + TheDalekMod.FML.getMinecraftServerInstance().func_71270_I() + "/Tardis_Data/Waypoints/Tardis_" + tardisID + "/";
        File f = new File(fileDir);
        if (!f.exists()) {
            f.mkdirs();
        }
        File[] files = f.listFiles();
        Arrays.sort(files, (f1, f2) -> Long.valueOf(f2.lastModified()).compareTo(f1.lastModified()));
        int startOffset = offset * 8;
        if (offset * 8 < files.length) {
            for (int i = offset * 8; i < offset * 8 + 8 && i < files.length; ++i) {
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new FileReader(files[i]));
                    StringBuilder sb = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                    }
                    reader.close();
                    WaypointData data = (WaypointData)TheDalekMod.GSON.fromJson(sb.toString(), WaypointData.class);
                    data.setWaypointFileName(files[i].getName());
                    wpData.add(data);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return TheDalekMod.GSON.toJson(wpData, TYPE_TOKEN);
    }

    public static NBTTagCompound getWaypointsAsNBT(int tardisID, int offset) {
        if (offset < 0) {
            offset = 0;
        }
        NBTTagCompound tag = new NBTTagCompound();
        String fileDir = ((File)FMLInjectionData.data()[6]).getAbsolutePath() + "/saves/" + TheDalekMod.FML.getMinecraftServerInstance().func_71270_I() + "/Tardis_Data/Waypoints/Tardis_" + tardisID + "/";
        File f = new File(fileDir);
        if (!f.exists()) {
            f.mkdirs();
        }
        File[] files = f.listFiles();
        Arrays.sort(files, (f1, f2) -> Long.valueOf(f2.lastModified()).compareTo(f1.lastModified()));
        ArrayList<File> jsonFiles = new ArrayList<File>();
        for (File ff : files) {
            if (!ff.getName().endsWith(".json")) continue;
            jsonFiles.add(ff);
        }
        int startOffset = offset * 10;
        if (offset * 10 < jsonFiles.size()) {
            for (int i = offset * 10; i < offset * 10 + 10 && i < jsonFiles.size(); ++i) {
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new FileReader((File)jsonFiles.get(i)));
                    StringBuilder sb = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                    }
                    reader.close();
                    WaypointData data = (WaypointData)TheDalekMod.GSON.fromJson(sb.toString(), WaypointData.class);
                    NBTTagCompound wp = new NBTTagCompound();
                    wp.func_74778_a("n", data.getWaypointName());
                    wp.func_74778_a("fn", ((File)jsonFiles.get(i)).getName());
                    wp.func_74768_a("x", data.getPos().x);
                    wp.func_74768_a("y", data.getPos().y);
                    wp.func_74768_a("z", data.getPos().z);
                    wp.func_74768_a("d", data.getDimension());
                    wp.func_74776_a("r", data.getRotation());
                    tag.func_74782_a("wp_" + tag.func_186856_d(), (NBTBase)wp);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return tag;
    }

    public static void editWaypoint(int tardisID, String name, String newWPName) {
        String fileDir = ((File)FMLInjectionData.data()[6]).getAbsolutePath() + "/saves/" + TheDalekMod.FML.getMinecraftServerInstance().func_71270_I() + "/Tardis_Data/Waypoints/Tardis_" + tardisID + "/";
        File f = new File(fileDir);
        if (!f.exists()) {
            f.mkdirs();
        }
        File f1 = new File(f.getAbsolutePath() + "/" + name);
        WaypointData data = null;
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(f1));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            data = (WaypointData)TheDalekMod.GSON.fromJson(sb.toString(), WaypointData.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (data != null) {
            data.setWaypointName(newWPName);
        }
        DMWaypoints.saveWaypoint(tardisID, data, name);
    }

    public static void deleteWaypoint(int tardisID, String name) {
        String fileDir = ((File)FMLInjectionData.data()[6]).getAbsolutePath() + "/saves/" + TheDalekMod.FML.getMinecraftServerInstance().func_71270_I() + "/Tardis_Data/Waypoints/Tardis_" + tardisID + "/";
        File f = new File(fileDir);
        if (!f.exists()) {
            f.mkdirs();
        }
        File f1 = new File(f.getAbsolutePath() + "/" + name);
        f1.delete();
    }

    public static int getTotalWaypoints(int tardisID) {
        String fileDir = ((File)FMLInjectionData.data()[6]).getAbsolutePath() + "/saves/" + TheDalekMod.FML.getMinecraftServerInstance().func_71270_I() + "/Tardis_Data/Waypoints/Tardis_" + tardisID + "/";
        File f = new File(fileDir);
        if (!f.exists()) {
            f.mkdirs();
        }
        ArrayList<File> jsonFiles = new ArrayList<File>();
        for (File ff : f.listFiles()) {
            if (!ff.getName().endsWith(".json")) continue;
            jsonFiles.add(ff);
        }
        return jsonFiles.size();
    }

    public static void saveWaypoint(int tardisID, WaypointData data, String fileName) {
        if (fileName == null) {
            fileName = "wp_" + System.currentTimeMillis() / 100L + ".json";
        }
        if (data.getWaypointName() == null || data.getWaypointName() != null && data.getWaypointName().length() < 1) {
            return;
        }
        String fileDir = ((File)FMLInjectionData.data()[6]).getAbsolutePath() + "/saves/" + TheDalekMod.FML.getMinecraftServerInstance().func_71270_I() + "/Tardis_Data/Waypoints/Tardis_" + tardisID + "/";
        File f = new File(fileDir);
        if (!f.exists()) {
            f.mkdirs();
        }
        try {
            FileWriter writer = new FileWriter(new File(f.getAbsolutePath() + "/" + fileName));
            writer.write(TheDalekMod.GSON.toJson((Object)data));
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

