/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.commands;

import com.mojang.authlib.GameProfile;
import com.swdteam.common.block.tardis.BlockTardis;
import com.swdteam.common.capability.CapabilityTardis;
import com.swdteam.common.capability.interfaces.ITardisCapability;
import com.swdteam.common.data.PlayerData;
import com.swdteam.common.init.DMBlocks;
import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.init.DMSounds;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tardis.data.UserTardises;
import com.swdteam.common.tardis.data.chameleon.ChameleonCircuitBase;
import com.swdteam.common.tileentity.tardis.TileEntityTardis;
import com.swdteam.common.tileentity.tardis.perms.TardisPermission;
import com.swdteam.main.TheDalekMod;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_TardisDoors;
import com.swdteam.utils.DMUtils;
import com.swdteam.utils.EnumDefaultResponse;
import com.swdteam.utils.PlayerUtils;
import com.swdteam.utils.Vector3;
import com.swdteam.utils.WorldUtils;
import com.swdteam.utils.math.Vector3d;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import net.minecraftforge.server.command.CommandTreeBase;

public class TardisAdminSubCommands {

    public static class TardisList
    extends CommandBase {
        public String func_71517_b() {
            return "list";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/tardis-admin " + this.func_71517_b() + " <online|player|count>";
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
            switch (args.length) {
                case 1: {
                    return TardisList.func_71530_a((String[])args, (String[])new String[]{"online", "player", "count", "id-xz"});
                }
                case 2: {
                    if (!args[0].equalsIgnoreCase("player")) break;
                    return TardisList.func_71530_a((String[])args, (String[])server.func_71213_z());
                }
            }
            return super.func_184883_a(server, sender, args, targetPos);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length > 0) {
                switch (args[0]) {
                    case "count": {
                        String fileDir = ((File)FMLInjectionData.data()[6]).getAbsolutePath() + "/saves/" + TheDalekMod.FML.getMinecraftServerInstance().func_71270_I() + "/Tardis_Data/Tardises/";
                        File f = new File(fileDir);
                        int size = f.listFiles().length - 1;
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)TardisList.func_71521_c((ICommandSender)sender), TextFormatting.GREEN + "IDs in use: " + (DMTardis.removed_tardis.size() > 0 ? size - DMTardis.removed_tardis.size() : size));
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)TardisList.func_71521_c((ICommandSender)sender), TextFormatting.GREEN + "Next ID : " + (DMTardis.removed_tardis.size() > 0 ? DMTardis.removed_tardis.get(0) : size + 1));
                        return;
                    }
                    case "online": {
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)TardisList.func_71521_c((ICommandSender)sender), TextFormatting.BOLD + "Displaying TARDIS List for all online players");
                        for (EntityPlayerMP p : server.func_184103_al().func_181057_v()) {
                            UUID uuid = p.func_110124_au();
                            if (uuid == null) continue;
                            DMTardis.reconstructPlayerLookup(uuid.toString());
                            UserTardises uTar = DMTardis.getUserTardises(uuid);
                            if (uTar == null || uTar.getTardises().size() <= 0) continue;
                            StringBuilder b = new StringBuilder();
                            for (int i = 0; i < uTar.getTardises().size(); ++i) {
                                b.append(uTar.getTardises().get(i) + (i == uTar.getTardises().size() - 1 ? "" : ","));
                            }
                            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)TardisList.func_71521_c((ICommandSender)sender), TextFormatting.GREEN + p.func_70005_c_() + " owns the following Tardises: " + TextFormatting.RESET + b.toString());
                        }
                        return;
                    }
                    case "player": {
                        if (args.length > 1) {
                            GameProfile profile = sender.func_184102_h().func_152358_ax().func_152655_a(args[1]);
                            if (profile != null) {
                                UUID uuid = profile.getId();
                                if (uuid == null || !(sender instanceof EntityPlayerMP)) {
                                    uuid = UUID.fromString(DMUtils.getUUIDs(args[1].replaceAll("@p", sender.func_70005_c_())));
                                }
                                if (uuid == null) {
                                    PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)TardisList.func_71521_c((ICommandSender)sender), TextFormatting.RED + "Player " + args[1] + " does not exist.");
                                    return;
                                }
                                if (uuid != null) {
                                    DMTardis.reconstructPlayerLookup(uuid.toString());
                                    UserTardises uTar = DMTardis.getUserTardises(uuid);
                                    if (uTar != null && uTar.getTardises().size() > 0) {
                                        StringBuilder b = new StringBuilder();
                                        for (int i = 0; i < uTar.getTardises().size(); ++i) {
                                            b.append(uTar.getTardises().get(i) + (i == uTar.getTardises().size() - 1 ? "" : ","));
                                        }
                                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)TardisList.func_71521_c((ICommandSender)sender), TextFormatting.GREEN + args[1] + " owns the following Tardises: " + TextFormatting.RESET + b.toString());
                                        return;
                                    }
                                    PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)TardisList.func_71521_c((ICommandSender)sender), TextFormatting.RED + args[1] + " has no Tardises");
                                    return;
                                }
                            }
                            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)TardisList.func_71521_c((ICommandSender)sender), TextFormatting.RED + args[1] + " does not exist");
                            return;
                        }
                    }
                    case "id-xz": {
                        EntityPlayerMP player = TardisList.func_71521_c((ICommandSender)sender);
                        System.out.println(args);
                        if (player.field_70170_p.field_73011_w.getDimension() != DMDimensions.DIM_TARDIS_ID && args.length == 1) {
                            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, EnumDefaultResponse.CANNOT_EXECUTE_IN_DIMENSION);
                            return;
                        }
                        boolean givxz = false;
                        int x = (int)player.field_70165_t;
                        int z = (int)player.field_70161_v;
                        int id = 1;
                        if (args.length == 2) {
                            givxz = true;
                            id = TardisList.func_175755_a((String)args[1]);
                        } else if (args.length > 2) {
                            givxz = false;
                            x = TardisList.func_175755_a((String)args[1]);
                            z = TardisList.func_175755_a((String)args[2]);
                        }
                        if (!givxz) {
                            id = DMTardis.getIDForXZ(x, z);
                        }
                        BlockPos pos = DMTardis.getXZForMap(id);
                        if (givxz) {
                            x = DMTardis.INTERIOR_BOUNDS / 2 + pos.func_177958_n() * DMTardis.INTERIOR_BOUNDS;
                        }
                        if (givxz) {
                            z = DMTardis.INTERIOR_BOUNDS / 2 + pos.func_177952_p() * DMTardis.INTERIOR_BOUNDS;
                        }
                        int ix = pos.func_177958_n();
                        int iz = pos.func_177952_p();
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.RED + "ID: " + id + " (" + x + ";" + z + ")[" + ix + ";" + iz + "]");
                        return;
                    }
                }
            }
            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)TardisList.func_71521_c((ICommandSender)sender), TextFormatting.RED + "Usage: " + this.func_71518_a(sender));
        }
    }

    public static class WTAILA
    extends SubCommand {
        public WTAILA(String[] name) {
            super(name);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            int i;
            EntityPlayerMP player = WTAILA.func_71521_c((ICommandSender)sender);
            BlockPos blockpos = new BlockPos(0, 0, 0);
            TileEntityTardis tardis = null;
            if (args.length > 2) {
                Vector3d coords = new Vector3d(WTAILA.func_175770_a((double)player.field_70165_t, (String)args[0], (boolean)true).func_179628_a(), WTAILA.func_175770_a((double)player.field_70163_u, (String)args[1], (boolean)true).func_179628_a(), WTAILA.func_175770_a((double)player.field_70161_v, (String)args[2], (boolean)true).func_179628_a());
                blockpos = new BlockPos(coords.x, coords.y, coords.z);
            } else if (server.func_71264_H()) {
                RayTraceResult trace = player.func_174822_a(16.0, 1.0f);
                blockpos = trace.func_178782_a();
            } else {
                Vec3d start = player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
                for (i = 0; i < 64 && player.field_70170_p.func_180495_p(blockpos = new BlockPos(start = start.func_178787_e(player.func_70040_Z()))).func_177230_c() != DMBlocks.TARDIS; ++i) {
                }
            }
            boolean edit = false;
            for (i = 0; i < args.length; ++i) {
                if (!args[i].equalsIgnoreCase("edit")) continue;
                edit = true;
            }
            if (player.field_70170_p.func_180495_p(blockpos).func_177230_c() == DMBlocks.TARDIS) {
                if (player.func_130014_f_().func_175625_s(blockpos) instanceof TileEntityTardis) {
                    tardis = (TileEntityTardis)player.func_130014_f_().func_175625_s(blockpos);
                    if (tardis.getTardisData() != null) {
                        TardisData data = DMTardis.getTardis(tardis.getTardisData().getTardisID());
                        TextComponentString header = new TextComponentString("-------------" + (edit ? "EDIT" : "TARDIS") + "-------------");
                        header.func_150255_a(new Style().func_150238_a(TextFormatting.GREEN));
                        WTAILA.sendMessage((ICommandSender)player, (ITextComponent)header);
                        TextComponentString owner = new TextComponentString("ID: " + data.getTardisID() + " | Owner: " + data.getOwner());
                        if (edit) {
                            owner.func_150255_a(new Style().func_150238_a(TextFormatting.WHITE).func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tardis-admin set-owner " + data.getTardisID() + " " + sender.func_70005_c_())).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Change Owner"))));
                        }
                        WTAILA.sendMessage((ICommandSender)player, (ITextComponent)owner);
                        TextComponentString exterior = new TextComponentString("Exterior: " + DMTardis.getTardisSkin(data.getExteriorID()).getExteriorName());
                        if (edit) {
                            exterior.func_150255_a(new Style().func_150238_a(TextFormatting.WHITE).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tardis-admin data-change " + data.getTardisID() + " chameleon-circuit next")).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Change Chameleon Circuit"))));
                        }
                        WTAILA.sendMessage((ICommandSender)player, (ITextComponent)exterior);
                        TextComponentString demat = new TextComponentString("Location: [" + data.getCurrentTardisPosition() + "]");
                        if (edit) {
                            demat.func_150255_a(new Style().func_150238_a(TextFormatting.WHITE).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/blockdata " + blockpos.func_177958_n() + " " + blockpos.func_177956_o() + " " + blockpos.func_177952_p() + " {isDemat:1}")).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("De-Materialize"))));
                        }
                        WTAILA.sendMessage((ICommandSender)player, (ITextComponent)demat);
                        TextComponentString interior = new TextComponentString("Interior Pos: [" + data.getTardisInteriorDoorLocation() + "](" + data.getInteriorX() + ";" + data.getInteriorZ() + ")");
                        if (edit) {
                            interior.func_150255_a(new Style().func_150238_a(TextFormatting.WHITE).func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tardis-admin data-change " + data.getTardisID() + " interior " + player.field_70165_t + " " + player.field_70163_u + " " + player.field_70161_v + " " + player.func_70079_am())).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Change Interior Position"))));
                        }
                        WTAILA.sendMessage((ICommandSender)player, (ITextComponent)interior);
                        TextComponentString destination = new TextComponentString("Planet / Dimension: " + data.getTardisCurrentdimension() + "\nDestination: " + data.getCurrentLocationName() + "\nIn Flight: " + data.isInFlight());
                        if (edit) {
                            destination.func_150255_a(new Style().func_150238_a(TextFormatting.WHITE).func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tardis-admin summon " + data.getTardisID())).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Summon TARDIS (TAB to autocomplete destination)"))));
                        }
                        WTAILA.sendMessage((ICommandSender)player, (ITextComponent)destination);
                        TextComponentString health = new TextComponentString("Health: " + data.getTardisHealth());
                        if (edit) {
                            health.func_150255_a(new Style().func_150238_a(TextFormatting.WHITE).func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tardis-admin data-change " + tardis.getTardisData().getTardisID() + " health 1000")).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Changes the health"))));
                        }
                        WTAILA.sendMessage((ICommandSender)player, (ITextComponent)health);
                        TextComponentString hads = new TextComponentString("HADS: " + (data.getHads() ? "enabled" : "disabled"));
                        if (edit) {
                            hads.func_150255_a(new Style().func_150238_a(TextFormatting.WHITE).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tardis-admin data-change " + data.getTardisID() + " hads toggle")).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Toggles the HADS"))));
                        }
                        WTAILA.sendMessage((ICommandSender)player, (ITextComponent)hads);
                        TextComponentString ffield = new TextComponentString("Force-Field: " + (data.areForcefieldsEnabled() ? "enabled" : "disabled"));
                        if (edit) {
                            ffield.func_150255_a(new Style().func_150238_a(TextFormatting.WHITE).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tardis-admin data-change " + data.getTardisID() + " forcefield toggle")).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Toggles the Force-Field"))));
                        }
                        WTAILA.sendMessage((ICommandSender)player, (ITextComponent)ffield);
                        TextComponentString cloak = new TextComponentString("Cloaked: " + (data.isCloak() ? "enabled" : "disabled"));
                        if (edit) {
                            cloak.func_150255_a(new Style().func_150238_a(TextFormatting.WHITE).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tardis-admin data-change " + data.getTardisID() + " cloak toggle")).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Toggles the Cloak"))));
                        }
                        WTAILA.sendMessage((ICommandSender)player, (ITextComponent)cloak);
                        TextComponentString lock = new TextComponentString("Locked: " + data.isLocked());
                        if (edit) {
                            lock.func_150255_a(new Style().func_150238_a(TextFormatting.WHITE).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tardis-admin toggle-lock " + blockpos.func_177958_n() + " " + blockpos.func_177956_o() + " " + blockpos.func_177952_p())).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Toggles the Door Lock"))));
                        }
                        WTAILA.sendMessage((ICommandSender)player, (ITextComponent)lock);
                        TextComponentString door = new TextComponentString("Open: " + data.isDoorOpen());
                        if (edit) {
                            door.func_150255_a(new Style().func_150238_a(TextFormatting.WHITE).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tardis-admin toggle-open " + blockpos.func_177958_n() + " " + blockpos.func_177956_o() + " " + blockpos.func_177952_p())).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Toggles the Door"))));
                        }
                        WTAILA.sendMessage((ICommandSender)player, (ITextComponent)door);
                        TextComponentString permission = new TextComponentString("Permissions: " + (Object)((Object)data.getTardisPermissions()));
                        if (edit) {
                            permission.func_150255_a(new Style().func_150238_a(TextFormatting.WHITE).func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tardis-admin data-change " + tardis.getTardisData().getTardisID() + " permissions companions")).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Change the permission level (TAB to autocomplete permission level)"))));
                        }
                        WTAILA.sendMessage((ICommandSender)player, (ITextComponent)permission);
                        return;
                    }
                    WTAILA.sendMessage(sender, TextFormatting.RED + "null");
                    return;
                }
                WTAILA.sendMessage(sender, TextFormatting.RED + "Not a TARDIS");
                return;
            }
            WTAILA.sendMessage(sender, TextFormatting.RED + "Not a TARDIS");
        }
    }

    public static class Companion
    extends SubCommand {
        public Companion(String[] name) {
            super(name);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length > 1) {
                EntityPlayerMP player = Companion.func_71521_c((ICommandSender)sender);
                int tardisID = 0;
                BlockPos tardis_pos = null;
                TileEntityTardis tardis = null;
                boolean found = false;
                if (args.length == 3) {
                    tardisID = Companion.func_175755_a((String)args[2]);
                } else if (args.length == 5) {
                    Vector3d coords = new Vector3d(Companion.func_175770_a((double)player.field_70165_t, (String)args[2], (boolean)true).func_179628_a(), Companion.func_175770_a((double)player.field_70163_u, (String)args[3], (boolean)true).func_179628_a(), Companion.func_175770_a((double)player.field_70161_v, (String)args[4], (boolean)true).func_179628_a());
                    tardis_pos = new BlockPos(coords.x, coords.y, coords.z);
                    if (player.field_70170_p.func_180495_p(tardis_pos).func_177230_c() == DMBlocks.TARDIS && player.func_130014_f_().func_175625_s(tardis_pos) instanceof TileEntityTardis) {
                        found = true;
                        tardis = (TileEntityTardis)player.func_130014_f_().func_175625_s(tardis_pos);
                        if (tardis.getTardisData() != null) {
                            tardisID = tardis.getTardisData().getTardisID();
                        }
                    }
                } else {
                    Vec3d start = player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
                    for (int i = 0; i < 64; ++i) {
                        tardis_pos = new BlockPos(start = start.func_178787_e(player.func_70040_Z()));
                        if (!player.field_70170_p.func_180495_p(tardis_pos).func_177230_c().func_176223_P().func_185913_b()) continue;
                        found = true;
                        break;
                    }
                    if (found) {
                        if (player.func_130014_f_().func_175625_s(tardis_pos) instanceof TileEntityTardis) {
                            found = true;
                            tardis = (TileEntityTardis)player.func_130014_f_().func_175625_s(tardis_pos);
                            if (tardis.getTardisData() != null) {
                                tardisID = tardis.getTardisData().getTardisID();
                            }
                        } else {
                            found = false;
                        }
                    }
                    if (!found) {
                        ITardisCapability capa = (ITardisCapability)player.getCapability(CapabilityTardis.FLIGHTMODE_CAP, null);
                        tardisID = capa.getTARDISID();
                    }
                    if (player.field_70170_p.field_73011_w.getDimension() == DMDimensions.DIM_TARDIS_ID) {
                        tardisID = DMTardis.getIDForXZ((int)player.field_70165_t, (int)player.field_70161_v);
                    }
                }
                String companion = args[1].replaceAll("@s", sender.func_70005_c_()).replaceAll("@p", sender.func_70005_c_());
                TardisData data = DMTardis.getTardis(tardisID);
                switch (args[0]) {
                    case "add": {
                        GameProfile profile = sender.func_184102_h().func_152358_ax().func_152655_a(companion);
                        if (profile != null) {
                            UUID uuid = profile.getId();
                            if (uuid == null || !(sender instanceof EntityPlayerMP)) {
                                uuid = UUID.fromString(DMUtils.getUUIDs(companion.replaceAll("@p", sender.func_70005_c_())));
                            }
                            if (uuid == null) {
                                PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)Companion.func_71521_c((ICommandSender)sender), TextFormatting.RED + "Player " + companion + " does not exist.");
                                return;
                            }
                            if (uuid != null && data != null) {
                                if (data.getCompanions() != null && data.getCompanions().size() > 0) {
                                    for (PlayerData pd : data.getCompanions()) {
                                        UUID tempUUID = pd.getPlayerUUID();
                                        if (!tempUUID.equals(uuid)) continue;
                                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)Companion.func_71521_c((ICommandSender)sender), TextFormatting.RED + "Player " + companion + " already a companion.");
                                        return;
                                    }
                                }
                                data.getCompanions().add(new PlayerData(uuid, companion));
                                data.setTardisPermissions(TardisPermission.COMPANIONS);
                                if (sender instanceof EntityPlayerMP) {
                                    PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)Companion.func_71521_c((ICommandSender)sender), TextFormatting.YELLOW + "Added " + companion + " to the TARDIS(" + data.getTardisID() + ")");
                                }
                            }
                        }
                        return;
                    }
                    case "remove": {
                        if (data != null) {
                            data.removeCompanion(companion);
                            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)Companion.func_71521_c((ICommandSender)sender), TextFormatting.YELLOW + "Removed " + companion + " from the TARDIS(" + data.getTardisID() + ")");
                        }
                        return;
                    }
                    case "list": {
                        if (data == null) break;
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.YELLOW + "TARDIS(" + data.getTardisID() + ") current companions are:");
                        StringBuilder b = new StringBuilder();
                        for (PlayerData pData : data.getCompanions()) {
                            b.append(pData.getUsername() + ", ");
                        }
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, b.toString());
                        break;
                    }
                    default: {
                        Companion.sendMessage(sender, TextFormatting.RED + "Usage: " + this.func_71518_a(sender));
                        return;
                    }
                }
                TardisSaveHandler.saveTardis(data);
                return;
            }
            Companion.sendMessage(sender, TextFormatting.RED + "Usage: " + this.func_71518_a(sender));
        }
    }

    public static class Remove
    extends SubCommand {
        public Remove(String[] name) {
            super(name);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length > 1) {
                EntityPlayerMP player = Remove.func_71521_c((ICommandSender)sender);
                int tardisID = Remove.func_175755_a((String)args[1]);
                boolean auto = args[0].equalsIgnoreCase("automatic");
                if (auto) {
                    Remove.sendMessage(sender, TextFormatting.RED + "Warning! automatic mode can be laggy on the server!");
                }
                if (args.length > 2) {
                    int to_tardisID = Remove.func_175755_a((String)args[2]);
                    for (int i = tardisID; i < to_tardisID + 1; ++i) {
                        TardisData data = DMTardis.getTardis(i);
                        if (!DMTardis.removeTardis(data, (EntityPlayer)player, auto)) continue;
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.RED + "Removed TARDIS with ID: " + data.getTardisID());
                    }
                    return;
                }
                TardisData data = DMTardis.getTardis(tardisID);
                if (DMTardis.removeTardis(data, (EntityPlayer)player, auto)) {
                    PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.RED + "Removed TARDIS with ID: " + data.getTardisID());
                    return;
                }
            }
            Remove.sendMessage(sender, TextFormatting.RED + "Usage: " + this.func_71518_a(sender));
        }
    }

    public static class ToggleLock
    extends SubCommand {
        public ToggleLock(String[] name) {
            super(name);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            EntityPlayerMP player = ToggleLock.func_71521_c((ICommandSender)sender);
            BlockPos tardis_pos = null;
            int tardisID = 0;
            TileEntityTardis tardis = null;
            boolean found = false;
            if (args.length == 1) {
                tardisID = ToggleLock.func_175755_a((String)args[0]);
            } else if (args.length == 3) {
                Vector3d coords = new Vector3d(ToggleLock.func_175770_a((double)player.field_70165_t, (String)args[0], (boolean)true).func_179628_a(), ToggleLock.func_175770_a((double)player.field_70163_u, (String)args[1], (boolean)true).func_179628_a(), ToggleLock.func_175770_a((double)player.field_70161_v, (String)args[2], (boolean)true).func_179628_a());
                tardis_pos = new BlockPos(coords.x, coords.y, coords.z);
                if (player.field_70170_p.func_180495_p(tardis_pos).func_177230_c() == DMBlocks.TARDIS && player.func_130014_f_().func_175625_s(tardis_pos) instanceof TileEntityTardis) {
                    found = true;
                    tardis = (TileEntityTardis)player.func_130014_f_().func_175625_s(tardis_pos);
                    if (tardis.getTardisData() != null) {
                        tardisID = tardis.getTardisData().getTardisID();
                    }
                }
            } else {
                Vec3d start = player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
                for (int i = 0; i < 64; ++i) {
                    tardis_pos = new BlockPos(start = start.func_178787_e(player.func_70040_Z()));
                    if (!player.field_70170_p.func_180495_p(tardis_pos).func_177230_c().func_176223_P().func_185913_b()) continue;
                    found = true;
                    break;
                }
                if (found) {
                    if (player.func_130014_f_().func_175625_s(tardis_pos) instanceof TileEntityTardis) {
                        found = true;
                        tardis = (TileEntityTardis)player.func_130014_f_().func_175625_s(tardis_pos);
                        if (tardis.getTardisData() != null) {
                            tardisID = tardis.getTardisData().getTardisID();
                        }
                    } else {
                        found = false;
                    }
                }
                if (!found) {
                    ITardisCapability capa = (ITardisCapability)player.getCapability(CapabilityTardis.FLIGHTMODE_CAP, null);
                    tardisID = capa.getTARDISID();
                }
                if (player.field_70170_p.field_73011_w.getDimension() == DMDimensions.DIM_TARDIS_ID) {
                    tardisID = DMTardis.getIDForXZ((int)player.field_70165_t, (int)player.field_70161_v);
                }
            }
            TardisData data = DMTardis.getTardis(tardisID);
            if (data != null && tardisID > 0) {
                data.setLocked(data.isLocked());
                TardisSaveHandler.saveTardis(data);
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "You have force " + (data.isLocked() ? "locked " : "unlocked ") + data.getOwner() + "'s Tardis(" + data.getTardisID() + ")"));
                return;
            }
            ToggleLock.sendMessage(sender, TextFormatting.RED + "Usage: " + this.func_71518_a(sender));
        }
    }

    public static class ToggleOpen
    extends SubCommand {
        public ToggleOpen(String[] name) {
            super(name);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            ChameleonCircuitBase skin;
            EntityPlayerMP player = ToggleOpen.func_71521_c((ICommandSender)sender);
            BlockPos tardis_pos = null;
            int tardisID = 0;
            TileEntityTardis tardis = null;
            boolean found = false;
            if (args.length == 1) {
                found = true;
                tardisID = ToggleOpen.func_175755_a((String)args[0]);
            } else if (args.length == 3) {
                Vector3d coords = new Vector3d(ToggleOpen.func_175770_a((double)player.field_70165_t, (String)args[0], (boolean)true).func_179628_a(), ToggleOpen.func_175770_a((double)player.field_70163_u, (String)args[1], (boolean)true).func_179628_a(), ToggleOpen.func_175770_a((double)player.field_70161_v, (String)args[2], (boolean)true).func_179628_a());
                tardis_pos = new BlockPos(coords.x, coords.y, coords.z);
                if (player.field_70170_p.func_180495_p(tardis_pos).func_177230_c() == DMBlocks.TARDIS && player.func_130014_f_().func_175625_s(tardis_pos) instanceof TileEntityTardis) {
                    found = true;
                    tardis = (TileEntityTardis)player.func_130014_f_().func_175625_s(tardis_pos);
                    if (tardis.getTardisData() != null) {
                        tardisID = tardis.getTardisData().getTardisID();
                    }
                }
            } else {
                Vec3d start = player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
                for (int i = 0; i < 64; ++i) {
                    tardis_pos = new BlockPos(start = start.func_178787_e(player.func_70040_Z()));
                    if (!player.field_70170_p.func_180495_p(tardis_pos).func_177230_c().func_176223_P().func_185913_b()) continue;
                    found = true;
                    break;
                }
                if (found) {
                    if (player.func_130014_f_().func_175625_s(tardis_pos) instanceof TileEntityTardis) {
                        found = true;
                        tardis = (TileEntityTardis)player.func_130014_f_().func_175625_s(tardis_pos);
                        if (tardis.getTardisData() != null) {
                            tardisID = tardis.getTardisData().getTardisID();
                        }
                    } else {
                        found = false;
                    }
                }
                if (!found) {
                    ITardisCapability capa = (ITardisCapability)player.getCapability(CapabilityTardis.FLIGHTMODE_CAP, null);
                    tardisID = capa.getTARDISID();
                }
                if (player.field_70170_p.field_73011_w.getDimension() == DMDimensions.DIM_TARDIS_ID) {
                    tardisID = DMTardis.getIDForXZ((int)player.field_70165_t, (int)player.field_70161_v);
                }
            }
            TardisData data = DMTardis.getTardis(tardisID);
            WorldServer worldserver = player.func_184102_h().func_71218_a(data.getTardisCurrentdimension());
            tardis_pos = new BlockPos(data.getCurrentTardisPosition().x, data.getCurrentTardisPosition().y, data.getCurrentTardisPosition().z);
            if (worldserver.func_180495_p(tardis_pos).func_177230_c() == DMBlocks.TARDIS && player.func_130014_f_().func_175625_s(tardis_pos) instanceof TileEntityTardis) {
                tardis = (TileEntityTardis)player.func_130014_f_().func_175625_s(tardis_pos);
            }
            if (tardis != null) {
                BlockTardis.getSkin(player.field_70170_p, tardis_pos).onRightClick(player.field_70170_p, (EntityPlayer)player, tardis_pos, tardis, true, false);
                return;
            }
            if (server != null && (skin = DMTardis.getTardisSkin(data.getExteriorID())) != null && skin.hasDoorRotation()) {
                PacketHandler.INSTANCE.sendToDimension((IMessage)new Packet_TardisDoors(WorldUtils.vec3ToBlockPos(data.getCurrentTardisPosition()), !data.isDoorOpen()), worldserver.field_73011_w.getDimension());
                data.setDoorOpen(!data.isDoorOpen());
                TardisSaveHandler.saveTardis(data);
                DMSounds.playSound((EntityPlayer)player, data.isDoorOpen() ? skin.doorSound(ChameleonCircuitBase.DoorState.OPEN) : skin.doorSound(ChameleonCircuitBase.DoorState.CLOSED), SoundCategory.BLOCKS, player.func_180425_c(), 1.0f, 1.0f);
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "You have force " + (data.isDoorOpen() ? "opened " : "closed ") + "the TARDIS(" + data.getTardisID() + ")'s Doors"));
                return;
            }
            ToggleOpen.sendMessage(sender, TextFormatting.RED + "Usage: " + this.func_71518_a(sender));
        }
    }

    public static class Summon
    extends SubCommand {
        public Summon(String[] name) {
            super(name);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            EntityPlayerMP player = Summon.func_71521_c((ICommandSender)sender);
            ITardisCapability capa = (ITardisCapability)player.getCapability(CapabilityTardis.FLIGHTMODE_CAP, null);
            int tardisID = capa.getTARDISID();
            BlockPos landpos = player.func_180425_c();
            if (server.func_71264_H()) {
                RayTraceResult trace = player.func_174822_a(16.0, 1.0f);
                landpos = trace.func_178782_a();
            } else {
                Vec3d start = player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
                boolean found = false;
                for (int i = 0; i < 64; ++i) {
                    landpos = new BlockPos(start = start.func_178787_e(player.func_70040_Z()));
                    if (player.field_70170_p.func_180495_p(landpos).func_177230_c().func_176223_P().func_185913_b()) {
                        found = true;
                        break;
                    }
                    if (found) continue;
                    landpos = player.func_180425_c();
                }
            }
            boolean calc = true;
            float rotation = player.func_70079_am();
            World world = player.field_70170_p;
            if (args.length > 0) {
                tardisID = Summon.func_175755_a((String)args[0]);
            }
            TardisData data = DMTardis.getTardis(tardisID);
            if (args.length > 3) {
                int x = (int)(Math.random() * server.func_71218_a(0).func_175723_af().func_177741_h() - server.func_71218_a(0).func_175723_af().func_177741_h() / 2.0);
                int z = (int)(Math.random() * server.func_71218_a(0).func_175723_af().func_177741_h() - server.func_71218_a(0).func_175723_af().func_177741_h() / 2.0);
                Vector3d landcoords = new Vector3d(Summon.func_175770_a((double)player.field_70165_t, (String)args[1].replaceAll("(.*)r", "" + x), (boolean)true).func_179628_a(), Summon.func_175770_a((double)player.field_70163_u, (String)args[2].replaceAll("(.*)r", "64"), (boolean)true).func_179628_a(), Summon.func_175770_a((double)player.field_70161_v, (String)args[3].replaceAll("(.*)r", "" + z), (boolean)true).func_179628_a());
                landpos = new BlockPos(landcoords.x, landcoords.y, landcoords.z);
                if (!WorldUtils.isInWorldBounds(new Vector3(landpos.func_177958_n(), landpos.func_177956_o(), landpos.func_177952_p()))) {
                    Summon.sendMessage(sender, TextFormatting.RED + "TARDIS Cannot land outside the world border");
                    return;
                }
                if (args.length > 4) {
                    rotation = (float)Summon.func_175765_c((String)args[4].replaceAll("r", "" + Math.random() * 360.0));
                }
                if (args.length > 5 && Summon.func_175755_a((String)args[5]) != DMDimensions.DIM_TARDIS_ID) {
                    world = server.func_71218_a(Summon.func_175755_a((String)args[5]));
                }
                if (args.length > 6) {
                    calc = Summon.func_180527_d((String)args[6]);
                }
            }
            if (calc) {
                for (int i = 1; i < 255 && (world.func_180495_p(landpos = new BlockPos(landpos.func_177958_n(), i, landpos.func_177952_p())).func_185913_b() || !world.func_180495_p(landpos.func_177982_a(0, -1, 0)).func_185913_b()); ++i) {
                }
            }
            if (WorldUtils.summonTardisToPos(world, data, landpos, rotation) == EnumActionResult.SUCCESS) {
                data.setTardisCurrentDimensionLocation(world.field_73011_w.getDimension());
            }
            data.setTardisDestinationDimension(world.field_73011_w.getDimension());
            data.setCurrentTardisPosition(new Vector3(landpos.func_177958_n(), landpos.func_177956_o(), landpos.func_177952_p()));
            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + "Summoned Tardis with ID: " + data.getTardisID() + " to " + landpos.func_177958_n() + "|" + landpos.func_177956_o() + "|" + landpos.func_177952_p() + " DIM: " + world.field_73011_w.func_186058_p().func_186065_b());
            TardisSaveHandler.saveTardis(data);
        }
    }

    public static class SetOwner
    extends SubCommand {
        public SetOwner(String[] name) {
            super(name);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length == 2) {
                String owner = args[1];
                int id = SetOwner.func_175755_a((String)args[0]);
                TardisData data = DMTardis.getTardis(id);
                if (sender.func_184102_h().func_152358_ax().func_152655_a(owner) != null) {
                    UUID uuid = sender.func_184102_h().func_152358_ax().func_152655_a(owner).getId();
                    if (uuid == null || !(sender instanceof EntityPlayerMP)) {
                        uuid = UUID.fromString(DMUtils.getUUIDs(owner.replaceAll("@p", sender.func_70005_c_())));
                    }
                    if (uuid == null) {
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)SetOwner.func_71521_c((ICommandSender)sender), TextFormatting.RED + "Player " + owner + " does not exist.");
                        return;
                    }
                    if (uuid != null) {
                        UserTardises uTarOld = DMTardis.getUserTardises(data.getCurrentOwner());
                        UserTardises uTarNew = DMTardis.getUserTardises(uuid);
                        uTarOld.getTardises().removeAll(Arrays.asList(data.getTardisID()));
                        uTarNew.addTardis(data.getTardisID());
                        DMTardis.updateUserTardisData(uTarOld, data.getCurrentOwner());
                        DMTardis.updateUserTardisData(uTarNew, uuid);
                        data.setCurrentOwner(uuid);
                        data.setOwner(owner.replaceAll("@p", sender.func_70005_c_()));
                        TardisSaveHandler.saveTardis(data);
                        SetOwner.sendMessage(sender, TextFormatting.YELLOW + "You have transferred TARDIS(" + data.getTardisID() + ") ownership to " + data.getOwner());
                    }
                }
                return;
            }
            SetOwner.sendMessage(sender, TextFormatting.RED + "Usage: " + this.func_71518_a(sender));
        }
    }

    public static class SubCommand
    extends CommandTreeBase {
        private String[] name;

        public SubCommand(String[] name) {
            this.name = name;
        }

        public String func_71517_b() {
            return this.name[0];
        }

        public String func_71518_a(ICommandSender sender) {
            StringBuilder b = new StringBuilder();
            for (int i = 1; i < this.name.length; ++i) {
                b.append(" [" + this.name[i] + "]");
            }
            return "/tardis-admin " + this.func_71517_b() + b.toString();
        }

        public static void sendMessage(ICommandSender sender, String message) throws PlayerNotFoundException {
            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)SubCommand.func_71521_c((ICommandSender)sender), message);
        }

        public static void sendMessage(ICommandSender sender, ITextComponent message) throws PlayerNotFoundException {
            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)SubCommand.func_71521_c((ICommandSender)sender), message);
        }

        public static String[] split(String s) {
            return s.split(",");
        }

        public static boolean eqArg(String s, String a) {
            return a.equalsIgnoreCase(s);
        }

        private List<String> func_32984594(int i, MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
            EntityPlayerMP p = null;
            try {
                p = SubCommand.func_71521_c((ICommandSender)sender);
            }
            catch (PlayerNotFoundException e) {
                e.printStackTrace();
            }
            String[] dim_ids = new String[DimensionManager.getIDs().length];
            for (int j = 0; j < dim_ids.length; ++j) {
                dim_ids[j] = "" + DimensionManager.getIDs()[j];
            }
            if (this.name.length > i) {
                switch (this.name[i]) {
                    case "tardis_id": {
                        if (p != null && p.field_70170_p.field_73011_w.getDimension() == DMDimensions.DIM_TARDIS_ID) {
                            return SubCommand.func_71530_a((String[])args, (String[])new String[]{"" + DMTardis.getIDForXZ(sender.func_180425_c().func_177958_n(), sender.func_180425_c().func_177952_p())});
                        }
                        return SubCommand.func_71530_a((String[])args, (String[])DMTardis.getTardisListAsArray());
                    }
                    case "player": {
                        return SubCommand.func_71530_a((String[])args, (String[])server.func_71213_z());
                    }
                    case "x": {
                        if (targetPos != null) {
                            return SubCommand.func_71530_a((String[])args, (String[])new String[]{"" + targetPos.func_177958_n()});
                        }
                        return SubCommand.func_71530_a((String[])args, (String[])new String[]{"~"});
                    }
                    case "y": {
                        if (targetPos != null) {
                            return SubCommand.func_71530_a((String[])args, (String[])new String[]{"" + targetPos.func_177956_o()});
                        }
                        return SubCommand.func_71530_a((String[])args, (String[])new String[]{"~"});
                    }
                    case "z": {
                        if (targetPos != null) {
                            return SubCommand.func_71530_a((String[])args, (String[])new String[]{"" + targetPos.func_177952_p()});
                        }
                        return SubCommand.func_71530_a((String[])args, (String[])new String[]{"~"});
                    }
                    case "rotation": {
                        if (p != null) {
                            // empty if block
                        }
                        return SubCommand.func_71530_a((String[])args, (String[])new String[]{"" + (int)(p.func_70079_am() < 0.0f ? p.func_70079_am() + 360.0f : p.func_70079_am())});
                    }
                    case "dimension": {
                        if (p != null) {
                            return SubCommand.func_71530_a((String[])args, (String[])dim_ids);
                        }
                    }
                    case "boolean": {
                        return SubCommand.func_71530_a((String[])args, (String[])new String[]{"true", "false"});
                    }
                }
                return SubCommand.func_71530_a((String[])args, (String[])SubCommand.split(this.name[i]));
            }
            return SubCommand.func_71530_a((String[])args, (String[])new String[]{""});
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
            switch (args.length) {
                case 1: {
                    return this.func_32984594(1, server, sender, args, targetPos);
                }
                case 2: {
                    return this.func_32984594(2, server, sender, args, targetPos);
                }
                case 3: {
                    return this.func_32984594(3, server, sender, args, targetPos);
                }
                case 4: {
                    return this.func_32984594(4, server, sender, args, targetPos);
                }
                case 5: {
                    return this.func_32984594(5, server, sender, args, targetPos);
                }
                case 6: {
                    return this.func_32984594(6, server, sender, args, targetPos);
                }
                case 7: {
                    return this.func_32984594(7, server, sender, args, targetPos);
                }
                case 8: {
                    return this.func_32984594(8, server, sender, args, targetPos);
                }
            }
            return super.func_184883_a(server, sender, args, targetPos);
        }
    }
}

