/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.init;

import com.swdteam.common.init.DMBlocks;
import com.swdteam.common.init.DMSchematics;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tardis.data.TardisInterior;
import com.swdteam.common.tileentity.TileEntityTardisDisplay;
import com.swdteam.main.TheDalekMod;
import com.swdteam.utils.world.SchematicUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DMTardisInteriors {
    private static List<TardisInterior> interiors = new ArrayList<TardisInterior>();
    public static TardisInterior TARDIS_DEFAULT;
    public static TardisInterior INTERIOR_2010;
    public static TardisInterior INTERIOR_ALPHA;
    public static TardisInterior INTERIOR_AMBIENT;
    public static TardisInterior INTERIOR_BETA;
    public static TardisInterior INTERIOR_BILL_TED;
    public static TardisInterior INTERIOR_BLOCKTOR;
    public static TardisInterior INTERIOR_CHRONOTIS;
    public static TardisInterior INTERIOR_CLASSIC;
    public static TardisInterior INTERIOR_CORAL;
    public static TardisInterior INTERIOR_CRYSTALINE;
    public static TardisInterior INTERIOR_DM_A;
    public static TardisInterior INTERIOR_DM_B;
    public static TardisInterior INTERIOR_DM_C;
    public static TardisInterior INTERIOR_DM_D;
    public static TardisInterior INTERIOR_ED;
    public static TardisInterior INTERIOR_EIGHTH_DOCTOR;
    public static TardisInterior INTERIOR_EPSIMO;
    public static TardisInterior INTERIOR_FLORAL;
    public static TardisInterior INTERIOR_FOURTH_SECONDARY;
    public static TardisInterior INTERIOR_FRIDGE;
    public static TardisInterior INTERIOR_GALLIFREY_WARDROBE;
    public static TardisInterior INTERIOR_GERONIMO;
    public static TardisInterior INTERIOR_GINGERBREAD;
    public static TardisInterior INTERIOR_GIZMO;
    public static TardisInterior INTERIOR_GRANDFATHER_CLOCK;
    public static TardisInterior INTERIOR_FIRST_DOCTOR;
    public static TardisInterior INTERIOR_HELLBENT;
    public static TardisInterior INTERIOR_HEXON;
    public static TardisInterior INTERIOR_POKEBALL;
    public static TardisInterior INTERIOR_RANI;
    public static TardisInterior INTERIOR_RUTH_DOCTOR;
    public static TardisInterior INTERIOR_SECOND_DOCTOR;
    public static TardisInterior INTERIOR_SHED;
    public static TardisInterior INTERIOR_ETHO;
    public static TardisInterior INTERIOR_TEMPUS;
    public static TardisInterior INTERIOR_TOYOTA;
    public static TardisInterior INTERIOR_TUD;
    public static TardisInterior INTERIOR_VANILLA;
    public static TardisInterior INTERIOR_VENDING_MACHINE;
    public static TardisInterior INTERIOR_WAR_DOCTOR;
    public static TardisInterior INTERIOR_WARDROBE;
    public static TardisInterior INTERIOR_YBLOCKS_K2;
    public static TardisInterior INTERIOR_BLANK_TEMPLATE;
    public static TardisInterior INTERIOR_NETHER;
    public static TardisInterior INTERIOR_DELTA;
    public static TardisInterior INTERIOR_GAMMA;
    public static TardisInterior INTERIOR_SB129;
    public static TardisInterior INTERIOR_TIME_LEAK;
    public static TardisInterior INTERIOR_RGB;
    public static TardisInterior INTERIOR_2013;
    public static TardisInterior INTERIOR_ZETA;
    public static TardisInterior INTERIOR_STORYMODE;

    public static void init() {
        interiors.clear();
        TARDIS_DEFAULT = DMTardisInteriors.getInterior("dm_default");
        INTERIOR_2010 = DMTardisInteriors.getInterior("2010_int");
        INTERIOR_ALPHA = DMTardisInteriors.getInterior("alpha_int");
        INTERIOR_AMBIENT = DMTardisInteriors.getInterior("ambient_int");
        INTERIOR_BETA = DMTardisInteriors.getInterior("beta_int");
        INTERIOR_BILL_TED = DMTardisInteriors.getInterior("bill_ted_int");
        INTERIOR_BLOCKTOR = DMTardisInteriors.getInterior("blocktor_int");
        INTERIOR_CHRONOTIS = DMTardisInteriors.getInterior("chronotis_int");
        INTERIOR_CLASSIC = DMTardisInteriors.getInterior("classic_int");
        INTERIOR_CORAL = DMTardisInteriors.getInterior("coral_int");
        INTERIOR_CRYSTALINE = DMTardisInteriors.getInterior("crystaline_int");
        INTERIOR_DM_A = DMTardisInteriors.getInterior("dm_a_int");
        INTERIOR_DM_B = DMTardisInteriors.getInterior("dm_b_int");
        INTERIOR_DM_C = DMTardisInteriors.getInterior("dm_c_int");
        INTERIOR_DM_D = DMTardisInteriors.getInterior("dm_d_int");
        INTERIOR_ED = DMTardisInteriors.getInterior("ed_interior");
        INTERIOR_EIGHTH_DOCTOR = DMTardisInteriors.getInterior("eight_int");
        INTERIOR_EPSIMO = DMTardisInteriors.getInterior("epsimo_int").setGenerator(new InteriorGenerator(){

            @Override
            public void generate(World w, BlockPos p, TardisData data) {
                BlockPos displayPos = p.func_177982_a(14, 17, 23);
                w.func_175656_a(displayPos, DMBlocks.bTeTardisDisplay.func_176223_P());
                TileEntityTardisDisplay display = (TileEntityTardisDisplay)w.func_175625_s(displayPos);
                display.setTardisID(data.getTardisID());
                display.rotation = 270.0f;
                display.ignoreSetup = true;
                display.func_70296_d();
                display.sendUpdates();
            }
        });
        INTERIOR_FLORAL = DMTardisInteriors.getInterior("floral");
        INTERIOR_FOURTH_SECONDARY = DMTardisInteriors.getInterior("fourth_secondary");
        INTERIOR_FRIDGE = DMTardisInteriors.getInterior("fridge_int");
        INTERIOR_GALLIFREY_WARDROBE = DMTardisInteriors.getInterior("gallifrey_wardrobe");
        INTERIOR_GERONIMO = DMTardisInteriors.getInterior("ger_tar");
        INTERIOR_GINGERBREAD = DMTardisInteriors.getInterior("gingerbread_interior");
        INTERIOR_GIZMO = DMTardisInteriors.getInterior("gizmo_int");
        INTERIOR_GRANDFATHER_CLOCK = DMTardisInteriors.getInterior("grandfather_interior");
        INTERIOR_FIRST_DOCTOR = DMTardisInteriors.getInterior("hartnell_int");
        INTERIOR_HELLBENT = DMTardisInteriors.getInterior("hellbent_int");
        INTERIOR_HEXON = DMTardisInteriors.getInterior("hex_int");
        INTERIOR_POKEBALL = DMTardisInteriors.getInterior("pokeball_int");
        INTERIOR_RANI = DMTardisInteriors.getInterior("rani_int");
        INTERIOR_RUTH_DOCTOR = DMTardisInteriors.getInterior("ruth_interior");
        INTERIOR_SECOND_DOCTOR = DMTardisInteriors.getInterior("second_int");
        INTERIOR_SHED = DMTardisInteriors.getInterior("shed_int");
        INTERIOR_ETHO = DMTardisInteriors.getInterior("spaceblock");
        INTERIOR_TEMPUS = DMTardisInteriors.getInterior("tempus_int").setGenerator(new InteriorGenerator(){

            @Override
            public void generate(World w, BlockPos p, TardisData data) {
                BlockPos displayPos = p.func_177982_a(24, 12, 19);
                w.func_175656_a(displayPos, DMBlocks.bTeTardisDisplay.func_176223_P());
                TileEntityTardisDisplay display = (TileEntityTardisDisplay)w.func_175625_s(displayPos);
                display.setTardisID(data.getTardisID());
                display.rotation = 360.0f;
                display.ignoreSetup = true;
                display.func_70296_d();
                display.sendUpdates();
            }
        });
        INTERIOR_TOYOTA = DMTardisInteriors.getInterior("toyota_int");
        INTERIOR_TUD = DMTardisInteriors.getInterior("tud_tardis");
        INTERIOR_VANILLA = DMTardisInteriors.getInterior("vanilla_int");
        INTERIOR_VENDING_MACHINE = DMTardisInteriors.getInterior("vending_int");
        INTERIOR_WAR_DOCTOR = DMTardisInteriors.getInterior("war_int");
        INTERIOR_WARDROBE = DMTardisInteriors.getInterior("wardrobe_int");
        INTERIOR_YBLOCKS_K2 = DMTardisInteriors.getInterior("yblocks_k2");
        INTERIOR_BLANK_TEMPLATE = DMTardisInteriors.getInterior("blank_template");
        INTERIOR_NETHER = DMTardisInteriors.getInterior("nether_int");
        INTERIOR_DELTA = DMTardisInteriors.getInterior("delta_int");
        INTERIOR_GAMMA = DMTardisInteriors.getInterior("gamma_int");
        INTERIOR_SB129 = DMTardisInteriors.getInterior("sb129_int");
        INTERIOR_TIME_LEAK = DMTardisInteriors.getInterior("time_leek_int");
        INTERIOR_RGB = DMTardisInteriors.getInterior("rgb_int");
        INTERIOR_2013 = DMTardisInteriors.getInterior("2013_int");
        INTERIOR_ZETA = DMTardisInteriors.getInterior("zeta_int");
        INTERIOR_STORYMODE = DMTardisInteriors.getInterior("storymode_int");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TardisInterior getInterior(String path) {
        InputStream stream = SchematicUtils.class.getResourceAsStream("/assets/thedalekmod/tardis/interior/" + path + ".json");
        InputStreamReader reader = new InputStreamReader(stream);
        BufferedReader br = new BufferedReader(reader);
        StringBuffer sb = new StringBuffer();
        String s = null;
        try {
            while ((s = br.readLine()) != null) {
                sb.append(s);
            }
            TardisInterior interior = (TardisInterior)TheDalekMod.GSON.fromJson(sb.toString(), TardisInterior.class);
            if (interior != null) {
                if (interior.getFileLocation() == null) {
                    interior.setFileLocation(SchematicUtils.FileLocation.EXTERNAL);
                }
                if (interior.getCdnPath() != null && !interior.getCdnPath().equalsIgnoreCase("null")) {
                    interior.setSchematic(DMSchematics.loadSchematic(interior.getCdnPath(), interior.getFileLocation()));
                }
            }
            interiors.add(interior);
            TardisInterior tardisInterior = interior;
            return tardisInterior;
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        finally {
            try {
                stream.close();
                reader.close();
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static List<TardisInterior> getInteriors() {
        return interiors;
    }

    public static interface InteriorGenerator {
        public void generate(World var1, BlockPos var2, TardisData var3);
    }
}

