/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.item;

import com.swdteam.common.capability.CapabilityTardis;
import com.swdteam.common.capability.interfaces.ITardisCapability;
import com.swdteam.common.init.DMBlocks;
import com.swdteam.common.init.DMSounds;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tardis.data.chameleon.ChameleonCircuitBase;
import com.swdteam.common.tileentity.tardis.TileEntityTardis;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_TardisDoors;
import com.swdteam.utils.PlayerUtils;
import com.swdteam.utils.WorldUtils;
import com.swdteam.utils.math.MathUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ItemTardisKey
extends Item {
    private boolean invisAblity;

    public ItemTardisKey(boolean invis) {
        this.func_77625_d(1);
        this.invisAblity = invis;
    }

    public void toggleCloak(EntityPlayer player) {
        World w = player.field_70170_p;
        player.func_184185_a(DMSounds.sonicScrewdriver, 1.0f, 0.7f);
        if (!w.field_72995_K) {
            PlayerUtils.Messaging.sendStatusMessageToPlayer(player, "Your tardis key cloaks you temporarly", true);
            player.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 1000, 9, false, false));
        }
    }

    public boolean onEntitySwing(EntityLivingBase player, ItemStack stack) {
        if (player instanceof EntityPlayer && player.func_70093_af() && this.invisAblity) {
            this.toggleCloak((EntityPlayer)player);
        }
        return super.onEntitySwing(player, stack);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (!world.field_72995_K) {
            TileEntityTardis tet;
            TardisData data;
            ItemStack stack = player.func_184586_b(hand);
            TileEntity te = world.func_175625_s(pos);
            if (te != null && te instanceof TileEntityTardis && (data = (tet = (TileEntityTardis)te).getTardisData()) != null) {
                if (data.getCurrentOwner() == null && data.getOwner().equals(player.func_70005_c_())) {
                    data.setCurrentOwner(player.func_110124_au());
                    TardisSaveHandler.saveTardis(data);
                }
                data.setTravelRotation(tet.rotation);
                if (DMTardis.hasPermission(data, player)) {
                    if (!player.func_70093_af()) {
                        boolean b = data.isLocked();
                        data.setLocked(!b);
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "You have " + (b ? "unlocked" : "locked") + " your Tardis"));
                        DMSounds.playSound(player, DMSounds.tardisKeyLock, SoundCategory.BLOCKS, pos, 1.0f, 1.0f);
                        if (data.isDoorOpen()) {
                            data.setDoorOpen(false);
                            PacketHandler.INSTANCE.sendToAllAround((IMessage)new Packet_TardisDoors(pos, false), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 50.0));
                            ChameleonCircuitBase skin = DMTardis.getTardisSkin(data.getExteriorID());
                            DMSounds.playSound(player, skin.doorSound(ChameleonCircuitBase.DoorState.CLOSED), SoundCategory.BLOCKS, pos, 1.0f, 1.0f);
                        }
                        TardisSaveHandler.saveTardis(data);
                        return EnumActionResult.PASS;
                    }
                    if (!stack.func_77942_o()) {
                        stack.func_77982_d(new NBTTagCompound());
                    }
                    if (stack.func_77978_p().func_74764_b("tardis_id")) {
                        PlayerUtils.Messaging.sendMessageToPlayer(player, TextFormatting.RED + "A Tardis is already bound to this key.");
                        data.setCurrentTardisPosition(MathUtils.blockPosToVec3(tet.func_174877_v()));
                    } else {
                        stack.func_77978_p().func_74768_a("tardis_id", data.getTardisID());
                        stack.func_151001_c(TextFormatting.YELLOW + "Tardis Key: (" + TextFormatting.RED + data.getTardisID() + TextFormatting.YELLOW + ")");
                        PlayerUtils.Messaging.sendMessageToPlayer(player, TextFormatting.GREEN + "Tardis bound to key: " + TextFormatting.YELLOW + data.getTardisID());
                        data.setCurrentTardisPosition(MathUtils.blockPosToVec3(tet.func_174877_v()));
                    }
                    TardisSaveHandler.saveTardis(data);
                    return EnumActionResult.PASS;
                }
            }
            ITardisCapability capability = (ITardisCapability)player.getCapability(CapabilityTardis.FLIGHTMODE_CAP, null);
            if (world.func_180495_p(pos) != DMBlocks.TARDIS) {
                TardisData data2;
                boolean tag;
                int tardisID = capability.getTARDISID();
                boolean bl = tag = stack.func_77942_o() && stack.func_77978_p().func_74764_b("tardis_id");
                if (tag) {
                    tardisID = stack.func_77978_p().func_74762_e("tardis_id");
                }
                if (DMTardis.doesTardisExist(tardisID) && (data2 = DMTardis.getTardis(tardisID)) != null) {
                    int summoned = (int)(System.currentTimeMillis() / 1000L - data2.lastSummoned);
                    if (DMTardis.hasPermission(data2, player) && summoned >= 12) {
                        data2.lastSummoned = System.currentTimeMillis() / 1000L;
                        int i = (int)player.field_70177_z + 360;
                        if (player.func_70093_af()) {
                            int snap;
                            float angle = player.func_70079_am();
                            if (angle - (float)((snap = (int)(angle / 45.0f)) * 45) > 22.0f) {
                                ++snap;
                            }
                            i = snap * 45;
                        }
                        if (i > 360) {
                            i -= 360;
                        }
                        if (i < 0) {
                            i += 360;
                        }
                        data2.setTravelRotation(i);
                        TardisSaveHandler.saveTardis(data2);
                        if (world.func_180495_p(pos.func_177982_a(0, 1, 0)).func_177230_c() != Blocks.field_150350_a) {
                            PlayerUtils.Messaging.sendMessageToPlayer(player, TextFormatting.RED + "You can't summon that here, try somewhere else.");
                            return EnumActionResult.FAIL;
                        }
                        WorldUtils.summonTardisToPos(world, data2, pos.func_177982_a(0, 1, 0), i);
                    } else if (summoned < 12) {
                        PlayerUtils.Messaging.sendStatusMessageToPlayer(player, TextFormatting.RED + "" + (12 - summoned) + " seconds left", true);
                    }
                }
            }
        }
        return super.func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("\u00a75Used to lock your TARDIS!");
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

