/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.tardis;

import com.swdteam.common.init.DMSounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum InteriorSounds {
    DEFAULT("Default Hum", DMSounds.tardishum_default),
    WAR("War Doctor Hum", DMSounds.tardishum_war),
    NINETEN("2005-2009 Hum", DMSounds.tardishum_coral),
    SEVENTEN("Season 7-10 Hum", DMSounds.tardishum_toyota),
    THIRTEEN("Season 11 Hum", DMSounds.tardishum_thirteen),
    CLOCK("Clock Hum", DMSounds.clock_tardis_hum),
    PORTAL("Portal Hum", DMSounds.tardisPortalHum),
    NETHER("Nether Portal", SoundEvents.field_187810_eg);

    private String name;
    private SoundEvent soundEvent;

    private InteriorSounds(String n2, SoundEvent event) {
        this.name = n2;
        this.soundEvent = event;
    }

    public String getName() {
        return this.name;
    }

    public SoundEvent getSoundEvent() {
        return this.soundEvent;
    }

    @SideOnly(value=Side.CLIENT)
    public ISound getSound() {
        return new PositionedSoundRecord(this.getSoundEvent().func_187503_a(), SoundCategory.AMBIENT, 0.2f, 1.0f, false, 0, ISound.AttenuationType.NONE, 0.0f, 0.0f, 0.0f);
    }

    public static class InteriorSoundHelper {
        public static List<ISound> sound = new ArrayList<ISound>();

        public static int nextHum(int id) {
            if (id + 1 < InteriorSounds.values().length) {
                return id + 1;
            }
            return 0;
        }

        public static int getHumId(InteriorSounds e) {
            for (int i = 0; i < InteriorSounds.values().length; ++i) {
                if (!InteriorSounds.values()[i].getName().equals(e.getName())) continue;
                return i;
            }
            return 0;
        }

        public static void init() {
            if (sound.size() > 0) {
                sound.clear();
            }
            for (InteriorSounds sounds : InteriorSounds.values()) {
                sound.add(sounds.getSound());
            }
        }

        public static InteriorSounds getEnumById(int i) {
            return InteriorSounds.values()[i];
        }

        public static ISound getHumById(int i) {
            if (i < InteriorSounds.values().length && i >= 0) {
                return sound.get(i);
            }
            return sound.get(0);
        }
    }
}

