/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.utils.world;

import com.swdteam.common.init.DMBlocks;
import com.swdteam.main.DM18BlockMap;
import com.swdteam.main.TheDalekMod;
import com.swdteam.utils.world.Schematic;
import com.swdteam.utils.world.TileData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SchematicUtils {
    public static void main(String[] args) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Schematic loadSchematic(String file, FileLocation location) {
        Schematic schem = null;
        if (location == FileLocation.INTERNAL) {
            InputStream stream = SchematicUtils.class.getResourceAsStream("/assets/thedalekmod/schematics/" + file + ".schm");
            try {
                ObjectInputStream ois = new ObjectInputStream(stream);
                Object o = ois.readObject();
                ois.close();
                if (!(o instanceof Schematic)) return schem;
                schem = (Schematic)o;
                return schem;
            }
            catch (Exception e) {
                e.printStackTrace();
                return schem;
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (location != FileLocation.EXTERNAL) return schem;
        try {
            FileInputStream stream = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(stream);
            Object o = ois.readObject();
            if (o instanceof Schematic) {
                schem = (Schematic)o;
            }
            ois.close();
            return schem;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return schem;
    }

    public static void saveSchematic(Schematic schem, String fileName) {
        String fileDir = "mods/Dalek Mod/Schematics/";
        fileName = fileName + ".schm";
        try {
            File file = new File(fileDir + fileName);
            file.getParentFile().mkdirs();
            file.createNewFile();
            FileOutputStream out = new FileOutputStream(file, false);
            ObjectOutputStream stream = new ObjectOutputStream(out);
            stream.writeObject(schem);
            stream.close();
            System.out.println(file.getPath());
        }
        catch (Exception e) {
            TheDalekMod.LOG.error((Object)e);
        }
    }

    public static void generateSchematic(GenerationQueue queue, World w, BlockPos p, Schematic schem) {
        if (schem != null) {
            SchematicUtils.generateSchematic(queue, w, p, schem, BlockMap.DM_1_12_2);
        }
    }

    public static void generateSchematic(GenerationQueue queue, World w, BlockPos p, Schematic schem, BlockMap map) {
        SchematicUtils.generateSchematic(queue, w, p, schem, map, null, null);
    }

    public static void generateSchematic(GenerationQueue queue, World w, BlockPos p, Schematic schem, BlockMap map, IBlockState[] blocksToIgnore, IBlockState airBlock) {
        SchematicUtils.generateSchematic(queue, w, p, schem, map, blocksToIgnore, airBlock, null);
    }

    public static void generateSchematic(GenerationQueue queue, World w, BlockPos p, Schematic schem, BlockMap map, IBlockState[] blocksToIgnore, IBlockState airBlock, IReplaceBlockSpawn[] blockReplace) {
        int i;
        if (schem == null) {
            return;
        }
        int chunkSize = schem.getSchemDimX() * schem.getSchemDimY() * schem.getSchemDimZ();
        int index = 0;
        ArrayList<SchematicChunk.SchematicChunkBlockState> ents = new ArrayList<SchematicChunk.SchematicChunkBlockState>();
        SchematicChunk chunk = new SchematicChunk(w);
        for (i = 0; i <= schem.getSchemDimY(); ++i) {
            int y = i;
            for (int x = 0; x <= schem.getSchemDimX(); ++x) {
                for (int z = 0; z <= schem.getSchemDimZ(); ++z) {
                    SchematicChunk.SchematicChunkBlockState s;
                    boolean placeBlock;
                    IBlockState state;
                    Block block;
                    if (index % queue.chunkSize == 0) {
                        queue.getList().add(chunk);
                        chunk = new SchematicChunk(w);
                    }
                    BlockPos pos = new BlockPos(x, y, z).func_177982_a(p.func_177958_n(), p.func_177956_o(), p.func_177952_p());
                    if (schem.getBoolMap()[index] == 1) {
                        block = null;
                        block = map == BlockMap.DM_1_12_2 ? DMBlocks.BlockInfo.DM_BLOCKS.get(schem.getBlockMap()[index]) : DM18BlockMap.getBlockForID(schem.getBlockMap()[index]);
                        state = block.func_176223_P();
                        try {
                            state = block.func_176203_a((int)schem.getMetaMap()[index]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        placeBlock = true;
                        if (state == null) {
                            state = block.func_176223_P();
                        }
                        if (blocksToIgnore != null) {
                            for (IBlockState iBlockState : blocksToIgnore) {
                                if (!state.equals(iBlockState)) continue;
                                placeBlock = false;
                            }
                        }
                        if (state == airBlock) {
                            state = Blocks.field_150350_a.func_176223_P();
                        }
                        if (blockReplace != null) {
                            for (IReplaceBlockSpawn iReplaceBlockSpawn : blockReplace) {
                                if (iReplaceBlockSpawn.getBlock() != null && iReplaceBlockSpawn.getBlock() == state.func_177230_c()) {
                                    s = new SchematicChunk.SchematicChunkBlockState(pos, (IBlockState)null);
                                    s.setBlockUpdater(iReplaceBlockSpawn);
                                    ents.add(s);
                                    placeBlock = iReplaceBlockSpawn.keepBlock();
                                    continue;
                                }
                                if (iReplaceBlockSpawn.getBlockState() != state) continue;
                                s = new SchematicChunk.SchematicChunkBlockState(pos, (IBlockState)null);
                                s.setBlockUpdater(iReplaceBlockSpawn);
                                ents.add(s);
                                placeBlock = iReplaceBlockSpawn.keepBlock();
                            }
                        }
                        if (placeBlock) {
                            chunk.blocks.add(new SchematicChunk.SchematicChunkBlockState(pos, state));
                        }
                    } else {
                        block = Block.func_149729_e((int)schem.getBlockMap()[index]);
                        state = block.func_176203_a((int)schem.getMetaMap()[index]);
                        placeBlock = true;
                        if (blocksToIgnore != null) {
                            for (IBlockState iBlockState : blocksToIgnore) {
                                if (!state.equals(iBlockState)) continue;
                                placeBlock = false;
                            }
                        }
                        if (state == airBlock) {
                            state = Blocks.field_150350_a.func_176223_P();
                        }
                        if (blockReplace != null) {
                            for (IReplaceBlockSpawn iReplaceBlockSpawn : blockReplace) {
                                if (iReplaceBlockSpawn.getBlock() != null && iReplaceBlockSpawn.getBlock() == state.func_177230_c()) {
                                    s = new SchematicChunk.SchematicChunkBlockState(pos, (IBlockState)null);
                                    s.setBlockUpdater(iReplaceBlockSpawn);
                                    ents.add(s);
                                    placeBlock = iReplaceBlockSpawn.keepBlock();
                                    continue;
                                }
                                if (iReplaceBlockSpawn.getBlockState() != state) continue;
                                s = new SchematicChunk.SchematicChunkBlockState(pos, (IBlockState)null);
                                s.setBlockUpdater(iReplaceBlockSpawn);
                                ents.add(s);
                                placeBlock = iReplaceBlockSpawn.keepBlock();
                            }
                        }
                        if (placeBlock) {
                            chunk.blocks.add(new SchematicChunk.SchematicChunkBlockState(pos, state));
                        }
                    }
                    ++index;
                }
            }
        }
        queue.getList().add(chunk);
        chunk = new SchematicChunk(w);
        for (i = 0; i < schem.getTileData().size(); ++i) {
            TileData tileData = schem.getTileData().get(i);
            BlockPos pos = new BlockPos(p.func_177958_n() + tileData.getPos()[0], p.func_177956_o() + tileData.getPos()[1], p.func_177952_p() + tileData.getPos()[2]);
            chunk.blocks.add(new SchematicChunk.SchematicChunkBlockState(pos, tileData.getNbtDataString()));
        }
        queue.getList().add(chunk);
        SchematicChunk cc = new SchematicChunk(w);
        cc.blocks.addAll(ents);
        queue.getList().add(cc);
    }

    public static enum FileLocation {
        INTERNAL,
        EXTERNAL;

    }

    public static interface IReplaceBlockSpawn {
        public void replaceBlock(World var1, BlockPos var2);

        public boolean keepBlock();

        public IBlockState getBlockState();

        public Block getBlock();
    }

    public static enum BlockMap {
        DM_1_8,
        DM_1_12_2;

    }

    public static class SchematicChunk {
        private final int worldID;
        private final List<SchematicChunkBlockState> blocks = new ArrayList<SchematicChunkBlockState>();

        public SchematicChunk(World world) {
            this.worldID = world.field_73011_w.getDimension();
        }

        public List<SchematicChunkBlockState> getBlocks() {
            return this.blocks;
        }

        public int getWorld() {
            return this.worldID;
        }

        public static class SchematicChunkBlockState {
            private final BlockPos p;
            private final IBlockState block;
            private String nbt = "";
            private IReplaceBlockSpawn blockUpdater;

            public SchematicChunkBlockState(BlockPos p, IBlockState state) {
                this.p = p;
                this.block = state;
            }

            public SchematicChunkBlockState(BlockPos p, String nbt) {
                this.p = p;
                this.block = null;
                this.nbt = nbt;
            }

            public IReplaceBlockSpawn getBlockUpdater() {
                return this.blockUpdater;
            }

            public void setBlockUpdater(IReplaceBlockSpawn blockUpdater) {
                this.blockUpdater = blockUpdater;
            }

            public IBlockState getBlock() {
                return this.block;
            }

            public String getNbt() {
                return this.nbt;
            }

            public BlockPos getPos() {
                return this.p;
            }
        }
    }

    public static enum GenerationQueue {
        DEFAULT,
        TARDIS,
        CITADEL(4096);

        private List<SchematicChunk> list = new ArrayList<SchematicChunk>();
        private int chunkSize = 512;

        private GenerationQueue() {
        }

        private GenerationQueue(int chunkSize) {
            this.chunkSize = chunkSize;
        }

        public List<SchematicChunk> getList() {
            return this.list;
        }
    }
}

