/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.overlay;

import com.swdteam.client.overlay.IOverlay;
import com.swdteam.common.capability.CapabilityRegeneration;
import com.swdteam.common.capability.interfaces.IRegenerationCapability;
import com.swdteam.utils.Graphics;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;

public class OverlayRegeneration
implements IOverlay {
    private boolean enabled = false;
    private float alpha = 0.0f;
    private float counter = 0.0f;
    private boolean p = false;
    private final int col = -30444;
    private final int r = 255;
    private final int g = 137;
    private final int b = 20;

    @Override
    public int depthLevel() {
        return -1;
    }

    @Override
    public void render(ScaledResolution s, Minecraft mc, EntityPlayer player, FontRenderer font) {
        if (player != null) {
            IRegenerationCapability capability = (IRegenerationCapability)player.getCapability(CapabilityRegeneration.REGEN_CAP, null);
            if (capability.isPostponed()) {
                mc.field_71466_p.func_175065_a(OverlayRegeneration.genTimeBetween(this.counter), (float)(s.func_78326_a() - 50), (float)(s.func_78328_b() / 2 + 110), -16777216, false);
            }
            if (Minecraft.func_71410_x().field_71439_g != null && this.enabled && Minecraft.func_71410_x().field_71462_r == null && Minecraft.func_71382_s()) {
                GlStateManager.func_179147_l();
                Graphics.FillRect(0.0, 0.0, (double)s.func_78326_a(), (double)s.func_78328_b(), 0.0, new Color(1.0f, 0.5372549f, 0.078431375f, this.alpha));
                GlStateManager.func_179084_k();
            }
        }
    }

    @Override
    public void update() {
        IRegenerationCapability capability = (IRegenerationCapability)Minecraft.func_71410_x().field_71439_g.getCapability(CapabilityRegeneration.REGEN_CAP, null);
        boolean bl = this.enabled = capability.getPreRegenTicks() > 0 && capability.getPreRegenTicks() < 300 || capability.getTicksExisted() > 0 || capability.isPostponed();
        if (capability.isPostponed()) {
            this.counter = capability.getPreRegenTicks();
        }
        if (capability.getPreRegenTicks() > 0 && capability.getPreRegenTicks() < 300) {
            if (!this.p && (double)this.alpha < 0.6) {
                this.alpha += 0.0116f;
                if ((double)this.alpha > 0.6) {
                    this.alpha = 0.6f;
                }
            } else {
                this.p = true;
                if ((double)this.alpha < 0.4) {
                    this.alpha += 0.0116f;
                    this.p = false;
                } else {
                    this.alpha -= 0.0116f;
                }
            }
        } else if (capability.getTicksExisted() > 0) {
            this.alpha = 0.5f;
        } else if (capability.isPostponed()) {
            this.alpha = OverlayRegeneration.interpolate(this.alpha, 0.0f, 0.011f);
        }
    }

    public static String genTimeBetween(float diff) {
        long seconds = (long)(diff / 20.0f % 60.0f);
        long minutes = (long)(diff / 1200.0f % 60.0f);
        long hours = (long)(diff / 72000.0f % 24.0f);
        long days = (long)(diff / 1728000.0f);
        String time = (days != 0L ? days + " Days " + (hours != 0L ? "| " : "") : "") + (hours != 0L ? hours + " Hours " + (minutes != 0L ? "| " : "") : "") + (minutes != 0L ? minutes + " M " + (seconds != 0L ? "| " : "") : "") + (seconds != 0L ? seconds + " S" : "");
        return time;
    }

    public static float interpolate(float curr, float fi, float per) {
        float f = curr;
        if (curr < fi) {
            f = curr + per;
            if (f > fi) {
                f = fi;
            }
        } else if (curr != fi && (f = curr - per) < fi) {
            f = fi;
        }
        return f;
    }
}

