/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.commands;

import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.utils.DMUtils;
import com.swdteam.utils.EnumDefaultResponse;
import com.swdteam.utils.PlayerUtils;
import com.swdteam.utils.Vector3;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.server.command.CommandTreeBase;

public class CommandTardisDoorPos
extends CommandTreeBase {
    public String func_71517_b() {
        return "tardis-interior-pos";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b() + " <x> <y> <z> <x_rot> <y_rot>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        if (sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            if (player.field_70170_p.field_73011_w.getDimension() != DMDimensions.DIM_TARDIS_ID) {
                PlayerUtils.Messaging.sendMessageToPlayer(player, EnumDefaultResponse.CANNOT_EXECUTE_IN_DIMENSION);
                return;
            }
            TardisData data = DMTardis.getTardis(player.func_180425_c());
            if (data != null) {
                if (data.getCurrentOwner() != null) {
                    if (!data.getCurrentOwner().equals(player.func_110124_au())) {
                        PlayerUtils.Messaging.sendMessageToPlayer(player, EnumDefaultResponse.NOT_YOUR_TARDIS);
                        return;
                    }
                } else {
                    return;
                }
                if (args.length < 1) {
                    PlayerUtils.Messaging.sendMessageToPlayer(player, TextFormatting.GREEN + "You Tardis interior door is located at: " + data.getTardisInteriorDoorLocation().toString());
                } else if (args.length > 2) {
                    float angleX;
                    int snap;
                    int x = data.getTardisInteriorDoorLocation().x;
                    int y = data.getTardisInteriorDoorLocation().y;
                    int z = data.getTardisInteriorDoorLocation().z;
                    float angle = player.func_70079_am();
                    if (angle - (float)((snap = (int)(angle / 45.0f)) * 45) > 22.0f) {
                        ++snap;
                    }
                    float xr = angleX = (float)(snap * 45);
                    float yr = 0.0f;
                    if (args.length > 4) {
                        xr = Float.parseFloat(args[3]);
                        yr = Float.parseFloat(args[4]);
                    }
                    try {
                        x = DMUtils.getPosFromArg(args[0], (int)player.field_70165_t);
                        y = DMUtils.getPosFromArg(args[1], (int)player.field_70163_u);
                        z = DMUtils.getPosFromArg(args[2], (int)player.field_70161_v);
                    }
                    catch (Exception e) {
                        PlayerUtils.Messaging.sendMessageToPlayer(player, EnumDefaultResponse.INVALID_COMMAND_PARAMS);
                        return;
                    }
                    int wip = DMTardis.getIDForXZ(x, z);
                    if (y > 254) {
                        PlayerUtils.Messaging.sendMessageToPlayer(player, TextFormatting.RED + "Cannot set interior position outside of the world");
                        return;
                    }
                    if (wip == data.getTardisID()) {
                        data.setTardisInteriorDoorLocation(new Vector3(x, y, z));
                        data.setSpawnFacing(xr);
                        data.setSpawnFacingY(-yr);
                        TardisSaveHandler.saveTardis(data);
                        PlayerUtils.Messaging.sendMessageToPlayer(player, TextFormatting.GREEN + "Tardis interior door position set to " + data.getTardisInteriorDoorLocation().toString());
                    } else {
                        PlayerUtils.Messaging.sendMessageToPlayer(player, TextFormatting.RED + "Cannot set interior position outside of TARDIS");
                    }
                } else {
                    PlayerUtils.Messaging.sendMessageToPlayer(player, EnumDefaultResponse.INVALID_COMMAND_PARAMS);
                }
            } else {
                PlayerUtils.Messaging.sendMessageToPlayer(player, EnumDefaultResponse.TARDIS_DOES_NOT_EXIST);
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        switch (args.length) {
            case 1: {
                return CommandTardisDoorPos.func_71530_a((String[])args, (String[])new String[]{String.valueOf(sender.func_180425_c().func_177958_n())});
            }
            case 2: {
                return CommandTardisDoorPos.func_71530_a((String[])args, (String[])new String[]{String.valueOf(sender.func_180425_c().func_177956_o())});
            }
            case 3: {
                return CommandTardisDoorPos.func_71530_a((String[])args, (String[])new String[]{String.valueOf(sender.func_180425_c().func_177952_p())});
            }
            case 4: {
                return CommandTardisDoorPos.func_71530_a((String[])args, (String[])new String[]{String.valueOf(sender.func_174793_f().func_70079_am())});
            }
            case 5: {
                return CommandTardisDoorPos.func_71530_a((String[])args, (String[])new String[]{String.valueOf(-sender.func_174793_f().field_70125_A)});
            }
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

