/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.regeneration.skinchanging;

import com.swdteam.common.regeneration.skinchanging.SkinChangingHandler;
import com.swdteam.main.TheDalekMod;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SkinData {
    private BufferedImage bufferedImage;
    private SkinChangingHandler.SkinChoice skinChoice = SkinChangingHandler.SkinChoice.STEVE;
    private ResourceLocation location = new ResourceLocation("");

    public SkinData() {
    }

    public SkinData(BufferedImage bufferedImage, SkinChangingHandler.SkinChoice choice) {
        this.bufferedImage = bufferedImage;
        this.skinChoice = choice;
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public SkinChangingHandler.SkinChoice getSkinChoice() {
        return this.skinChoice;
    }

    public void setBufferedImage(BufferedImage bufferedImage) {
        this.bufferedImage = bufferedImage;
    }

    public void setSkinType(SkinChangingHandler.SkinChoice alex) {
        this.skinChoice = alex;
    }

    @SideOnly(value=Side.CLIENT)
    public void createLocation(String name) {
        try {
            DynamicTexture dynamicTexture = new DynamicTexture(this.bufferedImage);
            this.location = Minecraft.func_71410_x().func_110434_K().func_110578_a(name + System.currentTimeMillis(), dynamicTexture);
        }
        catch (Exception e) {
            TheDalekMod.LOG.warn("Failed to create resourceLocation for player: " + name);
        }
    }

    public void reset() {
        this.bufferedImage = null;
        this.skinChoice = SkinChangingHandler.SkinChoice.STEVE;
        this.location = new ResourceLocation("minecraft:");
    }

    public void setLocation(ResourceLocation location) {
        this.location = location;
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    public void readNBT(NBTTagCompound tagCompound) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(tagCompound.func_74770_j("image"));
        try {
            this.bufferedImage = ImageIO.read(inputStream);
            this.skinChoice = SkinChangingHandler.SkinChoice.getSkinChoice(tagCompound.func_74779_i("skinchoice"));
            this.location = new ResourceLocation(tagCompound.func_74779_i("location"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeNBT(NBTTagCompound tagCompound) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            if (this.bufferedImage != null) {
                ImageIO.write((RenderedImage)this.bufferedImage, "png", bos);
            }
            tagCompound.func_74773_a("image", bos.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.skinChoice != null) {
            tagCompound.func_74778_a("skinchoice", this.skinChoice.getChoice());
        }
        tagCompound.func_74778_a("location", this.location.toString());
    }
}

