/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.tileentity;

import com.swdteam.client.worldportal.IWorldPortal;
import com.swdteam.client.worldportal.WorldPortal;
import com.swdteam.client.worldportal.WorldRender;
import com.swdteam.client.worldportal.packet.PacketRequestBoti;
import com.swdteam.common.tileentity.DMTileEntityBase;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.utils.FileUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBotiPainting
extends DMTileEntityBase
implements ITickable,
IWorldPortal {
    public static Map<String, WorldRender> paintings = new HashMap<String, WorldRender>();
    public WorldRender customWorld;
    private String painting_name = "";
    private boolean invalid_painting = false;
    private boolean packetSent = false;
    public boolean renderSurround = true;

    public static void setupPaintings() {
        File[] files;
        File f = new File("mods/Dalek Mod/cdn/paintings/");
        if (!f.exists()) {
            f.mkdirs();
        }
        if (f.exists() && (files = f.listFiles()).length > 0) {
            for (File file : files) {
                if (!file.getName().endsWith(".bp")) continue;
                try {
                    Object o = FileUtils.loadObjectFromFile(file.getAbsolutePath(), WorldRender.class);
                    if (!(o instanceof WorldRender)) continue;
                    WorldRender worldRender = (WorldRender)o;
                    paintings.put(file.getName().replaceAll(".bp", ""), worldRender);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void onLoad() {
        super.onLoad();
        if (!(this.field_145850_b.field_72995_K || this.painting_name.equals("") || paintings.containsKey(this.painting_name))) {
            this.invalid_painting = true;
            this.sendUpdates();
        }
    }

    public void setPainting_name(String painting_name) {
        this.painting_name = painting_name;
        this.sendUpdates();
    }

    public String getPainting_name() {
        return this.painting_name;
    }

    @Override
    public void setRotation(float rotation) {
        super.setRotation(rotation);
    }

    @Override
    public int getDimension() {
        return this.field_145850_b.field_73011_w.getDimension();
    }

    @Override
    public BlockPos getPosToRender() {
        return BlockPos.field_177992_a;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("name", this.painting_name);
        compound.func_74757_a("invalid", this.invalid_painting);
        compound.func_74757_a("surround", this.renderSurround);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.painting_name = compound.func_74779_i("name");
        this.invalid_painting = compound.func_74767_n("invalid");
        this.renderSurround = compound.func_74767_n("surround");
    }

    @Override
    public WorldRender getWorldRender() {
        return this.customWorld;
    }

    @Override
    public void setWorldRender(WorldRender worldRender) {
        this.customWorld = worldRender;
    }

    @Override
    public void requestRender() {
        if (this.field_145850_b.field_72995_K && !this.packetSent && !this.painting_name.equalsIgnoreCase("") && this.getWorldRender() == null && !this.invalid_painting) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketRequestBoti(this.field_174879_c));
            this.packetSent = true;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.customWorld == null && !this.painting_name.equalsIgnoreCase("") && paintings.containsKey(this.painting_name)) {
                this.customWorld = WorldPortal.WorldPortalServer.sendWorldRenderToClient(this.field_145850_b, this.field_174879_c, paintings.get(this.painting_name));
            } else if (this.customWorld != null && !this.painting_name.equalsIgnoreCase("") && paintings.containsKey(this.painting_name)) {
                WorldPortal.WorldPortalServer.sendWorldRenderToClient(this.field_145850_b, this.field_174879_c, this.customWorld);
            }
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K && this.packetSent && this.field_145850_b.func_72820_D() % 60L == 0L) {
            this.packetSent = false;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.invalid_painting && paintings.containsKey(this.painting_name)) {
                this.invalid_painting = false;
                this.sendUpdates();
            }
            if (!(this.invalid_painting || this.painting_name.equals("") || paintings.containsKey(this.painting_name))) {
                this.invalid_painting = true;
                this.sendUpdates();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72314_b(15.0, 15.0, 15.0);
    }
}

