/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.tileentity.tardis.decoration;

import com.swdteam.common.tileentity.DMTileEntityBase;
import com.swdteam.utils.DMUtils;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityChalkboard
extends DMTileEntityBase {
    private int[][] pixels = new int[32][18];
    private String owner = "";
    private String owner_uuid = "";
    private boolean isLocked = false;
    private float rotation = 0.0f;

    public TileEntityChalkboard() {
        this.setPixels(new int[32][18]);
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 18; ++j) {
                this.pixels[i][j] = 0;
            }
        }
    }

    public void drawPixel(int x, int y, boolean b) {
        this.pixels[x][y] = b ? 1 : 0;
    }

    public int getPixel(int x, int y) {
        return this.pixels[x][y];
    }

    public int[][] getPixels() {
        return this.pixels;
    }

    public void setPixels(int[][] pixels) {
        this.pixels = pixels;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("boardDrawing")) {
            int[] array = compound.func_74759_k("boardDrawing");
            if (array == null || array != null && array.length < 1) {
                array = new int[576];
            }
            this.setPixels(DMUtils.to2dArray(array, 32, 18));
        }
        if (compound.func_74764_b("rotation")) {
            this.setRotation(compound.func_74760_g("rotation"));
        }
        if (compound.func_74764_b("isLocked")) {
            this.setLocked(compound.func_74767_n("isLocked"));
        }
        if (compound.func_74764_b("owner")) {
            this.setOwner(compound.func_74779_i("owner"));
        }
        if (compound.func_74764_b("ownerUUID")) {
            this.setOwner_uuid(compound.func_74779_i("ownerUUID"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74783_a("boardDrawing", DMUtils.to1dArray(this.pixels, 32, 18));
        compound.func_74757_a("isLocked", this.isLocked());
        if (this.getOwner() != null && this.getOwner().length() > 0) {
            compound.func_74778_a("owner", this.getOwner());
        }
        if (this.getOwner_uuid() != null && this.getOwner_uuid().length() > 0) {
            compound.func_74778_a("ownerUUID", this.getOwner_uuid());
        }
        compound.func_74776_a("rotation", this.getRotation());
        return compound;
    }

    public void setLocked(boolean isLocked) {
        this.isLocked = isLocked;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setOwner_uuid(String owner_uuid) {
        this.owner_uuid = owner_uuid;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getOwner_uuid() {
        return this.owner_uuid;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public float getRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(float rotation) {
        this.rotation = rotation;
    }
}

