/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.world.multibiome;

import com.swdteam.common.world.multibiome.LayerGenBase;
import java.util.List;
import java.util.Random;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public class BiomeProviderBaseMulti
extends BiomeProvider {
    private GenLayer genBiomes;
    private GenLayer biomeIndexLayer;
    private BiomeCache biomeCache;

    public BiomeProviderBaseMulti() {
        this.biomeCache = new BiomeCache((BiomeProvider)this);
    }

    public BiomeProviderBaseMulti(long seed, Biome ... biomes) {
        GenLayer[] agenlayer = LayerGenBase.createWorld(seed, biomes);
        this.genBiomes = agenlayer[0];
        this.biomeIndexLayer = agenlayer[1];
        this.biomeCache = new BiomeCache((BiomeProvider)this);
    }

    public BiomeProviderBaseMulti(World world, Biome ... biomes) {
        this(world.func_72905_C(), biomes);
    }

    public Biome func_180631_a(BlockPos pos) {
        return this.func_180300_a(pos, null);
    }

    public Biome func_180300_a(BlockPos pos, Biome defaultBiome) {
        return this.biomeCache.func_180284_a(pos.func_177958_n(), pos.func_177952_p(), defaultBiome);
    }

    public Biome[] func_76937_a(Biome[] par1ArrayOfBiome, int par2, int par3, int par4, int par5) {
        IntCache.func_76446_a();
        if (par1ArrayOfBiome == null || par1ArrayOfBiome.length < par4 * par5) {
            par1ArrayOfBiome = new Biome[par4 * par5];
        }
        int[] aint = this.genBiomes.func_75904_a(par2, par3, par4, par5);
        try {
            for (int i = 0; i < par4 * par5; ++i) {
                par1ArrayOfBiome[i] = Biome.func_150568_d((int)aint[i]);
            }
            return par1ArrayOfBiome;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("RawBiomeBlock");
            crashreportcategory.func_71507_a("biomes[] size", (Object)par1ArrayOfBiome.length);
            crashreportcategory.func_71507_a("x", (Object)par2);
            crashreportcategory.func_71507_a("z", (Object)par3);
            crashreportcategory.func_71507_a("w", (Object)par4);
            crashreportcategory.func_71507_a("h", (Object)par5);
            throw new ReportedException(crashreport);
        }
    }

    public Biome[] func_76933_b(Biome[] oldBiomeList, int x, int z, int width, int depth) {
        return this.func_76931_a(oldBiomeList, x, z, width, depth, true);
    }

    public Biome[] func_76931_a(Biome[] listToReuse, int x, int y, int width, int length, boolean cacheFlag) {
        IntCache.func_76446_a();
        if (listToReuse == null || listToReuse.length < width * length) {
            listToReuse = new Biome[width * length];
        }
        if (cacheFlag && width == 16 && length == 16 && (x & 0xF) == 0 && (y & 0xF) == 0) {
            Biome[] aBiome1 = this.biomeCache.func_76839_e(x, y);
            System.arraycopy(aBiome1, 0, listToReuse, 0, width * length);
            return listToReuse;
        }
        int[] aint = this.biomeIndexLayer.func_75904_a(x, y, width, length);
        for (int i = 0; i < width * length; ++i) {
            listToReuse[i] = Biome.func_150568_d((int)aint[i]);
        }
        return listToReuse;
    }

    public boolean func_76940_a(int x, int z, int radius, List<Biome> allowed) {
        IntCache.func_76446_a();
        int i = x - radius >> 2;
        int j = z - radius >> 2;
        int k = x + radius >> 2;
        int l = z + radius >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        int[] aint = this.genBiomes.func_75904_a(i, j, i1, j1);
        try {
            for (int k1 = 0; k1 < i1 * j1; ++k1) {
                Biome biome = Biome.func_150568_d((int)aint[k1]);
                if (allowed.contains(biome)) continue;
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Layer");
            crashreportcategory.func_71507_a("Layer", (Object)this.genBiomes.toString());
            crashreportcategory.func_71507_a("x", (Object)x);
            crashreportcategory.func_71507_a("z", (Object)z);
            crashreportcategory.func_71507_a("radius", (Object)radius);
            crashreportcategory.func_71507_a("allowed", allowed);
            throw new ReportedException(crashreport);
        }
    }

    public BlockPos func_180630_a(int x, int z, int range, List biomes, Random random) {
        IntCache.func_76446_a();
        int l = x - range >> 2;
        int i1 = z - range >> 2;
        int j1 = x + range >> 2;
        int k1 = z + range >> 2;
        int l1 = j1 - l + 1;
        int i2 = k1 - i1 + 1;
        int[] aint = this.genBiomes.func_75904_a(l, i1, l1, i2);
        BlockPos blockpos = null;
        int j2 = 0;
        for (int k2 = 0; k2 < l1 * i2; ++k2) {
            int l2 = l + k2 % l1 << 2;
            int i3 = i1 + k2 / l1 << 2;
            Biome biome = Biome.func_150568_d((int)aint[k2]);
            if (!biomes.contains(biome) || blockpos != null && random.nextInt(j2 + 1) != 0) continue;
            blockpos = new BlockPos(l2, 0, i3);
            ++j2;
        }
        return blockpos;
    }

    public void func_76938_b() {
        this.biomeCache.func_76838_a();
    }
}

