/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.network.packets;

import com.swdteam.common.init.DMItems;
import com.swdteam.common.init.DMSounds;
import com.swdteam.network.packets.AbstractServerMessageHandler;
import com.swdteam.utils.PlayerUtils;
import com.swdteam.utils.TeleportUtils;
import com.swdteam.utils.Vector3;
import com.swdteam.utils.WorldUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class Packet_VortexManipulator
implements IMessage {
    private double X;
    private double Y;
    private double Z;
    private int dimension;

    public Packet_VortexManipulator() {
    }

    public Packet_VortexManipulator(double x, double y, double z, int dimension) {
        this.dimension = dimension;
        this.X = x;
        this.Y = y;
        this.Z = z;
    }

    public void fromBytes(ByteBuf buf) {
        this.X = buf.readDouble();
        this.Y = buf.readDouble();
        this.Z = buf.readDouble();
        this.dimension = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.X);
        buf.writeDouble(this.Y);
        buf.writeDouble(this.Z);
        buf.writeInt(this.dimension);
    }

    public static class Handler
    extends AbstractServerMessageHandler<Packet_VortexManipulator> {
        @Override
        public IMessage handleServerMessage(EntityPlayer player, Packet_VortexManipulator message, MessageContext ctx) {
            ctx.getServerHandler().field_147369_b.field_70170_p.func_73046_m().func_152344_a(() -> {
                ItemStack stack = player.func_184586_b(PlayerUtils.Hands.getEnumHandForItem((EntityLivingBase)player, DMItems.VORTEX_MANIPULATOR));
                if (player.func_184812_l_()) {
                    this.Teleport(stack, player, message);
                } else if (stack.func_77973_b() == DMItems.VORTEX_MANIPULATOR && stack.func_77978_p().func_74762_e("vortex_manipulator_charges") > 0 && !player.func_184812_l_()) {
                    this.Teleport(stack, player, message);
                } else {
                    PlayerUtils.Messaging.sendStatusTranslationMessageToPlayer(player, "message.vm.nocharge", true);
                }
            });
            return null;
        }

        public void Teleport(ItemStack stack, EntityPlayer player, Packet_VortexManipulator message) {
            if (!player.field_70170_p.field_72995_K) {
                if (!DimensionManager.isDimensionRegistered((int)message.dimension)) {
                    PlayerUtils.Messaging.sendMessageToPlayer(player, TextFormatting.RED + "Dimension is not enabled on this server.");
                    return;
                }
                if (WorldUtils.isInWorldBounds(new Vector3((int)message.X, (int)message.Y, (int)message.Z)) && WorldUtils.isInWorldBorderBounds(new Vector3((int)message.X, (int)message.Y, (int)message.Z), (World)player.field_70170_p.func_73046_m().func_71218_a(message.dimension))) {
                    if (!player.func_184812_l_()) {
                        if (message.dimension != player.field_71093_bK) {
                            if (stack.func_77978_p().func_74762_e("vortex_manipulator_charges") < 2) {
                                PlayerUtils.Messaging.sendStatusTranslationMessageToPlayer(player, "message.vm.enoughcharge", true);
                                return;
                            }
                            stack.func_77978_p().func_74768_a("vortex_manipulator_charges", stack.func_77978_p().func_74762_e("vortex_manipulator_charges") - 2);
                        } else {
                            stack.func_77978_p().func_74768_a("vortex_manipulator_charges", stack.func_77978_p().func_74762_e("vortex_manipulator_charges") - 1);
                        }
                    }
                    player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, DMSounds.angelBreakLight, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    TeleportUtils.teleportVortexManipulator(player, message.dimension, message.X, message.Y, message.Z, player.func_174811_aO().func_185119_l(), player.field_70726_aT);
                    player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 120, 2, true, false));
                    player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, DMSounds.angelBreakLight, SoundCategory.PLAYERS, 1.0f, 1.0f);
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "Coordinate too large!"), true);
                }
            }
        }
    }
}

